/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.io;

import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VFB {
    public static Vertex3d[] loadVertices(InputStream is) throws IOException, FileNotFoundException {
        return (Vertex3d[])VFB.load(new BufferedInputStream(is))[0];
    }

    public static int[] loadIndices(InputStream is) throws IOException, FileNotFoundException {
        return (int[])VFB.load(new BufferedInputStream(is))[1];
    }

    public static Object[] load(BufferedInputStream bis) throws IOException, FileNotFoundException {
        int nByteCount = bis.available();
        byte[] byteArray = new byte[nByteCount];
        bis.read(byteArray);
        int nByteIndex = 0;
        while (nByteIndex < nByteCount) {
            byte b = byteArray[nByteIndex];
            byteArray[nByteIndex] = byteArray[nByteIndex + 3];
            byteArray[nByteIndex + 3] = b;
            b = byteArray[nByteIndex + 1];
            byteArray[nByteIndex + 1] = byteArray[nByteIndex + 2];
            byteArray[nByteIndex + 2] = b;
            nByteIndex += 4;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        DataInputStream dis = new DataInputStream(bais);
        Object[] verticesAndIndices = new Object[2];
        int nVersion = dis.readInt();
        if (nVersion == 1) {
            int vertexCount = dis.readInt();
            Vertex3d[] vertices = new Vertex3d[vertexCount];
            int i = 0;
            while (i < vertices.length) {
                vertices[i] = new Vertex3d(19);
                vertices[i].position.x = -dis.readFloat();
                vertices[i].position.y = dis.readFloat();
                vertices[i].position.z = dis.readFloat();
                vertices[i].normal.x = -dis.readFloat();
                vertices[i].normal.y = dis.readFloat();
                vertices[i].normal.z = dis.readFloat();
                vertices[i].textureCoordinate0.x = dis.readFloat();
                vertices[i].textureCoordinate0.y = dis.readFloat();
                ++i;
            }
            int faceCount = dis.readInt();
            int faceDataCount = dis.readInt();
            int verticesPerFace = dis.readInt();
            int[] indices = new int[faceCount * 3];
            int i2 = 0;
            int f = 0;
            while (f < faceCount) {
                int length = verticesPerFace == 0 ? dis.readInt() : verticesPerFace;
                indices[i2 + 0] = dis.readInt();
                indices[i2 + 1] = dis.readInt();
                indices[i2 + 2] = dis.readInt();
                i2 += 3;
                int lcv = 3;
                while (lcv < length) {
                    dis.readInt();
                    ++lcv;
                }
                ++f;
            }
            verticesAndIndices[0] = vertices;
            verticesAndIndices[1] = indices;
        }
        return verticesAndIndices;
    }

    private static void store(BufferedOutputStream bos, int i) throws IOException {
        bos.write((byte)(i & 0xFF));
        bos.write((byte)(i >> 8 & 0xFF));
        bos.write((byte)(i >> 16 & 0xFF));
        bos.write((byte)(i >> 24 & 0xFF));
    }

    private static void store(BufferedOutputStream bos, float f) throws IOException {
        VFB.store(bos, Float.floatToIntBits(f));
    }

    public static void store(OutputStream os, Vertex3d[] vertices, int[] indices) throws IOException {
        int i;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        VFB.store(bos, 1);
        if (vertices != null) {
            VFB.store(bos, vertices.length);
            i = 0;
            while (i < vertices.length) {
                VFB.store(bos, (float)vertices[i].position.x);
                VFB.store(bos, (float)vertices[i].position.y);
                VFB.store(bos, (float)vertices[i].position.z);
                VFB.store(bos, (float)vertices[i].normal.x);
                VFB.store(bos, (float)vertices[i].normal.y);
                VFB.store(bos, (float)vertices[i].normal.z);
                VFB.store(bos, vertices[i].textureCoordinate0.x);
                VFB.store(bos, vertices[i].textureCoordinate0.y);
                ++i;
            }
        } else {
            VFB.store(bos, 0);
        }
        if (indices != null) {
            VFB.store(bos, indices.length / 3);
            VFB.store(bos, indices.length);
            VFB.store(bos, 3);
            i = 0;
            while (i < indices.length) {
                VFB.store(bos, indices[i + 2]);
                VFB.store(bos, indices[i + 1]);
                VFB.store(bos, indices[i]);
                i += 3;
            }
        } else {
            VFB.store(bos, 0);
        }
        bos.flush();
    }
}

