/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import javax.vecmath.Matrix4d;

public class SymmetricPerspectiveCamera
extends Camera {
    public static final Property VERTICAL_VIEWING_ANGLE_PROPERTY;
    public static final Property HORIZONTAL_VIEWING_ANGLE_PROPERTY;
    private double m_verticalViewingAngle = 0.5;
    private double m_horizontalViewingAngle = Double.NaN;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VERTICAL_VIEWING_ANGLE_PROPERTY = new Property(clazz, "VERTICAL_VIEWING_ANGLE");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HORIZONTAL_VIEWING_ANGLE_PROPERTY = new Property(clazz2, "HORIZONTAL_VIEWING_ANGLE");
    }

    public double getHorizontalViewingAngle() {
        return this.m_horizontalViewingAngle;
    }

    public void setHorizontalViewingAngle(double horizontalViewingAngle) {
        if (this.m_horizontalViewingAngle != horizontalViewingAngle) {
            this.m_horizontalViewingAngle = horizontalViewingAngle;
            this.onPropertyChange(HORIZONTAL_VIEWING_ANGLE_PROPERTY);
        }
    }

    public double getVerticalViewingAngle() {
        return this.m_verticalViewingAngle;
    }

    public void setVerticalViewingAngle(double verticalViewingAngle) {
        if (this.m_verticalViewingAngle != verticalViewingAngle) {
            this.m_verticalViewingAngle = verticalViewingAngle;
            this.onPropertyChange(VERTICAL_VIEWING_ANGLE_PROPERTY);
        }
    }

    public Matrix4d getProjection() {
        Matrix4d m = new Matrix4d();
        double w = 1.0 / Math.tan(this.getHorizontalViewingAngle() * 0.5);
        double h = 1.0 / Math.tan(this.getVerticalViewingAngle() * 0.5);
        double farPlane = this.getFarClippingPlaneDistance();
        double nearPlane = this.getNearClippingPlaneDistance();
        double Q = farPlane / (farPlane - nearPlane);
        m.m00 = w;
        m.m11 = h;
        m.m22 = Q;
        m.m32 = -Q * nearPlane;
        m.m23 = 1.0;
        return m;
    }
}

