/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Container
extends Component {
    private Vector m_children = new Vector();
    private Component[] m_childArray = null;
    private Vector m_childrenListeners = new Vector();
    private ChildrenListener[] m_childrenListenerArray = null;

    public boolean isAncestorOf(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDescendantOf(this);
    }

    protected void releasePass1() {
        Component[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Element.warnln("WARNING: released container " + this + " still has child " + children[i] + ".");
            children[i].setParent(null);
            ++i;
        }
        super.releasePass1();
    }

    protected void releasePass2() {
        this.m_children = null;
        this.m_childArray = null;
        super.releasePass2();
    }

    protected void releasePass3() {
        Enumeration enumeration = this.m_childrenListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enumeration.nextElement();
            Element.warnln("WARNING: released container " + this + " still has childrenListener " + childrenListener + ".");
        }
        this.m_childrenListeners = null;
        this.m_childrenListenerArray = null;
        super.releasePass3();
    }

    protected void onAddChild(Component child) {
        if (this.isReleased()) {
            Element.warnln("WARNING: scenegraph addChild " + child + " on already released " + this + ".");
        } else if (child.isReleased()) {
            Element.warnln("WARNING: scenegraph addChild from " + this + " on already released child " + child + ".");
        } else {
            this.m_children.addElement(child);
            this.m_childArray = null;
            ChildrenEvent childrenEvent = new ChildrenEvent(this, child);
            ChildrenListener[] childrenListeners = this.getChildrenListeners();
            int i = 0;
            while (i < childrenListeners.length) {
                childrenListeners[i].childAdded(childrenEvent);
                ++i;
            }
        }
    }

    protected void onRemoveChild(Component child) {
        if (this.isReleased()) {
            Element.warnln("WARNING: scenegraph removeChild " + child + " on already released " + this + ".");
        } else if (child.isReleased()) {
            Element.warnln("WARNING: scenegraph removeChild from " + this + " on already released child " + child + ".");
        } else {
            this.m_children.removeElement(child);
            this.m_childArray = null;
            ChildrenEvent childrenEvent = new ChildrenEvent(this, child);
            ChildrenListener[] childrenListeners = this.getChildrenListeners();
            int i = 0;
            while (i < childrenListeners.length) {
                childrenListeners[i].childRemoved(childrenEvent);
                ++i;
            }
        }
    }

    public Component[] getChildren() {
        if (this.m_childArray == null) {
            this.m_childArray = new Component[this.m_children.size()];
            this.m_children.copyInto(this.m_childArray);
        }
        return this.m_childArray;
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public Component getChildAt(int i) {
        return (Component)this.m_children.elementAt(i);
    }

    public void addChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.addElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public void removeChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.removeElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public ChildrenListener[] getChildrenListeners() {
        if (this.m_childrenListenerArray == null) {
            this.m_childrenListenerArray = new ChildrenListener[this.m_childrenListeners.size()];
            this.m_childrenListeners.copyInto(this.m_childrenListenerArray);
        }
        return this.m_childrenListenerArray;
    }

    protected void onAbsoluteTransformationChange() {
        super.onAbsoluteTransformationChange();
        Component[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].onAbsoluteTransformationChange();
            ++i;
        }
    }

    protected void onHierarchyChange() {
        super.onHierarchyChange();
        Component[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].onHierarchyChange();
            ++i;
        }
    }
}

