/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;

public abstract class Component
extends Element {
    public static final Property PARENT_PROPERTY;
    private Container m_parent = null;
    private Vector m_absoluteTransformationListeners = new Vector();
    private Vector m_hierarchyListeners = new Vector();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Component");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PARENT_PROPERTY = new Property(clazz, "PARENT");
    }

    protected void releasePass1() {
        if (this.m_parent != null) {
            Element.warnln("WARNING: released component " + this + " still has parent " + this.m_parent + ".");
            this.setParent(null);
        }
        super.releasePass1();
    }

    protected void releasePass3() {
        Enumeration enumeration = this.m_absoluteTransformationListeners.elements();
        while (enumeration.hasMoreElements()) {
            AbsoluteTransformationListener absoluteTransformationListener = (AbsoluteTransformationListener)enumeration.nextElement();
            Element.warnln("WARNING: released component " + this + " still has absoluteTransformationListener " + absoluteTransformationListener + ".");
        }
        enumeration = this.m_hierarchyListeners.elements();
        while (enumeration.hasMoreElements()) {
            HierarchyListener hierarchyListener = (HierarchyListener)enumeration.nextElement();
            Element.warnln("WARNING: released component " + this + " still has hierarchyListener " + hierarchyListener + ".");
        }
    }

    public Container getRoot() {
        if (this.m_parent != null) {
            return this.m_parent.getRoot();
        }
        return null;
    }

    public Matrix4d getAbsoluteTransformation() {
        if (this.m_parent != null) {
            return this.m_parent.getAbsoluteTransformation();
        }
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    public Matrix4d getInverseAbsoluteTransformation() {
        if (this.m_parent != null) {
            return this.m_parent.getInverseAbsoluteTransformation();
        }
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    public Container getParent() {
        return this.m_parent;
    }

    public void setParent(Container parent) {
        if (this.m_parent != parent) {
            if (this.m_parent != null) {
                this.m_parent.onRemoveChild(this);
            }
            this.m_parent = parent;
            if (this.m_parent != null) {
                this.m_parent.onAddChild(this);
            }
            this.onPropertyChange(PARENT_PROPERTY);
            this.onAbsoluteTransformationChange();
            this.onHierarchyChange();
        }
    }

    public boolean isDescendantOf(Container container) {
        if (container == null) {
            return false;
        }
        if (this.m_parent == container) {
            return true;
        }
        if (this.m_parent == null) {
            return false;
        }
        return this.m_parent.isDescendantOf(container);
    }

    public void addAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_absoluteTransformationListeners.addElement(absoluteTransformationListener);
    }

    public void removeAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_absoluteTransformationListeners.removeElement(absoluteTransformationListener);
    }

    public AbsoluteTransformationListener[] getAbsoluteTransformationListeners() {
        Object[] array = new AbsoluteTransformationListener[this.m_absoluteTransformationListeners.size()];
        this.m_absoluteTransformationListeners.copyInto(array);
        return array;
    }

    private void onAbsoluteTransformationChange(AbsoluteTransformationEvent absoluteTransformationEvent) {
        Enumeration enumeration = this.m_absoluteTransformationListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((AbsoluteTransformationListener)enumeration.nextElement()).absoluteTransformationChanged(absoluteTransformationEvent);
        }
    }

    protected void onAbsoluteTransformationChange() {
        if (this.isReleased()) {
            Element.warnln("WARNING: absolute transformation change on already released " + this + ".");
        } else {
            this.onAbsoluteTransformationChange(new AbsoluteTransformationEvent(this));
        }
    }

    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.m_hierarchyListeners.addElement(hierarchyListener);
    }

    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.m_hierarchyListeners.removeElement(hierarchyListener);
    }

    public HierarchyListener[] getHierarchyListeners() {
        Object[] array = new HierarchyListener[this.m_hierarchyListeners.size()];
        this.m_hierarchyListeners.copyInto(array);
        return array;
    }

    private void onHierarchyChange(HierarchyEvent hierarchyEvent) {
        Enumeration enumeration = this.m_hierarchyListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((HierarchyListener)enumeration.nextElement()).hierarchyChanged(hierarchyEvent);
        }
    }

    protected void onHierarchyChange() {
        if (this.isReleased()) {
            Element.warnln("WARNING: scenegraph heirarchy change on already released " + this + ".");
        } else {
            this.onHierarchyChange(new HierarchyEvent(this));
        }
    }
}

