/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.util;

import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.util.ProgressObserver;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class IndexedTriangleArrayUtil {
    public static int getProgressTotalForCalculateReversedIndexOrder(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray.getTriangleCount();
    }

    public static int[] calculateReversedIndexOrder(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        int[] indices = indexedTriangleArray.getIndices();
        int[] result = null;
        if (indices != null) {
            result = new int[indices.length];
            int index = 0;
            for (int i = 0; i < indexedTriangleArray.getTriangleCount(); ++i) {
                result[index] = indices[index + 2];
                result[index + 1] = indices[index + 1];
                result[index + 2] = indices[index];
                index += 3;
                if (progressObserver == null) continue;
                progressObserver.progressUpdateCurrent(i);
            }
        }
        return result;
    }

    private static Vector3d getDirection(Vertex3d vertexA, Vertex3d vertexB, Vertex3d vertexC) {
        Vector3d ba = new Vector3d();
        Vector3d bc = new Vector3d();
        ba.sub((Tuple3d)vertexA.position, (Tuple3d)vertexB.position);
        bc.sub((Tuple3d)vertexC.position, (Tuple3d)vertexB.position);
        ba.normalize();
        bc.normalize();
        Vector3d result = new Vector3d();
        result.cross(bc, ba);
        return result;
    }

    public static int getProgressTotalForCalculateNormals(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray.getTriangleCount();
    }

    public static Vector3d[] calculateNormals(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        Vector3d[] result = null;
        int triangleCount = indexedTriangleArray.getTriangleCount();
        if (triangleCount > 0) {
            Vertex3d[] vertices = indexedTriangleArray.getVertices();
            result = new Vector3d[vertices.length];
            int[] counts = new int[vertices.length];
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = 0;
                result[i] = new Vector3d();
            }
            int[] indices = indexedTriangleArray.getIndices();
            if (progressObserver != null) {
                progressObserver.progressUpdateTotal(triangleCount);
                progressObserver.progressUpdateCurrent(0);
            }
            int index = 0;
            for (int t = 0; t < triangleCount; ++t) {
                int a = indices[index++];
                int b = indices[index++];
                int c = indices[index++];
                Vector3d normal = IndexedTriangleArrayUtil.getDirection(vertices[a], vertices[b], vertices[c]);
                normal.normalize();
                result[a].add((Tuple3d)normal);
                result[b].add((Tuple3d)normal);
                result[c].add((Tuple3d)normal);
                int n = a;
                counts[n] = counts[n] + 1;
                int n2 = b;
                counts[n2] = counts[n2] + 1;
                int n3 = c;
                counts[n3] = counts[n3] + 1;
                if (progressObserver == null) continue;
                progressObserver.progressUpdateCurrent(t);
            }
            for (int i = 0; i < result.length; ++i) {
                result[i].scale(1.0 / (double)counts[i]);
            }
        }
        return result;
    }

    public static int getProgressTotalForCalculateUnsharedVertices(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray.getIndexCount();
    }

    public static Object[] calculateUnsharedVertices(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        Vertex3d[] verticesResult = null;
        int[] indicesResult = null;
        if (indexedTriangleArray.getIndexCount() > 0) {
            Vertex3d[] oldVertices = indexedTriangleArray.getVertices();
            int[] indices = indexedTriangleArray.getIndices();
            verticesResult = new Vertex3d[indices.length];
            indicesResult = new int[indices.length];
            if (progressObserver != null) {
                progressObserver.progressUpdateCurrent(0);
                progressObserver.progressUpdateTotal(indices.length);
            }
            for (int i = 0; i < indices.length; ++i) {
                verticesResult[i] = (Vertex3d)oldVertices[indices[i]].clone();
                indicesResult[i] = i;
                if (progressObserver == null) continue;
                progressObserver.progressUpdateCurrent(i + 1);
            }
        }
        return new Object[]{verticesResult, indicesResult};
    }

    public static int getProgressTotalForCalculateSharedVertices(IndexedTriangleArray indexedTriangleArray) {
        int n = indexedTriangleArray.getVertexCount();
        return n * n;
    }

    public static Object[] calculateSharedVertices(IndexedTriangleArray indexedTriangleArray, ProgressObserver progressObserver) {
        Vertex3d[] verticesResult = null;
        int[] indicesResult = null;
        int oldVertexCount = indexedTriangleArray.getVertexCount();
        if (oldVertexCount > 0) {
            int i;
            Vertex3d[] oldVertices = indexedTriangleArray.getVertices();
            int[] indices = indexedTriangleArray.getIndices();
            int newVertexCount = 0;
            int[] oldToNew = new int[oldVertexCount];
            for (int i2 = 0; i2 < oldVertexCount; ++i2) {
                oldToNew[i2] = -1;
            }
            int progress = 0;
            int n = oldVertexCount;
            if (progressObserver != null) {
                progressObserver.progressUpdateCurrent(progress);
                progressObserver.progressUpdateTotal(n * n);
            }
            for (i = 0; i < oldVertexCount; ++i) {
                if (oldToNew[i] == -1) {
                    oldToNew[i] = newVertexCount++;
                    for (int j = i + 1; j < oldVertexCount; ++j) {
                        if (!oldVertices[i].equals(oldVertices[j])) continue;
                        oldToNew[j] = oldToNew[i];
                    }
                }
                progress += n;
                if (progressObserver == null) continue;
                progressObserver.progressUpdateCurrent(progress);
            }
            indicesResult = new int[indices.length];
            for (i = 0; i < indices.length; ++i) {
                indicesResult[i] = oldToNew[indices[i]];
            }
            verticesResult = new Vertex3d[newVertexCount];
            int kOld = 0;
            int kNew = 0;
            int j = 0;
            for (int i3 = 0; i3 < verticesResult.length; ++i3) {
                while (oldToNew[j++] != i3) {
                    ++kOld;
                }
                verticesResult[kNew++] = oldVertices[kOld++];
            }
        }
        return new Object[]{verticesResult, indicesResult};
    }

    public static int getProgressTotalForCalculateSmoothedNormals(IndexedTriangleArray indexedTriangleArray) {
        int n = indexedTriangleArray.getVertexCount();
        return n * n;
    }

    public static Vector3d[] calculateSmoothedNormals(IndexedTriangleArray indexedTriangleArray, double threshold, ProgressObserver progressObserver) {
        Vector3d[] result = null;
        int triangleCount = indexedTriangleArray.getTriangleCount();
        if (triangleCount > 0) {
            Vertex3d[] vertices = indexedTriangleArray.getVertices();
            result = new Vector3d[vertices.length];
            int[] a = new int[vertices.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = -1;
            }
            int progress = 0;
            if (progressObserver != null) {
                progressObserver.progressUpdateTotal(triangleCount);
                progressObserver.progressUpdateCurrent(0);
            }
            for (int i = 0; i < vertices.length; ++i) {
                if (a[i] == -1) {
                    int j;
                    a[i] = i;
                    Point3d posI = vertices[i].position;
                    Vector3d normalI = vertices[i].normal;
                    Vector3d sum = new Vector3d(normalI);
                    for (j = i + 1; j < vertices.length; ++j) {
                        double f;
                        Point3d posJ = vertices[j].position;
                        Vector3d normalJ = vertices[j].normal;
                        if (!posI.equals((Tuple3d)posJ) || !((f = -((normalI.dot(normalJ) - 1.0) * Math.PI * 0.5)) < threshold)) continue;
                        sum.add((Tuple3d)normalJ);
                        a[j] = i;
                    }
                    sum.normalize();
                    for (j = i; j < vertices.length; ++j) {
                        if (a[j] != i) continue;
                        result[j] = sum;
                    }
                }
                progress += vertices.length;
                if (progressObserver == null) continue;
                progressObserver.progressUpdateCurrent(progress);
            }
        }
        return result;
    }
}

