/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.io;

import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.io.OBJ;
import edu.cmu.cs.stage3.alice.scenegraph.io.VFB;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IndexedTriangleArrayIO {
    private static final String[] s_codecNames = new String[]{"obj", "vfb"};
    private static final String[] s_objExtensions = new String[]{"obj"};
    private static final String[] s_vfbExtensions = new String[]{"vfb"};

    public static String[] getCodecNames() {
        return s_codecNames;
    }

    public static String[] getExtensionsForCodec(String codecName) {
        if (codecName.equals("obj")) {
            return s_objExtensions;
        }
        if (codecName.equals("vfb")) {
            return s_vfbExtensions;
        }
        return null;
    }

    public static String mapExtensionToCodecName(String extension) {
        String[] codecNames = IndexedTriangleArrayIO.getCodecNames();
        for (int i = 0; i < codecNames.length; ++i) {
            String[] extensions = IndexedTriangleArrayIO.getExtensionsForCodec(codecNames[i]);
            for (int j = 0; j < extensions.length; ++j) {
                if (!extensions[j].equalsIgnoreCase(extension)) continue;
                return codecNames[i];
            }
        }
        return null;
    }

    private static Object[] decodeOBJ(BufferedInputStream bufferedInputStream) throws IOException {
        return OBJ.load(bufferedInputStream);
    }

    private static Object[] decodeVFB(BufferedInputStream bufferedInputStream) throws IOException {
        return VFB.load(bufferedInputStream);
    }

    public static IndexedTriangleArray decode(String codecName, InputStream inputStream) throws IOException {
        Object[] array;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        if (codecName.equals("obj")) {
            array = IndexedTriangleArrayIO.decodeOBJ(bufferedInputStream);
        } else if (codecName.equals("vfb")) {
            array = IndexedTriangleArrayIO.decodeVFB(bufferedInputStream);
        } else {
            throw new RuntimeException("unknown codec: ".concat(String.valueOf(String.valueOf(codecName))));
        }
        if (array != null) {
            IndexedTriangleArray ita = new IndexedTriangleArray();
            ita.setVertices((Vertex3d[])array[0]);
            ita.setIndices((int[])array[1]);
            return ita;
        }
        return null;
    }

    private static void encodeOBJ(BufferedOutputStream bufferedOutputStream, Vertex3d[] vertices, int[] indices) throws IOException {
        OBJ.store(bufferedOutputStream, vertices, indices, null, null);
    }

    private static void encodeVFB(BufferedOutputStream bufferedOutputStream, Vertex3d[] vertices, int[] indices) throws IOException {
        VFB.store(bufferedOutputStream, vertices, indices);
    }

    public static void encode(String codecName, OutputStream outputStream, IndexedTriangleArray ita) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        if (codecName.equals("obj")) {
            IndexedTriangleArrayIO.encodeOBJ(bufferedOutputStream, ita.getVertices(), ita.getIndices());
        } else if (codecName.equals("vfb")) {
            IndexedTriangleArrayIO.encodeVFB(bufferedOutputStream, ita.getVertices(), ita.getIndices());
        } else {
            throw new RuntimeException("unknown codec: ".concat(String.valueOf(String.valueOf(codecName))));
        }
        bufferedOutputStream.flush();
    }
}

