/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Affector;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Sphere;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector4d;

public class Visual
extends Component {
    public static final Property FRONT_FACING_APPEARANCE_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Visual == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Visual = Visual.class$("edu.cmu.cs.stage3.alice.scenegraph.Visual")) : class$edu$cmu$cs$stage3$alice$scenegraph$Visual, "FRONT_FACING_APPEARANCE");
    public static final Property BACK_FACING_APPEARANCE_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Visual == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Visual = Visual.class$("edu.cmu.cs.stage3.alice.scenegraph.Visual")) : class$edu$cmu$cs$stage3$alice$scenegraph$Visual, "BACK_FACING_APPEARANCE");
    public static final Property GEOMETRY_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Visual == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Visual = Visual.class$("edu.cmu.cs.stage3.alice.scenegraph.Visual")) : class$edu$cmu$cs$stage3$alice$scenegraph$Visual, "GEOMETRY");
    public static final Property SCALE_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Visual == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Visual = Visual.class$("edu.cmu.cs.stage3.alice.scenegraph.Visual")) : class$edu$cmu$cs$stage3$alice$scenegraph$Visual, "SCALE");
    public static final Property IS_SHOWING_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Visual == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Visual = Visual.class$("edu.cmu.cs.stage3.alice.scenegraph.Visual")) : class$edu$cmu$cs$stage3$alice$scenegraph$Visual, "IS_SHOWING");
    public static final Property DISABLED_AFFECTORS_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Visual == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Visual = Visual.class$("edu.cmu.cs.stage3.alice.scenegraph.Visual")) : class$edu$cmu$cs$stage3$alice$scenegraph$Visual, "DISABLED_AFFECTORS");
    private Appearance m_frontFacingAppearance = null;
    private Appearance m_backFacingAppearance = null;
    private Geometry m_geometry = null;
    private Matrix3d m_scale = new Matrix3d();
    private boolean m_isShowing = true;
    private Affector[] m_disabledAffectors = null;
    static Class class$edu$cmu$cs$stage3$alice$scenegraph$Visual;

    public Visual() {
        this.m_scale.setIdentity();
    }

    protected void releasePass1() {
        if (this.m_frontFacingAppearance != null) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: released visual ").append(this).append(" still has front facing appearance ").append(this.m_frontFacingAppearance).append("."))));
            this.setFrontFacingAppearance(null);
        }
        if (this.m_backFacingAppearance != null) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: released visual ").append(this).append(" still has back facing appearance ").append(this.m_frontFacingAppearance).append("."))));
            this.setBackFacingAppearance(null);
        }
        if (this.m_geometry != null) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: released visual ").append(this).append(" still has geometry ").append(this.m_geometry).append("."))));
            this.setGeometry(null);
        }
        if (this.m_disabledAffectors != null && this.m_disabledAffectors.length > 0) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: released visual ").append(this).append(" still has disabled affectors: "))));
            for (int i = 0; i < this.m_disabledAffectors.length; ++i) {
                Element.warnln("\t".concat(String.valueOf(String.valueOf(this.m_disabledAffectors[i]))));
            }
            this.setDisabledAffectors(null);
        }
        super.releasePass1();
    }

    public Geometry getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(Geometry geometry) {
        if (Element.notequal(this.m_geometry, geometry)) {
            this.m_geometry = geometry;
            this.onPropertyChange(GEOMETRY_PROPERTY);
        }
    }

    public Appearance getFrontFacingAppearance() {
        return this.m_frontFacingAppearance;
    }

    public void setFrontFacingAppearance(Appearance frontFacingAppearance) {
        if (Element.notequal(this.m_frontFacingAppearance, frontFacingAppearance)) {
            this.m_frontFacingAppearance = frontFacingAppearance;
            this.onPropertyChange(FRONT_FACING_APPEARANCE_PROPERTY);
        }
    }

    public Appearance getBackFacingAppearance() {
        return this.m_backFacingAppearance;
    }

    public void setBackFacingAppearance(Appearance backFacingAppearance) {
        if (Element.notequal(this.m_backFacingAppearance, backFacingAppearance)) {
            this.m_backFacingAppearance = backFacingAppearance;
            this.onPropertyChange(BACK_FACING_APPEARANCE_PROPERTY);
        }
    }

    public Matrix3d getScale() {
        return this.m_scale;
    }

    public void setScale(Matrix3d scale) {
        if (Element.notequal(this.m_scale, scale)) {
            this.m_scale = scale;
            this.onPropertyChange(SCALE_PROPERTY);
        }
    }

    public boolean getIsShowing() {
        return this.m_isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        if (this.m_isShowing != isShowing) {
            this.m_isShowing = isShowing;
            this.onPropertyChange(IS_SHOWING_PROPERTY);
        }
    }

    public Affector[] getDisabledAffectors() {
        return this.m_disabledAffectors;
    }

    public void setDisabledAffectors(Affector[] disabledAffectors) {
        if (Element.notequal(this.m_disabledAffectors, disabledAffectors)) {
            this.m_disabledAffectors = disabledAffectors;
            this.onPropertyChange(DISABLED_AFFECTORS_PROPERTY);
        }
    }

    public Box getBoundingBox() {
        if (this.m_geometry != null) {
            Box box = this.m_geometry.getBoundingBox();
            if (box != null) {
                box.scale(this.m_scale);
            }
            return box;
        }
        return null;
    }

    public Sphere getBoundingSphere() {
        if (this.m_geometry != null) {
            Sphere sphere = this.m_geometry.getBoundingSphere();
            if (sphere != null) {
                sphere.scale(this.m_scale);
            }
            return sphere;
        }
        return null;
    }

    public void transform(Matrix4d trans) {
        Geometry geometry = this.getGeometry();
        if (geometry != null) {
            geometry.transform(trans);
        }
    }

    public boolean isInProjectionVolumeOf(Camera camera) {
        Sphere boundingSphere = this.getBoundingSphere();
        if (boundingSphere != null) {
            Matrix4d cameraProjection = camera.getProjection();
            Matrix4d cameraInverse = camera.getInverseAbsoluteTransformation();
            Matrix4d absolute = this.getAbsoluteTransformation();
            Matrix44 m = Matrix44.multiply((Matrix4d)absolute, (Matrix4d)Matrix44.multiply((Matrix4d)cameraInverse, (Matrix4d)cameraProjection));
            Vector4 centerV4 = new Vector4((Tuple3d)boundingSphere.getCenter(), 1.0);
            centerV4 = Vector4.multiply((Vector4d)centerV4, (Matrix4d)m);
            Vector3 centerV3 = new Vector3(centerV4.x / centerV4.w, centerV4.y / centerV4.w, centerV4.z / centerV4.w);
            if (centerV3.x <= 1.0 && centerV3.x >= (double)-1 && centerV3.y <= 1.0 && centerV3.y >= (double)-1 && centerV3.z <= 1.0 && centerV3.z >= 0.0) {
                return true;
            }
        }
        return false;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

