/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;

public class Transformable
extends ReferenceFrame {
    public static final Property LOCAL_TRANSFORMATION_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Transformable == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Transformable = Transformable.class$("edu.cmu.cs.stage3.alice.scenegraph.Transformable")) : class$edu$cmu$cs$stage3$alice$scenegraph$Transformable, "LOCAL_TRANSFORMATION");
    public static final Property IS_FIRST_CLASS_PROPERTY = new Property(class$edu$cmu$cs$stage3$alice$scenegraph$Transformable == null ? (class$edu$cmu$cs$stage3$alice$scenegraph$Transformable = Transformable.class$("edu.cmu.cs.stage3.alice.scenegraph.Transformable")) : class$edu$cmu$cs$stage3$alice$scenegraph$Transformable, "IS_FIRST_CLASS");
    private Matrix4d m_localTransformation = null;
    private boolean m_isFirstClass = true;
    private static Transformable s_helperA = new Transformable();
    private static Transformable s_helperB = new Transformable();
    private Matrix4d m_absoluteTransformation = null;
    private Matrix4d m_inverseAbsoluteTransformation = null;
    private Object m_absoluteTransformationLock = new Object();
    static Class class$edu$cmu$cs$stage3$alice$scenegraph$Transformable;

    public Transformable() {
        this.m_localTransformation = new Matrix4d();
        this.m_localTransformation.setIdentity();
    }

    public boolean getIsFirstClass() {
        return this.m_isFirstClass;
    }

    public void setIsFirstClass(boolean isFirstClass) {
        if (this.m_isFirstClass != isFirstClass) {
            this.m_isFirstClass = isFirstClass;
            this.onPropertyChange(IS_FIRST_CLASS_PROPERTY);
        }
    }

    public Matrix4d getLocalTransformation() {
        if (this.m_localTransformation == null) {
            throw new NullPointerException();
        }
        return new Matrix44(this.m_localTransformation);
    }

    public void setLocalTransformation(Matrix4d localTransformation) {
        if (localTransformation == null) {
            throw new NullPointerException();
        }
        if (Element.notequal(this.m_localTransformation, localTransformation)) {
            if (Math.abs(localTransformation.m33 - 1.0) > 0.01) {
                System.err.println("JAVA SCENEGRAH LOCAL: holy corrupt matrix batman ".concat(String.valueOf(String.valueOf(localTransformation))));
            }
            this.m_localTransformation = localTransformation;
            this.onPropertyChange(LOCAL_TRANSFORMATION_PROPERTY);
            this.onAbsoluteTransformationChange();
        }
    }

    public Matrix4d getAbsoluteTransformation() {
        Object object = this.m_absoluteTransformationLock;
        synchronized (object) {
            if (this.m_absoluteTransformation == null) {
                Container parent = this.getParent();
                this.m_absoluteTransformation = parent != null ? Matrix44.multiply((Matrix4d)this.m_localTransformation, (Matrix4d)parent.getAbsoluteTransformation()) : new Matrix44(this.m_localTransformation);
                if (Math.abs(this.m_absoluteTransformation.m33 - 1.0) > 0.01) {
                    System.err.println("JAVA SCENEGRAH LOCAL: holy corrupt matrix batman ".concat(String.valueOf(String.valueOf(this.m_absoluteTransformation))));
                }
            }
            Matrix44 matrix44 = new Matrix44(this.m_absoluteTransformation);
            return matrix44;
        }
    }

    public Matrix4d getInverseAbsoluteTransformation() {
        Object object = this.m_absoluteTransformationLock;
        synchronized (object) {
            if (this.m_inverseAbsoluteTransformation == null) {
                this.m_inverseAbsoluteTransformation = this.getAbsoluteTransformation();
                try {
                    this.m_inverseAbsoluteTransformation.invert();
                }
                catch (SingularMatrixException sme) {
                    System.err.println("cannot invert: ".concat(String.valueOf(String.valueOf(this.m_inverseAbsoluteTransformation))));
                    throw sme;
                }
            }
            Matrix44 matrix44 = new Matrix44(this.m_inverseAbsoluteTransformation);
            return matrix44;
        }
    }

    protected void onAbsoluteTransformationChange() {
        super.onAbsoluteTransformationChange();
        Object object = this.m_absoluteTransformationLock;
        synchronized (object) {
            this.m_absoluteTransformation = null;
            this.m_inverseAbsoluteTransformation = null;
        }
    }

    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        ReferenceFrame vehicle = (ReferenceFrame)this.getParent();
        if (asSeenBy == null) {
            asSeenBy = vehicle;
        }
        if (asSeenBy == vehicle) {
            return new Matrix44(this.getLocalTransformation());
        }
        if (asSeenBy instanceof Scene) {
            return new Matrix44(this.getAbsoluteTransformation());
        }
        return super.getTransformation(asSeenBy);
    }

    public Matrix44 calculateTransformation(Matrix4d m, ReferenceFrame asSeenBy) {
        ReferenceFrame vehicle = (ReferenceFrame)this.getParent();
        if (asSeenBy == null) {
            asSeenBy = vehicle;
        }
        if (asSeenBy == vehicle) {
            return new Matrix44(m);
        }
        return Matrix44.multiply((Matrix4d)m, (Matrix4d)Matrix44.multiply((Matrix4d)asSeenBy.getAbsoluteTransformation(), (Matrix4d)vehicle.getInverseAbsoluteTransformation()));
    }

    public void setAbsoluteTransformation(Matrix4d m) {
        ReferenceFrame vehicle = (ReferenceFrame)this.getParent();
        this.setLocalTransformation((Matrix4d)Matrix44.multiply((Matrix4d)m, (Matrix4d)vehicle.getInverseAbsoluteTransformation()));
    }

    public void setTransformation(Matrix4d m, ReferenceFrame asSeenBy) {
        this.setLocalTransformation((Matrix4d)this.calculateTransformation(m, asSeenBy));
    }

    public void setPosition(Vector3d position, ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getAxes(null);
        Matrix44 m = new Matrix44();
        m.setPosition(position);
        m = this.calculateTransformation((Matrix4d)m, asSeenBy);
        m.setAxes((Matrix3d)axes);
        this.setLocalTransformation((Matrix4d)m);
    }

    public void setAxes(Matrix3d axes, ReferenceFrame asSeenBy) {
        Vector3 translation = this.getPosition(null);
        Matrix44 m = new Matrix44();
        m.setAxes(axes);
        m = this.calculateTransformation((Matrix4d)m, asSeenBy);
        m.setPosition((Vector3d)translation);
        this.setLocalTransformation((Matrix4d)m);
    }

    public void setQuaternion(Quaternion quaternion, ReferenceFrame asSeenBy) {
        this.setAxes((Matrix3d)quaternion.getMatrix33(), asSeenBy);
    }

    public Matrix33 calculatePointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy, boolean onlyAffectYaw) {
        Matrix33 result;
        ReferenceFrame actualTarget;
        if (upGuide == null) {
            upGuide = Vector3.Y_AXIS;
        }
        if (asSeenBy == null) {
            asSeenBy = (ReferenceFrame)this.getParent();
        }
        Matrix44 transform = this.getTransformation(asSeenBy);
        Vector3 position = transform.getPosition();
        if (offset == null) {
            actualTarget = target;
        } else {
            ReferenceFrame.s_helperOffset.setParent(target);
            Matrix44 m = new Matrix44();
            m.m30 = offset.x;
            m.m31 = offset.y;
            m.m32 = offset.z;
            ReferenceFrame.s_helperOffset.setLocalTransformation((Matrix4d)m);
            actualTarget = ReferenceFrame.s_helperOffset;
        }
        if (onlyAffectYaw) {
            s_helperA.setParent(asSeenBy);
            s_helperA.setLocalTransformation((Matrix4d)new Matrix44());
            s_helperA.setPosition((Vector3d)Vector3.ZERO, this);
            Vector3 targetPosition = actualTarget.getPosition(s_helperA);
            double targetTheta = Math.atan2(targetPosition.x, targetPosition.z);
            s_helperB.setParent(this);
            s_helperB.setPosition((Vector3d)Vector3.Z_AXIS, this);
            Vector3 forwardPosition = s_helperB.getPosition(s_helperA);
            double forwardTheta = Math.atan2(forwardPosition.x, forwardPosition.z);
            s_helperB.setLocalTransformation((Matrix4d)new Matrix44());
            double deltaTheta = targetTheta - forwardTheta;
            s_helperB.rotate((Vector3d)Vector3.Y_AXIS, deltaTheta, s_helperA);
            result = s_helperB.getAxes(asSeenBy);
            s_helperA.setParent(null);
            s_helperB.setParent(null);
        } else {
            Vector3 targetPosition = actualTarget.getPosition(asSeenBy);
            Vector3 zAxis = Vector3.normalizeV((Vector3d)Vector3.subtract((Vector3d)targetPosition, (Vector3d)position));
            Vector3 xAxis = Vector3.normalizeV((Vector3d)Vector3.crossProduct((Vector3d)upGuide, (Vector3d)zAxis));
            if (Double.isNaN(xAxis.getLengthSquared())) {
                throw new RuntimeException(String.valueOf(String.valueOf(new StringBuffer("cannot calculate point at: zAxis=").append(zAxis).append(" upGuide=").append(upGuide))));
            }
            Vector3 yAxis = Vector3.crossProduct((Vector3d)zAxis, (Vector3d)xAxis);
            result = new Matrix33(xAxis, yAxis, zAxis);
        }
        if (offset == null) {
            ReferenceFrame.s_helperOffset.setParent(null);
        }
        return result;
    }

    public Matrix33 calculatePointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy) {
        return this.calculatePointAt(target, offset, upGuide, asSeenBy, false);
    }

    public void pointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy) {
        this.setAxes((Matrix3d)this.calculatePointAt(target, offset, upGuide, asSeenBy), asSeenBy);
    }

    public static Matrix33 calculateOrientation(Vector3d forward, Vector3d upGuide) {
        Vector3 zAxis;
        Vector3 xAxis;
        if (upGuide == null) {
            upGuide = Vector3.Y_AXIS;
        }
        if (Double.isNaN((xAxis = Vector3.normalizeV((Vector3d)Vector3.crossProduct((Vector3d)upGuide, (Vector3d)(zAxis = Vector3.normalizeV((Vector3d)forward))))).getLengthSquared())) {
            throw new RuntimeException(String.valueOf(String.valueOf(new StringBuffer("cannot calculate orientation: forward=").append(forward).append(" upGuide=").append(upGuide))));
        }
        Vector3 yAxis = Vector3.crossProduct((Vector3d)zAxis, (Vector3d)xAxis);
        return new Matrix33(xAxis, yAxis, zAxis);
    }

    public void setOrientation(Vector3d forward, Vector3d upGuide, ReferenceFrame asSeenBy) {
        this.setAxes((Matrix3d)Transformable.calculateOrientation(forward, upGuide), asSeenBy);
    }

    public Matrix33 calculateStandUp(ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getAxes(asSeenBy);
        Vector3 yAxis = (Vector3)Vector3.Y_AXIS.clone();
        Vector3 zAxis = Vector3.normalizeV((Vector3d)Vector3.crossProduct((Vector3d)axes.getRow(0), (Vector3d)yAxis));
        Vector3 xAxis = Vector3.crossProduct((Vector3d)yAxis, (Vector3d)zAxis);
        return new Matrix33(xAxis, yAxis, zAxis);
    }

    public void standUp(ReferenceFrame asSeenBy) {
        this.setAxes((Matrix3d)this.calculateStandUp(asSeenBy), asSeenBy);
    }

    public void translate(Vector3d vector, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.translate(vector);
        this.setTransformation((Matrix4d)m, asSeenBy);
    }

    public void rotate(Vector3d axis, double amount, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.rotate(axis, amount);
        this.setTransformation((Matrix4d)m, asSeenBy);
    }

    public void scale(Vector3d axis, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.scale(axis);
        this.setTransformation((Matrix4d)m, asSeenBy);
    }

    public void transform(Matrix4d trans, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = this.getTransformation(asSeenBy);
        m.transform(trans);
        this.setTransformation((Matrix4d)m, asSeenBy);
    }

    public void setPivot(ReferenceFrame pivot) {
        Matrix44 m = this.getTransformation(pivot);
        Matrix44 mInverse = Matrix44.invert((Matrix44)m);
        this.transform((Matrix4d)mInverse, this);
        for (int i = 0; i < this.getChildCount(); ++i) {
            Component child = this.getChildAt(i);
            if (child instanceof Transformable) {
                ((Transformable)child).transform((Matrix4d)m, this);
                continue;
            }
            if (!(child instanceof Visual)) continue;
            ((Visual)child).transform((Matrix4d)m);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        s_helperA.setName("s_helperA");
        s_helperB.setName("s_helperB");
    }
}

