/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class ReferenceFrame
extends Container {
    protected static Transformable s_helperOffset = new Transformable();

    public Matrix44 getTransformation(Vector3d offset, ReferenceFrame asSeenBy) {
        ReferenceFrame actual;
        Matrix44 m;
        if (offset != null) {
            s_helperOffset.setParent(this);
            m = new Matrix44();
            m.m30 = offset.x;
            m.m31 = offset.y;
            m.m32 = offset.z;
            s_helperOffset.setLocalTransformation((Matrix4d)m);
            actual = s_helperOffset;
        } else {
            actual = this;
        }
        m = Matrix44.multiply((Matrix4d)actual.getAbsoluteTransformation(), (Matrix4d)asSeenBy.getInverseAbsoluteTransformation());
        if (offset != null) {
            s_helperOffset.setParent(null);
        }
        return m;
    }

    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        return this.getTransformation(null, asSeenBy);
    }

    public Vector3 getPosition(Vector3d offset, ReferenceFrame asSeenBy) {
        return this.getTransformation(asSeenBy).getPosition();
    }

    public Vector3 getPosition(ReferenceFrame asSeenBy) {
        return this.getPosition(null, asSeenBy);
    }

    public Matrix33 getAxes(ReferenceFrame asSeenBy) {
        return this.getTransformation(asSeenBy).getAxes();
    }

    public Vector3[] getOrientation(ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getAxes(asSeenBy);
        Vector3[] array = new Vector3[]{axes.getRow(2), axes.getRow(1)};
        return array;
    }

    public Quaternion getQuaternion(ReferenceFrame asSeenBy) {
        return this.getAxes(asSeenBy).getQuaternion();
    }

    public Vector4d transformTo(Vector4d xyzw, ReferenceFrame to) {
        return Vector4.multiply((Vector4d)xyzw, (Matrix4d)this.getTransformation(to));
    }

    public Vector3 transformTo(Vector3d xyz, ReferenceFrame to) {
        return new Vector3((Tuple4d)this.transformTo((Vector4d)new Vector4((Tuple3d)xyz, 1.0), to));
    }

    static {
        s_helperOffset.setName("s_helperOffset");
    }
}

