/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Container
extends Component {
    private Vector m_children = new Vector();
    private Component[] m_childArray = null;
    private Vector m_childrenListeners = new Vector();
    private ChildrenListener[] m_childrenListenerArray = null;

    public boolean isAncestorOf(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDescendantOf(this);
    }

    protected void releasePass1() {
        Component[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: released container ").append(this).append(" still has child ").append(children[i]).append("."))));
            children[i].setParent(null);
        }
        super.releasePass1();
    }

    protected void releasePass2() {
        this.m_children = null;
        this.m_childArray = null;
        super.releasePass2();
    }

    protected void releasePass3() {
        Enumeration enumeration = this.m_childrenListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enumeration.nextElement();
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: released container ").append(this).append(" still has childrenListener ").append(childrenListener).append("."))));
        }
        this.m_childrenListeners = null;
        this.m_childrenListenerArray = null;
        super.releasePass3();
    }

    protected void onAddChild(Component child) {
        if (this.isReleased()) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: scenegraph addChild ").append(child).append(" on already released ").append(this).append("."))));
        } else if (child.isReleased()) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: scenegraph addChild from ").append(this).append(" on already released child ").append(child).append("."))));
        } else {
            this.m_children.addElement(child);
            this.m_childArray = null;
            ChildrenEvent childrenEvent = new ChildrenEvent(this, child);
            ChildrenListener[] childrenListeners = this.getChildrenListeners();
            for (int i = 0; i < childrenListeners.length; ++i) {
                childrenListeners[i].childAdded(childrenEvent);
            }
        }
    }

    protected void onRemoveChild(Component child) {
        if (this.isReleased()) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: scenegraph removeChild ").append(child).append(" on already released ").append(this).append("."))));
        } else if (child.isReleased()) {
            Element.warnln(String.valueOf(String.valueOf(new StringBuffer("WARNING: scenegraph removeChild from ").append(this).append(" on already released child ").append(child).append("."))));
        } else {
            this.m_children.removeElement(child);
            this.m_childArray = null;
            ChildrenEvent childrenEvent = new ChildrenEvent(this, child);
            ChildrenListener[] childrenListeners = this.getChildrenListeners();
            for (int i = 0; i < childrenListeners.length; ++i) {
                childrenListeners[i].childRemoved(childrenEvent);
            }
        }
    }

    public Component[] getChildren() {
        if (this.m_childArray == null) {
            this.m_childArray = new Component[this.m_children.size()];
            this.m_children.copyInto(this.m_childArray);
        }
        return this.m_childArray;
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public Component getChildAt(int i) {
        return (Component)this.m_children.elementAt(i);
    }

    public void addChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.addElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public void removeChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.removeElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public ChildrenListener[] getChildrenListeners() {
        if (this.m_childrenListenerArray == null) {
            this.m_childrenListenerArray = new ChildrenListener[this.m_childrenListeners.size()];
            this.m_childrenListeners.copyInto(this.m_childrenListenerArray);
        }
        return this.m_childrenListenerArray;
    }

    protected void onAbsoluteTransformationChange() {
        super.onAbsoluteTransformationChange();
        Component[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].onAbsoluteTransformationChange();
        }
    }

    protected void onHierarchyChange() {
        super.onHierarchyChange();
        Component[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].onHierarchyChange();
        }
    }
}

