/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.HierarchyListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyListener;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.HeavyweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.LightweightOnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RendererEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RendererListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Vector3d;

public abstract class AbstractRenderer
extends Thread
implements Renderer,
AbsoluteTransformationListener,
BoundListener,
ChildrenListener,
HierarchyListener,
PropertyListener,
ReleaseListener {
    private Vector m_lightweightOnscreenRenderTargets = new Vector();
    private Vector m_heavyweightOnscreenRenderTargets = new Vector();
    private Vector m_offscreenRenderTargets = new Vector();
    private LightweightOnscreenRenderTarget[] m_lightweightOnscreenRenderTargetArray = null;
    private HeavyweightOnscreenRenderTarget[] m_heavyweightOnscreenRenderTargetArray = null;
    private OnscreenRenderTarget[] m_onscreenRenderTargetArray = null;
    private OffscreenRenderTarget[] m_offscreenRenderTargetArray = null;
    private Vector m_rendererListeners = new Vector();
    private RendererListener[] m_rendererListenerArray = null;
    private Object m_releaseMonitor = null;
    private boolean m_continue;
    private Vector m_pendingAbsoluteTransformationChanges = new Vector();
    private Vector m_pendingBoundChanges = new Vector();
    private Vector m_pendingChildAdd = new Vector();
    private Vector m_pendingChildRemove = new Vector();
    private Vector m_pendingHeirarchyChanges = new Vector();
    private Vector m_pendingPropertyChanges = new Vector();
    private Vector m_pendingReleases = new Vector();
    private int m_ignoreCount = 0;
    private RendererEvent m_rendererEvent = new RendererEvent(this);

    protected abstract void dispatchAbsoluteTransformationChange(AbsoluteTransformationEvent var1);

    protected abstract void dispatchBoundChange(BoundEvent var1);

    protected abstract void dispatchChildAdd(ChildrenEvent var1);

    protected abstract void dispatchChildRemove(ChildrenEvent var1);

    protected abstract void dispatchHierarchyChange(HierarchyEvent var1);

    protected abstract void dispatchPropertyChange(PropertyEvent var1);

    protected abstract void dispatchRelease(ReleaseEvent var1);

    protected abstract boolean requiresHierarchyAndAbsoluteTransformationListening();

    protected abstract boolean requiresBoundListening();

    public AbstractRenderer() {
        this.start();
    }

    public final OnscreenRenderTarget createOnscreenRenderTarget() {
        return this.createHeavyweightOnscreenRenderTarget();
    }

    public void enterIgnore() {
        ++this.m_ignoreCount;
    }

    public void leaveIgnore() {
        --this.m_ignoreCount;
    }

    private boolean ignore() {
        return this.m_ignoreCount > 0;
    }

    public void markAllRenderTargetsDirty() {
        if (this.m_ignoreCount <= 0) {
            int i;
            RenderTarget[] renderTargets = this.getOffscreenRenderTargets();
            for (i = 0; i < renderTargets.length; ++i) {
                renderTargets[i].markDirty();
            }
            renderTargets = this.getOnscreenRenderTargets();
            for (i = 0; i < renderTargets.length; ++i) {
                renderTargets[i].markDirty();
            }
        }
    }

    public void addListenersToSGElement(Element sgElement) {
        if (sgElement instanceof Geometry) {
            if (this.requiresBoundListening()) {
                ((Geometry)sgElement).addBoundListener((BoundListener)this);
            }
        } else if (sgElement instanceof Component) {
            if (sgElement instanceof Container) {
                ((Container)sgElement).addChildrenListener((ChildrenListener)this);
            }
            if (this.requiresHierarchyAndAbsoluteTransformationListening()) {
                ((Component)sgElement).addAbsoluteTransformationListener((AbsoluteTransformationListener)this);
                ((Component)sgElement).addHierarchyListener((HierarchyListener)this);
            }
        }
        sgElement.addPropertyListener((PropertyListener)this);
        sgElement.addReleaseListener((ReleaseListener)this);
    }

    public void removeListenersFromSGElement(Element sgElement) {
        if (sgElement instanceof Geometry) {
            if (this.requiresBoundListening()) {
                ((Geometry)sgElement).removeBoundListener((BoundListener)this);
            }
        } else if (sgElement instanceof Component) {
            if (sgElement instanceof Container) {
                ((Container)sgElement).removeChildrenListener((ChildrenListener)this);
            }
            if (this.requiresHierarchyAndAbsoluteTransformationListening()) {
                ((Component)sgElement).removeAbsoluteTransformationListener((AbsoluteTransformationListener)this);
                ((Component)sgElement).removeHierarchyListener((HierarchyListener)this);
            }
        }
        sgElement.removePropertyListener((PropertyListener)this);
        sgElement.removeReleaseListener((ReleaseListener)this);
    }

    public void commitAnyPendingChanges() {
        Enumeration enumeration;
        Vector vector;
        if (this.m_pendingAbsoluteTransformationChanges.size() > 0) {
            vector = this.m_pendingAbsoluteTransformationChanges;
            synchronized (vector) {
                enumeration = this.m_pendingAbsoluteTransformationChanges.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchAbsoluteTransformationChange((AbsoluteTransformationEvent)enumeration.nextElement());
                }
                this.m_pendingAbsoluteTransformationChanges.clear();
            }
        }
        if (this.m_pendingBoundChanges.size() > 0) {
            vector = this.m_pendingBoundChanges;
            synchronized (vector) {
                enumeration = this.m_pendingBoundChanges.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchBoundChange((BoundEvent)enumeration.nextElement());
                }
                this.m_pendingBoundChanges.clear();
            }
        }
        if (this.m_pendingChildAdd.size() > 0) {
            vector = this.m_pendingChildAdd;
            synchronized (vector) {
                enumeration = this.m_pendingChildAdd.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchChildAdd((ChildrenEvent)enumeration.nextElement());
                }
                this.m_pendingChildAdd.clear();
            }
        }
        if (this.m_pendingChildRemove.size() > 0) {
            vector = this.m_pendingChildRemove;
            synchronized (vector) {
                enumeration = this.m_pendingChildRemove.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchChildRemove((ChildrenEvent)enumeration.nextElement());
                }
                this.m_pendingChildRemove.clear();
            }
        }
        if (this.m_pendingHeirarchyChanges.size() > 0) {
            vector = this.m_pendingHeirarchyChanges;
            synchronized (vector) {
                enumeration = this.m_pendingHeirarchyChanges.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchHierarchyChange((HierarchyEvent)enumeration.nextElement());
                }
                this.m_pendingHeirarchyChanges.clear();
            }
        }
        if (this.m_pendingPropertyChanges.size() > 0) {
            vector = this.m_pendingPropertyChanges;
            synchronized (vector) {
                enumeration = this.m_pendingPropertyChanges.elements();
                while (enumeration.hasMoreElements()) {
                    this.dispatchPropertyChange((PropertyEvent)enumeration.nextElement());
                }
                this.m_pendingPropertyChanges.clear();
            }
        }
    }

    public void absoluteTransformationChanged(AbsoluteTransformationEvent absoluteTransformationEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchAbsoluteTransformationChange(absoluteTransformationEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingAbsoluteTransformationChanges.addElement(absoluteTransformationEvent);
        }
    }

    public void boundChanged(BoundEvent boundEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchBoundChange(boundEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingBoundChanges.addElement(boundEvent);
        }
    }

    public void childAdded(ChildrenEvent childrenEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchChildAdd(childrenEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingChildAdd.addElement(childrenEvent);
        }
    }

    public void childRemoved(ChildrenEvent childrenEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchChildRemove(childrenEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingChildRemove.addElement(childrenEvent);
        }
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchHierarchyChange(hierarchyEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingHeirarchyChanges.addElement(hierarchyEvent);
        }
    }

    public synchronized void changed(PropertyEvent propertyEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchPropertyChange(propertyEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingPropertyChanges.addElement(propertyEvent);
        }
    }

    public synchronized void releasing(ReleaseEvent releaseEvent) {
    }

    public synchronized void released(ReleaseEvent releaseEvent) {
        if (Thread.currentThread() == this) {
            this.dispatchRelease(releaseEvent);
            this.markAllRenderTargetsDirty();
        } else {
            this.m_pendingReleases.addElement(releaseEvent);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public boolean addRenderTarget(RenderTarget renderTarget) {
        block1: {
            block2: {
                block0: {
                    if (!(renderTarget instanceof HeavyweightOnscreenRenderTarget)) break block0;
                    this.m_onscreenRenderTargetArray = null;
                    this.m_heavyweightOnscreenRenderTargetArray = null;
                    this.m_heavyweightOnscreenRenderTargets.addElement(renderTarget);
                    break block1;
                }
                if (!(renderTarget instanceof LightweightOnscreenRenderTarget)) break block2;
                this.m_onscreenRenderTargetArray = null;
                this.m_lightweightOnscreenRenderTargetArray = null;
                this.m_lightweightOnscreenRenderTargets.addElement(renderTarget);
                break block1;
            }
            if (!(renderTarget instanceof OffscreenRenderTarget)) break block1;
            this.m_offscreenRenderTargetArray = null;
            this.m_offscreenRenderTargets.addElement(renderTarget);
        }
        return true;
    }

    public boolean removeRenderTarget(RenderTarget renderTarget) {
        if (renderTarget instanceof HeavyweightOnscreenRenderTarget) {
            this.m_onscreenRenderTargetArray = null;
            this.m_heavyweightOnscreenRenderTargetArray = null;
            return this.m_heavyweightOnscreenRenderTargets.removeElement(renderTarget);
        }
        if (renderTarget instanceof LightweightOnscreenRenderTarget) {
            this.m_onscreenRenderTargetArray = null;
            this.m_lightweightOnscreenRenderTargetArray = null;
            return this.m_lightweightOnscreenRenderTargets.removeElement(renderTarget);
        }
        if (renderTarget instanceof OffscreenRenderTarget) {
            this.m_offscreenRenderTargetArray = null;
            return this.m_offscreenRenderTargets.removeElement(renderTarget);
        }
        return true;
    }

    public HeavyweightOnscreenRenderTarget[] getHeavyweightOnscreenRenderTargets() {
        if (this.m_heavyweightOnscreenRenderTargetArray == null) {
            this.m_heavyweightOnscreenRenderTargetArray = new HeavyweightOnscreenRenderTarget[this.m_heavyweightOnscreenRenderTargets.size()];
            this.m_heavyweightOnscreenRenderTargets.copyInto(this.m_heavyweightOnscreenRenderTargetArray);
        }
        return this.m_heavyweightOnscreenRenderTargetArray;
    }

    public LightweightOnscreenRenderTarget[] getLightweightOnscreenRenderTargets() {
        if (this.m_lightweightOnscreenRenderTargetArray == null) {
            this.m_lightweightOnscreenRenderTargetArray = new LightweightOnscreenRenderTarget[this.m_lightweightOnscreenRenderTargets.size()];
            this.m_lightweightOnscreenRenderTargets.copyInto(this.m_lightweightOnscreenRenderTargetArray);
        }
        return this.m_lightweightOnscreenRenderTargetArray;
    }

    public OnscreenRenderTarget[] getOnscreenRenderTargets() {
        if (this.m_onscreenRenderTargetArray == null) {
            int j;
            this.m_onscreenRenderTargetArray = new OnscreenRenderTarget[this.m_heavyweightOnscreenRenderTargets.size() + this.m_lightweightOnscreenRenderTargets.size()];
            this.m_heavyweightOnscreenRenderTargets.copyInto(this.m_onscreenRenderTargetArray);
            int i = 0;
            for (j = 0; j < this.m_heavyweightOnscreenRenderTargets.size(); ++j) {
                this.m_onscreenRenderTargetArray[i++] = (OnscreenRenderTarget)this.m_heavyweightOnscreenRenderTargets.get(j);
            }
            for (j = 0; j < this.m_lightweightOnscreenRenderTargets.size(); ++j) {
                this.m_onscreenRenderTargetArray[i++] = (OnscreenRenderTarget)this.m_lightweightOnscreenRenderTargets.get(j);
            }
        }
        return this.m_onscreenRenderTargetArray;
    }

    public OffscreenRenderTarget[] getOffscreenRenderTargets() {
        if (this.m_offscreenRenderTargetArray == null) {
            this.m_offscreenRenderTargetArray = new OffscreenRenderTarget[this.m_offscreenRenderTargets.size()];
            this.m_offscreenRenderTargets.copyInto(this.m_offscreenRenderTargetArray);
        }
        return this.m_offscreenRenderTargetArray;
    }

    public synchronized void release() {
        if (this.m_continue) {
            this.m_continue = false;
            if (Thread.currentThread() != this) {
                try {
                    this.m_releaseMonitor = new Object();
                    this.m_releaseMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void addRendererListener(RendererListener rendererListener) {
        if (rendererListener == null) {
            throw new NullPointerException();
        }
        this.m_rendererListeners.addElement(rendererListener);
        this.m_rendererListenerArray = null;
    }

    public void removeRendererListener(RendererListener rendererListener) {
        if (rendererListener == null) {
            throw new NullPointerException();
        }
        this.m_rendererListeners.removeElement(rendererListener);
        this.m_rendererListenerArray = null;
    }

    public RendererListener[] getRendererListeners() {
        if (this.m_rendererListenerArray == null) {
            this.m_rendererListenerArray = new RendererListener[this.m_rendererListeners.size()];
            this.m_rendererListeners.copyInto(this.m_rendererListenerArray);
        }
        return this.m_rendererListenerArray;
    }

    protected void onIdle() {
        RendererListener[] rls = this.getRendererListeners();
        for (int i = 0; i < rls.length; ++i) {
            rls[i].idle(this.m_rendererEvent);
        }
    }

    protected abstract void doFrame();

    public void run() {
        this.m_continue = false;
        while (this.m_releaseMonitor == null) {
            this.doFrame();
        }
        OnscreenRenderTarget[] onscreenRenderTargets = this.getOnscreenRenderTargets();
        for (int i = 0; i < onscreenRenderTargets.length; ++i) {
            onscreenRenderTargets[i].release();
        }
        OffscreenRenderTarget[] offscreenRenderTargets = this.getOffscreenRenderTargets();
        for (int i = 0; i < offscreenRenderTargets.length; ++i) {
            offscreenRenderTargets[i].release();
        }
        if (this.m_releaseMonitor != null) {
            this.m_releaseMonitor.notifyAll();
        }
    }

    public abstract PickInfo pick(Component var1, Vector3d var2, double var3, double var5, double var7, double var9, double var11, double var13, boolean var15, boolean var16);

    public abstract DisplayDriver[] getDisplayDrivers();

    public abstract OffscreenRenderTarget createOffscreenRenderTarget();

    public abstract HeavyweightOnscreenRenderTarget createHeavyweightOnscreenRenderTarget();

    public abstract LightweightOnscreenRenderTarget createLightweightOnscreenRenderTarget();
}

