/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ReleaseEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractRenderer;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractProxyRenderer
extends AbstractRenderer {
    private Hashtable m_sgElementToProxyMap = new Hashtable();
    private Vector m_queuedPropertyChanges = new Vector();

    protected void dispatchPropertyChange(PropertyEvent propertyEvent) {
        Property property = propertyEvent.getProperty();
        Element sgElement = (Element)propertyEvent.getSource();
        if (!sgElement.isReleased()) {
            AbstractProxy proxy = this.getProxyFor(sgElement);
            proxy.changed(property, property.get((Object)sgElement));
            this.markAllRenderTargetsDirty();
        }
    }

    protected void dispatchRelease(ReleaseEvent releaseEvent) {
        Element sgElement = (Element)releaseEvent.getSource();
        AbstractProxy proxy = this.getProxyFor(sgElement);
        proxy.release();
    }

    protected abstract AbstractProxy createProxyFor(Element var1);

    public AbstractProxy getProxyFor(Element sgElement) {
        AbstractProxy proxy;
        if (sgElement != null) {
            proxy = (AbstractProxy)this.m_sgElementToProxyMap.get(sgElement);
            if (proxy == null) {
                proxy = this.createProxyFor(sgElement);
                if (proxy != null) {
                    this.m_sgElementToProxyMap.put(sgElement, proxy);
                    proxy.initialize(sgElement, this);
                    this.createNecessaryProxies(sgElement);
                } else {
                    Element.warnln((Object)"warning: could not create proxy for: ".concat(String.valueOf(String.valueOf(sgElement))));
                }
            } else if (proxy.getSceneGraphElement() == null) {
                proxy = null;
                Element.warnln((Object)String.valueOf(String.valueOf(sgElement)).concat("'s proxy has null for a sgElement"));
            }
        } else {
            proxy = null;
        }
        return proxy;
    }

    public AbstractProxy[] getProxiesFor(Element[] sgElements, Class componentType) {
        if (sgElements != null) {
            AbstractProxy[] proxies = (AbstractProxy[])Array.newInstance(componentType, sgElements.length);
            for (int i = 0; i < sgElements.length; ++i) {
                proxies[i] = this.getProxyFor(sgElements[i]);
            }
            return proxies;
        }
        return null;
    }

    public void forgetProxyFor(Element sgElement) {
        this.m_sgElementToProxyMap.remove(sgElement);
    }

    public void createNecessaryProxies(Element sgElement) {
        this.getProxyFor(sgElement);
        if (sgElement instanceof Container) {
            Container sgContainer = (Container)sgElement;
            for (int i = 0; i < sgContainer.getChildCount(); ++i) {
                Component sgComponent = sgContainer.getChildAt(i);
                this.getProxyFor((Element)sgComponent);
                if (!(sgComponent instanceof Container)) continue;
                this.createNecessaryProxies((Element)((Container)sgComponent));
            }
        }
    }
}

