/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderer;
import java.util.Enumeration;

public abstract class AbstractProxy {
    private Element m_sgElement;
    private AbstractProxyRenderer m_abstractProxyRenderer;

    public void initialize(Element sgElement, AbstractProxyRenderer renderer) {
        this.m_sgElement = sgElement;
        this.setRenderer(renderer);
        this.initializeProperties();
        renderer.addListenersToSGElement(sgElement);
    }

    public void release() {
        this.m_abstractProxyRenderer.removeListenersFromSGElement(this.m_sgElement);
        this.m_abstractProxyRenderer.forgetProxyFor(this.m_sgElement);
        this.m_sgElement = null;
    }

    protected void setRenderer(AbstractProxyRenderer renderer) {
        this.m_abstractProxyRenderer = renderer;
    }

    protected void initializeProperties() {
        Enumeration enumeration = Property.getProperties(this.m_sgElement.getClass()).elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            this.changed(property, property.get((Object)this.m_sgElement));
        }
    }

    protected abstract void changed(Property var1, Object var2);

    public Element getSceneGraphElement() {
        return this.m_sgElement;
    }

    public AbstractProxyRenderer getRenderer() {
        return this.m_abstractProxyRenderer;
    }

    protected AbstractProxy getProxyFor(Element sgElement) {
        return this.m_abstractProxyRenderer.getProxyFor(sgElement);
    }

    protected AbstractProxy[] getProxiesFor(Element[] sgElements, Class componentType) {
        return this.m_abstractProxyRenderer.getProxiesFor(sgElements, componentType);
    }

    protected void createNecessaryProxies(Element sgElement) {
        this.m_abstractProxyRenderer.createNecessaryProxies(sgElement);
    }

    protected void markAllRenderTargetsDirty() {
        this.m_abstractProxyRenderer.markAllRenderTargetsDirty();
    }
}

