/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector4d;

public class Vector4
extends Vector4d {
    public Vector4() {
    }

    public Vector4(double x, double y, double z, double w) {
        ((Tuple4d)this).x = x;
        ((Tuple4d)this).y = y;
        ((Tuple4d)this).z = z;
        ((Tuple4d)this).w = w;
    }

    public Vector4(double[] v) {
        this(v[0], v[1], v[2], v[3]);
    }

    public Vector4(Tuple3d v, double w) {
        this(v.x, v.y, v.z, w);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Vector4) {
            Vector4 v = (Vector4)((Object)o);
            return ((Tuple4d)this).x == ((Tuple4d)v).x && ((Tuple4d)this).y == ((Tuple4d)v).y && ((Tuple4d)this).z == ((Tuple4d)v).z && ((Tuple4d)this).w == ((Tuple4d)v).w;
        }
        return false;
    }

    public double[] getArray() {
        double[] a = new double[]{((Tuple4d)this).x, ((Tuple4d)this).y, ((Tuple4d)this).z, ((Tuple4d)this).w};
        return a;
    }

    public void setArray(double[] a) {
        ((Tuple4d)this).x = a[0];
        ((Tuple4d)this).y = a[1];
        ((Tuple4d)this).z = a[2];
        ((Tuple4d)this).w = a[3];
    }

    public void set(Vector4 other) {
        ((Tuple4d)this).x = ((Tuple4d)other).x;
        ((Tuple4d)this).y = ((Tuple4d)other).y;
        ((Tuple4d)this).z = ((Tuple4d)other).z;
        ((Tuple4d)this).w = ((Tuple4d)other).w;
    }

    public boolean equals(Vector4 v) {
        return ((Tuple4d)this).x == ((Tuple4d)v).x && ((Tuple4d)this).y == ((Tuple4d)v).y && ((Tuple4d)this).z == ((Tuple4d)v).z && ((Tuple4d)this).w == ((Tuple4d)v).w;
    }

    public double getItem(int i) {
        switch (i) {
            case 0: {
                return ((Tuple4d)this).x;
            }
            case 1: {
                return ((Tuple4d)this).y;
            }
            case 2: {
                return ((Tuple4d)this).z;
            }
            case 3: {
                return ((Tuple4d)this).w;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setItem(int i, double v) {
        switch (i) {
            case 0: {
                ((Tuple4d)this).x = v;
                return;
            }
            case 1: {
                ((Tuple4d)this).y = v;
                return;
            }
            case 2: {
                ((Tuple4d)this).z = v;
                return;
            }
            case 3: {
                ((Tuple4d)this).w = v;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vector4 negate(Vector4 v) {
        return new Vector4(-((Tuple4d)v).x, -((Tuple4d)v).y, -((Tuple4d)v).z, -((Tuple4d)v).w);
    }

    public static double dotProduct(Vector4 a, Vector4 b) {
        return ((Tuple4d)a).x * ((Tuple4d)b).x + ((Tuple4d)a).y * ((Tuple4d)b).y + ((Tuple4d)a).z * ((Tuple4d)b).z + ((Tuple4d)a).w * ((Tuple4d)b).w;
    }

    public static Vector4 multiply(Vector4d a, Matrix4d b) {
        Vector4 ab = new Vector4();
        ((Tuple4d)ab).x = a.x * b.m00 + a.y * b.m10 + a.z * b.m20 + a.w * b.m30;
        ((Tuple4d)ab).y = a.x * b.m01 + a.y * b.m11 + a.z * b.m21 + a.w * b.m31;
        ((Tuple4d)ab).z = a.x * b.m02 + a.y * b.m12 + a.z * b.m22 + a.w * b.m32;
        ((Tuple4d)ab).w = a.x * b.m03 + a.y * b.m13 + a.z * b.m23 + a.w * b.m33;
        return ab;
    }

    public static Vector4 multiply(Matrix4d a, Vector4d b) {
        Vector4 ab = new Vector4();
        ((Tuple4d)ab).x = b.x * a.m00 + b.y * a.m01 + b.z * a.m02 + b.w * a.m03;
        ((Tuple4d)ab).y = b.x * a.m10 + b.y * a.m11 + b.z * a.m12 + b.w * a.m13;
        ((Tuple4d)ab).z = b.x * a.m20 + b.y * a.m21 + b.z * a.m22 + b.w * a.m23;
        ((Tuple4d)ab).w = b.x * a.m30 + b.y * a.m31 + b.z * a.m32 + b.w * a.m33;
        return ab;
    }

    public void transform(Matrix4d m) {
        this.set(Vector4.multiply(this, m));
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("edu.cmu.cs.stage3.math.Vector4[x=").append(((Tuple4d)this).x).append(",y=").append(((Tuple4d)this).y).append(",z=").append(((Tuple4d)this).z).append(",w=").append(((Tuple4d)this).w).append("]")));
    }

    public static Vector4 valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Vector4[x=", ",y=", ",z=", ",w=", "]"};
        double[] values = new double[markers.length - 1];
        for (int i = 0; i < values.length; ++i) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
        }
        return new Vector4(values);
    }
}

