/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.AxisAngle;
import edu.cmu.cs.stage3.math.Interpolable;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.SingularityException;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class Matrix44
extends Matrix4d
implements Interpolable {
    public static final Matrix44 IDENTITY = new Matrix44();

    public Matrix44() {
        this(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix44(double rc00, double rc01, double rc02, double rc03, double rc10, double rc11, double rc12, double rc13, double rc20, double rc21, double rc22, double rc23, double rc30, double rc31, double rc32, double rc33) {
        this.m00 = rc00;
        this.m01 = rc01;
        this.m02 = rc02;
        this.m03 = rc03;
        this.m10 = rc10;
        this.m11 = rc11;
        this.m12 = rc12;
        this.m13 = rc13;
        this.m20 = rc20;
        this.m21 = rc21;
        this.m22 = rc22;
        this.m23 = rc23;
        this.m30 = rc30;
        this.m31 = rc31;
        this.m32 = rc32;
        this.m33 = rc33;
    }

    public Matrix44(double[] row0, double[] row1, double[] row2, double[] row3) {
        this(row0[0], row0[1], row0[2], row0[3], row1[0], row1[1], row1[2], row1[3], row2[0], row2[1], row2[2], row2[3], row3[0], row3[1], row3[2], row3[3]);
    }

    public Matrix44(double[] a) {
        this(a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15]);
    }

    public Matrix44(double[][] m) {
        this(m[0], m[1], m[2], m[3]);
    }

    public Matrix44(Matrix4d m) {
        if (m == null) {
            throw new NullPointerException();
        }
        this.set(m);
    }

    public Matrix44(Matrix3d axes, Vector3 t) {
        this.setAxes(axes);
        this.setPosition(t);
        this.m33 = 1.0;
    }

    public Matrix44(AxisAngle aa, Vector3 t) {
        this(aa.getMatrix33(), t);
    }

    public Matrix44(Quaternion q, Vector3 t) {
        this(q.getMatrix33(), t);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Matrix44) {
            Matrix44 m = (Matrix44)o;
            return this.m00 == m.m00 && this.m01 == m.m01 && this.m02 == m.m02 && this.m03 == m.m03 && this.m10 == m.m10 && this.m11 == m.m11 && this.m12 == m.m12 && this.m13 == m.m13 && this.m20 == m.m20 && this.m21 == m.m21 && this.m22 == m.m22 && this.m23 == m.m23 && this.m30 == m.m30 && this.m31 == m.m31 && this.m32 == m.m32 && this.m33 == m.m33;
        }
        return false;
    }

    public double getItem(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
                break;
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
                break;
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
                break;
            }
            case 3: {
                switch (j) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void setItem(int i, int j, double v) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        this.m00 = v;
                        return;
                    }
                    case 1: {
                        this.m01 = v;
                        return;
                    }
                    case 2: {
                        this.m02 = v;
                        return;
                    }
                    case 3: {
                        this.m03 = v;
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (j) {
                    case 0: {
                        this.m10 = v;
                        return;
                    }
                    case 1: {
                        this.m11 = v;
                        return;
                    }
                    case 2: {
                        this.m12 = v;
                        return;
                    }
                    case 3: {
                        this.m13 = v;
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (j) {
                    case 0: {
                        this.m20 = v;
                        return;
                    }
                    case 1: {
                        this.m21 = v;
                        return;
                    }
                    case 2: {
                        this.m22 = v;
                        return;
                    }
                    case 3: {
                        this.m23 = v;
                        return;
                    }
                }
                break;
            }
            case 3: {
                switch (j) {
                    case 0: {
                        this.m30 = v;
                        return;
                    }
                    case 1: {
                        this.m31 = v;
                        return;
                    }
                    case 2: {
                        this.m32 = v;
                        return;
                    }
                    case 3: {
                        this.m33 = v;
                        return;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4 getRow(int i) {
        switch (i) {
            case 0: {
                return new Vector4(this.m00, this.m01, this.m02, this.m03);
            }
            case 1: {
                return new Vector4(this.m10, this.m11, this.m12, this.m13);
            }
            case 2: {
                return new Vector4(this.m20, this.m21, this.m22, this.m23);
            }
            case 3: {
                return new Vector4(this.m30, this.m31, this.m32, this.m33);
            }
        }
        return null;
    }

    public void setRow(int i, Vector4 v) {
        switch (i) {
            case 0: {
                this.m00 = ((Tuple4d)v).x;
                this.m01 = ((Tuple4d)v).y;
                this.m02 = ((Tuple4d)v).z;
                this.m03 = ((Tuple4d)v).w;
                break;
            }
            case 1: {
                this.m10 = ((Tuple4d)v).x;
                this.m11 = ((Tuple4d)v).y;
                this.m12 = ((Tuple4d)v).z;
                this.m13 = ((Tuple4d)v).w;
                break;
            }
            case 2: {
                this.m20 = ((Tuple4d)v).x;
                this.m21 = ((Tuple4d)v).y;
                this.m22 = ((Tuple4d)v).z;
                this.m23 = ((Tuple4d)v).w;
                break;
            }
            case 3: {
                this.m30 = ((Tuple4d)v).x;
                this.m31 = ((Tuple4d)v).y;
                this.m32 = ((Tuple4d)v).z;
                this.m33 = ((Tuple4d)v).w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Vector4 getColumn(int i) {
        switch (i) {
            case 0: {
                return new Vector4(this.m00, this.m10, this.m20, this.m30);
            }
            case 1: {
                return new Vector4(this.m01, this.m11, this.m21, this.m31);
            }
            case 2: {
                return new Vector4(this.m02, this.m12, this.m22, this.m32);
            }
            case 3: {
                return new Vector4(this.m03, this.m13, this.m23, this.m33);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setColumn(int i, Vector4 v) {
        switch (i) {
            case 0: {
                this.m00 = ((Tuple4d)v).x;
                this.m10 = ((Tuple4d)v).y;
                this.m20 = ((Tuple4d)v).z;
                this.m30 = ((Tuple4d)v).w;
                break;
            }
            case 1: {
                this.m01 = ((Tuple4d)v).x;
                this.m11 = ((Tuple4d)v).y;
                this.m21 = ((Tuple4d)v).z;
                this.m31 = ((Tuple4d)v).w;
                break;
            }
            case 2: {
                this.m02 = ((Tuple4d)v).x;
                this.m12 = ((Tuple4d)v).y;
                this.m22 = ((Tuple4d)v).z;
                this.m32 = ((Tuple4d)v).w;
                break;
            }
            case 3: {
                this.m03 = ((Tuple4d)v).x;
                this.m13 = ((Tuple4d)v).y;
                this.m23 = ((Tuple4d)v).z;
                this.m33 = ((Tuple4d)v).w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public double[] getArray(boolean rowMajor) {
        if (rowMajor) {
            double[] a = new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
            return a;
        }
        double[] a = new double[]{this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33};
        return a;
    }

    public void setArray(double[] a, boolean rowMajor) {
        if (rowMajor) {
            this.m00 = a[0];
            this.m01 = a[1];
            this.m02 = a[2];
            this.m03 = a[3];
            this.m10 = a[4];
            this.m11 = a[5];
            this.m12 = a[6];
            this.m13 = a[7];
            this.m20 = a[8];
            this.m21 = a[9];
            this.m22 = a[10];
            this.m23 = a[11];
            this.m30 = a[12];
            this.m31 = a[13];
            this.m32 = a[14];
            this.m33 = a[15];
        } else {
            this.m00 = a[0];
            this.m01 = a[4];
            this.m02 = a[8];
            this.m03 = a[12];
            this.m10 = a[1];
            this.m11 = a[5];
            this.m12 = a[9];
            this.m13 = a[13];
            this.m20 = a[2];
            this.m21 = a[6];
            this.m22 = a[10];
            this.m23 = a[14];
            this.m30 = a[3];
            this.m31 = a[7];
            this.m32 = a[11];
            this.m33 = a[15];
        }
    }

    public double[][] getMatrix() {
        double[][] m = new double[][]{{this.m00, this.m01, this.m02, this.m03}, {this.m10, this.m11, this.m12, this.m13}, {this.m20, this.m21, this.m22, this.m23}, {this.m30, this.m31, this.m32, this.m33}};
        return m;
    }

    public void setMatrix(double[][] m) {
        this.m00 = m[0][0];
        this.m01 = m[0][1];
        this.m02 = m[0][2];
        this.m03 = m[0][3];
        this.m10 = m[1][0];
        this.m11 = m[1][1];
        this.m12 = m[1][2];
        this.m13 = m[1][3];
        this.m20 = m[2][0];
        this.m21 = m[2][1];
        this.m22 = m[2][2];
        this.m23 = m[2][3];
        this.m30 = m[3][0];
        this.m31 = m[3][1];
        this.m32 = m[3][2];
        this.m33 = m[3][3];
    }

    public void set(Matrix44 other) {
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m03 = other.m03;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m13 = other.m13;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        this.m23 = other.m23;
        this.m30 = other.m30;
        this.m31 = other.m31;
        this.m32 = other.m32;
        this.m33 = other.m33;
    }

    public Vector3 getPosition() {
        return new Vector3(this.m30, this.m31, this.m32);
    }

    public void setPosition(Vector3d position) {
        this.m30 = position.x;
        this.m31 = position.y;
        this.m32 = position.z;
    }

    public Matrix33 getAxes() {
        return new Matrix33(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public void setAxes(Matrix3d axes) {
        this.m00 = axes.m00;
        this.m01 = axes.m01;
        this.m02 = axes.m02;
        this.m10 = axes.m10;
        this.m11 = axes.m11;
        this.m12 = axes.m12;
        this.m20 = axes.m20;
        this.m21 = axes.m21;
        this.m22 = axes.m22;
    }

    public void translate(Vector3d vector) {
        if (vector.x != 0.0) {
            this.m00 += this.m03 * vector.x;
            this.m10 += this.m13 * vector.x;
            this.m20 += this.m23 * vector.x;
            this.m30 += this.m33 * vector.x;
        }
        if (vector.y != 0.0) {
            this.m01 += this.m03 * vector.y;
            this.m11 += this.m13 * vector.y;
            this.m21 += this.m23 * vector.y;
            this.m31 += this.m33 * vector.y;
        }
        if (vector.z != 0.0) {
            this.m02 += this.m03 * vector.z;
            this.m12 += this.m13 * vector.z;
            this.m22 += this.m23 * vector.z;
            this.m32 += this.m33 * vector.z;
        }
    }

    public void rotateX(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        for (int i = 0; i < 4; ++i) {
            double tmp = this.getItem(i, 1);
            this.setItem(i, 1, tmp * cosAngle - this.getItem(i, 2) * sinAngle);
            this.setItem(i, 2, tmp * sinAngle + this.getItem(i, 2) * cosAngle);
        }
    }

    public void rotateY(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        for (int i = 0; i < 4; ++i) {
            double tmp = this.getItem(i, 0);
            this.setItem(i, 0, tmp * cosAngle + this.getItem(i, 2) * sinAngle);
            this.setItem(i, 2, -tmp * sinAngle + this.getItem(i, 2) * cosAngle);
        }
    }

    public void rotateZ(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        for (int i = 0; i < 4; ++i) {
            double tmp = this.getItem(i, 0);
            this.setItem(i, 0, tmp * cosAngle - this.getItem(i, 1) * sinAngle);
            this.setItem(i, 1, tmp * sinAngle + this.getItem(i, 1) * cosAngle);
        }
    }

    public void scale(Vector3d vector) {
        if (vector.x != 1.0) {
            this.m00 *= vector.x;
            this.m10 *= vector.x;
            this.m20 *= vector.x;
            this.m30 *= vector.x;
        }
        if (vector.y != 1.0) {
            this.m01 *= vector.y;
            this.m11 *= vector.y;
            this.m21 *= vector.y;
            this.m31 *= vector.y;
        }
        if (vector.z != 1.0) {
            this.m02 *= vector.z;
            this.m12 *= vector.z;
            this.m22 *= vector.z;
            this.m32 *= vector.z;
        }
    }

    public void transform(Matrix4d m) {
        this.set(Matrix44.multiply(this, m));
    }

    public void rotate(Vector3d axis, double angle) {
        if (axis.equals((Tuple3d)Vector3.X_AXIS)) {
            this.rotateX(angle);
        } else if (axis.equals((Tuple3d)Vector3.Y_AXIS)) {
            this.rotateY(angle);
        } else if (axis.equals((Tuple3d)Vector3.Z_AXIS)) {
            this.rotateZ(angle);
        } else if (axis.equals((Tuple3d)Vector3.X_AXIS_NEGATIVE)) {
            this.rotateX(-angle);
        } else if (axis.equals((Tuple3d)Vector3.Y_AXIS_NEGATIVE)) {
            this.rotateY(-angle);
        } else if (axis.equals((Tuple3d)Vector3.Z_AXIS_NEGATIVE)) {
            this.rotateZ(-angle);
        } else {
            Matrix44 m = new Matrix44();
            double cosAngle = Math.cos(angle);
            double sinAngle = Math.sin(angle);
            m.m00 = axis.x * axis.x + cosAngle * ((double)1.0f - axis.x * axis.x);
            m.m01 = axis.x * axis.y * ((double)1.0f - cosAngle) + axis.z * sinAngle;
            m.m02 = axis.z * axis.x * ((double)1.0f - cosAngle) - axis.y * sinAngle;
            m.m10 = axis.x * axis.y * ((double)1.0f - cosAngle) - axis.z * sinAngle;
            m.m11 = axis.y * axis.y + cosAngle * ((double)1.0f - axis.y * axis.y);
            m.m12 = axis.y * axis.z * ((double)1.0f - cosAngle) + axis.x * sinAngle;
            m.m20 = axis.z * axis.x * ((double)1.0f - cosAngle) + axis.y * sinAngle;
            m.m21 = axis.y * axis.z * ((double)1.0f - cosAngle) - axis.x * sinAngle;
            m.m22 = axis.z * axis.z + cosAngle * ((double)1.0f - axis.z * axis.z);
            this.transform(m);
        }
    }

    public static Matrix44 multiply(Matrix4d a, Matrix4d b) {
        Matrix44 m = new Matrix44();
        m.m00 = a.m00 * b.m00 + a.m01 * b.m10 + a.m02 * b.m20 + a.m03 * b.m30;
        m.m01 = a.m00 * b.m01 + a.m01 * b.m11 + a.m02 * b.m21 + a.m03 * b.m31;
        m.m02 = a.m00 * b.m02 + a.m01 * b.m12 + a.m02 * b.m22 + a.m03 * b.m32;
        m.m03 = a.m00 * b.m03 + a.m01 * b.m13 + a.m02 * b.m23 + a.m03 * b.m33;
        m.m10 = a.m10 * b.m00 + a.m11 * b.m10 + a.m12 * b.m20 + a.m13 * b.m30;
        m.m11 = a.m10 * b.m01 + a.m11 * b.m11 + a.m12 * b.m21 + a.m13 * b.m31;
        m.m12 = a.m10 * b.m02 + a.m11 * b.m12 + a.m12 * b.m22 + a.m13 * b.m32;
        m.m13 = a.m10 * b.m03 + a.m11 * b.m13 + a.m12 * b.m23 + a.m13 * b.m33;
        m.m20 = a.m20 * b.m00 + a.m21 * b.m10 + a.m22 * b.m20 + a.m23 * b.m30;
        m.m21 = a.m20 * b.m01 + a.m21 * b.m11 + a.m22 * b.m21 + a.m23 * b.m31;
        m.m22 = a.m20 * b.m02 + a.m21 * b.m12 + a.m22 * b.m22 + a.m23 * b.m32;
        m.m23 = a.m20 * b.m03 + a.m21 * b.m13 + a.m22 * b.m23 + a.m23 * b.m33;
        m.m30 = a.m30 * b.m00 + a.m31 * b.m10 + a.m32 * b.m20 + a.m33 * b.m30;
        m.m31 = a.m30 * b.m01 + a.m31 * b.m11 + a.m32 * b.m21 + a.m33 * b.m31;
        m.m32 = a.m30 * b.m02 + a.m31 * b.m12 + a.m32 * b.m22 + a.m33 * b.m32;
        m.m33 = a.m30 * b.m03 + a.m31 * b.m13 + a.m32 * b.m23 + a.m33 * b.m33;
        return m;
    }

    public static Matrix44 transpose(Matrix44 m) {
        Matrix44 mTranspose = new Matrix44();
        mTranspose.m00 = m.m00;
        mTranspose.m01 = m.m10;
        mTranspose.m02 = m.m20;
        mTranspose.m03 = m.m30;
        mTranspose.m10 = m.m01;
        mTranspose.m11 = m.m11;
        mTranspose.m12 = m.m21;
        mTranspose.m13 = m.m31;
        mTranspose.m20 = m.m02;
        mTranspose.m21 = m.m12;
        mTranspose.m22 = m.m22;
        mTranspose.m23 = m.m32;
        mTranspose.m30 = m.m03;
        mTranspose.m31 = m.m13;
        mTranspose.m32 = m.m23;
        mTranspose.m33 = m.m33;
        return mTranspose;
    }

    public void divide(double denom) {
        this.m00 /= denom;
        this.m01 /= denom;
        this.m02 /= denom;
        this.m03 /= denom;
        this.m10 /= denom;
        this.m11 /= denom;
        this.m12 /= denom;
        this.m13 /= denom;
        this.m20 /= denom;
        this.m21 /= denom;
        this.m22 /= denom;
        this.m23 /= denom;
        this.m30 /= denom;
        this.m31 /= denom;
        this.m32 /= denom;
        this.m33 /= denom;
    }

    private static Vector3 ROW(Vector4 a, Vector4 b, Vector4 c, int index) {
        return new Vector3(a.getItem(index), b.getItem(index), c.getItem(index));
    }

    private static double DET(Vector4 a, Vector4 b, Vector4 c, int i, int j, int k) {
        return Vector3.dotProduct(Matrix44.ROW(a, b, c, i), Vector3.crossProduct(Matrix44.ROW(a, b, c, j), Matrix44.ROW(a, b, c, k)));
    }

    private static Vector4 cross(Vector4 a, Vector4 b, Vector4 c) {
        Vector4 result = new Vector4();
        ((Tuple4d)result).x = Matrix44.DET(a, b, c, 1, 2, 3);
        ((Tuple4d)result).y = -Matrix44.DET(a, b, c, 0, 2, 3);
        ((Tuple4d)result).z = Matrix44.DET(a, b, c, 0, 1, 3);
        ((Tuple4d)result).w = -Matrix44.DET(a, b, c, 0, 1, 2);
        return result;
    }

    public static Matrix44 adjoint(Matrix44 m) {
        Matrix44 mAdjoint = new Matrix44();
        mAdjoint.setRow(0, Matrix44.cross(m.getRow(1), m.getRow(2), m.getRow(3)));
        mAdjoint.setRow(1, Vector4.negate(Matrix44.cross(m.getRow(0), m.getRow(2), m.getRow(3))));
        mAdjoint.setRow(2, Matrix44.cross(m.getRow(0), m.getRow(1), m.getRow(3)));
        mAdjoint.setRow(3, Vector4.negate(Matrix44.cross(m.getRow(0), m.getRow(1), m.getRow(2))));
        return mAdjoint;
    }

    public static Matrix44 invert(Matrix44 m) {
        Matrix44 mInverse = new Matrix44();
        if (Math.abs(m.m03) > 0.001 || Math.abs(m.m13) > 0.001 || Math.abs(m.m23) > 0.001 || Math.abs(m.m33 - 1.0) > 0.001) {
            Matrix44 adj = Matrix44.adjoint(m);
            double mDet = Vector4.dotProduct(adj.getRow(0), m.getRow(0));
            if (mDet == 0.0) {
                throw new SingularityException();
            }
            mInverse = Matrix44.transpose(adj);
            mInverse.divide(mDet);
        } else {
            double fDetInv = 1.0 / (m.m00 * (m.m11 * m.m22 - m.m12 * m.m21) - m.m01 * (m.m10 * m.m22 - m.m12 * m.m20) + m.m02 * (m.m10 * m.m21 - m.m11 * m.m20));
            mInverse.m00 = fDetInv * (m.m11 * m.m22 - m.m12 * m.m21);
            mInverse.m01 = -fDetInv * (m.m01 * m.m22 - m.m02 * m.m21);
            mInverse.m02 = fDetInv * (m.m01 * m.m12 - m.m02 * m.m11);
            mInverse.m03 = 0.0;
            mInverse.m10 = -fDetInv * (m.m10 * m.m22 - m.m12 * m.m20);
            mInverse.m11 = fDetInv * (m.m00 * m.m22 - m.m02 * m.m20);
            mInverse.m12 = -fDetInv * (m.m00 * m.m12 - m.m02 * m.m10);
            mInverse.m13 = 0.0;
            mInverse.m20 = fDetInv * (m.m10 * m.m21 - m.m11 * m.m20);
            mInverse.m21 = -fDetInv * (m.m00 * m.m21 - m.m01 * m.m20);
            mInverse.m22 = fDetInv * (m.m00 * m.m11 - m.m01 * m.m10);
            mInverse.m23 = 0.0;
            mInverse.m30 = -(m.m30 * mInverse.m00 + m.m31 * mInverse.m10 + m.m32 * mInverse.m20);
            mInverse.m31 = -(m.m30 * mInverse.m01 + m.m31 * mInverse.m11 + m.m32 * mInverse.m21);
            mInverse.m32 = -(m.m30 * mInverse.m02 + m.m31 * mInverse.m12 + m.m32 * mInverse.m22);
            mInverse.m33 = 1.0;
        }
        return mInverse;
    }

    public static Matrix44 interpolate(Matrix44 a, Matrix44 b, double portion) {
        Vector3 t = Vector3.interpolate(a.getPosition(), b.getPosition(), portion);
        Matrix33 m = Matrix33.interpolate(a.getAxes(), b.getAxes(), portion);
        return new Matrix44(m, t);
    }

    public Interpolable interpolate(Interpolable b, double portion) {
        return Matrix44.interpolate(this, (Matrix44)b, portion);
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("edu.cmu.cs.stage3.math.Matrix44[rc00=").append(this.m00).append(",rc01=").append(this.m01).append(",rc02=").append(this.m02).append(",rc03=").append(this.m03).append(",rc10=").append(this.m10).append(",rc11=").append(this.m11).append(",rc12=").append(this.m12).append(",rc13=").append(this.m13).append(",rc20=").append(this.m20).append(",rc21=").append(this.m21).append(",rc22=").append(this.m22).append(",rc23=").append(this.m23).append(",rc30=").append(this.m30).append(",rc31=").append(this.m31).append(",rc32=").append(this.m32).append(",rc33=").append(this.m33).append("]")));
    }

    public static Matrix44 valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Matrix44[rc00=", ",rc01=", ",rc02=", ",rc03=", ",rc10=", ",rc11=", ",rc12=", ",rc13=", ",rc20=", ",rc21=", ",rc22=", ",rc23=", ",rc30=", ",rc31=", ",rc32=", ",rc33=", "]"};
        double[] values = new double[markers.length - 1];
        for (int i = 0; i < values.length; ++i) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            String v = s.substring(begin, end);
            Double d = Double.valueOf(v);
            values[i] = d;
        }
        return new Matrix44(values);
    }
}

