/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.AxisAngle;
import edu.cmu.cs.stage3.math.Interpolable;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Shear;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;

public class EulerAngles
implements Interpolable,
Cloneable {
    public double pitch = 0.0;
    public double yaw = 0.0;
    public double roll = 0.0;

    public EulerAngles() {
    }

    public EulerAngles(double pitch, double yaw, double roll) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
    }

    public EulerAngles(double[] a) {
        this(a[0], a[1], a[2]);
    }

    public EulerAngles(Matrix33 m) {
        this.setMatrix33(m);
    }

    public EulerAngles(AxisAngle aa) {
        this.setAxisAngle(aa);
    }

    public EulerAngles(Quaternion q) {
        this.setQuaternion(q);
    }

    public synchronized Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof EulerAngles) {
            EulerAngles ea = (EulerAngles)o;
            return this.yaw == ea.yaw && this.pitch == ea.pitch && this.roll == ea.roll;
        }
        return false;
    }

    public Matrix33 getMatrix33() {
        return new Matrix33(this);
    }

    public void setMatrix33(Matrix33 m) {
        Vector3 row0 = m.getRow(0);
        Vector3 row1 = m.getRow(1);
        Vector3 row2 = m.getRow(2);
        Vector3 scale = new Vector3();
        Shear shear = new Shear();
        ((Tuple3d)scale).x = row0.getLength();
        row0.normalize();
        shear.xy = Vector3.dotProduct(row0, row1);
        row1 = Vector3.combine(row1, row0, 1.0, -shear.xy);
        ((Tuple3d)scale).y = row1.getLength();
        row1.normalize();
        shear.xy /= ((Tuple3d)scale).y;
        shear.xz = Vector3.dotProduct(row0, row2);
        row2 = Vector3.combine(row2, row0, 1.0, -shear.xz);
        shear.yz = Vector3.dotProduct(row1, row2);
        row2 = Vector3.combine(row2, row1, 1.0, -shear.yz);
        ((Tuple3d)scale).z = row2.getLength();
        row2.normalize();
        shear.xz /= ((Tuple3d)scale).z;
        shear.yz /= ((Tuple3d)scale).z;
        double determinate = Vector3.dotProduct(row0, Vector3.crossProduct(row1, row2));
        if (determinate < 0.0) {
            row0.negate();
            row1.negate();
            row2.negate();
            scale.multiply(-1.0);
        }
        this.yaw = Math.asin(-((Tuple3d)row0).z);
        if (Math.cos(this.yaw) != 0.0) {
            this.pitch = Math.atan2(((Tuple3d)row1).z, ((Tuple3d)row2).z);
            this.roll = Math.atan2(((Tuple3d)row0).y, ((Tuple3d)row0).x);
        } else {
            this.pitch = Math.atan2(((Tuple3d)row1).x, ((Tuple3d)row1).y);
            this.roll = 0.0;
        }
    }

    public AxisAngle getAxisAngle() {
        return new AxisAngle(this);
    }

    public void setAxisAngle(AxisAngle aa) {
        this.setMatrix33(aa.getMatrix33());
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this);
    }

    public void setQuaternion(Quaternion q) {
        this.setMatrix33(q.getMatrix33());
    }

    public static EulerAngles interpolate(EulerAngles a, EulerAngles b, double portion) {
        Quaternion q = Quaternion.interpolate(a.getQuaternion(), b.getQuaternion(), portion);
        return new EulerAngles(q);
    }

    public Interpolable interpolate(Interpolable b, double portion) {
        return EulerAngles.interpolate(this, (EulerAngles)b, portion);
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("edu.cmu.cs.stage3.math.EulerAngles[pitch=").append(this.pitch).append(",yaw=").append(this.yaw).append(",roll=").append(this.roll).append("]")));
    }

    public static EulerAngles revolutionsToRadians(EulerAngles ea) {
        return new EulerAngles(ea.pitch / 0.15915494309189535, ea.yaw / 0.15915494309189535, ea.roll / 0.15915494309189535);
    }

    public static EulerAngles radiansToRevolutions(EulerAngles ea) {
        return new EulerAngles(ea.pitch * 0.15915494309189535, ea.yaw * 0.15915494309189535, ea.roll * 0.15915494309189535);
    }

    public static EulerAngles valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.EulerAngles[pitch=", ",yaw=", ",roll=", "]"};
        double[] values = new double[markers.length - 1];
        for (int i = 0; i < values.length; ++i) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
        }
        return new EulerAngles(values);
    }
}

