/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class Box
implements Cloneable {
    protected Vector3d m_minimum = null;
    protected Vector3d m_maximum = null;

    public Box() {
    }

    public Box(Vector3d minimum, Vector3d maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public Box(double minimumX, double minimumY, double minimumZ, double maximumX, double maximumY, double maximumZ) {
        this.setMinimum(new Vector3d(minimumX, minimumY, minimumZ));
        this.setMaximum(new Vector3d(maximumX, maximumY, maximumZ));
    }

    public synchronized Object clone() {
        try {
            Box box = (Box)super.clone();
            box.setMinimum(this.m_minimum);
            box.setMaximum(this.m_maximum);
            Box box2 = box;
            return box2;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Box) {
            Box box = (Box)o;
            return this.m_minimum.equals((Tuple3d)box.m_minimum) && this.m_maximum.equals((Tuple3d)box.m_maximum);
        }
        return false;
    }

    public Vector3d[] getCorners() {
        Vector3d[] corners = new Vector3d[]{new Vector3d(this.m_minimum.x, this.m_minimum.y, this.m_minimum.z), new Vector3d(this.m_minimum.x, this.m_minimum.y, this.m_maximum.z), new Vector3d(this.m_minimum.x, this.m_maximum.y, this.m_minimum.z), new Vector3d(this.m_minimum.x, this.m_maximum.y, this.m_maximum.z), new Vector3d(this.m_maximum.x, this.m_minimum.y, this.m_minimum.z), new Vector3d(this.m_maximum.x, this.m_minimum.y, this.m_maximum.z), new Vector3d(this.m_maximum.x, this.m_maximum.y, this.m_minimum.z), new Vector3d(this.m_maximum.x, this.m_maximum.y, this.m_maximum.z)};
        return corners;
    }

    public Vector3d getMinimum() {
        if (this.m_minimum != null) {
            return new Vector3d(this.m_minimum);
        }
        return null;
    }

    public void setMinimum(Vector3d minimum) {
        this.m_minimum = minimum != null ? new Vector3d(minimum) : null;
    }

    public Vector3d getMaximum() {
        if (this.m_maximum != null) {
            return new Vector3d(this.m_maximum);
        }
        return null;
    }

    public void setMaximum(Vector3d maximum) {
        this.m_maximum = maximum != null ? new Vector3d(maximum) : null;
    }

    public Vector3d getCenter() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d((this.m_minimum.x + this.m_maximum.x) / (double)2, (this.m_minimum.y + this.m_maximum.y) / (double)2, (this.m_minimum.z + this.m_maximum.z) / (double)2);
        }
        return null;
    }

    public Vector3d getCenterOfFrontFace() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d((this.m_minimum.x + this.m_maximum.x) / (double)2, (this.m_minimum.y + this.m_maximum.y) / (double)2, this.m_maximum.z);
        }
        return null;
    }

    public Vector3d getCenterOfBackFace() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d((this.m_minimum.x + this.m_maximum.x) / (double)2, (this.m_minimum.y + this.m_maximum.y) / (double)2, this.m_minimum.z);
        }
        return null;
    }

    public Vector3d getCenterOfLeftFace() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d(this.m_minimum.x, (this.m_minimum.y + this.m_maximum.y) / (double)2, (this.m_minimum.z + this.m_maximum.z) / (double)2);
        }
        return null;
    }

    public Vector3d getCenterOfRightFace() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d(this.m_maximum.x, (this.m_minimum.y + this.m_maximum.y) / (double)2, (this.m_minimum.z + this.m_maximum.z) / (double)2);
        }
        return null;
    }

    public Vector3d getCenterOfTopFace() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d((this.m_minimum.x + this.m_maximum.x) / (double)2, this.m_maximum.y, (this.m_minimum.z + this.m_maximum.z) / (double)2);
        }
        return null;
    }

    public Vector3d getCenterOfBottomFace() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return new Vector3d((this.m_minimum.x + this.m_maximum.x) / (double)2, this.m_minimum.y, (this.m_minimum.z + this.m_maximum.z) / (double)2);
        }
        return null;
    }

    public double getWidth() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return this.m_maximum.x - this.m_minimum.x;
        }
        return 0.0;
    }

    public double getHeight() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return this.m_maximum.y - this.m_minimum.y;
        }
        return 0.0;
    }

    public double getDepth() {
        if (this.m_minimum != null && this.m_maximum != null) {
            return this.m_maximum.z - this.m_minimum.z;
        }
        return 0.0;
    }

    public void union(Box b) {
        if (b != null) {
            if (b.m_minimum != null) {
                if (this.m_minimum != null) {
                    this.m_minimum.x = Math.min(this.m_minimum.x, b.m_minimum.x);
                    this.m_minimum.y = Math.min(this.m_minimum.y, b.m_minimum.y);
                    this.m_minimum.z = Math.min(this.m_minimum.z, b.m_minimum.z);
                } else {
                    this.m_minimum = new Vector3d(b.m_minimum);
                }
            }
            if (b.m_maximum != null) {
                if (this.m_maximum != null) {
                    this.m_maximum.x = Math.max(this.m_maximum.x, b.m_maximum.x);
                    this.m_maximum.y = Math.max(this.m_maximum.y, b.m_maximum.y);
                    this.m_maximum.z = Math.max(this.m_maximum.z, b.m_maximum.z);
                } else {
                    this.m_maximum = new Vector3d(b.m_maximum);
                }
            }
        }
    }

    public void transform(Matrix44 m) {
        if (this.m_minimum != null && this.m_maximum != null) {
            this.m_minimum = new Vector3((Tuple4d)Vector4.multiply(new Vector4((Tuple3d)this.m_minimum, 1.0), m));
            this.m_maximum = new Vector3((Tuple4d)Vector4.multiply(new Vector4((Tuple3d)this.m_maximum, 1.0), m));
        }
    }

    public void scale(Matrix3d s) {
        if (s != null) {
            if (this.m_minimum != null) {
                s.transform((Tuple3d)this.m_minimum);
            }
            if (this.m_maximum != null) {
                s.transform((Tuple3d)this.m_maximum);
            }
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("edu.cmu.cs.stage3.math.Box[minimum=").append(this.m_minimum).append(",maximum=").append(this.m_maximum).append("]")));
    }
}

