/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.EulerAngles;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;

public class AxisAngle
implements Cloneable {
    protected Vector3 m_axis = (Vector3)Vector3.Z_AXIS.clone();
    protected double m_angle = 0.0;

    public AxisAngle() {
    }

    public AxisAngle(double x, double y, double z, double angle) {
        this(new Vector3(x, y, z), angle);
    }

    public AxisAngle(double[] axis, double angle) {
        this(new Vector3(axis), angle);
    }

    public AxisAngle(double[] array) {
        this(array[0], array[1], array[2], array[3]);
    }

    public AxisAngle(Vector3 axis, double angle) {
        this.m_axis = axis;
        this.m_angle = angle;
    }

    public AxisAngle(Matrix33 m) {
        this.setMatrix33(m);
    }

    public AxisAngle(Quaternion q) {
        this.setQuaternion(q);
    }

    public AxisAngle(EulerAngles ea) {
        this.setEulerAngles(ea);
    }

    public double getAngle() {
        return this.m_angle;
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
    }

    public Vector3 getAxis() {
        if (this.m_axis != null) {
            return (Vector3)this.m_axis.clone();
        }
        return null;
    }

    public void setAxis(Vector3 axis) {
        this.m_axis = axis;
    }

    public synchronized Object clone() {
        try {
            AxisAngle axisAngle = (AxisAngle)super.clone();
            axisAngle.setAxis((Vector3)this.m_axis.clone());
            AxisAngle axisAngle2 = axisAngle;
            return axisAngle2;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof AxisAngle) {
            AxisAngle aa = (AxisAngle)o;
            return this.m_axis.equals((Tuple3d)aa.m_axis) && this.m_angle == aa.m_angle;
        }
        return false;
    }

    public double[] getArray() {
        double[] a = new double[]{((Tuple3d)this.m_axis).x, ((Tuple3d)this.m_axis).y, ((Tuple3d)this.m_axis).z, this.m_angle};
        return a;
    }

    public void setArray(double[] a) {
        ((Tuple3d)this.m_axis).x = a[0];
        ((Tuple3d)this.m_axis).y = a[1];
        ((Tuple3d)this.m_axis).z = a[2];
        this.m_angle = a[3];
    }

    public Quaternion getQuaternion() {
        return new Quaternion(this);
    }

    public void setQuaternion(Quaternion q) {
        this.m_angle = (double)2 * Math.acos(q.w);
        ((Tuple3d)this.m_axis).x = (double)2 * Math.asin(q.x);
        ((Tuple3d)this.m_axis).y = (double)2 * Math.asin(q.y);
        ((Tuple3d)this.m_axis).z = (double)2 * Math.asin(q.z);
    }

    public EulerAngles getEulerAngles() {
        return new EulerAngles(this);
    }

    public void setEulerAngles(EulerAngles ea) {
        this.setQuaternion(ea.getQuaternion());
    }

    public Matrix33 getMatrix33() {
        return new Matrix33(this);
    }

    public void setMatrix33(Matrix33 m) {
        this.setQuaternion(m.getQuaternion());
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("edu.cmu.cs.stage3.math.AxisAngle[axis.x=").append(((Tuple3d)this.m_axis).x).append(",axis.y=").append(((Tuple3d)this.m_axis).y).append(",axis.z=").append(((Tuple3d)this.m_axis).z).append(",angle=").append(this.m_angle).append("]")));
    }

    public static AxisAngle valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.AxisAngle[axis.x=", ",axis.y=", ",axis.z=", ",angle=", "]"};
        double[] values = new double[markers.length - 1];
        for (int i = 0; i < values.length; ++i) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
        }
        return new AxisAngle(values);
    }
}

