/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import teddy.Def;
import teddy.Vector2;
import teddy.Vertex;

public class Vertex2D
extends Vector2 {
    public int index;
    public boolean fixed;

    public double distance(Vertex2D node) {
        return Math.sqrt((node.x - this.x) * (node.x - this.x) + (node.y - this.y) * (node.y - this.y));
    }

    public static double distance(Vertex2D n1, Vertex2D n2) {
        return Math.sqrt((n1.x - n2.x) * (n1.x - n2.x) + (n1.y - n2.y) * (n1.y - n2.y));
    }

    public static Vertex2D mid_point(Vertex2D a, Vertex2D b) {
        return new Vertex2D((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    Vertex2D() {
    }

    public Vertex2D(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Vertex2D(Vertex2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vertex2D(Point p, int i) {
        this.x = p.x;
        this.y = p.y;
        this.index = i;
    }

    public Vertex2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    Vertex2D(Vector2 p) {
        this.x = p.x;
        this.y = p.y;
    }

    Vertex2D(Vertex v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vertex2D translate(Vector2 v) {
        return new Vertex2D(this.x + v.x, this.y + v.y);
    }

    public static Vertex2D interporate(Vertex2D start, Vertex2D end, double t) {
        return new Vertex2D(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }

    public static Vertex2D translate(Vertex2D v, Vector2 vec) {
        return new Vertex2D(v.x + vec.x, v.y + vec.y);
    }

    public Vertex2D copy() {
        Vertex2D v = new Vertex2D(this.x, this.y);
        return v;
    }

    public void warp(Vertex2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public boolean same_position(Vertex2D v) {
        return this.x == v.x && this.y == v.y;
    }

    public boolean same(Vertex2D node) {
        return Def.equal(node.x, this.x) && Def.equal(node.y, this.y);
    }
}

