/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Def;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Seam;
import teddy.Vector3;

public class Vertex
extends Vector3
implements Serializable {
    LinkedList edges = new LinkedList();
    public transient Vertex child = this;
    public transient int index;
    public double target_edge_length;
    public double[] weight_vector;
    public Vector3 normal;
    public boolean fixed;
    Vertex body_vertex;
    Object body_element;
    public double[] quadratic_function;
    public Vector quadratic_functions;
    public Hashtable quadratic_function_hashtable;
    public double area;

    public Vector get_edges_clockwise(Edge base) {
        Polygon2 polygon = base.left_polygon;
        if (base.end == this) {
            polygon = base.right_polygon;
        }
        Vector<Edge> result = new Vector<Edge>();
        Edge edge = base;
        while (true) {
            result.addElement(edge);
            edge = this.get_edges_clockwise_get_next_edge(polygon, edge);
            if (edge == null || edge == base) {
                return result;
            }
            polygon = edge.get_another_polygon(polygon);
        }
    }

    public void walk_body_surface_to(Vertex target) {
    }

    public static Vertex mid_point(Vertex a, Vertex b) {
        return new Vertex((a.x + b.x) / 2.0, (a.y + b.y) / 2.0, (a.z + b.z) / 2.0);
    }

    public Seam get_seam() {
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.on_seam()) continue;
            return edge.seam;
        }
        return null;
    }

    public LinkedList get_sorrounding_vertices_on_seam() {
        LinkedList vertices = new LinkedList();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.on_seam()) continue;
            vertices.append(edge.get_the_other_vertex(this));
        }
        return vertices;
    }

    public boolean on_sharp() {
        int count = 0;
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            ++count;
        }
        return count >= 2;
    }

    public Vertex position_copy() {
        Vertex v;
        this.child = v = new Vertex(this.x, this.y, this.z);
        return v;
    }

    public LinkedList get_surrounding_vertices() {
        LinkedList vertices = new LinkedList();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            vertices.append(edge.get_the_other_vertex(this));
        }
        return vertices;
    }

    public Edge[] get_seam_edges() {
        int n = 0;
        Edge[] sharp_edges = new Edge[2];
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.seam == null) continue;
            sharp_edges[n++] = edge;
            if (n != 2) continue;
            return sharp_edges;
        }
        return null;
    }

    public boolean edge_is_empty() {
        return this.edges.size() == 0;
    }

    public static boolean exactly_same_position(Vertex a, Vertex b) {
        return a.x == b.x && a.y == b.y && a.z == b.z;
    }

    public Edge get_edge(int i) {
        i = Def.mod(i, this.edges.size());
        return (Edge)this.edges.elementAt(i);
    }

    public Edge next_edge(Edge prev_edge, Polygon2 polygon) {
        int j = 0;
        while (j < 3) {
            Edge edge = polygon.edges[j];
            if (edge != prev_edge && edge.contain(this)) {
                return edge;
            }
            ++j;
        }
        return null;
    }

    public double get_target_edge_length() {
        if (this.body_element == null) {
            return ((Polygon2)this.polygons().head()).patch.unit_length;
        }
        if (this.body_element instanceof Vertex) {
            return ((Vertex)this.body_element).target_edge_length;
        }
        if (this.body_element instanceof Edge) {
            Edge edge = (Edge)this.body_element;
            return (edge.start.target_edge_length + edge.end.target_edge_length) / 2.0;
        }
        Polygon2 polygon = (Polygon2)this.body_element;
        double l0 = polygon.get_vertex((int)0).target_edge_length;
        double l1 = polygon.get_vertex((int)1).target_edge_length;
        double l2 = polygon.get_vertex((int)2).target_edge_length;
        return (l0 + l1 + l2) / 3.0;
    }

    public boolean on_seam_cross() {
        Seam s0 = null;
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.seam == null) continue;
            if (s0 == null) {
                s0 = edge.seam;
                continue;
            }
            if (s0 == edge.seam) continue;
            return true;
        }
        return false;
    }

    public double x() {
        return this.x;
    }

    public void renew_network() {
        LinkedList new_edges = new LinkedList();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            new_edges.append(edge.child);
        }
        this.edges = new_edges;
    }

    public LinkedList polygons() {
        LinkedList polygons = new LinkedList();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.left_polygon != null && !polygons.member(edge.left_polygon())) {
                polygons.append(edge.left_polygon());
            }
            if (edge.right_polygon == null || polygons.member(edge.right_polygon())) continue;
            polygons.append(edge.right_polygon());
        }
        return polygons;
    }

    public double y() {
        return this.y;
    }

    public Vector3 get_seam_normal() {
        Vector3 total = new Vector3();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.on_seam()) continue;
            Vector3 vec = new Vector3(this, edge.get_the_other_vertex(this));
            vec.normalize_self();
            total.add_self(vec);
        }
        total.normalize_self();
        return total;
    }

    public LinkedList get_surrounding_edges() {
        LinkedList surrounding_edges = new LinkedList();
        Enumeration e = this.polygons().elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            surrounding_edges.append(polygon.get_opposite_edge(this));
        }
        return surrounding_edges;
    }

    public Edge get_common_edge(Vertex v) {
        return this.get_shared_edge(v);
    }

    public Edge get_shared_edge(Vertex v) {
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.start != v && edge.end != v) continue;
            return edge;
        }
        return null;
    }

    public double z() {
        return this.z;
    }

    public Vector3 calculate_normal() {
        this.normal = new Vector3();
        LinkedList polygons = this.polygons();
        Enumeration e = polygons.elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            Edge edge = polygon.get_opposite_edge(this);
            Vertex u0 = edge.start;
            Vertex u1 = edge.end;
            if (edge.right_polygon == polygon) {
                u0 = edge.end;
                u1 = edge.start;
            }
            this.normal.add_self(Vector3.cross_product(new Vector3(this, u0), new Vector3(this, u1)));
        }
        this.normal.normalize_self();
        return this.normal;
    }

    public Vector3 get_non0_normal() {
        Enumeration e = this.get_surrounding_vertices().elements();
        while (e.hasMoreElements()) {
            Vertex v = (Vertex)e.nextElement();
            if (!(v.normal.length() > 0.0)) continue;
            return v.normal;
        }
        System.out.println("error in Vertex.get_non0_normal()");
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vertex() {
        this.edges = new LinkedList();
    }

    public Vertex(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.edges = new LinkedList();
    }

    Vertex(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.edges = new LinkedList();
    }

    Vertex(Vertex v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public boolean same_vertex(double _x, double _y, double _z) {
        return this.x == _x && this.y == _y && this.z == _z;
    }

    public Vertex translate(Vector3 v) {
        return new Vertex(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vertex shift(Vector3 v) {
        return new Vertex(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public double get_coord(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0;
    }

    public void set_coord(int i, double a) {
        switch (i) {
            case 0: {
                this.x = a;
                return;
            }
            case 1: {
                this.y = a;
                return;
            }
            case 2: {
                this.z = a;
                return;
            }
        }
    }

    public void translate_self(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public static Vertex translate(Vertex v, Vector3 vec) {
        return new Vertex(v.x + vec.x, v.y + vec.y, v.z + vec.z);
    }

    public Vector3 get_sharp_normal(Polygon2 polygon) {
        if (!this.on_sharp()) {
            return this.normal;
        }
        Vector<Polygon2> polygons = new Vector<Polygon2>();
        polygons.addElement(polygon);
        int i = 0;
        while (i < 3) {
            if (polygon.edges[i].contain(this)) {
                this.get_sharp_normal_sub(polygon.edges[i], polygon, polygons, polygon);
            }
            ++i;
        }
        Vector3 vector = new Vector3();
        int i2 = 0;
        while (i2 < polygons.size()) {
            vector.add_self(((Polygon2)polygons.elementAt((int)i2)).normal);
            ++i2;
        }
        vector.normalize_self();
        return vector;
    }

    public void get_sharp_normal_sub(Edge edge, Polygon2 polygon, Vector polygons, Polygon2 start_polygon) {
        if (edge.sharp) {
            return;
        }
        Polygon2 next_polygon = edge.get_another_polygon(polygon);
        if (next_polygon == null || next_polygon == start_polygon) {
            return;
        }
        int i = 0;
        while (i < 3) {
            Edge next_edge = next_polygon.edges[i];
            if (next_edge.contain(this) && next_edge != edge) {
                polygons.addElement(next_polygon);
                this.get_sharp_normal_sub(next_edge, next_polygon, polygons, start_polygon);
            }
            ++i;
        }
    }

    public Vertex copy() {
        Vertex v = new Vertex(this.x, this.y, this.z);
        v.edges = this.edges;
        if (this.normal != null) {
            v.normal = new Vector3(this.normal);
        }
        v.fixed = this.fixed;
        this.child = v;
        v.body_element = this.body_element;
        v.body_vertex = this.body_vertex;
        v.index = this.index;
        return v;
    }

    public void warp(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3 get_patch_noraml(Patch patch) {
        if (!this.on_sharp()) {
            return this.normal;
        }
        Vector3 normal = new Vector3();
        Enumeration e = this.polygons().elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            if (polygon.patch != patch) continue;
            normal.add_self(polygon.normal);
        }
        normal.normalize_self();
        return normal;
    }

    public boolean same_position(Vertex v) {
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public void remove_edge(Edge edge) {
        this.edges.remove(edge);
    }

    private Edge get_edges_clockwise_get_next_edge(Polygon2 polygon, Edge base) {
        int i = 0;
        while (i < 3) {
            Edge edge = polygon.edges[i];
            if (edge != base && edge.contain(this)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public void set_area() {
        this.area = 0.0;
        Enumeration e = this.polygons().elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            if (polygon.area == 0.0) {
                polygon.set_area();
            }
            this.area += polygon.area;
        }
    }

    public Edge[] get_sharp_edges() {
        int n = 0;
        Edge[] sharp_edges = new Edge[2];
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            sharp_edges[n++] = edge;
            if (n != 2) continue;
            return sharp_edges;
        }
        return null;
    }

    public Vector get_polygon_groups_divided_by_sharp_edges() {
        Vector groups = new Vector();
        Edge start_edge = null;
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            start_edge = (Edge)e.nextElement();
            if (start_edge.sharp) break;
        }
        Edge edge = start_edge;
        Polygon2 polygon = edge.left_polygon;
        Vector<Polygon2> group = new Vector<Polygon2>();
        groups.addElement(group);
        group.addElement(polygon);
        while ((edge = this.next_edge(edge, polygon)) != start_edge) {
            polygon = edge.get_another_polygon(polygon);
            if (edge.sharp) {
                group = new Vector();
                groups.addElement(group);
            }
            group.addElement(polygon);
        }
        return groups;
    }

    public boolean on_seam_end() {
        int count = 0;
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.on_seam()) continue;
            ++count;
        }
        return count == true;
    }

    public boolean on_seam() {
        int count = 0;
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.on_seam()) continue;
            ++count;
        }
        return count >= 2;
    }

    public Vector3 set_normal() {
        Polygon2 polygon;
        this.normal = new Vector3();
        Enumeration e = this.polygons().elements();
        while (e.hasMoreElements()) {
            polygon = (Polygon2)e.nextElement();
            this.normal.add_self(polygon.normal);
        }
        this.normal.normalize_self();
        if (this.normal.length() == 0.0) {
            System.out.println("0 in Vertex.set_normal()");
            e = this.polygons().elements();
            while (e.hasMoreElements()) {
                polygon = (Polygon2)e.nextElement();
                System.out.println("   " + polygon.get_vertex(0) + " " + polygon.get_vertex(1) + " " + polygon.get_vertex(2));
            }
        }
        return this.normal;
    }

    public double distance(Vertex v) {
        return Vector3.distance(this, v);
    }
}

