/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import teddy.Point2;
import teddy.Vertex;

public class Vector3
implements Serializable {
    public double x;
    public double y;
    public double z;

    public Vector3 subtract(Vector3 v) {
        return new Vector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public void normalize_self() {
        this.normalize();
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
    }

    public static double distance(Vertex start, Vertex end) {
        return Vector3.distance(start.x, start.y, start.z, end.x, end.y, end.z);
    }

    public void normalize() {
        double l = this.length();
        if (l == 0.0) {
            return;
        }
        this.x /= l;
        this.y /= l;
        this.z /= l;
    }

    public static Vector3 average(Vector3 a, Vector3 b) {
        return new Vector3((a.x + b.x) / 2.0, (a.y + b.y) / 2.0, (a.z + b.z) / 2.0);
    }

    public boolean parallel(Vector3 v) {
        double sine = this.sin(v);
        return sine < 0.01 && sine > -0.01;
    }

    public double get_sin(Vector3 v) {
        return this.sin(v);
    }

    public Vector3 add(Vector3 v) {
        return new Vector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public static Vector3 add(Vector3 u, Vector3 v) {
        return new Vector3(u.x + v.x, u.y + v.y, u.z + v.z);
    }

    public static Vector3 add(Vector3 u, Vector3 v, Vector3 w) {
        return new Vector3(u.x + v.x + w.x, u.y + v.y + w.y, u.z + v.z + w.z);
    }

    public double get_cos(Vector3 v) {
        return this.cos(v);
    }

    public void multiple_self(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public void rotate_x(double angle) {
        Point2 p = this.rotate_sub(this.y, this.z, angle);
        this.y = p.x;
        this.z = p.y;
    }

    public static Vector3 cross_product(Vector3 u, Vector3 v) {
        return u.cross_product(v);
    }

    public Vector3 cross_product(Vector3 v) {
        double _x = this.y * v.z - this.z * v.y;
        double _y = this.z * v.x - this.x * v.z;
        double _z = this.x * v.y - this.y * v.x;
        return new Vector3(_x, _y, _z);
    }

    public Vector3 copyVector3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public void rotate_y(double angle) {
        Point2 p = this.rotate_sub(this.z, this.x, angle);
        this.z = p.x;
        this.x = p.y;
    }

    public Vector3 reverse() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public void add_self(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void rotate_z(double angle) {
        Point2 p = this.rotate_sub(this.x, this.y, angle);
        this.x = p.x;
        this.y = p.y;
    }

    public Vector3 get_normalized() {
        double l = this.length();
        return new Vector3(this.x / l, this.y / l, this.z / l);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double cos(Vector3 u, Vector3 v) {
        double length = Math.sqrt((u.x * u.x + u.y * u.y + u.z * u.z) * (v.x * v.x + v.y * v.y + v.z * v.z));
        if (length > 0.0) {
            return Vector3.dot_product(u, v) / length;
        }
        return 0.0;
    }

    public double cos(Vector3 v) {
        double length = Math.sqrt((this.x * this.x + this.y * this.y + this.z * this.z) * (v.x * v.x + v.y * v.y + v.z * v.z));
        if (length > 0.0) {
            return this.dot_product(v) / length;
        }
        return 0.0;
    }

    public static double dot_product(Vector3 u, Vector3 v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    public double dot_product(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public static double sin(Vector3 u, Vector3 v) {
        double length = Math.sqrt((u.x * u.x + u.y * u.y + u.z * u.z) * (v.x * v.x + v.y * v.y + v.z * v.z));
        if (length > 0.0) {
            return Vector3.cross_product(u, v).length() / length;
        }
        return 0.0;
    }

    public double sin(Vector3 v) {
        double length = Math.sqrt((this.x * this.x + this.y * this.y + this.z * this.z) * (v.x * v.x + v.y * v.y + v.z * v.z));
        if (length > 0.0) {
            return this.cross_product(v).length() / length;
        }
        return 0.0;
    }

    public Vector3() {
    }

    public Vector3(Vertex v0, Vertex v1) {
        this.x = v1.x - v0.x;
        this.y = v1.y - v0.y;
        this.z = v1.z - v0.z;
    }

    public Vector3(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public Vector3(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public static Vector3 multiply(Vector3 v, double m) {
        return new Vector3(v.x * m, v.y * m, v.z * m);
    }

    public void rotate(int axis, double angle) {
        if (axis == 0) {
            this.rotate_x(angle);
        } else if (axis == 1) {
            this.rotate_y(angle);
        } else {
            this.rotate_z(angle);
        }
    }

    public static Vertex interporate(Vertex start, Vertex end, double t) {
        return new Vertex(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t, start.z * (1.0 - t) + end.z * t);
    }

    public Vertex vertex() {
        return new Vertex(this.x, this.y, this.z);
    }

    public Vector3 multiple(double m) {
        return new Vector3(this.x * m, this.y * m, this.z * m);
    }

    public double get_relative_angle(Vector3 v) {
        double cosine = this.cos(v);
        if (cosine <= -1.0) {
            return Math.PI;
        }
        if (cosine >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosine);
    }

    public double get_angle(Vector3 v, Vector3 normal) {
        double cos = this.get_cos(v);
        double sin = this.get_sin(v);
        if (this.cross_product(v).dot_product(normal) < 0.0) {
            sin *= -1.0;
        }
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle += 180.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public Point2 rotate_sub(double x, double y, double angle) {
        double cos = Math.cos(Math.PI * angle / 180.0);
        double sin = Math.sin(Math.PI * angle / 180.0);
        double _x = cos * x - sin * y;
        double _y = sin * x + cos * y;
        return new Point2(_x, _y);
    }

    public static Vector3 subtract(Vector3 u, Vector3 v) {
        return new Vector3(u.x - v.x, u.y - v.y, u.z - v.z);
    }
}

