/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import teddy.Vector3;
import teddy.Vertex2D;

public class Vector2 {
    public double x;
    public double y;

    public static double distance(Point start, Point end) {
        return Vector2.distance(start.x, start.y, end.x, end.y);
    }

    public void normalize_self() {
        double length = this.length();
        if (length == 0.0) {
            length = 1.0;
        }
        this.x /= length;
        this.y /= length;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double distance(Vertex2D start, Vertex2D end) {
        return Vector2.distance(start.x, start.y, end.x, end.y);
    }

    public Vector2 normalize() {
        double length = this.length();
        if (length == 0.0) {
            length = 1.0;
        }
        return new Vector2(this.x / length, this.y / length);
    }

    public static Vector2 subtract(Vector2 u, Vector2 v) {
        return new Vector2(u.x - v.x, u.y - v.y);
    }

    public void subtract(Vector2 v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public double get_sin(Vector2 v) {
        double length = Math.sqrt((this.x * this.x + this.y * this.y) * (v.x * v.x + v.y * v.y));
        if (length > 0.0) {
            return this.cross_product(v) / length;
        }
        return 0.0;
    }

    protected Vector2 add(Vector2 v) {
        return new Vector2(this.x + v.x, this.y + v.y);
    }

    public static Vector2 add(Vector2 u, Vector2 v) {
        return new Vector2(u.x + v.x, u.y + v.y);
    }

    public double get_cos(Vector2 v) {
        double length = Math.sqrt((this.x * this.x + this.y * this.y) * (v.x * v.x + v.y * v.y));
        if (length > 0.0) {
            return this.inner_product(v) / length;
        }
        return 0.0;
    }

    public void multiple_self(double m) {
        this.x *= m;
        this.y *= m;
    }

    public void rotate90_self() {
        double xx = this.x;
        double yy = this.y;
        this.y = this.x = -this.y;
    }

    public double inner_product(Vector2 v) {
        return this.x * v.x + this.y * v.y;
    }

    public double cross_product(Vector2 v) {
        return this.x * v.y - this.y * v.x;
    }

    public static double cross_product(Vector2 u, Vector2 v) {
        return u.x * v.y - u.y * v.x;
    }

    public Vertex2D vertex2D() {
        return new Vertex2D(this.x, this.y);
    }

    public void add_self(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public Vector2 flip_y_axis() {
        return new Vector2(-this.x, this.y);
    }

    public Vector2 get_normalized() {
        double length = this.length();
        if (length == 0.0) {
            length = 1.0;
        }
        return new Vector2(this.x / length, this.y / length);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double cos(Vector2 u, Vector2 v) {
        double length = Math.sqrt((u.x * u.x + u.y * u.y) * (v.x * v.x + v.y * v.y));
        if (length > 0.0) {
            return Vector2.dot_product(u, v) / length;
        }
        return 0.0;
    }

    public Vector2 rotate90() {
        return new Vector2(-this.y, this.x);
    }

    public Vector2 scale(double scale) {
        return new Vector2(this.x * scale, this.y * scale);
    }

    public double cos(Vector2 v) {
        return this.get_cos(v);
    }

    public double outer_product(Vector2 v) {
        return this.x * v.y - this.y * v.x;
    }

    public double dot_product(Vector2 v) {
        return this.x * v.x + this.y * v.y;
    }

    public static double dot_product(Vector2 u, Vector2 v) {
        return u.x * v.x + u.y * v.y;
    }

    public double sin(Vector2 v) {
        return this.get_sin(v);
    }

    public static double sin(Vector2 u, Vector2 v) {
        double length = Math.sqrt((u.x * u.x + u.y * u.y) * (v.x * v.x + v.y * v.y));
        if (length > 0.0) {
            return Vector2.cross_product(u, v) / length;
        }
        return 0.0;
    }

    public double get_angle180(Vector2 v) {
        double cos = Vector2.cos(this, v);
        double sin = Vector2.sin(this, v);
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return -90.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        return angle;
    }

    public Vector2(Point start, Point end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector2(Point start, Vector2 end) {
        this.x = end.x - (double)start.x;
        this.y = end.y - (double)start.y;
    }

    public Vector2(Vector2 start, Vector2 end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector2(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vector2() {
    }

    public Vector2(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    Vector2(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vector2 rotate(double degree) {
        if (degree == 90.0) {
            return new Vector2(-this.y, this.x);
        }
        if (degree == 180.0) {
            return new Vector2(-this.x, -this.y);
        }
        if (degree == 270.0) {
            return new Vector2(this.y, -this.x);
        }
        double radian = degree * Math.PI / 180.0;
        double cos = Math.cos(radian);
        double sin = Math.sin(radian);
        return new Vector2(this.x * cos - this.y * sin, this.x * sin + this.y * cos);
    }

    public static Vector2 interporate(Point start, Point end, double t) {
        return new Vector2((double)start.x * (1.0 - t) + (double)end.x * t, (double)start.y * (1.0 - t) + (double)end.y * t);
    }

    public static Vector2 multiply(Vector2 vec, double m) {
        return new Vector2(m * vec.x, m * vec.y);
    }

    public Vector2 multiple(double m) {
        return new Vector2(this.x * m, this.y * m);
    }

    public double get_relative_angle(Vector2 v) {
        double cosine = this.cos(v);
        if (cosine <= -1.0) {
            return Math.PI;
        }
        if (cosine >= 1.0) {
            return 0.0;
        }
        return Math.acos(this.cos(v));
    }

    public double get_angle(Vector2 v) {
        double cos = this.get_cos(v);
        double sin = this.get_sin(v);
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle += 180.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public Point point() {
        return new Point((int)this.x, (int)this.y);
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }
}

