/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Vector;
import teddy.Edge;
import teddy.ImplicitFunction;
import teddy.LeastSquareFit;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;

public class VariationalSubdivision {
    public static ImplicitFunction calculate_implicitFunction(Vertex v) {
        Vector zeroKnots = LeastSquareFit.get_nearby_vertices_wide(v);
        Vector<Vertex> plusKnots = new Vector<Vertex>();
        int i = 0;
        while (i < zeroKnots.size()) {
            Vertex u = (Vertex)zeroKnots.elementAt(i);
            plusKnots.addElement(u.translate(u.normal.multiple(0.001)));
            ++i;
        }
        return new ImplicitFunction(zeroKnots, plusKnots);
    }

    public static void subdivide(Polyhedron h) {
        Edge edge;
        ImplicitFunction[] implicitFunctions = new ImplicitFunction[h.n_vertices];
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            implicitFunctions[i] = VariationalSubdivision.calculate_implicitFunction(v);
            ++i;
        }
        h._vertices = new LinkedList();
        h._edges = new LinkedList();
        h._polygons = new LinkedList();
        Vertex[] target_edge_positions = new Vertex[h.n_edges];
        int i2 = 0;
        while (i2 < h.n_edges) {
            edge = h.edges[i2];
            Vertex v = edge.get_mid_vertex();
            Vector3 normal = Vector3.add(edge.left_polygon.normal, edge.right_polygon.normal);
            normal.normalize_self();
            target_edge_positions[i2] = Vertex.mid_point(VariationalSubdivision.move_to_isosurface(v, normal, implicitFunctions[edge.start.index]), VariationalSubdivision.move_to_isosurface(v, normal, implicitFunctions[edge.end.index]));
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_vertices) {
            Vertex v = h.vertices[i2];
            h._vertices.append(v);
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_edges) {
            Vertex mid_vertex = h.edges[i2].get_mid_vertex();
            mid_vertex.warp(target_edge_positions[i2]);
            mid_vertex.normal = target_edge_positions[i2].normal;
            h._vertices.append(mid_vertex);
            h._edges.append(new Edge(h.edges[i2].start, mid_vertex, h.edges[i2].sharp));
            h._edges.append(new Edge(mid_vertex, h.edges[i2].end, h.edges[i2].sharp));
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_polygons) {
            Polygon2 polygon = h.polygons[i2];
            Vertex v0 = polygon.get_vertex(0);
            Vertex v1 = polygon.edges[0].mid_vertex;
            Vertex v2 = polygon.get_vertex(1);
            Vertex v3 = polygon.edges[1].mid_vertex;
            Vertex v4 = polygon.get_vertex(2);
            Vertex v5 = polygon.edges[2].mid_vertex;
            Edge edge13 = new Edge(v1, v3);
            Edge edge35 = new Edge(v3, v5);
            Edge edge51 = new Edge(v5, v1);
            Edge edge01 = v0.get_shared_edge(v1);
            Edge edge12 = v1.get_shared_edge(v2);
            Edge edge23 = v2.get_shared_edge(v3);
            Edge edge34 = v3.get_shared_edge(v4);
            Edge edge45 = v4.get_shared_edge(v5);
            Edge edge50 = v5.get_shared_edge(v0);
            edge01.seam = edge12.seam = polygon.edges((int)0).seam;
            edge23.seam = edge34.seam = polygon.edges((int)1).seam;
            edge45.seam = edge50.seam = polygon.edges((int)2).seam;
            edge01.sharp = edge12.sharp = polygon.edges((int)0).sharp;
            edge23.sharp = edge34.sharp = polygon.edges((int)1).sharp;
            edge45.sharp = edge50.sharp = polygon.edges((int)2).sharp;
            h._polygons.append(new Polygon2(edge13, edge35, edge51, polygon.patch));
            h._polygons.append(new Polygon2(edge01, edge51, edge50, polygon.patch));
            h._polygons.append(new Polygon2(edge12, edge23, edge13, polygon.patch));
            h._polygons.append(new Polygon2(edge34, edge45, edge35, polygon.patch));
            h._edges.append(edge13);
            h._edges.append(edge35);
            h._edges.append(edge51);
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_edges) {
            edge = h.edges[i2];
            edge.start.remove_edge(edge);
            edge.end.remove_edge(edge);
            ++i2;
        }
        h.postprocess_list_to_array();
        h.set_parameters();
    }

    public static Vertex move_to_isosurface(Vertex v, Vector3 normal, ImplicitFunction iFunction) {
        double height = iFunction.get_value(v);
        if (Double.isNaN(height)) {
            System.out.println("height Nan");
        }
        Vector3 dv = normal.multiple(-height / 1000.0);
        return v.translate(dv);
    }
}

