/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Vector;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class TaubinFairing2D {
    public static Vertex2D to_sum_of_vectors(Vertex2D vertex, Vertex2D prev, Vertex2D next, double direction) {
        Vector2 gross_vector = new Vector2();
        double gross_weight = 0.0;
        Vector2 vec = new Vector2(vertex, (Vector2)prev);
        double weight = 1.0 / vec.length();
        gross_vector.add_self(vec.multiple(weight));
        gross_weight += weight;
        vec = new Vector2(vertex, (Vector2)next);
        weight = 1.0 / vec.length();
        gross_vector.add_self(vec.multiple(weight));
        gross_vector.multiple_self(1.0 / (gross_weight += weight));
        Vertex2D new_v = new Vertex2D(vertex.add(gross_vector.multiple(direction)));
        return new_v;
    }

    public static void smooth(Vector points, int n) {
        int i = 0;
        while (i < n) {
            TaubinFairing2D.smooth_sub(points, 0.63139836);
            TaubinFairing2D.smooth_sub(points, -0.6739516);
            ++i;
        }
    }

    public static void smooth_sub(Vector vertices, double direction) {
        Vertex2D v;
        Vertex2D[] new_positions = new Vertex2D[vertices.size()];
        int i = 0;
        while (i < vertices.size()) {
            v = (Vertex2D)vertices.elementAt(i);
            Vertex2D prev = (Vertex2D)vertices.elementAt(Util.mod(i - 1, vertices.size()));
            Vertex2D next = (Vertex2D)vertices.elementAt(Util.mod(i + 1, vertices.size()));
            new_positions[i] = TaubinFairing2D.to_sum_of_vectors(v, prev, next, direction);
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            v = (Vertex2D)vertices.elementAt(i);
            if (!v.fixed) {
                v.warp(new_positions[i]);
            }
            ++i;
        }
    }
}

