/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class TaubinFairing {
    private static Polyhedron h;

    private static Vertex get_gravity_center(LinkedList vertices) {
        Vertex v = new Vertex();
        Enumeration e = vertices.elements();
        while (e.hasMoreElements()) {
            v.add_self((Vertex)e.nextElement());
        }
        return new Vertex(v.multiple(1.0 / (double)vertices.size()));
    }

    public static Vertex to_sum_of_vectors(LinkedList vs, Vertex vertex, double direction) {
        Vector3 gross_vector = new Vector3(0.0, 0.0, 0.0);
        double gross_weight = 0.0;
        Enumeration e = vs.elements();
        while (e.hasMoreElements()) {
            Vertex v = (Vertex)e.nextElement();
            Vector3 vec = new Vector3(vertex, v);
            double weight = 1.0 / vec.length();
            gross_vector.add_self(vec.multiple(weight));
            gross_weight += weight;
        }
        gross_vector.multiple_self(1.0 / gross_weight);
        Vertex new_v = new Vertex(vertex.add(gross_vector.multiple(direction)));
        return new_v;
    }

    public static void smooth(Polyhedron h, int n) {
        int i = 0;
        while (i < n) {
            TaubinFairing.smooth_sub(h, 0.63139836);
            TaubinFairing.smooth_sub(h, -0.6739516);
            ++i;
        }
    }

    public static void smooth(Vector vertices, int n) {
        int i = 0;
        while (i < n) {
            TaubinFairing.smooth_sub(vertices, 0.63139836);
            TaubinFairing.smooth_sub(vertices, -0.6739516);
            ++i;
        }
    }

    public static void constrained_smooth(Vector internal_vertices, Vector boundary_vertices, int count) {
        Vertex[] vs = new Vertex[boundary_vertices.size()];
        int i = 0;
        while (i < boundary_vertices.size()) {
            Vertex v = (Vertex)boundary_vertices.elementAt(i);
            vs[i] = new Vertex(v);
            ++i;
        }
        Vector vertices = Util.connectVector(internal_vertices, boundary_vertices);
        int i2 = 0;
        while (i2 < count) {
            TaubinFairing.smooth(vertices, 3);
            int j = 0;
            while (j < boundary_vertices.size()) {
                Vertex v = (Vertex)boundary_vertices.elementAt(j);
                v.warp(vs[j]);
                ++j;
            }
            ++i2;
        }
    }

    public static Vertex to_the_center(LinkedList vs, Vertex v, double direction) {
        Vertex center = TaubinFairing.get_gravity_center(vs);
        Vector3 full = new Vector3(v, center);
        Vertex new_v = new Vertex(v.add(full.multiple(direction)));
        return new_v;
    }

    public static void smooth_sub(Polyhedron h, double direction) {
        Vertex[] new_positions = new Vertex[h.n_vertices];
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            LinkedList vs = v.get_surrounding_vertices();
            new_positions[i] = TaubinFairing.to_sum_of_vectors(vs, v, direction);
            ++i;
        }
        i = 0;
        while (i < h.n_vertices) {
            if (!h.vertices[i].on_sharp()) {
                h.vertices[i].warp(new_positions[i]);
            }
            ++i;
        }
    }

    public static void smooth_sub(Vector vertices, double direction) {
        Vertex[] new_positions = new Vertex[vertices.size()];
        int i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i);
            LinkedList vs = v.get_surrounding_vertices();
            new_positions[i] = TaubinFairing.to_sum_of_vectors(vs, v, direction);
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            ((Vertex)vertices.elementAt(i)).warp(new_positions[i]);
            ++i;
        }
    }

    private static Vector3 get_normal(LinkedList vertices, Vertex center) {
        LinkedList s = new LinkedList();
        Enumeration e = vertices.elements();
        while (e.hasMoreElements()) {
            s.append(new Vector3((Vertex)e.nextElement(), center));
        }
        e = s.elements();
        double Sxy = 0.0;
        double Syz = 0.0;
        double Szx = 0.0;
        double Sx = 0.0;
        double Sy = 0.0;
        double Sz = 0.0;
        while (e.hasMoreElements()) {
            Vector3 v = (Vector3)e.nextElement();
            Sxy += v.x * v.y;
            Syz += v.y * v.z;
            Szx += v.z * v.x;
            Sx += v.x * v.x;
            Sy += v.y * v.y;
            Sz += v.z * v.z;
        }
        Vector3 normal = new Vector3(Sz * Sy - Syz * Syz, Sxy * Syz - Sxy * Sz, Sxy * Syz - Szx * Sy);
        return normal.get_normalized();
    }

    private static Vector3 get_averaged_normal(LinkedList polygons) {
        Vertex v = new Vertex();
        Enumeration e = polygons.elements();
        while (e.hasMoreElements()) {
            v.add_self(((Polygon2)e.nextElement()).normal);
        }
        Vector3 normal = v.multiple(1.0 / (double)polygons.size());
        return normal.get_normalized();
    }

    private static Vertex horizontal_shift(LinkedList vs, Vertex v) {
        Vertex center = TaubinFairing.get_gravity_center(vs);
        Vector3 normal = TaubinFairing.get_averaged_normal(v.polygons());
        Vector3 center_to_v = new Vector3(center, v);
        Vertex target_v = new Vertex(center.add(normal.multiple(center_to_v.length())));
        Vector3 full = new Vector3(v, target_v);
        Vertex new_v = new Vertex(v.add(full.multiple(0.5)));
        return new_v;
    }
}

