/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Edge;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Vector3;
import teddy.Vertex;

public class SurroundingSurfacePath
extends SurfacePath {
    public void propagate(Vertex v, Vector visited, Vector boundary, Vector boundary_edges, Hashtable distances, SurfacePath basePath, double radius) {
        if (visited.contains(v)) {
            return;
        }
        visited.addElement(v);
        double d = this.distance(basePath, v);
        distances.put(v, new Double(d));
        if (d > radius) {
            boundary.addElement(v);
            return;
        }
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex u = edge.get_the_other_vertex(v);
            this.propagate(u, visited, boundary, boundary_edges, distances, basePath, radius);
            if (!boundary.contains(u)) continue;
            boundary_edges.addElement(edge);
        }
    }

    public SurroundingSurfacePath(Polyhedron h, SurfacePath basePath) {
        Edge edge;
        Vector visited = new Vector();
        Vector boundary = new Vector();
        Vector boundary_edges = new Vector();
        Hashtable distances = new Hashtable();
        double radius = 0.1;
        int i = 0;
        while (i < basePath.path.size()) {
            if (basePath.onEdge(i)) {
                Edge edge2 = basePath.getEdge(i);
                this.propagate(edge2.start, visited, boundary, boundary_edges, distances, basePath, radius);
                this.propagate(edge2.end, visited, boundary, boundary_edges, distances, basePath, radius);
            }
            ++i;
        }
        System.out.println("" + visited.size() + " " + boundary.size() + " " + boundary_edges.size());
        Edge start_edge = edge = (Edge)boundary_edges.elementAt(0);
        Polygon2 polygon = edge.left_polygon;
        while (true) {
            Vertex v = this.get_edge_vertex(edge, distances, radius);
            this.path.addElement(new SurfacePath.PathElement(edge, v));
            Edge next_edge = this.find_next_boundary_edge(polygon, edge, boundary_edges);
            if (next_edge == null || next_edge == start_edge) break;
            polygon = next_edge.get_another_polygon(polygon);
            edge = next_edge;
        }
    }

    public Edge find_next_boundary_edge(Polygon2 polygon, Edge base_edge, Vector boundary_edges) {
        int i = 0;
        while (i < 3) {
            Edge edge = polygon.edges[i];
            if (edge != base_edge && boundary_edges.contains(edge)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public Vertex get_edge_vertex(Edge edge, Hashtable distances, double radius) {
        double d0 = Math.abs((Double)distances.get(edge.start) - radius);
        double d1 = Math.abs((Double)distances.get(edge.end) - radius);
        return Vector3.interporate(edge.start, edge.end, d0 / (d0 + d1));
    }

    public double distance(SurfacePath basePath, Vertex v) {
        double min = -1.0;
        int i = 0;
        while (i < basePath.path.size() - 1) {
            Vertex v0 = basePath.getVertex(i);
            Vertex v1 = basePath.getVertex(i + 1);
            Edge edge = new Edge(v0, v1);
            double d = edge.distance_as_a_segment(v);
            if (min == -1.0 || d < min) {
                min = d;
            }
            ++i;
        }
        return min;
    }
}

