/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleSVD;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import teddy.CameraInterface;
import teddy.Edge;
import teddy.Edge2D;
import teddy.LeastSquareFit;
import teddy.Line;
import teddy.PNsubdivision;
import teddy.Plane;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Seam;
import teddy.Util;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class SurfacePath {
    public CameraInterface camera;
    public Polyhedron h;
    public Vector path = new Vector();
    public boolean loop;
    Seam seam;
    Hashtable crosssection = new Hashtable();

    private Vertex project_onto_polygon(Vertex2D v, Polygon2 polygon) {
        Plane plane = new Plane(polygon.get_vertex(0), polygon.normal);
        Line line = new Line(this.camera.screen_coords_to_local_coords(v), this.camera.get_camera_lay(v));
        Vertex vertex = plane.cross_point(line);
        if (v.fixed) {
            vertex.fixed = true;
        }
        return vertex;
    }

    public void insertOnPolygon() {
        Edge edge0 = this.getEdge(0);
        Edge edge1 = this.getEdge(this.path.size() - 1);
        Polygon2 polygon = edge0.get_common_polygon(edge1);
        Vertex v0 = this.getVertex(0);
        Vertex v1 = this.getVertex(this.path.size() - 1);
        Vertex v = Vertex.mid_point(v0, v1);
        this.path.insertElementAt(new PathElement(polygon, v), 0);
    }

    public Object[] pick(Point p) {
        Vertex2D v = new Vertex2D(p);
        Polygon2 polygon = this.pick_front_facing_polygon(v);
        if (polygon == null) {
            return null;
        }
        Object[] result = new Object[]{this.project_onto_polygon(v, polygon), polygon};
        return result;
    }

    public Object[] pick(Vertex2D next_v, Vertex2D prev_v, Polygon2 polygon) {
        boolean[] forward = new boolean[1];
        forward[0] = (polygon = this.extend_path(prev_v, next_v, polygon, forward, true)) == null;
        if (forward[0]) {
            return null;
        }
        Object[] result = new Object[]{this.project_onto_polygon(next_v, polygon), polygon};
        return result;
    }

    public void addPathElement(Object parent, Vertex vertex) {
        this.path.addElement(new PathElement(parent, vertex));
    }

    public void add(Vertex vertex, Edge edge) {
        this.path.addElement(new PathElement(edge, vertex));
    }

    public void add(Vertex vertex, Polygon2 polygon) {
        this.path.addElement(new PathElement(polygon, vertex));
    }

    public Edge getEdge(int i) {
        return ((PathElement)this.path.elementAt(i)).getEdge();
    }

    public Vector getPath_cut(Vector stroke) {
        Vertex2D prev_p;
        int i = 0;
        while (i < stroke.size()) {
            ((Vertex2D)stroke.elementAt((int)i)).index = i;
            ++i;
        }
        Polygon2 polygon = null;
        int n = 0;
        int i2 = 1;
        while (i2 < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.elementAt(i2);
            polygon = this.pick_front_facing_polygon(p);
            if (polygon != null) {
                n = i2;
                break;
            }
            ++i2;
        }
        if (n == 0) {
            return null;
        }
        int min_n = n;
        int max_n = 0;
        Vertex2D start_p = prev_p = (Vertex2D)stroke.elementAt(n);
        Polygon2 start_polygon = polygon;
        ++n;
        while (true) {
            if (n == stroke.size()) {
                return null;
            }
            Vertex2D next_p = (Vertex2D)stroke.elementAt(n);
            if (n > max_n) {
                max_n = n;
            }
            Vertex v = this.project_onto_polygon(prev_p, polygon);
            this.path.addElement(new PathElement(polygon, v));
            this.register_crosssection(prev_p, v);
            boolean[] forward = new boolean[1];
            polygon = this.extend_path(prev_p, next_p, polygon, forward, false);
            if (!forward[0]) {
                next_p = prev_p;
            }
            if (next_p == start_p && polygon == start_polygon) break;
            n = this.front_facing(polygon) ? next_p.index + 1 : next_p.index - 1;
            prev_p = next_p;
        }
        return this.path;
    }

    public Vector getPath(Vector stroke) {
        Polygon2 polygon;
        Vertex2D last_p;
        block5: {
            if (this.pick_front_facing_polygon((Vertex2D)stroke.elementAt(0)) == null) {
                return this.getPath_cut(stroke);
            }
            int i = 0;
            while (i < stroke.size()) {
                ((Vertex2D)stroke.elementAt((int)i)).index = i;
                ++i;
            }
            Vertex2D prev_p = (Vertex2D)stroke.elementAt(0);
            last_p = (Vertex2D)stroke.elementAt(stroke.size() - 1);
            int n = 1;
            if (this.loop) {
                prev_p = (Vertex2D)stroke.elementAt(stroke.size() - 1);
                n = 0;
                last_p = prev_p;
            }
            polygon = this.pick_front_facing_polygon(prev_p);
            Polygon2 end_polygon = this.pick_front_facing_polygon(last_p);
            do {
                Vertex2D next_p = (Vertex2D)stroke.elementAt(n);
                this.path.addElement(new PathElement(polygon, this.project_onto_polygon(prev_p, polygon)));
                boolean[] forward = new boolean[1];
                polygon = this.extend_path(prev_p, next_p, polygon, forward, false);
                if (!forward[0]) {
                    next_p = prev_p;
                }
                if (next_p == last_p && polygon == end_polygon) break block5;
                n = this.front_facing(polygon) ? next_p.index + 1 : next_p.index - 1;
                prev_p = next_p;
            } while (n != -1);
            this.path = null;
            return null;
        }
        this.path.addElement(new PathElement(polygon, this.project_onto_polygon(last_p, polygon)));
        return this.path;
    }

    private Polygon2 pick_front_facing_polygon(Vertex2D p) {
        int i = 0;
        while (i < this.h.n_polygons) {
            Polygon2 polygon = this.h.polygons[i];
            if (this.front_facing(polygon) && this.is_projected_inside(p, polygon)) {
                return polygon;
            }
            ++i;
        }
        return null;
    }

    public Polygon2 getPolygon(int i) {
        return ((PathElement)this.path.elementAt(i)).getPolygon();
    }

    private Vertex get_nearest_point_on_polygon(Vertex2D p, Polygon2 polygon) {
        Vertex v = this.project_onto_polygon(p, polygon);
        Vertex v0 = polygon.get_vertex(0);
        Vertex v1 = polygon.get_vertex(1);
        Vertex v2 = polygon.get_vertex(2);
        Vertex v01 = this.get_foot(v0, v1, v);
        Vertex v12 = this.get_foot(v1, v2, v);
        Vertex v20 = this.get_foot(v2, v0, v);
        double d01 = Double.MAX_VALUE;
        double d12 = Double.MAX_VALUE;
        double d20 = Double.MAX_VALUE;
        if (this.is_inside(v01, v1, v2, v0, polygon.normal)) {
            d01 = Vector3.distance(v, v01);
        }
        if (this.is_inside(v12, v2, v0, v1, polygon.normal)) {
            d12 = Vector3.distance(v, v12);
        }
        if (this.is_inside(v20, v0, v1, v2, polygon.normal)) {
            d20 = Vector3.distance(v, v20);
        }
        double d0 = Vector3.distance(v0, v);
        double d1 = Vector3.distance(v1, v);
        double d2 = Vector3.distance(v2, v);
        if (d0 < d1 && d0 < d2 && d0 < d01 && d0 < d12 && d0 < d20) {
            return v0;
        }
        if (d1 < d0 && d1 < d2 && d1 < d01 && d1 < d12 && d1 < d20) {
            return v1;
        }
        if (d2 < d1 && d2 < d0 && d2 < d01 && d2 < d12 && d2 < d20) {
            return v2;
        }
        if (d01 < d0 && d01 < d1 && d01 < d2 && d01 < d12 && d01 < d20) {
            return v01;
        }
        if (d12 < d0 && d12 < d1 && d12 < d2 && d12 < d01 && d12 < d20) {
            return v12;
        }
        if (d20 < d0 && d20 < d1 && d20 < d2 && d20 < d12 && d20 < d01) {
            return v20;
        }
        System.out.println("error in SurfacePath.get_nearest_point_on_polygon()");
        return null;
    }

    public Object[] pick_nearest_point_on_edge(Point p) {
        Vertex2D v = new Vertex2D(p);
        int i = 0;
        while (i < this.h.n_polygons) {
            this.h.polygons[i].front_facing = this.front_facing(this.h.polygons[i]);
            ++i;
        }
        Edge nearest_edge = null;
        double min = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < this.h.n_edges) {
            Vertex2D v1;
            Vertex2D v0;
            double d;
            Edge edge = this.h.edges[i2];
            if (!(edge.left_polygon().front_facing && edge.right_polygon().front_facing || !edge.left_polygon().front_facing && !edge.right_polygon().front_facing || !((d = new Edge2D(v0 = this.camera.local_coords_to_screen_coords(edge.start), v1 = this.camera.local_coords_to_screen_coords(edge.end)).distance_as_a_segment(v)) < min))) {
                min = d;
                nearest_edge = edge;
            }
            ++i2;
        }
        Vertex2D v0 = this.camera.local_coords_to_screen_coords(nearest_edge.start);
        Vertex2D v1 = this.camera.local_coords_to_screen_coords(nearest_edge.end);
        Vertex2D u = new Edge2D(v0, v1).get_nearest_point_on_edge(v);
        Polygon2 polygon = nearest_edge.left_polygon;
        if (!this.front_facing(polygon)) {
            polygon = nearest_edge.right_polygon;
        }
        Object[] result = new Object[]{this.project_onto_polygon(u, polygon), polygon};
        return result;
    }

    public boolean onEdge(int i) {
        return ((PathElement)this.path.elementAt(i)).onEdge();
    }

    SurfacePath() {
    }

    public SurfacePath(Polyhedron h, CameraInterface camera) {
        this.h = h;
        this.camera = camera;
    }

    public SurfacePath(Polyhedron h, CameraInterface camera, Vector path, boolean loop) {
        this.h = h;
        this.camera = camera;
        this.path = path;
        this.loop = loop;
    }

    public Vertex pick_nearest_vertex(Point p) {
        Vertex2D v = new Vertex2D(p);
        Polygon2 polygon = this.pick_front_facing_polygon(v);
        if (polygon == null) {
            return null;
        }
        double min = 100000.0;
        Vertex nearest = null;
        int i = 0;
        while (i < 3) {
            Vertex u = polygon.get_vertex(i);
            Vertex2D w = this.camera.local_coords_to_screen_coords(u);
            double d = Vertex2D.distance(v, w);
            if (d < min) {
                min = d;
                nearest = u;
            }
            ++i;
        }
        return nearest;
    }

    public SurfacePath(Polyhedron h) {
        this.h = h;
    }

    public boolean inside(Point point, CameraInterface camera) {
        Vertex2D p = new Vertex2D(point);
        double angle = 0.0;
        Vertex2D prev = camera.local_coords_to_screen_coords(this.getVertex(this.path.size() - 1));
        int i = 0;
        while (i < this.path.size()) {
            Vector2 vec0 = new Vector2(p, (Vector2)prev);
            Vertex2D next = camera.local_coords_to_screen_coords(this.getVertex(i));
            Vector2 vec1 = new Vector2(p, (Vector2)next);
            double da = vec0.get_angle(vec1);
            if (da > 180.0) {
                da -= 360.0;
            }
            angle += da;
            prev = next;
            ++i;
        }
        return angle < -180.0 || angle > 180.0;
    }

    public Object getParent(int i) {
        return ((PathElement)this.path.elementAt(i)).getParent();
    }

    public Vertex getVertex(int i) {
        return ((PathElement)this.path.elementAt(i)).getVertex();
    }

    public SurfacePath(Vector boundary_edges) {
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i);
            this.path.addElement(new PathElement(edge.start, edge.start));
            ++i;
        }
        Edge edge0 = (Edge)boundary_edges.elementAt(0);
        Edge edge1 = (Edge)boundary_edges.elementAt(boundary_edges.size() - 1);
        this.loop = edge0.start == edge1.end;
    }

    public Vertex getCenter() {
        Vertex v = new Vertex();
        int count = 0;
        int i = 0;
        while (i < this.path.size()) {
            if (this.onPolygon(i)) {
                v.add_self(this.getVertex(i));
                ++count;
            }
            ++i;
        }
        v.multiple_self(1.0 / (double)count);
        return v;
    }

    public Vertex[] pick_quadratic_patch(Point p) {
        Polygon2 polygon = this.pick_front_facing_polygon(new Vertex2D(p));
        Vertex v = this.pick_nearest_vertex(p);
        LeastSquareFit.calculate_quadratic_patch(v, true);
        double[] F = v.quadratic_function;
        if (F == null) {
            F = (double[])v.quadratic_function_hashtable.get(polygon);
        }
        Vector3 normal = LeastSquareFit.get_normal(v, F);
        Vector3 b0 = new Vector3(normal.y - normal.z, normal.z - normal.x, normal.x - normal.y);
        b0.normalize_self();
        Vector3 b1 = Vector3.cross_product(normal, b0);
        b1.normalize_self();
        double[][] A = new double[2][2];
        A[0][0] = 2.0 * (F[0] * b0.x * b0.x + F[1] * b0.y * b0.y + F[2] * b0.z * b0.z + F[3] * b0.x * b0.y + F[4] * b0.y * b0.z + F[5] * b0.z * b0.x);
        double d = 2.0 * (F[0] * b0.x * b1.x + F[1] * b0.y * b1.y + F[2] * b0.z * b1.z) + F[3] * b0.x * b1.y + F[4] * b0.y * b1.z + F[5] * b0.z * b1.x + F[3] * b1.x * b0.y + F[4] * b1.y * b0.z + F[5] * b1.z * b0.x;
        A[0][1] = d;
        A[1][0] = d;
        A[1][1] = 2.0 * (F[0] * b1.x * b1.x + F[1] * b1.y * b1.y + F[2] * b1.z * b1.z + F[3] * b1.x * b1.y + F[4] * b1.y * b1.z + F[5] * b1.z * b1.x);
        DoubleSVD svd = new DoubleSVD(A);
        double[][] V = svd.V();
        Vector3 n0 = Vector3.add(b0.multiple(V[0][0]), b1.multiple(V[1][0]));
        Vector3 n1 = Vector3.add(b0.multiple(V[0][1]), b1.multiple(V[1][1]));
        b0 = n0;
        b1 = n1;
        b0.normalize_self();
        b1.normalize_self();
        if (Vector3.dot_product(v.normal, Vector3.cross_product(b0, b1)) < 0.0) {
            b1.multiple_self(-1.0);
        }
        Vertex[] triangle_array = new Vertex[726];
        double d2 = 0.02;
        int n = 0;
        int i = -5;
        while (i <= 5) {
            int j = -5;
            while (j <= 5) {
                Vertex v0 = v.translate(b0.multiple((double)i * d2).add(b1.multiple((double)j * d2)));
                Vertex v1 = v.translate(b0.multiple((double)i * d2 + d2).add(b1.multiple((double)j * d2)));
                Vertex v2 = v.translate(b0.multiple((double)i * d2 + d2).add(b1.multiple((double)j * d2 + d2)));
                Vertex v3 = v.translate(b0.multiple((double)i * d2).add(b1.multiple((double)j * d2 + d2)));
                v0 = LeastSquareFit.move_to_isosurface(v0, F);
                v1 = LeastSquareFit.move_to_isosurface(v1, F);
                v2 = LeastSquareFit.move_to_isosurface(v2, F);
                v3 = LeastSquareFit.move_to_isosurface(v3, F);
                triangle_array[n++] = v0;
                triangle_array[n++] = v1;
                triangle_array[n++] = v2;
                triangle_array[n++] = v0;
                triangle_array[n++] = v2;
                triangle_array[n++] = v3;
                ++j;
            }
            ++i;
        }
        return triangle_array;
    }

    private Vertex get_foot(Vertex v0, Vertex v1, Vertex v) {
        Vector3 vec = new Vector3(v0, v1);
        vec.normalize_self();
        return Vertex.translate(v0, Vector3.multiply(vec, Vector3.dot_product(vec, new Vector3(v0, v))));
    }

    public void bring_PolygonVertex_first() {
        PathElement pe;
        Vector<PathElement> lead_path = new Vector<PathElement>();
        Vector<PathElement> new_path = new Vector<PathElement>();
        int i = 0;
        i = 0;
        while (i < this.path.size()) {
            pe = (PathElement)this.path.elementAt(i);
            if (!pe.onEdge()) break;
            lead_path.addElement(pe);
            ++i;
        }
        while (i < this.path.size()) {
            pe = (PathElement)this.path.elementAt(i);
            new_path.addElement(pe);
            ++i;
        }
        this.path = Util.connectVector(new_path, lead_path);
    }

    public boolean onPolygon(int i) {
        return ((PathElement)this.path.elementAt(i)).onPolygon();
    }

    public int size() {
        return this.path.size();
    }

    public Vector3 getNormal(int i) {
        return ((PathElement)this.path.elementAt(i)).getNormal();
    }

    public static SurfacePath getSurfacePath(Polyhedron h, Vector stroke, CameraInterface camera, boolean loop) {
        SurfacePath surfacePath = new SurfacePath(h, camera, new Vector(), loop);
        Vector path = surfacePath.getPath(stroke);
        if (path == null) {
            return null;
        }
        surfacePath.path = path;
        surfacePath.adjust_to_PNsurface();
        return surfacePath;
    }

    private boolean front_facing(Polygon2 polygon) {
        return this.camera.front_facing(polygon.get_vertex(0), polygon.normal);
    }

    public Vertex getParentVertex(int i) {
        return ((PathElement)this.path.elementAt(i)).getParentVertex();
    }

    public Vector pick_nearby_vertices(Point p) {
        Vector vs = this.pick_nearby_vertices_main(p);
        return vs;
    }

    private void register_crosssection(Vertex2D p, Vertex v) {
        Vector vertices = new Vector();
        if (this.crosssection.containsKey(p)) {
            vertices = (Vector)this.crosssection.get(p);
        } else {
            this.crosssection.put(p, vertices);
            vertices.addElement(this.camera.get_camera_lay(p));
        }
        vertices.addElement(v);
    }

    private Edge find_next_edge(Edge2D strokeEdge, Edge prev_edge, Polygon2 polygon) {
        int i = 0;
        while (i < 3) {
            Edge2D edge2D;
            Edge edge = polygon.edges[i];
            if (edge != prev_edge && strokeEdge.cross(edge2D = new Edge2D(this.camera.local_coords_to_screen_coords(edge.start), this.camera.local_coords_to_screen_coords(edge.end)))) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public void adjust_to_PNsurface() {
        int i = 0;
        while (i < this.path.size()) {
            Vertex v = this.getVertex(i);
            Object parent = this.getParent(i);
            v.warp(PNsubdivision.calculate_position(v, parent));
            ++i;
        }
    }

    public Vector pick_nearby_vertices_main(Point p) {
        Vertex v = this.pick_nearest_vertex(p);
        if (!v.on_sharp()) {
            return LeastSquareFit.get_nearby_vertices_wide(v);
        }
        Vertex2D u = new Vertex2D(p);
        Polygon2 polygon = this.pick_front_facing_polygon(u);
        Vector<Polygon2> polygons = new Vector<Polygon2>();
        polygons.addElement(polygon);
        return LeastSquareFit.get_nearby_vertices(v, polygons);
    }

    private Polygon2 extend_path(Vertex2D prev_p, Vertex2D next_p, Polygon2 polygon, boolean[] forward, boolean front_facing_only) {
        Edge edge = null;
        Vertex prev_v = this.camera.screen_coords_to_local_coords(prev_p);
        Vertex next_v = this.camera.screen_coords_to_local_coords(next_p);
        Vertex third_v = prev_v.translate(this.camera.get_camera_lay(prev_p));
        Plane cutPlane = new Plane(third_v, prev_v, next_v);
        Edge2D strokeEdge = new Edge2D(prev_p, next_p);
        int count = 0;
        do {
            if (this.is_projected_inside(next_p, polygon)) {
                forward[0] = true;
                return polygon;
            }
            if (++count > 1000) {
                System.out.println("infinite loop in Surfacepath.extend");
                return null;
            }
            if ((edge = this.find_next_edge(strokeEdge, edge, polygon)) == null) {
                return null;
            }
            Vertex v = cutPlane.cross_point(edge);
            this.path.addElement(new PathElement(edge, v));
            polygon = edge.get_the_other_polygon(polygon);
            if (!front_facing_only || this.front_facing(polygon)) continue;
            return null;
        } while (!this.is_projected_inside(prev_p, polygon));
        forward[0] = false;
        return polygon;
    }

    private boolean is_projected_inside(Vertex2D v, Polygon2 polygon) {
        int sign = 1;
        if (!this.front_facing(polygon)) {
            sign = -1;
        }
        int i = 0;
        while (i < 3) {
            Vertex2D end;
            Vector2 vec1;
            Vertex2D start = this.camera.local_coords_to_screen_coords(polygon.get_vertex(i));
            Vector2 vec0 = new Vector2(start, (Vector2)v);
            if (vec0.cross_product(vec1 = new Vector2(start, (Vector2)(end = this.camera.local_coords_to_screen_coords(polygon.get_vertex(i + 1))))) * (double)sign > 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean is_inside(Vertex v01, Vertex v1, Vertex v2, Vertex v0, Vector3 normal) {
        Vector3 vector3 = new Vector3(v1, v2);
        Vector3 vector32 = new Vector3(v1, v01);
        return Vector3.dot_product(Vector3.cross_product(vector3, vector32), normal) > 0.0 && Vector3.dot_product(Vector3.cross_product(new Vector3(v2, v0), new Vector3(v2, v01)), normal) > 0.0;
    }

    public boolean onVertex(int i) {
        return ((PathElement)this.path.elementAt(i)).onVertex();
    }

    public class PathElement {
        Object parent;
        Vertex vertex;

        boolean onEdge() {
            return this.parent instanceof Edge;
        }

        public String toString() {
            return "" + this.vertex + " " + this.parent;
        }

        public PathElement(Object parent, Vertex vertex) {
            SurfacePath.this.getClass();
            this.parent = parent;
            this.vertex = vertex;
        }

        Object getParent() {
            return this.parent;
        }

        Vertex getVertex() {
            return this.vertex;
        }

        boolean onPolygon() {
            return this.parent instanceof Polygon2;
        }

        Edge getEdge() {
            return (Edge)this.parent;
        }

        Vector3 getNormal() {
            if (this.parent instanceof Polygon2) {
                return ((Polygon2)this.parent).normal;
            }
            if (this.parent instanceof Edge) {
                return ((Edge)this.parent).get_normal();
            }
            return ((Vertex)this.parent).normal;
        }

        Vertex getParentVertex() {
            return (Vertex)this.parent;
        }

        Polygon2 getPolygon() {
            return (Polygon2)this.parent;
        }

        boolean onVertex() {
            return this.parent instanceof Vertex;
        }
    }
}

