/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Polygon;
import java.io.Serializable;
import java.util.Enumeration;
import teddy.Def;
import teddy.Edge;
import teddy.Geometry;
import teddy.LinkedList;
import teddy.Objects;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

class SurfaceLine
extends Edge
implements Serializable {
    public Polygon2 polygon;
    public static Polyhedron h;

    SurfaceLine() {
        this.start = new Vertex();
        this.end = new Vertex();
        this.polygon = null;
    }

    SurfaceLine(Vertex _start, Vertex _end, Polygon2 _polygon) {
        this.start = _start;
        this.end = _end;
        this.polygon = _polygon;
        if (this.polygon != null) {
            this.polygon.surface_lines.append(this);
        }
    }

    SurfaceLine(Vertex2D v0, Vertex2D v1, Polyhedron _h) {
        Vertex camera = null;
        Geometry.init(_h, camera);
        Objects r0 = Geometry.find_vertex_on_surface(v0, true);
        Objects r1 = Geometry.find_vertex_on_surface(v1, true);
        if (r0.get(0) != r1.get(0)) {
            System.out.println("surface line, different polygon");
        }
        this.start = (Vertex)r0.get(1);
        this.end = (Vertex)r1.get(1);
        this.polygon = (Polygon2)r0.get(0);
    }

    public static LinkedList generate_surface_lines_sub(LinkedList edge_vertex_list) {
        LinkedList surface_lines = new LinkedList();
        Enumeration e = edge_vertex_list.elements();
        Objects objects = (Objects)e.nextElement();
        Polygon2 polygon = (Polygon2)objects.get(0);
        Vertex previous_vertex3D = (Vertex)objects.get(1);
        while (e.hasMoreElements()) {
            objects = (Objects)e.nextElement();
            Vertex next_vertex3D = (Vertex)objects.get(1);
            surface_lines.append(new SurfaceLine(previous_vertex3D, next_vertex3D, polygon));
            if (objects.get(0) instanceof Edge) {
                Edge next_edge = (Edge)objects.get(0);
                polygon = next_edge.get_another_polygon(polygon);
            }
            previous_vertex3D = next_vertex3D.copy();
        }
        return surface_lines;
    }

    public static void get_edge_vertex_list_sub(Vertex2D start2D, Vertex2D end2D, Polyhedron h, LinkedList edge_vertex_list) {
        Objects polygon_vertex0 = Geometry.find_vertex_on_surface(start2D, true);
        Objects polygon_vertex1 = Geometry.find_vertex_on_surface(end2D, true);
        if (polygon_vertex0 == null || polygon_vertex1 == null) {
            System.out.println("failed to find surface");
            return;
        }
        Vertex start3D = (Vertex)polygon_vertex0.get(1);
        Vertex end3D = (Vertex)polygon_vertex1.get(1);
        Polygon2 start_polygon = (Polygon2)polygon_vertex0.get(0);
        Polygon2 end_polygon = (Polygon2)polygon_vertex1.get(0);
        edge_vertex_list.connect(Geometry.surface_path(start2D, end2D, start3D, end3D, start_polygon, end_polygon));
        edge_vertex_list.append(polygon_vertex1);
    }

    public Edge copy() {
        Polygon2 new_polygon = this.polygon.child;
        SurfaceLine new_surface_line = new SurfaceLine(this.start.position_copy(), this.end.position_copy(), new_polygon);
        new_polygon.surface_lines.append(new_surface_line);
        return new_surface_line;
    }

    private static LinkedList remove_short_edges(LinkedList edge_vertex_list_original) {
        Objects prev_objects;
        boolean loop = false;
        if (edge_vertex_list_original.head() == edge_vertex_list_original.tail()) {
            loop = true;
        }
        LinkedList edge_vertex_list = new LinkedList();
        Enumeration e = edge_vertex_list_original.elements();
        Objects prev_prev_objects = prev_objects = (Objects)e.nextElement();
        Objects discarded_objects = prev_objects;
        edge_vertex_list.append(prev_objects);
        Vertex prev_vertex = (Vertex)prev_objects.get(1);
        while (e.hasMoreElements()) {
            Objects next_objects = (Objects)e.nextElement();
            Vertex next_vertex = (Vertex)next_objects.get(1);
            if (Vector3.distance(prev_vertex, next_vertex) > Def.MINIMUM_EDGE_LENGTH || next_objects.get(0) instanceof Edge) {
                if (prev_objects.get(0) instanceof Polygon && Vector3.distance(prev_vertex, next_vertex) < Def.MINIMUM_EDGE_LENGTH) {
                    edge_vertex_list.remove(edge_vertex_list.tail());
                }
                if (prev_objects.get(0) instanceof Edge && prev_objects.get(0) == next_objects.get(0)) {
                    edge_vertex_list.append(discarded_objects);
                    System.out.println("inserted");
                }
                edge_vertex_list.append(next_objects);
                prev_prev_objects = prev_objects;
                prev_vertex = next_vertex;
                prev_objects = next_objects;
            }
            discarded_objects = next_objects;
        }
        if (loop) {
            if (edge_vertex_list.head() != edge_vertex_list.tail()) {
                edge_vertex_list.append(edge_vertex_list.head());
            }
        } else {
            if (edge_vertex_list.head() != edge_vertex_list_original.head()) {
                edge_vertex_list.reset();
                edge_vertex_list.insert(edge_vertex_list_original.head());
            }
            if (edge_vertex_list.tail() != edge_vertex_list_original.tail()) {
                edge_vertex_list.append(edge_vertex_list_original.tail());
            }
        }
        return edge_vertex_list;
    }
}

