/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import teddy.Edge;
import teddy.Vector3;
import teddy.Vertex;

class Surface {
    public Vertex base;
    public Vector3 normal;

    public Vertex cross_point(Edge edge) {
        double start_to_surface = this.signed_distance(edge.start);
        double end_to_surface = this.signed_distance(edge.end);
        double start_to_end = start_to_surface - end_to_surface;
        return new Vertex(edge.start.add(edge.vector3().multiple(start_to_surface / start_to_end)));
    }

    Surface() {
        this.base = new Vertex();
        this.normal = new Vector3();
    }

    Surface(Vertex _base, Vector3 _normal) {
        this.base = _base;
        this.normal = _normal;
        this.normal.normalize();
    }

    Surface(Vertex v0, Vertex v1, Vertex v2) {
        Vector3 vec0 = new Vector3(v0, v1);
        Vector3 vec1 = new Vector3(v0, v2);
        this.normal = vec0.cross_product(vec1);
        this.base = v0;
        this.normal.normalize();
    }

    public double angle(Vector3 v) {
        double angle = this.normal.get_relative_angle(v);
        return Math.abs(angle - 1.5707963267948966);
    }

    public static Surface get_normal_surface(Vertex prev_vertex, Vertex center_vertex, Vertex next_vertex) {
        Vector3 vector0 = new Vector3(prev_vertex, center_vertex);
        Vector3 vector1 = new Vector3(center_vertex, next_vertex);
        vector0.normalize();
        vector1.normalize();
        return new Surface(center_vertex, vector0.add(vector1));
    }

    public double signed_distance(Vertex v) {
        Vector3 vector = new Vector3(this.base, v);
        return this.normal.dot_product(vector);
    }

    public double distance(Vertex v) {
        Vector3 vector = new Vector3(this.base, v);
        return Math.abs(this.normal.dot_product(vector));
    }
}

