/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import teddy.Edge;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Skin;
import teddy.Vector3;
import teddy.Vertex;

public class Subdivision {
    public static void update_body_vertex_and_body_element(Vertex v, Edge edge) {
        Object[] result0 = Skin.move_along_body_surface(edge.seam, edge.start.body_element, v);
        Object[] result1 = Skin.move_along_body_surface(edge.seam, edge.end.body_element, v);
        Vertex v0 = (Vertex)result0[1];
        Vertex v1 = (Vertex)result1[1];
        if (Vector3.distance(v, v0) < Vector3.distance(v, v1)) {
            v.body_vertex = v0;
            v.body_element = result0[0];
        } else {
            v.body_vertex = v1;
            v.body_element = result1[0];
        }
    }

    public static void subdivide(Polyhedron h) {
        h._vertices = new LinkedList();
        h._edges = new LinkedList();
        h._polygons = new LinkedList();
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            h._vertices.append(v);
            ++i;
        }
        i = 0;
        while (i < h.n_edges) {
            Vertex mid_vertex = h.edges[i].get_mid_vertex();
            h._vertices.append(mid_vertex);
            h._edges.append(new Edge(h.edges[i].start, mid_vertex, h.edges[i].sharp));
            h._edges.append(new Edge(mid_vertex, h.edges[i].end, h.edges[i].sharp));
            Subdivision.update_body_vertex_and_body_element(mid_vertex, h.edges[i]);
            ++i;
        }
        i = 0;
        while (i < h.n_polygons) {
            Polygon2 polygon = h.polygons[i];
            Vertex v0 = polygon.get_vertex(0);
            Vertex v1 = polygon.edges[0].mid_vertex;
            Vertex v2 = polygon.get_vertex(1);
            Vertex v3 = polygon.edges[1].mid_vertex;
            Vertex v4 = polygon.get_vertex(2);
            Vertex v5 = polygon.edges[2].mid_vertex;
            Edge edge13 = new Edge(v1, v3);
            Edge edge35 = new Edge(v3, v5);
            Edge edge51 = new Edge(v5, v1);
            Edge edge01 = v0.get_shared_edge(v1);
            Edge edge12 = v1.get_shared_edge(v2);
            Edge edge23 = v2.get_shared_edge(v3);
            Edge edge34 = v3.get_shared_edge(v4);
            Edge edge45 = v4.get_shared_edge(v5);
            Edge edge50 = v5.get_shared_edge(v0);
            edge01.seam = edge12.seam = polygon.edges((int)0).seam;
            edge23.seam = edge34.seam = polygon.edges((int)1).seam;
            edge45.seam = edge50.seam = polygon.edges((int)2).seam;
            edge01.sharp = edge12.sharp = polygon.edges((int)0).sharp;
            edge23.sharp = edge34.sharp = polygon.edges((int)1).sharp;
            edge45.sharp = edge50.sharp = polygon.edges((int)2).sharp;
            h._polygons.append(new Polygon2(edge13, edge35, edge51, polygon.patch));
            h._polygons.append(new Polygon2(edge01, edge51, edge50, polygon.patch));
            h._polygons.append(new Polygon2(edge12, edge23, edge13, polygon.patch));
            h._polygons.append(new Polygon2(edge34, edge45, edge35, polygon.patch));
            h._edges.append(edge13);
            h._edges.append(edge35);
            h._edges.append(edge51);
            ++i;
        }
        i = 0;
        while (i < h.n_edges) {
            Edge edge = h.edges[i];
            edge.start.remove_edge(edge);
            edge.end.remove_edge(edge);
            ++i;
        }
        h.postprocess_list_to_array();
        h.set_parameters();
    }
}

