/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Vector;
import teddy.ButterflySubdivision;
import teddy.CameraInterface;
import teddy.Crease;
import teddy.Cut;
import teddy.Extrusion;
import teddy.Fillet;
import teddy.HoppeOptimization;
import teddy.LeastSquareFit;
import teddy.LoopSubdivision;
import teddy.Merge;
import teddy.PNsubdivision;
import teddy.Polyhedron;
import teddy.QuadraticSubdivision;
import teddy.Skin;
import teddy.Smooth;
import teddy.SurfacePath;
import teddy.TaubinFairing;
import teddy.VariationalSubdivision;

public class SubdivMesh {
    private Polyhedron skeleton_mesh;
    public Polyhedron skin_mesh;
    public static final boolean SLOW_AND_ROBUST_ON = true;
    public static final boolean SLOW_AND_ROBUST_OFF = false;

    public void pop(SurfacePath path) {
        Smooth.smooth_region(this.skin_mesh, path);
        this.set_control_and_skeleton_mesh(this.skin_mesh, false);
    }

    public SurfacePath merge(Polyhedron child, boolean smooth) {
        SurfacePath path = Merge.merge(this.skin_mesh, child, smooth);
        this.set_skeleton_mesh(this.skin_mesh, false);
        return path;
    }

    public void set_skin_mesh_as_skeleton_mesh() {
        this.set_skeleton_mesh(this.skin_mesh, true);
    }

    public static Polyhedron create_skeleton_mesh(Polyhedron mesh, boolean slow_and_robust) {
        Polyhedron skeleton_mesh = mesh.copy();
        Skin.init_bodyPolygon_and_bodyVertex(mesh, skeleton_mesh);
        LeastSquareFit.calculate_quadratic_patch(skeleton_mesh, slow_and_robust);
        LeastSquareFit.set_target_edge_length(skeleton_mesh);
        return skeleton_mesh;
    }

    public void remesh() {
        Skin.refine_mesh_connectivity(this.skin_mesh);
        this.skin_mesh.set_normals();
    }

    public void taubin() {
        TaubinFairing.smooth(this.skin_mesh, 3);
    }

    public SubdivMesh(Polyhedron master) {
        this.skin_mesh = master;
        this.skeleton_mesh = SubdivMesh.create_skeleton_mesh(this.skin_mesh, true);
    }

    public SurfacePath extrude(SurfacePath path, Vector stroke, CameraInterface camera) {
        SurfacePath surfacePath = Extrusion.extrude(this.skin_mesh, path, stroke, camera);
        this.set_skeleton_mesh(this.skin_mesh, true);
        return surfacePath;
    }

    public void _update_skeleton_mesh(Polyhedron mesh) {
        Skin.init_bodyPolygon_and_bodyVertex(mesh, this.skeleton_mesh);
        Skin.calculate_curvature(this.skeleton_mesh);
    }

    public void crease(SurfacePath path) {
        Crease.crease(this.skin_mesh, path);
        this.set_skeleton_mesh(this.skin_mesh, false);
    }

    public void update_skeleton_mesh(boolean slow_and_robust) {
        this.set_skeleton_mesh(this.skin_mesh, slow_and_robust);
    }

    public void smooth(SurfacePath path) {
        Smooth.smooth_region_test(this.skin_mesh, path);
    }

    public SubdivMesh copy() {
        return new SubdivMesh(this.skin_mesh.copy());
    }

    public void optimize_vertex() {
        HoppeOptimization.optimize_control_mesh(this.skin_mesh, this.skeleton_mesh);
    }

    public Polyhedron get_subdivided_polyhedron(String type) {
        Polyhedron polyhedron = this.skin_mesh.copy();
        if (type.equals("Quadratic")) {
            QuadraticSubdivision.subdivide(polyhedron);
        } else if (type.equals("PNTriangle")) {
            polyhedron.set_normals();
            PNsubdivision.subdivide(polyhedron);
        } else if (type.equals("Butterfly")) {
            ButterflySubdivision.subdivide(polyhedron);
        } else if (type.equals("Loop")) {
            LoopSubdivision.subdivide(polyhedron);
        } else if (type.equals("RadialBasis")) {
            VariationalSubdivision.subdivide(polyhedron);
        }
        return polyhedron;
    }

    public void drift(int n) {
        Skin.drift(this.skin_mesh, n);
        this.skin_mesh.set_normals();
    }

    public void refine(boolean taubin_fairing) {
        Skin.drift(this.skin_mesh, 5);
        Skin.refine_mesh_connectivity(this.skin_mesh);
        Skin.drift(this.skin_mesh, 5);
        Skin.refine_mesh_connectivity(this.skin_mesh);
        Skin.drift(this.skin_mesh, 5);
        this.skin_mesh.set_normals();
        if (taubin_fairing) {
            TaubinFairing.smooth(this.skin_mesh, 3);
        }
        this.set_skeleton_mesh(this.skin_mesh, false);
        Skin.refine_mesh_connectivity(this.skin_mesh);
        Skin.drift(this.skin_mesh, 5);
        Skin.refine_mesh_connectivity(this.skin_mesh);
        Skin.drift(this.skin_mesh, 5);
        this.skin_mesh.set_normals();
    }

    public SurfacePath cut(SurfacePath surfacePath, boolean smooth) {
        SurfacePath path = Cut.cut(this.skin_mesh, surfacePath, smooth);
        this.skeleton_mesh = SubdivMesh.create_skeleton_mesh(this.skin_mesh, false);
        return path;
    }

    public void fillet(SurfacePath path) {
        Fillet.fillet(this.skin_mesh, path);
        this.set_skeleton_mesh(this.skin_mesh, false);
    }

    public void set_control_and_skeleton_mesh(Polyhedron mesh, boolean slow_and_robust) {
        this.skin_mesh = mesh.copy();
        this.skeleton_mesh = SubdivMesh.create_skeleton_mesh(this.skin_mesh, slow_and_robust);
        Skin.init_bodyPolygon_and_bodyVertex(mesh, this.skeleton_mesh);
    }

    public void set_skeleton_mesh(Polyhedron mesh, boolean slow_and_robust) {
        this.skeleton_mesh = SubdivMesh.create_skeleton_mesh(mesh, slow_and_robust);
    }
}

