/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import java.util.Vector;
import teddy.Def;
import teddy.Vector2;
import teddy.Vertex2D;
import teddy._Line2D;

public class StrokeAnalyzer {
    public static double unit_length = Def.NORMALIZED_STROKE_LENGTH_NEW;
    public static double margin_for_sharp_angle = unit_length / 2.0;
    public static double corner_threshold = unit_length / 2.0;

    public static Vector getResampledVertices(Vector vertices) {
        Vector corners = StrokeAnalyzer.getCorners(vertices);
        if (corners.size() <= 1) {
            corners = StrokeAnalyzer.getExtremes(vertices);
        }
        Vector resampled = new Vector();
        int v0_index = ((Vertex2D)corners.elementAt((int)(corners.size() - 1))).index;
        int i = 0;
        while (i < corners.size()) {
            int v1_index = ((Vertex2D)corners.elementAt((int)i)).index;
            Vector sub_vertices = StrokeAnalyzer.get_sub_vertices(vertices, v0_index, v1_index);
            Vector resampled_sub = StrokeAnalyzer.resample(sub_vertices);
            resampled_sub.removeElementAt(0);
            resampled = StrokeAnalyzer.connect_vector(resampled, resampled_sub);
            v0_index = v1_index;
            ++i;
        }
        return resampled;
    }

    public static Vector points_to_vertex2Ds(Vector points) {
        Vector<Vertex2D> vertices = new Vector<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            vertices.addElement(new Vertex2D((Point)points.elementAt(i), i));
            ++i;
        }
        return vertices;
    }

    public static Vector getCorners(Vector vertices) {
        Vector extremes = StrokeAnalyzer.getExtremes(vertices);
        Vertex2D v0 = (Vertex2D)extremes.elementAt(0);
        int index_v0 = v0.index;
        Vertex2D v1 = (Vertex2D)extremes.elementAt(1);
        int index_v1 = v1.index;
        Vector vertices_v0_to_v1 = new Vector();
        int i = index_v0;
        while (i != index_v1) {
            vertices_v0_to_v1.addElement(vertices.elementAt(i));
            if (++i != vertices.size()) continue;
            i = 0;
        }
        Vector vertices_v1_to_v0 = new Vector();
        int i2 = index_v1;
        while (i2 != index_v0) {
            vertices_v1_to_v0.addElement(vertices.elementAt(i2));
            if (++i2 != vertices.size()) continue;
            i2 = 0;
        }
        Vector corners_v0_to_v1 = StrokeAnalyzer.get_corners_sub(vertices_v0_to_v1);
        Vector corners_v1_to_v0 = StrokeAnalyzer.get_corners_sub(vertices_v1_to_v0);
        Vector<Vertex2D> corners = new Vector<Vertex2D>();
        corners.addElement(v0);
        int i3 = 0;
        while (i3 < corners_v0_to_v1.size()) {
            corners.addElement((Vertex2D)corners_v0_to_v1.elementAt(i3));
            ++i3;
        }
        corners.addElement(v1);
        i3 = 0;
        while (i3 < corners_v1_to_v0.size()) {
            corners.addElement((Vertex2D)corners_v1_to_v0.elementAt(i3));
            ++i3;
        }
        return corners;
    }

    public static Vertex2D get_next_vertex_with_margin(Vector vertices, Vertex2D v, double margin, int step) {
        double d = 0.0;
        int index = v.index;
        Vertex2D prev_vertex = v;
        Vertex2D vertex = v;
        while (true) {
            if ((index += step) == vertices.size()) {
                index = 0;
            } else if (index == -1) {
                index = vertices.size() - 1;
            }
            vertex = (Vertex2D)vertices.elementAt(index);
            if ((d += Vertex2D.distance(prev_vertex, vertex)) > margin) break;
            prev_vertex = vertex;
        }
        double t = (d - margin) / Vertex2D.distance(prev_vertex, vertex);
        return Vertex2D.interporate(vertex, prev_vertex, t);
    }

    public static Vector connect_vector(Vector main, Vector sub) {
        int i = 0;
        while (i < sub.size()) {
            main.addElement(sub.elementAt(i));
            ++i;
        }
        return main;
    }

    public static Vector getResampledVertices_noLoop(Vector vertices) {
        Vector corners = StrokeAnalyzer.getCorners_noLoop(vertices);
        Vector resampled = new Vector();
        int v0_index = ((Vertex2D)corners.elementAt((int)0)).index;
        int i = 1;
        while (i < corners.size()) {
            int v1_index = ((Vertex2D)corners.elementAt((int)i)).index;
            Vector sub_vertices = StrokeAnalyzer.get_sub_vertices(vertices, v0_index, v1_index);
            Vector resampled_sub = StrokeAnalyzer.resample(sub_vertices);
            if (i != 1) {
                resampled_sub.removeElementAt(0);
            }
            resampled = StrokeAnalyzer.connect_vector(resampled, resampled_sub);
            v0_index = v1_index;
            ++i;
        }
        return resampled;
    }

    public static double getLoopLength(Vector stroke) {
        double length = 0.0;
        Vertex2D prev = (Vertex2D)stroke.elementAt(stroke.size() - 1);
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D next = (Vertex2D)stroke.elementAt(i);
            length += Vertex2D.distance(prev, next);
            prev = next;
            ++i;
        }
        return length;
    }

    public static Vector resample(Vector vertices) {
        Vertex2D v0 = (Vertex2D)vertices.elementAt(0);
        Vertex2D v1 = (Vertex2D)vertices.elementAt(vertices.size() - 1);
        Vector<Vertex2D> resampled = new Vector<Vertex2D>();
        resampled.addElement(v0);
        double l = StrokeAnalyzer.length(vertices);
        int n = (int)(l / unit_length + 0.5);
        if (n <= 1) {
            resampled.addElement(v1);
            return resampled;
        }
        double unit = l / (double)n;
        double total = 0.0;
        double prev_total = 0.0;
        Vertex2D prev = v0;
        double next_spot = unit;
        int index = 1;
        int count = 0;
        while (true) {
            Vertex2D next = (Vertex2D)vertices.elementAt(index);
            total += Vertex2D.distance(prev, next);
            while (total >= next_spot) {
                Vertex2D new_vertex = Vertex2D.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.addElement(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
            ++index;
        }
        resampled.addElement(v1);
        return resampled;
    }

    public static Vertex2D get_center(Vector vertices) {
        Vertex2D center = new Vertex2D();
        int i = 0;
        while (i < vertices.size()) {
            center.add_self((Vertex2D)vertices.elementAt(i));
            ++i;
        }
        center.multiple_self(1.0 / (double)vertices.size());
        return center;
    }

    public static Vector getCorners_noLoop(Vector vertices) {
        Vector middle_corners = StrokeAnalyzer.get_corners_sub(vertices);
        Vector corners = new Vector();
        corners.addElement(vertices.elementAt(0));
        corners = StrokeAnalyzer.connect_vector(corners, middle_corners);
        corners.addElement(vertices.elementAt(vertices.size() - 1));
        return corners;
    }

    public static Vector getResampled_Points(Vector stroke, double l, boolean loop) {
        StrokeAnalyzer.setParameters(l);
        Vector vertices = StrokeAnalyzer.points_to_vertex2Ds(stroke);
        if (loop) {
            return StrokeAnalyzer.getResampledVertices(vertices);
        }
        return StrokeAnalyzer.getResampledVertices_noLoop(vertices);
    }

    public static double getLength_Points(Vector stroke, boolean loop) {
        double length = 0.0;
        Point prev = (Point)stroke.elementAt(0);
        int i = 1;
        while (i < stroke.size()) {
            Point next = (Point)stroke.elementAt(i);
            length += Vector2.distance(prev, next);
            prev = next;
            ++i;
        }
        if (loop) {
            Point next = (Point)stroke.elementAt(0);
            length += Vector2.distance(prev, next);
        }
        return length;
    }

    public static Vector get_sub_vertices(Vector vertices, int index_v0, int index_v1) {
        Vector vertices_v0_to_v1 = new Vector();
        int i = index_v0;
        while (i != index_v1) {
            vertices_v0_to_v1.addElement(vertices.elementAt(i));
            if (++i != vertices.size()) continue;
            i = 0;
        }
        vertices_v0_to_v1.addElement(vertices.elementAt(index_v1));
        return vertices_v0_to_v1;
    }

    public static void setParameters(double l) {
        unit_length = l;
        margin_for_sharp_angle = l;
        corner_threshold = l / 2.0;
    }

    public static Vector getSharpCorners(Vector vertices) {
        Vector corners = StrokeAnalyzer.getCorners(vertices);
        Vector<Vertex2D> sharp_corners = new Vector<Vertex2D>();
        int i = 0;
        while (i < corners.size()) {
            Vertex2D v1;
            Vector2 q;
            Vertex2D v = (Vertex2D)corners.elementAt(i);
            Vertex2D v0 = StrokeAnalyzer.get_next_vertex_with_margin(vertices, v, margin_for_sharp_angle, -1);
            Vector2 p = new Vector2(v0, (Vector2)v);
            double cos = p.get_cos(q = new Vector2(v, (Vector2)(v1 = StrokeAnalyzer.get_next_vertex_with_margin(vertices, v, margin_for_sharp_angle, 1))));
            if (cos < 0.5) {
                sharp_corners.addElement(v);
            }
            ++i;
        }
        return sharp_corners;
    }

    public static Vector getExtremes(Vector vertices) {
        Vertex2D center = StrokeAnalyzer.get_center(vertices);
        Vertex2D v0 = null;
        int index_v0 = 0;
        double max = 0.0;
        int i = 0;
        while (i < vertices.size()) {
            Vertex2D v = (Vertex2D)vertices.elementAt(i);
            double d = Vertex2D.distance(center, v);
            if (d > max) {
                v0 = v;
                max = d;
                index_v0 = i;
            }
            ++i;
        }
        Vertex2D v1 = null;
        max = 0.0;
        int index_v1 = 0;
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vertex2D v = (Vertex2D)vertices.elementAt(i2);
            double d = Vertex2D.distance(v0, v);
            if (d > max) {
                v1 = v;
                max = d;
                index_v1 = i2;
            }
            ++i2;
        }
        Vector<Vertex2D> extremes = new Vector<Vertex2D>();
        extremes.addElement(v0);
        extremes.addElement(v1);
        return extremes;
    }

    public static Vector get_corners_sub(Vector vertices) {
        Vertex2D v1;
        Vertex2D v0 = (Vertex2D)vertices.elementAt(0);
        if (v0.same_position(v1 = (Vertex2D)vertices.elementAt(vertices.size() - 1))) {
            return new Vector();
        }
        _Line2D line = new _Line2D(v0, v1);
        Vertex2D cv = null;
        double max = corner_threshold;
        int index_cv = -1;
        int i = 0;
        while (i < vertices.size()) {
            Vertex2D v = (Vertex2D)vertices.elementAt(i);
            double d = Math.abs(line.distance(v));
            if (d > max) {
                cv = v;
                max = d;
                index_cv = i;
            }
            ++i;
        }
        if (cv == null) {
            return new Vector();
        }
        Vector vertices0 = new Vector();
        int i2 = 0;
        while (i2 <= index_cv) {
            vertices0.addElement(vertices.elementAt(i2));
            ++i2;
        }
        Vector corners0 = StrokeAnalyzer.get_corners_sub(vertices0);
        Vector vertices1 = new Vector();
        int i3 = index_cv;
        while (i3 < vertices.size()) {
            vertices1.addElement(vertices.elementAt(i3));
            ++i3;
        }
        Vector corners1 = StrokeAnalyzer.get_corners_sub(vertices1);
        Vector corners = new Vector();
        int i4 = 0;
        while (i4 < corners0.size()) {
            corners.addElement(corners0.elementAt(i4));
            ++i4;
        }
        corners.addElement(cv);
        i4 = 0;
        while (i4 < corners1.size()) {
            corners.addElement(corners1.elementAt(i4));
            ++i4;
        }
        return corners;
    }

    public static double length(Vector vertices) {
        double l = 0.0;
        int i = 0;
        while (i < vertices.size() - 1) {
            Vertex2D v0 = (Vertex2D)vertices.elementAt(i);
            Vertex2D v1 = (Vertex2D)vertices.elementAt(i + 1);
            l += Vertex2D.distance(v0, v1);
            ++i;
        }
        return l;
    }
}

