/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import teddy.Edge;
import teddy.LeastSquareFit;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Queue;
import teddy.Remesh;
import teddy.Seam;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;

public class Skin {
    public static final double RADIUS_TO_EDGE_LENGTH = 0.8;

    public static void calculate_curvature(Vector vertices) {
        Polygon2 p0 = (Polygon2)((Vertex)vertices.elementAt(0)).polygons().head();
        double max_edge_length = p0.patch.unit_length * 3.0;
        double min_edge_length = p0.patch.unit_length / 10.0;
        double total = 0.0;
        double min = 1000.0;
        double max = 0.0;
        int i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i);
            double sum = 10000.0;
            Vector3 normal = v.normal;
            Enumeration e = v.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                Vector3 vec = new Vector3(v, edge.get_the_other_vertex(v));
                if (v.on_sharp()) {
                    if (edge.sharp) {
                        Vector3 vec1;
                        Edge[] sharp_edges = v.get_sharp_edges();
                        Vector3 vec0 = new Vector3(v, sharp_edges[0].get_the_other_vertex(v));
                        normal = Vector3.cross_product(vec0, vec1 = new Vector3(v, sharp_edges[1].get_the_other_vertex(v)));
                        if (normal.length() == 0.0) {
                            normal = null;
                        } else {
                            vec0 = Vector3.cross_product(vec0, normal);
                            vec1 = Vector3.cross_product(normal, vec1);
                            normal = Vector3.add(vec0, vec1);
                            normal.normalize_self();
                        }
                    } else {
                        normal = v.get_sharp_normal(edge.left_polygon);
                    }
                }
                if (normal == null) continue;
                double cos = Math.abs(Vector3.cos(normal, vec));
                double l = edge.length() / 2.0 / cos * 0.8;
                if (Double.isNaN(l)) continue;
                sum = Math.min(sum, l);
            }
            v.target_edge_length = Math.max(min_edge_length, Math.min(sum, max_edge_length));
            max = Math.max(max, sum);
            min = Math.min(min, sum);
            ++i;
        }
        min = 1000.0;
        max = 0.0;
        double[] target_length = new double[vertices.size()];
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i2);
            target_length[i2] = Skin.prevail(v, v.target_edge_length);
            ++i2;
        }
        i2 = 0;
        while (i2 < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i2);
            v.target_edge_length = target_length[i2];
            ++i2;
        }
    }

    public static void update_bodyPolygon_and_bodyVertex(Vertex v, Vertex base, Seam seam) {
        if (base.body_element == null) {
            return;
        }
        Object[] result = Skin.move_along_body_surface(seam, base.body_element, v);
        v.body_element = result[0];
        v.body_vertex = (Vertex)result[1];
    }

    static Vector3 get_vector_to_isosurface(Vertex v) {
        if (!v.on_seam()) {
            double height = ((Polygon2)v.polygons().head()).patch.iFunction.get_value(v);
            if (Double.isNaN(height)) {
                System.out.println("height Nan");
            }
            Vector3 dv = v.normal.multiple(-height / 10000.0);
            return dv;
        }
        Vector3 dv = new Vector3();
        LinkedList polygons = v.polygons();
        Enumeration e = polygons.elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            double height = polygon.patch.iFunction.get_value(v);
            if (Double.isNaN(height)) {
                System.out.println("height Nan");
            }
            dv = dv.add(polygon.normal.multiple(-height / 10000.0 / (double)polygons.size()));
        }
        return dv;
    }

    public static void refine_mesh_connectivity(Polyhedron h) {
        h.lock();
        int c = Remesh.refine_mesh_connectivity(h);
        h.unlock();
        h.set_indices();
    }

    public static void refine_mesh_connectivity(Polyhedron h, Vector edges) {
        h.lock();
        int c = Remesh.refine_mesh_connectivity(h, edges);
        h.unlock();
        h.set_indices();
    }

    public static void walk_body_surface_to(Vertex v, Vertex target) {
        Object[] result = Skin.move_along_body_surface(v.get_seam(), v.body_element, target);
        v.body_element = result[0];
        v.body_vertex = (Vertex)result[1];
        v.warp(v.body_vertex);
    }

    public static void drift_main(Polyhedron h) {
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            if (!v.fixed && !v.on_seam_cross()) {
                Skin.drift(v);
            }
            ++i;
        }
    }

    public static void drift_main(Vector vertices) {
        int i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i);
            if (!v.fixed && !v.on_seam_cross()) {
                Skin.drift(v);
            }
            ++i;
        }
    }

    static Vector3 get_vector_to_centroid_on_seam(Vertex v) {
        Vertex center = new Vertex();
        LinkedList vertices = v.get_sorrounding_vertices_on_seam();
        if (vertices.size() != 2) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        Enumeration e = vertices.elements();
        while (e.hasMoreElements()) {
            center.add_self((Vertex)e.nextElement());
        }
        center.multiple_self(1.0 / (double)vertices.size());
        Vector3 vector = new Vector3(v, center);
        double weight = 0.8;
        return vector.multiple(weight);
    }

    static double average_edge_length(Vertex v) {
        double l = 0.0;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            l += ((Edge)e.nextElement()).length();
        }
        return l /= (double)v.edges.size();
    }

    public static double prevail(Vertex center, double r) {
        Queue queue = new Queue();
        Vector<Vertex> visited = new Vector<Vertex>();
        queue.append(center);
        visited.addElement(center);
        while (queue.size() > 0) {
            Vertex v = (Vertex)queue.dequeue();
            r = Skin.prevail(v, center, r, queue, visited);
        }
        return r;
    }

    public static double prevail(Vertex v, Vertex center, double r, Queue queue, Vector visited) {
        LinkedList vs = v.get_surrounding_vertices();
        Enumeration e = vs.elements();
        while (e.hasMoreElements()) {
            Vertex u = (Vertex)e.nextElement();
            double d = Vector3.distance(center, u);
            if (!(d < r) || visited.contains(u)) continue;
            double l = v.target_edge_length;
            l = Math.max(d - l, l);
            r = Math.min(r, l);
            visited.addElement(u);
            queue.append(u);
        }
        return r;
    }

    public static void drift_to_implicit_surface(Polyhedron h, Vertex v) {
        double height = h.iFunction.get_value(v);
        double slope = h.iFunction.get_slope(v, v.normal);
        if (slope == 0.0) {
            return;
        }
        Vector3 dv = v.normal.multiple(-height / 100.0);
        v.warp(v.translate(dv));
    }

    public static Object[] move_along_body_surface(Seam seam, Object body_element, Vertex target_vertex) {
        if (body_element instanceof Polygon2) {
            Polygon2 polygon = (Polygon2)body_element;
            Object[] result = polygon.find_closest_point(target_vertex);
            Vertex vertex = (Vertex)result[0];
            if (result[1] instanceof Polygon2) {
                Object[] result2 = new Object[]{polygon, vertex};
                return result2;
            }
            if (result[1] instanceof Edge) {
                Edge next_edge = (Edge)result[1];
                return Skin.move_along_body_surface(seam, next_edge, target_vertex);
            }
            Vertex next_vertex = (Vertex)result[1];
            return Skin.move_along_body_surface(seam, next_vertex, target_vertex);
        }
        if (body_element instanceof Edge) {
            Edge edge = (Edge)body_element;
            double v0 = Vector3.distance(edge.start, target_vertex);
            double v1 = Vector3.distance(edge.end, target_vertex);
            double d = edge.distance_as_a_segment(target_vertex);
            double p0 = edge.left_polygon().distance_as_a_segment(target_vertex);
            double p1 = edge.right_polygon().distance_as_a_segment(target_vertex);
            if (seam != null) {
                p0 = 10000.0;
                p1 = 10000.0;
            }
            if (v0 <= d && v0 <= v1 && v0 <= p0 && v0 <= p1) {
                return Skin.move_along_body_surface(seam, edge.start, target_vertex);
            }
            if (v1 <= d && v1 <= v0 && v1 <= p0 && v1 <= p1) {
                return Skin.move_along_body_surface(seam, edge.end, target_vertex);
            }
            if (d <= v0 && d <= v1 && d <= p0 && d <= p1) {
                Object[] result = new Object[]{edge, edge.project_as_a_segment(target_vertex)};
                return result;
            }
            if (p0 <= v0 && p0 <= v1 && p0 <= d && p0 <= p1) {
                return Skin.move_along_body_surface(seam, edge.left_polygon(), target_vertex);
            }
            if (p1 <= v0 && p1 <= v1 && p1 <= d && p1 <= p0) {
                return Skin.move_along_body_surface(seam, edge.right_polygon(), target_vertex);
            }
            System.out.println("ouch Skin");
        } else if (body_element instanceof Vertex) {
            double d;
            Vertex vertex = (Vertex)body_element;
            double min = Vector3.distance(vertex, target_vertex);
            Serializable next_element = vertex;
            Enumeration e = vertex.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                if (seam != null && edge.seam != seam || !((d = edge.distance_as_a_segment(target_vertex)) < min)) continue;
                min = d;
                next_element = edge;
            }
            if (seam == null) {
                e = vertex.polygons().elements();
                while (e.hasMoreElements()) {
                    Polygon2 polygon = (Polygon2)e.nextElement();
                    d = polygon.distance_as_a_segment(target_vertex);
                    if (!(d < min)) continue;
                    min = d;
                    next_element = polygon;
                }
            }
            if (next_element == vertex) {
                Object[] result = new Object[]{vertex, vertex};
                return result;
            }
            return Skin.move_along_body_surface(seam, next_element, target_vertex);
        }
        return null;
    }

    public static Vector2 project(Vertex vertex, Vertex base, Vector3 x_vector, Vector3 y_vector) {
        Vector3 vector = new Vector3(base, vertex);
        return Skin.project(vector, x_vector, y_vector);
    }

    public static Vector2 project(Vector3 vector, Vector3 x_vector, Vector3 y_vector) {
        return new Vector2(Vector3.dot_product(x_vector, vector), Vector3.dot_product(y_vector, vector));
    }

    static Vertex find_useful_neighbor(Vertex v) {
        Enumeration e = v.get_surrounding_vertices().elements();
        while (e.hasMoreElements()) {
            Vertex u = (Vertex)e.nextElement();
            if (!(v.on_seam() ? u.on_seam() && u.body_element != null : u.body_element != null)) continue;
            return u;
        }
        System.out.println("error in Skin.find_useful_neighbor()");
        return null;
    }

    public static void drift(Polyhedron h, int steps) {
        int i = 0;
        while (i < steps) {
            Skin.drift_main(h);
            ++i;
        }
    }

    public static void _drift(Polyhedron h) {
        Skin.drift_main(h);
        h.set_normals();
    }

    public static void drift(Vector vertices, int steps) {
        int i = 0;
        while (i < steps) {
            Skin.drift_main(vertices);
            ++i;
        }
    }

    public static void drift(Vertex v) {
        Vector3 cv = Skin.get_vector_to_centroid(v);
        if (Double.isNaN(cv.x)) {
            System.out.println("NaN in drift");
            return;
        }
        Vertex target = Vertex.translate(v, cv);
        Skin.walk_body_surface_to(v, target);
        v.warp(LeastSquareFit.calculate_position(v, v.body_vertex, v.body_element));
    }

    public static void drift_to_center(Vertex v) {
        double length = 0.0;
        Vertex v_to_c = new Vertex();
        LinkedList surrounding_edges = v.get_surrounding_edges();
        Enumeration e = surrounding_edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vector3 v_to_m = new Vector3(v, edge.mid_vertex());
            v_to_c.add_self(v_to_m.multiple(edge.length()));
            length += edge.length();
        }
        v_to_c.multiple_self(1.0 / length);
        double cos = v.normal.dot_product(v_to_c);
        Vector3 slide_vector = v_to_c.add(v.normal.multiple(-cos));
        v.add_self(slide_vector.multiple(0.5));
    }

    static Vector3 get_vector_to_centroid(Vertex v) {
        if (v.on_seam()) {
            return Skin.get_vector_to_centroid_on_seam(v);
        }
        Vertex center = new Vertex();
        double length = 0.0;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex u = edge.get_the_other_vertex(v);
            double l = edge.length() / edge.get_target_edge_length();
            center.add_self(u.multiple(l));
            length += l;
        }
        center.multiple_self(1.0 / length);
        Vector3 vector = new Vector3(v, center);
        double weight = 0.8;
        return vector.multiple(weight);
    }

    static Vector3 adjust_dv(Vector3 dv, Vertex v) {
        double max_l;
        double l = dv.length();
        if (l < (max_l = Skin.average_edge_length(v) / 2.0)) {
            return dv;
        }
        return dv.multiple(max_l / l);
    }

    static Edge find_vertical_edge(LinkedList edges, Vector3 y) {
        Edge v_edge = null;
        double max_cos = -2.0;
        Enumeration e = edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            double cos = edge.vector3().get_normalized().cos(y);
            if (!(cos > max_cos)) continue;
            max_cos = cos;
            v_edge = edge;
        }
        return v_edge;
    }

    public static void init_bodyPolygon_and_bodyVertex(Polyhedron h, Polyhedron body) {
        if (h.n_vertices != body.n_vertices) {
            System.out.println("error in Skin.init_bodyPolygon_and_bodyVertex()");
        }
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            v.body_vertex = body.vertices[i];
            v.body_element = body.vertices[i];
            ++i;
        }
    }

    public static void refine_mesh_connectivity_split_only(Polyhedron h, Vector edges) {
        h.lock();
        int c = Remesh.refine_mesh_connectivity_split_only(h, edges);
        h.unlock();
        h.set_indices();
    }

    public static void subdivide(Polyhedron h) {
        h._vertices = new LinkedList();
        h._edges = new LinkedList();
        h._polygons = new LinkedList();
        int i = 0;
        while (i < h.n_vertices) {
            h._vertices.append(h.vertices[i]);
            ++i;
        }
        i = 0;
        while (i < h.n_edges) {
            Vertex mid_vertex = h.edges[i].get_mid_vertex();
            h._vertices.append(mid_vertex);
            h._edges.append(new Edge(h.edges[i].start, mid_vertex));
            h._edges.append(new Edge(mid_vertex, h.edges[i].end));
            ++i;
        }
        i = 0;
        while (i < h.n_polygons) {
            Polygon2 polygon = h.polygons[i];
            Vertex v0 = polygon.get_vertex(0);
            Vertex v1 = polygon.edges[0].mid_vertex;
            Vertex v2 = polygon.get_vertex(1);
            Vertex v3 = polygon.edges[1].mid_vertex;
            Vertex v4 = polygon.get_vertex(2);
            Vertex v5 = polygon.edges[2].mid_vertex;
            Edge edge13 = new Edge(v1, v3);
            Edge edge35 = new Edge(v3, v5);
            Edge edge51 = new Edge(v5, v1);
            Edge edge01 = v0.get_shared_edge(v1);
            Edge edge12 = v1.get_shared_edge(v2);
            Edge edge23 = v2.get_shared_edge(v3);
            Edge edge34 = v3.get_shared_edge(v4);
            Edge edge45 = v4.get_shared_edge(v5);
            Edge edge50 = v5.get_shared_edge(v0);
            edge01.seam = edge12.seam = polygon.edges((int)0).seam;
            edge23.seam = edge34.seam = polygon.edges((int)1).seam;
            edge45.seam = edge50.seam = polygon.edges((int)2).seam;
            edge01.sharp = edge12.sharp = polygon.edges((int)0).sharp;
            edge23.sharp = edge34.sharp = polygon.edges((int)1).sharp;
            edge45.sharp = edge50.sharp = polygon.edges((int)2).sharp;
            h._polygons.append(new Polygon2(edge13, edge35, edge51, polygon.patch));
            h._polygons.append(new Polygon2(edge01, edge51, edge50, polygon.patch));
            h._polygons.append(new Polygon2(edge12, edge23, edge13, polygon.patch));
            h._polygons.append(new Polygon2(edge34, edge45, edge35, polygon.patch));
            h._edges.append(edge13);
            h._edges.append(edge35);
            h._edges.append(edge51);
            ++i;
        }
        i = 0;
        while (i < h.n_edges) {
            Edge edge = h.edges[i];
            edge.start.remove_edge(edge);
            edge.end.remove_edge(edge);
            ++i;
        }
        int c = 0;
        Enumeration e = h._edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.left_polygon() != null && edge.right_polygon() != null) continue;
            ++c;
        }
        h.postprocess_list_to_array();
        h.set_parameters();
    }

    public static void update_bodyPolygon_and_bodyVertex(Polyhedron h, Polyhedron body) {
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            if (v.body_element == null) {
                Vertex parent = Skin.find_useful_neighbor(v);
                Object[] result = Skin.move_along_body_surface(v.get_seam(), parent.body_element, v);
                v.body_element = result[0];
                v.body_vertex = (Vertex)result[1];
            }
            ++i;
        }
    }

    public static boolean seam_peak(Vertex v) {
        Vector3 vec1;
        Edge edge0 = null;
        Edge edge1 = null;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.seam == null) continue;
            if (edge0 == null) {
                edge0 = edge;
                continue;
            }
            edge1 = edge;
        }
        Vector3 vec0 = new Vector3(v, edge0.get_the_other_vertex(v));
        return vec0.get_relative_angle(vec1 = new Vector3(v, edge1.get_the_other_vertex(v))) < 2.0734511513692637;
    }

    public static void calculate_curvature(Polyhedron h) {
        Vector<Vertex> vertices = new Vector<Vertex>();
        int i = 0;
        while (i < h.n_vertices) {
            vertices.addElement(h.vertices[i]);
            ++i;
        }
        Skin.calculate_curvature(vertices);
    }

    public static Vertex reverse_project(Vertex base, Vector3 x_vector, Vector3 y_vector, Vector2 coords) {
        return Vertex.translate(base, Vector3.add(Vector3.multiply(x_vector, coords.x), Vector3.multiply(y_vector, coords.y)));
    }
}

