/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Delaunay;
import teddy.Edge;
import teddy.Line2D;
import teddy.LinkedList;
import teddy.NewPolyhedron;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Region;
import teddy.Seam;
import teddy.SkEdge2D;
import teddy.SkPolygon2D;
import teddy.SkVertex2D;
import teddy.TrimData;
import teddy.Util;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

class Skeleton {
    static final boolean SET_SILHOUETTE_SEAM = true;
    public static int steps = 3;
    public static double max_height;
    public static double inflation_ratio;
    public static LinkedList triangles;
    public static LinkedList edges;
    public static SkVertex2D[] vertices;
    public static int n_vertices;
    public static NewPolyhedron h;

    public static LinkedList get_skeleton_edges(LinkedList stroke) {
        return new LinkedList();
    }

    static SkEdge2D find_crease_edge(SkVertex2D v, Vector2 vec) {
        double min = -1.0;
        SkEdge2D crease_edge = null;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type != 3) continue;
            Vector2 vector = new Vector2(v, (Vector2)edge.get_the_other_vertex(v));
            double d = Math.abs(Vector2.sin(vector, vec));
            if (min != -1.0 && !(d < min)) continue;
            min = d;
            crease_edge = edge;
        }
        return crease_edge;
    }

    static Vector2 crease_direction(SkVertex2D v) {
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        SkVertex2D next = vertices[Util.mod(v.index + 1, n_vertices)];
        Vector2 vector0 = new Vector2(v, (Vector2)prev);
        Vector2 vector1 = new Vector2(v, (Vector2)next);
        vector0.normalize_self();
        vector1.normalize_self();
        return Vector2.add(vector0, vector1);
    }

    static boolean is_crease(SkVertex2D v) {
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        SkVertex2D next = vertices[Util.mod(v.index + 1, n_vertices)];
        Vector2 vector0 = new Vector2(prev, (Vector2)v);
        Vector2 vector1 = new Vector2(v, (Vector2)next);
        if (vector0.length() == 0.0) {
            System.out.println(" ouch in in is_crease");
        }
        return Vector2.sin(vector0, vector1) > 0.0 && Vector2.cos(vector0, vector1) <= 0.0;
    }

    private static void propagate(SkPolygon2D start_polygon, SkEdge2D start_edge, TrimData td, LinkedList covers, LinkedList cover_edges) {
        SkPolygon2D prev_polygon = start_polygon;
        SkEdge2D prev_edge = start_edge;
        prev_polygon.mark();
        SkPolygon2D next_polygon = prev_edge.the_other_polygon(prev_polygon);
        if (next_polygon.type == 1) {
            SkEdge2D next_edge = next_polygon.the_other_internal_edge(prev_edge);
        }
        if (next_polygon.type == 2) {
            next_polygon.setTrimData(prev_edge, td);
            Skeleton.propagate_junction(next_polygon, covers, cover_edges);
        } else {
            SkVertex2D center = prev_edge.get_mid_vertex();
            Enumeration e = td.terminal_edges.elements();
            while (e.hasMoreElements()) {
                SkEdge2D edge1;
                SkEdge2D terminal_edge = (SkEdge2D)e.nextElement();
                SkEdge2D edge0 = ((SkVertex2D)terminal_edge.start).get_shared_edge(center);
                if (edge0 == null) {
                    edge0 = new SkEdge2D((SkVertex2D)terminal_edge.start, center, 3);
                    cover_edges.append(edge0);
                }
                if ((edge1 = ((SkVertex2D)terminal_edge.end).get_shared_edge(center)) == null) {
                    edge1 = new SkEdge2D((SkVertex2D)terminal_edge.end, center, 3);
                    cover_edges.append(edge1);
                }
                covers.append(new SkPolygon2D(terminal_edge, edge1, edge0, 3));
            }
        }
    }

    static void add_plusKnots_around_sharp_corner_sub(SkVertex2D v, Vector plusKnots, Vector2 vec) {
        vec.normalize_self();
        Vector3 normal = new Vector3(-vec.y, vec.x, 0.0);
        Vertex pv = v.getVertex().translate(normal.multiple(1.0E-4));
        plusKnots.addElement(pv);
    }

    static Vector3 crease_normal(SkVertex2D v, Region region) {
        Vector2 vec;
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        SkVertex2D next = vertices[Util.mod(v.index + 1, n_vertices)];
        if (v.get_common_edge((SkVertex2D)prev).left_polygon.region == region) {
            vec = new Vector2(prev, (Vector2)v);
        } else if (v.get_common_edge((SkVertex2D)next).left_polygon.region == region) {
            vec = new Vector2(v, (Vector2)next);
        } else {
            return null;
        }
        vec.normalize_self();
        return new Vector3(-vec.y, vec.x, 0.0);
    }

    Skeleton() {
    }

    static boolean is_crease_edge(SkVertex2D v, SkEdge2D edge) {
        SkVertex2D u;
        Vector2 vec;
        SkVertex2D next;
        Vector2 vector1;
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        Vector2 vector0 = new Vector2(v, (Vector2)prev);
        Vector2 normal = vector0.add(vector1 = new Vector2(v, (Vector2)(next = vertices[Util.mod(v.index + 1, n_vertices)])));
        double cos = normal.cos(vec = new Vector2(v, (Vector2)(u = (SkVertex2D)edge.get_the_other_vertex(v))));
        return cos < -0.5;
    }

    private static void propagate_junction(SkPolygon2D junction_polygon, LinkedList covers, LinkedList cover_edges) {
        SkEdge2D edge;
        SkEdge2D longest_edge = junction_polygon.get_longest_edge();
        TrimData new_td = new TrimData();
        boolean failed = false;
        boolean one_of_the_short_edges_is_still_waiting = false;
        int i = 0;
        while (i < junction_polygon.edges.size()) {
            edge = junction_polygon.get_edge(i);
            if (edge != longest_edge) {
                TrimData td = junction_polygon.getTrimData(i);
                if (td != null) {
                    if (!td.terminals_are_within_this_circle(edge)) {
                        failed = true;
                    } else {
                        new_td.merge(td);
                    }
                } else {
                    one_of_the_short_edges_is_still_waiting = true;
                }
            }
            ++i;
        }
        if (junction_polygon.getTrimData(longest_edge) != null) {
            failed = true;
        }
        if (one_of_the_short_edges_is_still_waiting) {
            return;
        }
        if (failed) {
            return;
        }
        i = 0;
        while (i < junction_polygon.edges.size()) {
            edge = junction_polygon.get_edge(i);
            if (edge != longest_edge) {
                edge.pruned = true;
            }
            ++i;
        }
        Skeleton.propagate(junction_polygon, longest_edge, new_td, covers, cover_edges);
    }

    private static void propagate_junction_final(SkPolygon2D junction_polygon, LinkedList covers, LinkedList cover_edges) {
        LinkedList terminal_edges = new LinkedList();
        int i = 0;
        while (i < junction_polygon.edges.size()) {
            TrimData td = junction_polygon.getTrimData(i);
            if (td != null) {
                SkEdge2D edge = (SkEdge2D)junction_polygon.edges.elementAt(i);
                if (junction_polygon.center_edge != edge) {
                    edge.pruned = true;
                }
                terminal_edges.connect(td.terminal_edges);
            }
            ++i;
        }
        SkVertex2D center = junction_polygon.center;
        Enumeration e = terminal_edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge1;
            SkEdge2D terminal_edge = (SkEdge2D)e.nextElement();
            SkEdge2D edge0 = ((SkVertex2D)terminal_edge.start).get_shared_edge(center);
            if (edge0 == null) {
                edge0 = new SkEdge2D((SkVertex2D)terminal_edge.start, center, 3);
                cover_edges.append(edge0);
            }
            if ((edge1 = ((SkVertex2D)terminal_edge.end).get_shared_edge(center)) == null) {
                edge1 = new SkEdge2D((SkVertex2D)terminal_edge.end, center, 3);
                cover_edges.append(edge1);
            }
            covers.append(new SkPolygon2D(terminal_edge, edge1, edge0, 3));
        }
    }

    public static SkVertex2D get_vertex(int i) {
        if (i >= n_vertices) {
            i -= i / n_vertices * n_vertices;
        }
        if (i < 0) {
            i += (-i / n_vertices + 1) * n_vertices;
        }
        return vertices[i];
    }

    static void add_plusKnots_around_sharp_corner(SkVertex2D v, Vector plusKnots) {
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        Skeleton.add_plusKnots_around_sharp_corner_sub(v, plusKnots, new Vector2(prev, (Vector2)v));
        SkVertex2D next = vertices[Util.mod(v.index + 1, n_vertices)];
        Skeleton.add_plusKnots_around_sharp_corner_sub(v, plusKnots, new Vector2(v, (Vector2)next));
    }

    static LinkedList[] prune_edges() {
        SkPolygon2D polygon;
        LinkedList covers = new LinkedList();
        LinkedList cover_edges = new LinkedList();
        Enumeration e = triangles.elements();
        while (e.hasMoreElements()) {
            polygon = (SkPolygon2D)e.nextElement();
            if (polygon.type != 0) continue;
            Skeleton.propagate_terminal(polygon, covers, cover_edges);
        }
        e = triangles.elements();
        while (e.hasMoreElements()) {
            polygon = (SkPolygon2D)e.nextElement();
            if (polygon.type != 2 || polygon.marked || polygon.getTrimData(0) == null && polygon.getTrimData(1) == null && polygon.getTrimData(2) == null) continue;
            Skeleton.propagate_junction_final(polygon, covers, cover_edges);
        }
        LinkedList[] result = new LinkedList[]{covers, cover_edges};
        return result;
    }

    public static Polyhedron generate_polyhedron(LinkedList stroke, double _inflation_ratio, double _max_height, double unit_length) {
        SkEdge2D edge1;
        SkEdge2D edge0;
        max_height = _max_height;
        inflation_ratio = _inflation_ratio;
        n_vertices = stroke.size();
        int size = n_vertices + 1;
        vertices = new SkVertex2D[size];
        Enumeration e = stroke.elements();
        int i = 0;
        while (i < n_vertices) {
            Skeleton.vertices[i] = new SkVertex2D((Vertex2D)e.nextElement());
            Skeleton.vertices[i].index = i;
            ++i;
        }
        Skeleton.vertices[Skeleton.n_vertices] = vertices[0];
        Vector loop = stroke.vector();
        Vector[] delaunay_result = Delaunay.triangulate(loop);
        Vector delaunay_edges = delaunay_result[0];
        Vector delaunay_triangles = delaunay_result[1];
        edges = new LinkedList();
        int i2 = 0;
        while (i2 < delaunay_edges.size()) {
            int[] delaunay_edge = (int[])delaunay_edges.elementAt(i2);
            int dif = Math.abs(delaunay_edge[0] - delaunay_edge[1]);
            int type = dif == 1 || dif == n_vertices - 1 ? 0 : 2;
            SkEdge2D edge = new SkEdge2D(vertices[delaunay_edge[0]], vertices[delaunay_edge[1]], type);
            edges.append(edge);
            ++i2;
        }
        triangles = new LinkedList();
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 1;
        int[] triangle_types = nArray;
        int i3 = 0;
        while (i3 < delaunay_triangles.size()) {
            int[] delaunay_triangle = (int[])delaunay_triangles.elementAt(i3);
            SkEdge2D edge02 = (SkEdge2D)edges.elementAt(delaunay_triangle[0]);
            SkEdge2D edge12 = (SkEdge2D)edges.elementAt(delaunay_triangle[1]);
            SkEdge2D edge2 = (SkEdge2D)edges.elementAt(delaunay_triangle[2]);
            int n_externals = SkEdge2D.count_external_edges(edge02, edge12, edge2);
            int type = triangle_types[n_externals];
            SkPolygon2D triangle = new SkPolygon2D(edge02, edge12, edge2, type);
            triangles.append(triangle);
            ++i3;
        }
        Region region = new Region();
        e = triangles.elements();
        while (e.hasMoreElements()) {
            SkPolygon2D polygon = (SkPolygon2D)e.nextElement();
            polygon.region = region;
        }
        double total = 0.0;
        int n = 0;
        e = edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (!edge.is_internal()) continue;
            if (edge.left_polygon.type == 1 && edge.right_polygon.type == 1 || edge.left_polygon.type == 0 && edge.right_polygon.type == 1 || edge.right_polygon.type == 0 && edge.left_polygon.type == 1) {
                Vector2 vec0 = Skeleton.get_tangent_vector((SkVertex2D)edge.start, vertices);
                Vector2 vec1 = Skeleton.get_tangent_vector((SkVertex2D)edge.end, vertices).multiple(-1.0);
                if (vec0.length() == 0.0 && vec1.length() == 0.0) {
                    edge.height = edge.length() / 2.0 * inflation_ratio;
                } else {
                    Line2D line2D = new Line2D(edge.start, vec0.add(vec1));
                    edge.height = line2D.distance(edge.mid_point()) * inflation_ratio;
                }
            } else {
                edge.height = edge.length() / 2.0 * inflation_ratio;
            }
            if (edge.height > max_height) {
                edge.height = max_height;
            }
            total += edge.height;
            ++n;
        }
        e = triangles.elements();
        while (e.hasMoreElements()) {
            SkPolygon2D polygon = (SkPolygon2D)e.nextElement();
            if (polygon.type != 2) continue;
            polygon.set_center();
        }
        LinkedList[] result = Skeleton.prune_edges();
        LinkedList covers = result[0];
        LinkedList cover_edges = result[1];
        LinkedList new_edges = new LinkedList();
        e = edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.pruned) continue;
            new_edges.append(edge);
        }
        edges = new_edges;
        edges.connect(cover_edges);
        Hashtable<SkVertex2D, Vector2> creases = new Hashtable<SkVertex2D, Vector2>();
        int i4 = 0;
        while (i4 < n_vertices) {
            if (Skeleton.is_crease(vertices[i4])) {
                Skeleton.vertices[i4].crease = true;
                creases.put(vertices[i4], Skeleton.crease_direction(vertices[i4]));
            }
            ++i4;
        }
        System.out.println("creases " + creases.size());
        LinkedList internal_vertices = new LinkedList();
        new_edges = new LinkedList();
        e = edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type == 2) {
                SkVertex2D v = edge.get_mid_vertex();
                internal_vertices.append(v);
                edge0 = v.get_common_edge((SkVertex2D)edge.start);
                if (edge0 == null) {
                    edge0 = new SkEdge2D((SkVertex2D)edge.start, v, 3);
                    new_edges.append(edge0);
                }
                if ((edge1 = v.get_common_edge((SkVertex2D)edge.end)) != null) continue;
                edge1 = new SkEdge2D((SkVertex2D)edge.end, v, 3);
                new_edges.append(edge1);
                continue;
            }
            new_edges.append(edge);
        }
        edges = new_edges;
        LinkedList new_triangles = new LinkedList();
        e = triangles.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge20c;
            SkEdge2D edge12c;
            SkVertex2D v1;
            SkVertex2D v0;
            SkPolygon2D polygon = (SkPolygon2D)e.nextElement();
            if (polygon.type == 0 && !polygon.marked) {
                SkEdge2D int_edge = polygon.get_internal_edge();
                LinkedList ext_edges = polygon.get_external_edges();
                SkEdge2D ext_edge0 = (SkEdge2D)ext_edges.head();
                SkEdge2D ext_edge1 = (SkEdge2D)ext_edges.tail();
                v0 = (SkVertex2D)ext_edge0.get_common_vertex(int_edge);
                v1 = (SkVertex2D)ext_edge1.get_common_vertex(int_edge);
                SkVertex2D center_vertex = int_edge.get_mid_vertex();
                SkEdge2D int_edge0 = v0.get_common_edge(center_vertex);
                SkEdge2D int_edge1 = v1.get_common_edge(center_vertex);
                SkEdge2D center_edge = new SkEdge2D((SkVertex2D)ext_edge0.get_common_vertex(ext_edge1), center_vertex, 3);
                edges.append(center_edge);
                new_triangles.append(new SkPolygon2D(ext_edge0, int_edge0, center_edge, 3));
                new_triangles.append(new SkPolygon2D(ext_edge1, center_edge, int_edge1, 3));
                continue;
            }
            if (polygon.type == 1 && !polygon.marked) {
                SkEdge2D cross_edge;
                SkEdge2D ext_edge = polygon.get_external_edge();
                LinkedList int_edges = polygon.get_internal_edges();
                SkEdge2D int_edge0 = (SkEdge2D)int_edges.head();
                SkEdge2D int_edge1 = (SkEdge2D)int_edges.tail();
                v0 = (SkVertex2D)ext_edge.get_common_vertex(int_edge0);
                v1 = int_edge0.get_mid_vertex();
                SkVertex2D v2 = (SkVertex2D)int_edge0.get_common_vertex(int_edge1);
                SkVertex2D v3 = int_edge1.get_mid_vertex();
                SkVertex2D v4 = (SkVertex2D)ext_edge.get_common_vertex(int_edge1);
                SkEdge2D int_edge00 = v0.get_common_edge(v1);
                SkEdge2D int_edge01 = v1.get_common_edge(v2);
                SkEdge2D int_edge10 = v2.get_common_edge(v3);
                SkEdge2D int_edge11 = v3.get_common_edge(v4);
                SkEdge2D center_edge = new SkEdge2D(v1, v3, 4);
                edges.append(center_edge);
                new_triangles.append(new SkPolygon2D(center_edge, int_edge01, int_edge10, 4));
                if (Vertex2D.distance(v0, v3) < Vertex2D.distance(v1, v4)) {
                    cross_edge = new SkEdge2D(v0, v3, 3);
                    edges.append(cross_edge);
                    new_triangles.append(new SkPolygon2D(center_edge, cross_edge, int_edge00, 4));
                    new_triangles.append(new SkPolygon2D(ext_edge, cross_edge, int_edge11, 3));
                    continue;
                }
                cross_edge = new SkEdge2D(v4, v1, 3);
                edges.append(cross_edge);
                new_triangles.append(new SkPolygon2D(center_edge, int_edge11, cross_edge, 4));
                new_triangles.append(new SkPolygon2D(ext_edge, int_edge00, cross_edge, 3));
                continue;
            }
            if (polygon.type != 2 || polygon.marked) continue;
            if (polygon.center_edge == null) {
                internal_vertices.append(polygon.center);
            }
            edge0 = polygon.get_edge(0);
            edge1 = polygon.get_edge(1);
            SkEdge2D edge2 = polygon.get_edge(2);
            SkVertex2D v01 = (SkVertex2D)edge0.get_common_vertex(edge1);
            SkVertex2D v12 = (SkVertex2D)edge1.get_common_vertex(edge2);
            SkVertex2D v20 = (SkVertex2D)edge2.get_common_vertex(edge0);
            SkEdge2D edge02 = edge0.get_mid_vertex().get_common_edge(v20);
            SkEdge2D edge01 = edge0.get_mid_vertex().get_common_edge(v01);
            SkEdge2D edge10 = edge1.get_mid_vertex().get_common_edge(v01);
            SkEdge2D edge12 = edge1.get_mid_vertex().get_common_edge(v12);
            SkEdge2D edge21 = edge2.get_mid_vertex().get_common_edge(v12);
            SkEdge2D edge20 = edge2.get_mid_vertex().get_common_edge(v20);
            SkEdge2D edge01c = polygon.center.get_common_edge(v01);
            if (edge01c == null) {
                edge01c = new SkEdge2D(v01, polygon.center, 3);
                edges.append(edge01c);
            }
            if ((edge12c = polygon.center.get_common_edge(v12)) == null) {
                edge12c = new SkEdge2D(v12, polygon.center, 3);
                edges.append(edge12c);
            }
            if ((edge20c = polygon.center.get_common_edge(v20)) == null) {
                edge20c = new SkEdge2D(v20, polygon.center, 3);
                edges.append(edge20c);
            }
            if (polygon.center_edge != edge0 && !edge0.pruned) {
                new_triangles.append(new SkPolygon2D(edge20c, edge02, edge01, edge01c, 5));
            }
            if (polygon.center_edge != edge1 && !edge1.pruned) {
                new_triangles.append(new SkPolygon2D(edge01c, edge10, edge12, edge12c, 5));
            }
            if (polygon.center_edge == edge2 || edge2.pruned) continue;
            new_triangles.append(new SkPolygon2D(edge12c, edge21, edge20, edge20c, 5));
        }
        new_triangles.connect(covers);
        Vector<Vertex> _vertices = new Vector<Vertex>();
        Vector<Edge> _edges = new Vector<Edge>();
        Vector<Polygon2> _polygons = new Vector<Polygon2>();
        int i5 = 0;
        while (i5 < n_vertices) {
            _vertices.addElement(vertices[i5].getVertex());
            ++i5;
        }
        e = internal_vertices.elements();
        while (e.hasMoreElements()) {
            SkVertex2D v = (SkVertex2D)e.nextElement();
            _vertices.addElement(v.getVertexAbove());
            _vertices.addElement(v.getVertexBelow());
        }
        Seam silhouette_seam = new Seam();
        e = edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type == 0) {
                Edge _edge = edge.getEdge();
                _edge.seam = silhouette_seam;
                _edges.addElement(_edge);
                continue;
            }
            if (edge.type == 3) {
                int i6 = 0;
                while (i6 < steps) {
                    _edges.addElement(edge.getEdgeAbove(i6));
                    _edges.addElement(edge.getEdgeBelow(i6));
                    if (i6 > 0) {
                        _vertices.addElement(edge.getVertexAbove(i6));
                        _vertices.addElement(edge.getVertexBelow(i6));
                    }
                    ++i6;
                }
                continue;
            }
            if (edge.type != 4) continue;
            _edges.addElement(edge.getEdgeAbove());
            _edges.addElement(edge.getEdgeBelow());
        }
        e = new_triangles.elements();
        while (e.hasMoreElements()) {
            Vertex v;
            Edge cross_edge_below;
            Edge cross_edge_above;
            Edge next_edge_above;
            Edge edge1_below;
            Edge edge0_below;
            Edge edge1_above;
            Edge edge0_above;
            Edge prev_edge_below;
            Edge prev_edge_above;
            SkEdge2D int_edge1;
            SkEdge2D int_edge0;
            SkPolygon2D polygon = (SkPolygon2D)e.nextElement();
            if (polygon.type == 3) {
                SkEdge2D ext_edge = (SkEdge2D)polygon.edges.elementAt(0);
                int_edge0 = (SkEdge2D)polygon.edges.elementAt(1);
                int_edge1 = (SkEdge2D)polygon.edges.elementAt(2);
                prev_edge_above = ext_edge.getEdge();
                prev_edge_below = ext_edge.getEdge();
                int i7 = 0;
                while (i7 < steps) {
                    Edge next_edge_below;
                    edge0_above = int_edge0.getEdgeAbove(i7);
                    edge1_above = int_edge1.getEdgeAbove(i7);
                    edge0_below = int_edge0.getEdgeBelow(i7);
                    edge1_below = int_edge1.getEdgeBelow(i7);
                    if (i7 == steps - 1) {
                        _polygons.addElement(new Polygon2(prev_edge_above, edge0_above, edge1_above));
                        _polygons.addElement(new Polygon2(prev_edge_below, edge1_below, edge0_below));
                    } else if (Vector3.distance(int_edge0.getVertexAbove(i7), int_edge1.getVertexAbove(i7 + 1)) < Vector3.distance(int_edge0.getVertexAbove(i7 + 1), int_edge1.getVertexAbove(i7))) {
                        next_edge_above = new Edge(int_edge0.getVertexAbove(i7 + 1), int_edge1.getVertexAbove(i7 + 1));
                        cross_edge_above = new Edge(int_edge0.getVertexAbove(i7), int_edge1.getVertexAbove(i7 + 1));
                        _edges.addElement(next_edge_above);
                        _edges.addElement(cross_edge_above);
                        _polygons.addElement(new Polygon2(prev_edge_above, cross_edge_above, edge1_above));
                        _polygons.addElement(new Polygon2(edge0_above, next_edge_above, cross_edge_above));
                        next_edge_below = new Edge(int_edge0.getVertexBelow(i7 + 1), int_edge1.getVertexBelow(i7 + 1));
                        cross_edge_below = new Edge(int_edge0.getVertexBelow(i7), int_edge1.getVertexBelow(i7 + 1));
                        _edges.addElement(next_edge_below);
                        _edges.addElement(cross_edge_below);
                        _polygons.addElement(new Polygon2(prev_edge_below, edge1_below, cross_edge_below));
                        _polygons.addElement(new Polygon2(edge0_below, cross_edge_below, next_edge_below));
                        prev_edge_above = next_edge_above;
                        prev_edge_below = next_edge_below;
                    } else {
                        next_edge_above = new Edge(int_edge0.getVertexAbove(i7 + 1), int_edge1.getVertexAbove(i7 + 1));
                        cross_edge_above = new Edge(int_edge1.getVertexAbove(i7), int_edge0.getVertexAbove(i7 + 1));
                        _edges.addElement(next_edge_above);
                        _edges.addElement(cross_edge_above);
                        _polygons.addElement(new Polygon2(prev_edge_above, edge0_above, cross_edge_above));
                        _polygons.addElement(new Polygon2(next_edge_above, edge1_above, cross_edge_above));
                        next_edge_below = new Edge(int_edge0.getVertexBelow(i7 + 1), int_edge1.getVertexBelow(i7 + 1));
                        cross_edge_below = new Edge(int_edge1.getVertexBelow(i7), int_edge0.getVertexBelow(i7 + 1));
                        _edges.addElement(next_edge_below);
                        _edges.addElement(cross_edge_below);
                        _polygons.addElement(new Polygon2(prev_edge_below, cross_edge_below, edge0_below));
                        _polygons.addElement(new Polygon2(next_edge_below, cross_edge_below, edge1_below));
                        prev_edge_above = next_edge_above;
                        prev_edge_below = next_edge_below;
                    }
                    ++i7;
                }
                continue;
            }
            if (polygon.type == 4) {
                SkEdge2D center_edge = (SkEdge2D)polygon.edges.elementAt(0);
                int_edge0 = (SkEdge2D)polygon.edges.elementAt(1);
                int_edge1 = (SkEdge2D)polygon.edges.elementAt(2);
                prev_edge_above = center_edge.getEdgeAbove();
                prev_edge_below = center_edge.getEdgeBelow();
                int i8 = 0;
                while (i8 < steps) {
                    Edge next_edge_below;
                    edge0_above = int_edge0.getEdgeAbove(steps - 1 - i8);
                    edge1_above = int_edge1.getEdgeAbove(steps - 1 - i8);
                    edge0_below = int_edge0.getEdgeBelow(steps - 1 - i8);
                    edge1_below = int_edge1.getEdgeBelow(steps - 1 - i8);
                    if (i8 == steps - 1) {
                        _polygons.addElement(new Polygon2(prev_edge_above, edge0_above, edge1_above));
                        _polygons.addElement(new Polygon2(prev_edge_below, edge1_below, edge0_below));
                    } else if (Vector3.distance(int_edge0.getVertexAbove(steps - i8), int_edge1.getVertexAbove(steps - 1 - i8)) < Vector3.distance(int_edge1.getVertexAbove(steps - i8), int_edge0.getVertexAbove(steps - 1 - i8))) {
                        next_edge_above = new Edge(int_edge0.getVertexAbove(steps - 1 - i8), int_edge1.getVertexAbove(steps - 1 - i8));
                        cross_edge_above = new Edge(int_edge0.getVertexAbove(steps - i8), int_edge1.getVertexAbove(steps - 1 - i8));
                        _edges.addElement(next_edge_above);
                        _edges.addElement(cross_edge_above);
                        _polygons.addElement(new Polygon2(prev_edge_above, cross_edge_above, edge1_above));
                        _polygons.addElement(new Polygon2(edge0_above, next_edge_above, cross_edge_above));
                        next_edge_below = new Edge(int_edge0.getVertexBelow(steps - 1 - i8), int_edge1.getVertexBelow(steps - 1 - i8));
                        cross_edge_below = new Edge(int_edge0.getVertexBelow(steps - i8), int_edge1.getVertexBelow(steps - i8 - 1));
                        _edges.addElement(next_edge_below);
                        _edges.addElement(cross_edge_below);
                        _polygons.addElement(new Polygon2(prev_edge_below, edge1_below, cross_edge_below));
                        _polygons.addElement(new Polygon2(edge0_below, cross_edge_below, next_edge_below));
                        prev_edge_above = next_edge_above;
                        prev_edge_below = next_edge_below;
                    } else {
                        next_edge_above = new Edge(int_edge0.getVertexAbove(steps - 1 - i8), int_edge1.getVertexAbove(steps - 1 - i8));
                        cross_edge_above = new Edge(int_edge1.getVertexAbove(steps - i8), int_edge0.getVertexAbove(steps - 1 - i8));
                        _edges.addElement(next_edge_above);
                        _edges.addElement(cross_edge_above);
                        _polygons.addElement(new Polygon2(prev_edge_above, edge0_above, cross_edge_above));
                        _polygons.addElement(new Polygon2(next_edge_above, edge1_above, cross_edge_above));
                        next_edge_below = new Edge(int_edge0.getVertexBelow(steps - 1 - i8), int_edge1.getVertexBelow(steps - 1 - i8));
                        cross_edge_below = new Edge(int_edge1.getVertexBelow(steps - i8), int_edge0.getVertexBelow(steps - i8 - 1));
                        _edges.addElement(next_edge_below);
                        _edges.addElement(cross_edge_below);
                        _polygons.addElement(new Polygon2(prev_edge_below, cross_edge_below, edge0_below));
                        _polygons.addElement(new Polygon2(next_edge_below, cross_edge_below, edge1_below));
                        prev_edge_above = next_edge_above;
                        prev_edge_below = next_edge_below;
                    }
                    ++i8;
                }
                continue;
            }
            SkEdge2D edge03 = (SkEdge2D)polygon.edges.elementAt(0);
            SkEdge2D edge13 = (SkEdge2D)polygon.edges.elementAt(1);
            SkEdge2D edge2 = (SkEdge2D)polygon.edges.elementAt(2);
            SkEdge2D edge3 = (SkEdge2D)polygon.edges.elementAt(3);
            Vector<Vertex2D> vertices = new Vector<Vertex2D>();
            Vector<Vertex> verticesAbove = new Vector<Vertex>();
            Vector<Vertex> verticesBelow = new Vector<Vertex>();
            int i9 = 0;
            while (i9 < steps) {
                v = edge03.getVertexAbove(steps - i9);
                vertices.addElement(new Vertex2D(v.x, v.y));
                verticesAbove.addElement(v);
                verticesBelow.addElement(edge03.getVertexBelow(steps - i9));
                ++i9;
            }
            i9 = 0;
            while (i9 < steps) {
                v = edge13.getVertexAbove(i9);
                vertices.addElement(new Vertex2D(v.x, v.y));
                verticesAbove.addElement(v);
                verticesBelow.addElement(edge13.getVertexBelow(i9));
                ++i9;
            }
            i9 = 0;
            while (i9 < steps) {
                v = edge2.getVertexAbove(steps - i9);
                vertices.addElement(new Vertex2D(v.x, v.y));
                verticesAbove.addElement(v);
                verticesBelow.addElement(edge2.getVertexBelow(steps - i9));
                ++i9;
            }
            i9 = 0;
            while (i9 < steps) {
                v = edge3.getVertexAbove(i9);
                vertices.addElement(new Vertex2D(v.x, v.y));
                verticesAbove.addElement(v);
                verticesBelow.addElement(edge3.getVertexBelow(i9));
                ++i9;
            }
            i9 = 0;
            while (i9 < vertices.size()) {
                ((Vertex2D)vertices.elementAt((int)i9)).index = i9;
                ++i9;
            }
            Vector[] delaunay_result2 = Delaunay.triangulate(vertices);
            Vector edges2D = delaunay_result2[0];
            Vector polygons2D = delaunay_result2[1];
            Vector<Edge> edgesAbove = new Vector<Edge>();
            Vector<Edge> edgesBelow = new Vector<Edge>();
            int i10 = 0;
            while (i10 < edges2D.size()) {
                Edge edgeBelow;
                int[] edge2D = (int[])edges2D.elementAt(i10);
                Edge edgeAbove = ((Vertex)verticesAbove.elementAt(edge2D[0])).get_common_edge((Vertex)verticesAbove.elementAt(edge2D[1]));
                if (edgeAbove == null) {
                    edgeAbove = new Edge((Vertex)verticesAbove.elementAt(edge2D[0]), (Vertex)verticesAbove.elementAt(edge2D[1]));
                    _edges.addElement(edgeAbove);
                }
                if ((edgeBelow = ((Vertex)verticesBelow.elementAt(edge2D[0])).get_common_edge((Vertex)verticesBelow.elementAt(edge2D[1]))) == null) {
                    edgeBelow = new Edge((Vertex)verticesBelow.elementAt(edge2D[0]), (Vertex)verticesBelow.elementAt(edge2D[1]));
                    _edges.addElement(edgeBelow);
                }
                edgesAbove.addElement(edgeAbove);
                edgesBelow.addElement(edgeBelow);
                ++i10;
            }
            i10 = 0;
            while (i10 < polygons2D.size()) {
                int[] polygon2D = (int[])polygons2D.elementAt(i10);
                _polygons.addElement(new Polygon2((Edge)edgesAbove.elementAt(polygon2D[0]), (Edge)edgesAbove.elementAt(polygon2D[1]), (Edge)edgesAbove.elementAt(polygon2D[2])));
                _polygons.addElement(new Polygon2((Edge)edgesBelow.elementAt(polygon2D[1]), (Edge)edgesBelow.elementAt(polygon2D[0]), (Edge)edgesBelow.elementAt(polygon2D[2])));
                ++i10;
            }
        }
        e = creases.keys();
        while (e.hasMoreElements()) {
            SkVertex2D v = (SkVertex2D)e.nextElement();
            Vector2 vec = (Vector2)creases.get(v);
            SkEdge2D edge = Skeleton.find_crease_edge(v, vec);
            Seam seam = new Seam();
            int i11 = 0;
            while (i11 < steps - 1) {
                edge.getEdgeAbove((int)i11).seam = seam;
                edge.getEdgeBelow((int)i11).seam = seam;
                edge.getEdgeAbove((int)i11).sharp = true;
                edge.getEdgeBelow((int)i11).sharp = true;
                ++i11;
            }
            edge.getVertexAbove((int)(Skeleton.steps - 2)).fixed = true;
            edge.getVertexBelow((int)(Skeleton.steps - 2)).fixed = true;
        }
        Polyhedron h = new Polyhedron(_vertices, _edges, _polygons);
        h.set_parameters();
        Patch patch = new Patch();
        patch.unit_length = unit_length;
        int i12 = 0;
        while (i12 < h.n_polygons) {
            h.polygons[i12].patch = patch;
            ++i12;
        }
        return h;
    }

    static SkVertex2D adjacent_silhouette_vertex_outside_region(SkVertex2D v, Region region) {
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        if (v.get_common_edge((SkVertex2D)prev).left_polygon.region != region) {
            return prev;
        }
        SkVertex2D next = vertices[Util.mod(v.index + 1, n_vertices)];
        if (v.get_common_edge((SkVertex2D)next).left_polygon.region != region) {
            return next;
        }
        return null;
    }

    static Vector2 get_tangent_vector(SkVertex2D v, SkVertex2D[] vertices) {
        Vector2 vec1;
        int n0 = v.index - 1;
        if (n0 == -1) {
            n0 = vertices.length - 2;
        }
        SkVertex2D prev = vertices[n0];
        int n1 = v.index + 1;
        SkVertex2D next = vertices[n1];
        Vector2 vec0 = new Vector2(prev, (Vector2)v).get_normalized();
        if (Vector2.sin(vec0, vec1 = new Vector2(v, (Vector2)next).get_normalized()) > 0.0 && Vector2.cos(vec0, vec1) <= 0.0) {
            return new Vector2();
        }
        return vec0.add(vec1).get_normalized();
    }

    static SkVertex2D get_corresponding_SkVertex(Vertex v) {
        int j = 0;
        while (j < vertices.length - 1) {
            SkVertex2D v0 = vertices[j];
            if (v0.x == v.x && v0.y == v.y) {
                return v0;
            }
            ++j;
        }
        return null;
    }

    private static void propagate_terminal(SkPolygon2D terminal_polygon, LinkedList covers, LinkedList cover_edges) {
        SkVertex2D terminal_vertex = terminal_polygon.get_terminal_vertex();
        LinkedList terminal_edges = terminal_polygon.get_external_edges();
        SkEdge2D start_edge = terminal_polygon.get_internal_edge();
        TrimData td = new TrimData(terminal_vertex, terminal_edges);
        Skeleton.propagate(terminal_polygon, start_edge, td, covers, cover_edges);
    }

    static boolean is_concave(SkVertex2D v) {
        SkVertex2D next;
        Vector2 vector1;
        SkVertex2D prev = vertices[Util.mod(v.index - 1, n_vertices)];
        Vector2 vector0 = new Vector2(prev, (Vector2)v);
        return vector0.sin(vector1 = new Vector2(v, (Vector2)(next = vertices[Util.mod(v.index + 1, n_vertices)]))) > 0.0;
    }

    static void propagate_region(SkPolygon2D triangle, Region region, SkEdge2D prev_edge) {
        triangle.region = region;
        region.triangles.addElement(triangle);
        int i = 0;
        while (i < 3) {
            SkEdge2D edge = triangle.get_edge(i);
            if (prev_edge != edge && edge.is_internal() && edge.seam == null) {
                Skeleton.propagate_region(edge.the_other_polygon(triangle), region, edge);
            }
            ++i;
        }
    }
}

