/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import teddy.Geometry2D;
import teddy.LinkedList;
import teddy.Region;
import teddy.SkEdge2D;
import teddy.SkVertex2D;
import teddy.Skeleton;
import teddy.TrimData;
import teddy.Vertex2D;

class SkPolygon2D {
    public LinkedList edges = new LinkedList();
    public int type;
    public SkVertex2D center;
    public SkEdge2D center_edge;
    public boolean marked = false;
    public Region region = null;
    public static final int TERMINAL = 0;
    public static final int SLEEVE = 1;
    public static final int JUNCTION = 2;
    public static final int COVER = 3;
    public static final int INTERNAL = 4;
    public static final int SUB_JUNCTION = 5;
    public TrimData[] trimData = null;

    private Vertex2D get_gravity_center() {
        double x = 0.0;
        double y = 0.0;
        int size = this.edges.size();
        int i = 0;
        while (i < size) {
            SkVertex2D v = this.get_vertex(i);
            x += v.x;
            y += v.y;
            ++i;
        }
        return new Vertex2D(x /= (double)size, y /= (double)size);
    }

    public double average_edge_length() {
        Enumeration e = this.edges.elements();
        double total = 0.0;
        while (e.hasMoreElements()) {
            total += ((SkEdge2D)e.nextElement()).length();
        }
        return total / (double)this.edges.size();
    }

    SkPolygon2D(SkEdge2D e0, SkEdge2D e1, SkEdge2D e2, int _type) {
        if (e0.is_internal()) {
            if (e1.is_internal()) {
                this.edges.append(e2);
                this.edges.append(e0);
                this.edges.append(e1);
            } else {
                this.edges.append(e1);
                this.edges.append(e2);
                this.edges.append(e0);
            }
        } else if (e1.is_internal() && e2.is_external()) {
            this.edges.append(e2);
            this.edges.append(e0);
            this.edges.append(e1);
        } else {
            this.edges.append(e0);
            this.edges.append(e1);
            this.edges.append(e2);
        }
        this.type = _type;
        this.set_variables();
    }

    SkPolygon2D(SkEdge2D e0, SkEdge2D e1, SkEdge2D e2, SkEdge2D e3, int _type) {
        this.edges.append(e0);
        this.edges.append(e1);
        this.edges.append(e2);
        this.edges.append(e3);
        this.type = _type;
        this.set_variables();
    }

    public SkVertex2D get_terminal_vertex() {
        if (this.get_edge((int)0).type == 2) {
            return this.get_vertex(2);
        }
        if (this.get_edge((int)1).type == 2) {
            return this.get_vertex(0);
        }
        return this.get_vertex(1);
    }

    public SkVertex2D get_opposite_vertex(SkEdge2D edge) {
        int i = 0;
        while (i < 3) {
            SkVertex2D v = this.get_vertex(i);
            if (!edge.contains(v)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public LinkedList get_internal_edges() {
        LinkedList internal_edges = new LinkedList();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type != 2) continue;
            internal_edges.append(edge);
        }
        return internal_edges;
    }

    public double get_height() {
        double l = Vertex2D.distance(this.get_vertex(0), this.center);
        double h = l * Skeleton.inflation_ratio;
        h = Math.min(h, Skeleton.max_height);
        return h;
    }

    public SkEdge2D get_internal_edge() {
        if (this.get_edge((int)0).type == 2) {
            return this.get_edge(0);
        }
        if (this.get_edge((int)1).type == 2) {
            return this.get_edge(1);
        }
        return this.get_edge(2);
    }

    public void mark() {
        this.marked = true;
    }

    public SkEdge2D get_edge(int n) {
        int n_edges = this.edges.size();
        if (n >= n_edges) {
            n -= n / n_edges * n_edges;
        }
        if (n < 0) {
            n += (-n / n_edges + 1) * n_edges;
        }
        Enumeration e = this.edges.elements();
        SkEdge2D edge = null;
        int i = 0;
        while (i <= n) {
            edge = (SkEdge2D)e.nextElement();
            ++i;
        }
        return edge;
    }

    public SkEdge2D the_other_internal_edge(SkEdge2D base_edge) {
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type != 2 || edge == base_edge) continue;
            return edge;
        }
        System.out.println("fail in SkPolygon2D.the_other_internal_edge");
        return null;
    }

    public SkEdge2D get_external_edge() {
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type != 0) continue;
            return edge;
        }
        System.out.println("fail in SkPolygon2D.get_external_edge");
        return null;
    }

    public SkEdge2D get_longest_edge() {
        Enumeration e = this.edges.elements();
        double max = -1.0;
        SkEdge2D longest = null;
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            double l = edge.length();
            if (!(l > max)) continue;
            max = l;
            longest = edge;
        }
        return longest;
    }

    public SkVertex2D get_internal_vertex() {
        LinkedList internal_edges = this.get_internal_edges();
        SkEdge2D edge0 = (SkEdge2D)internal_edges.head();
        SkEdge2D edge1 = (SkEdge2D)internal_edges.tail();
        return (SkVertex2D)edge0.get_common_vertex(edge1);
    }

    public int get_index(SkEdge2D edge) {
        Enumeration e = this.edges.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            if ((SkEdge2D)e.nextElement() == edge) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public SkVertex2D set_center() {
        double l2;
        double l1;
        SkEdge2D edge0 = (SkEdge2D)this.edges.elementAt(0);
        SkEdge2D edge1 = (SkEdge2D)this.edges.elementAt(1);
        SkEdge2D edge2 = (SkEdge2D)this.edges.elementAt(2);
        double l0 = edge0.length() * edge0.length();
        if (l0 > (l1 = edge1.length() * edge1.length()) + (l2 = edge2.length() * edge2.length())) {
            this.center_edge = edge0;
        } else if (l1 > l0 + l2) {
            this.center_edge = edge1;
        } else if (l2 > l0 + l1) {
            this.center_edge = edge2;
        } else {
            this.center_edge = null;
            Vertex2D _center = this.get_circumcenter();
            if (_center == null) {
                System.out.println("error in Skeleton.set_center");
                _center = this.get_gravity_center();
            }
            this.center = new SkVertex2D(_center);
            this.center.height = this.get_height();
            return this.center;
        }
        this.center = this.center_edge.get_mid_vertex();
        return this.center;
    }

    private Vertex2D get_circumcenter() {
        return Geometry2D.get_circumcenter(this.get_vertex(0), this.get_vertex(1), this.get_vertex(2));
    }

    public SkVertex2D get_vertex(int n) {
        SkEdge2D edge = this.get_edge(n);
        if (edge.left_polygon == this) {
            return (SkVertex2D)edge.start;
        }
        return (SkVertex2D)edge.end;
    }

    public LinkedList get_external_edges() {
        LinkedList external_edges = new LinkedList();
        Enumeration e = this.edges.elements();
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            if (edge.type != 0) continue;
            external_edges.append(edge);
        }
        return external_edges;
    }

    public SkEdge2D get_shortest_edge() {
        Enumeration e = this.edges.elements();
        double min = Double.MAX_VALUE;
        SkEdge2D shortest = null;
        while (e.hasMoreElements()) {
            SkEdge2D edge = (SkEdge2D)e.nextElement();
            double l = edge.length();
            if (!(l < min)) continue;
            min = l;
            shortest = edge;
        }
        return shortest;
    }

    public void setTrimData(SkEdge2D edge, TrimData td) {
        if (this.trimData == null) {
            this.trimData = new TrimData[this.edges.size()];
        }
        int i = this.get_index(edge);
        this.trimData[i] = td;
    }

    public TrimData getTrimData(int i) {
        if (this.trimData == null) {
            return null;
        }
        return this.trimData[i];
    }

    private void set_variables() {
        SkEdge2D next;
        Enumeration e = this.edges.elements();
        SkEdge2D prev = (SkEdge2D)e.nextElement();
        while (e.hasMoreElements()) {
            next = (SkEdge2D)e.nextElement();
            if (next.contains(prev.end)) {
                prev.set_left_polygon(this);
            } else {
                prev.set_right_polygon(this);
            }
            prev = next;
        }
        next = (SkEdge2D)this.edges.head();
        if (next.contains(prev.end)) {
            prev.set_left_polygon(this);
        } else {
            prev.set_right_polygon(this);
        }
        if (this.type == 2) {
            this.trimData = new TrimData[this.edges.size()];
        }
    }

    public TrimData getTrimData(SkEdge2D edge) {
        if (this.trimData == null) {
            return null;
        }
        return this.trimData[this.get_index(edge)];
    }
}

