/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import teddy.Edge;
import teddy.Edge2D;
import teddy.Seam;
import teddy.SkPolygon2D;
import teddy.SkVertex2D;
import teddy.Skeleton;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;

class SkEdge2D
extends Edge2D {
    public static final int EXTERNAL = 0;
    public static final int INTERNAL_SHARED = 2;
    public static final int COVER_EDGE = 3;
    public static final int CENTER_EDGE = 4;
    int type;
    Seam seam = null;
    boolean pruned = false;
    SkPolygon2D right_polygon = null;
    SkPolygon2D left_polygon = null;
    public double height = -1.0;
    Edge edge;
    Edge[] edges;
    SkVertex2D mid_vertex;
    Edge[] edgeAbove;
    Edge[] edgeBelow;
    Vertex[] vertexAbove;
    Vertex[] vertexBelow;
    double[] cos;
    double[] sin;

    public Edge getEdgeStartBelow() {
        return this.edges[2];
    }

    SkEdge2D(SkVertex2D _start, SkVertex2D _end, int _type) {
        this.start = _start;
        this.end = _end;
        _start.add_owner(this);
        _end.add_owner(this);
        this.type = _type;
    }

    public void init_cos_sin() {
        int steps = Skeleton.steps;
        this.cos = new double[steps + 1];
        this.sin = new double[steps + 1];
        int i = 0;
        while (i <= steps) {
            this.cos[i] = Math.cos(1.5707963267948966 * (double)i / (double)steps);
            this.sin[i] = Math.sin(1.5707963267948966 * (double)i / (double)steps);
            ++i;
        }
    }

    public Vertex2D get_common_vertex(SkEdge2D edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        if (this.end == edge.start || this.end == edge.end) {
            return this.end;
        }
        return null;
    }

    public static int count_external_edges(SkEdge2D edge0, SkEdge2D edge1, SkEdge2D edge2) {
        int count = 0;
        if (edge0.is_external()) {
            ++count;
        }
        if (edge1.is_external()) {
            ++count;
        }
        if (edge2.is_external()) {
            ++count;
        }
        return count;
    }

    public void set_left_polygon(SkPolygon2D polygon) {
        this.left_polygon = polygon;
    }

    public SkPolygon2D the_other_polygon(SkPolygon2D polygon) {
        if (this.left_polygon == polygon) {
            return this.right_polygon;
        }
        return this.left_polygon;
    }

    public Edge getEdge() {
        if (this.edge == null) {
            this.edge = new Edge(((SkVertex2D)this.start).getVertex(), ((SkVertex2D)this.end).getVertex());
        }
        return this.edge;
    }

    public Edge[] getEdges() {
        if (this.edges == null) {
            this.edges = new Edge[4];
            this.edges[0] = new Edge(((SkVertex2D)this.start).getVertex(), this.getVertexAbove());
            this.edges[1] = new Edge(((SkVertex2D)this.end).getVertex(), this.getVertexAbove());
            this.edges[2] = new Edge(((SkVertex2D)this.start).getVertex(), this.getVertexBelow());
            this.edges[3] = new Edge(((SkVertex2D)this.end).getVertex(), this.getVertexBelow());
            if (this.seam != null) {
                this.edges[2].seam = this.edges[3].seam = this.seam;
                this.edges[1].seam = this.edges[3].seam;
                this.edges[0].seam = this.edges[3].seam;
            }
        }
        return this.edges;
    }

    public void createEdgesVertices() {
        if (this.cos == null) {
            this.init_cos_sin();
        }
        int steps = Skeleton.steps;
        this.edgeAbove = new Edge[steps];
        this.edgeBelow = new Edge[steps];
        this.vertexAbove = new Vertex[steps + 1];
        this.vertexBelow = new Vertex[steps + 1];
        this.vertexAbove[0] = ((SkVertex2D)this.start).getVertex();
        this.vertexBelow[0] = ((SkVertex2D)this.start).getVertex();
        this.vertexAbove[steps] = ((SkVertex2D)this.end).getVertexAbove();
        this.vertexBelow[steps] = ((SkVertex2D)this.end).getVertexBelow();
        double x0 = this.end.x;
        double y0 = this.end.y;
        double rx = this.start.x - this.end.x;
        double ry = this.start.y - this.end.y;
        double height = ((SkVertex2D)this.end).height;
        int i = 1;
        while (i < steps) {
            double x = x0 + rx * this.cos[i];
            double y = y0 + ry * this.cos[i];
            double z = height * this.sin[i];
            this.vertexAbove[i] = new Vertex(x, y, -z);
            this.vertexBelow[i] = new Vertex(x, y, z);
            ++i;
        }
        i = 0;
        while (i < steps) {
            this.edgeAbove[i] = new Edge(this.vertexAbove[i], this.vertexAbove[i + 1]);
            this.edgeBelow[i] = new Edge(this.vertexBelow[i], this.vertexBelow[i + 1]);
            ++i;
        }
    }

    public boolean is_internal() {
        return this.type == 2;
    }

    public boolean out_of_circle(SkVertex2D v) {
        Vector2 vec0 = new Vector2(v, (Vector2)this.start);
        Vector2 vec1 = new Vector2(v, (Vector2)this.end);
        return vec0.get_cos(vec1) >= 0.0;
    }

    public Vertex getVertexAbove() {
        return this.get_mid_vertex().getVertexAbove();
    }

    public Edge getEdgeAbove() {
        Vertex v1;
        Vertex v0 = this.type == 3 ? ((SkVertex2D)this.start).getVertex() : ((SkVertex2D)this.start).getVertexAbove();
        Edge edge = v0.get_shared_edge(v1 = ((SkVertex2D)this.end).getVertexAbove());
        if (edge == null) {
            edge = new Edge(v0, v1);
        }
        return edge;
    }

    public Edge getEdgeAbove(int i) {
        if (this.edgeAbove == null) {
            this.createEdgesVertices();
        }
        return this.edgeAbove[i];
    }

    public Vertex getVertexBelow() {
        return this.get_mid_vertex().getVertexBelow();
    }

    public void set_right_polygon(SkPolygon2D polygon) {
        this.right_polygon = polygon;
    }

    public Edge getEdgeBelow() {
        Vertex v1;
        Vertex v0 = this.type == 3 ? ((SkVertex2D)this.start).getVertex() : ((SkVertex2D)this.start).getVertexBelow();
        Edge edge = v0.get_shared_edge(v1 = ((SkVertex2D)this.end).getVertexBelow());
        if (edge == null) {
            edge = new Edge(v0, v1);
        }
        return edge;
    }

    public Vertex getVertexAbove(int i) {
        if (this.vertexAbove == null) {
            this.createEdgesVertices();
        }
        return this.vertexAbove[i];
    }

    public Edge getEdgeBelow(int i) {
        if (this.edgeBelow == null) {
            this.createEdgesVertices();
        }
        return this.edgeBelow[i];
    }

    public Edge getEdgeEndBelow() {
        return this.edges[3];
    }

    public Vertex getVertexBelow(int i) {
        if (this.vertexBelow == null) {
            this.createEdgesVertices();
        }
        return this.vertexBelow[i];
    }

    public boolean is_external() {
        return this.type == 0;
    }

    public SkVertex2D get_mid_vertex() {
        if (this.mid_vertex == null) {
            this.mid_vertex = new SkVertex2D(this.mid_point());
            this.mid_vertex.height = this.height;
        }
        return this.mid_vertex;
    }

    public Edge getEdgeEndAbove() {
        return this.edges[1];
    }

    public Edge getEdgeStartAbove() {
        return this.edges[0];
    }
}

