/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import teddy.BoundEdges;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Polyhedron;
import teddy.ProjectedEdge;
import teddy.ProjectedVertex;
import teddy.Vertex;

class SilhouetteFind {
    public static ProjectedEdge[] silhouette_edges;
    public static int n_silhouette_edges;
    public static ProjectedEdge[] possible_edges;
    public static int n_possible_edges;
    public static int eye_z;
    public static Vertex camera;
    private static LinkedList visible_edges;
    private static ProjectedVertex[] possible_vertices;
    private static int n_possible_vertices;

    private static void propagate(ProjectedEdge edge, ProjectedVertex v, int v_QI) {
        ProjectedVertex v2 = edge.another_vertex(v);
        edge.QI = v_QI;
        int v2_QI = v_QI;
        int i = 0;
        while (i < n_silhouette_edges) {
            ProjectedEdge silhouette_edge = silhouette_edges[i];
            if (edge.cross_behind(silhouette_edge, camera)) {
                edge.QI = 2;
                v2_QI = silhouette_edge.in(v) ? (v2_QI -= 2) : (v2_QI += 2);
            }
            ++i;
        }
        if (v2_QI < 0) {
            return;
        }
        if (v2.QI == -1) {
            v2.QI = v2_QI;
            SilhouetteFind.propagate(v2, edge);
        }
    }

    private static void propagate(ProjectedVertex v2, ProjectedEdge edge) {
        int cusp = v2.cusp();
        if (cusp > 0) {
            if (cusp > 2) {
                return;
            }
            int delta_from_back_to_front = v2.back_silhouette_edge.covered(v2) ? -1 : 1;
            int base_QI = v2.QI;
            if (edge == v2.back_silhouette_edge) {
                v2.QI += delta_from_back_to_front;
            }
            Enumeration e = v2.edges.elements();
            while (e.hasMoreElements()) {
                ProjectedEdge next_edge = (ProjectedEdge)e.nextElement();
                if (next_edge == edge || next_edge.QI != -1) continue;
                if (next_edge == v2.back_silhouette_edge) {
                    int QI = v2.QI - delta_from_back_to_front;
                    if (QI < 0) {
                        System.out.println("back_silhouette's QI becomes -1 (SilhouetteFind.propagate())" + base_QI + ", delta" + delta_from_back_to_front);
                        continue;
                    }
                    SilhouetteFind.propagate(next_edge, v2, QI);
                    continue;
                }
                SilhouetteFind.propagate(next_edge, v2, v2.QI);
            }
        } else {
            Enumeration e = v2.edges.elements();
            while (e.hasMoreElements()) {
                ProjectedEdge next_edge = (ProjectedEdge)e.nextElement();
                if (next_edge == edge || next_edge.QI != -1) continue;
                if (next_edge.type == 1 && edge.type == 3) {
                    SilhouetteFind.propagate(next_edge, v2, v2.QI - 1);
                    continue;
                }
                if (next_edge.type == 3 && edge.type == 1) {
                    SilhouetteFind.propagate(next_edge, v2, v2.QI + 1);
                    continue;
                }
                SilhouetteFind.propagate(next_edge, v2, v2.QI);
            }
        }
    }

    SilhouetteFind() {
    }

    private static void propagate_from_silhouette(ProjectedEdge e, int QI, Polyhedron h) {
        ProjectedVertex v = e.start;
        if (v.original.y > 0.0) {
            QI += 2;
        }
        e.QI = QI;
        v.QI = QI;
        SilhouetteFind.propagate(e, v, v.QI);
        SilhouetteFind.propagate(v, e);
    }

    static {
        eye_z = 10;
    }

    private static ProjectedVertex find_same_vertex(ProjectedVertex vertex) {
        int i = 0;
        while (i < n_possible_vertices) {
            ProjectedVertex v = possible_vertices[i];
            if (v.same_position(vertex)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    private static void renew_network() {
        possible_vertices = new ProjectedVertex[n_possible_edges * 2];
        n_possible_vertices = 0;
        int i = 0;
        while (i < n_possible_edges) {
            ProjectedEdge projected_edge = possible_edges[i];
            ProjectedVertex v = SilhouetteFind.find_same_vertex(projected_edge.start);
            if (v != null) {
                projected_edge.start = v;
                v.edges.append(projected_edge);
            } else {
                SilhouetteFind.possible_vertices[SilhouetteFind.n_possible_vertices++] = projected_edge.start;
                projected_edge.start.edges.append(projected_edge);
            }
            v = SilhouetteFind.find_same_vertex(projected_edge.end);
            if (v != null) {
                projected_edge.end = v;
                v.edges.append(projected_edge);
            } else {
                SilhouetteFind.possible_vertices[SilhouetteFind.n_possible_vertices++] = projected_edge.end;
                projected_edge.end.edges.append(projected_edge);
            }
            ++i;
        }
    }

    private static void propagate_from_boundedges(BoundEdges boundedges) {
        boundedges.right.right_vertex().QI = 0;
        boundedges.top.top_vertex().QI = 0;
        boundedges.bottom.bottom_vertex().QI = 0;
        ProjectedEdge e = boundedges.left;
        ProjectedVertex v = e.left_vertex();
        v.QI = 0;
        SilhouetteFind.propagate(e, v, v.QI);
        SilhouetteFind.propagate(v, e);
        e = boundedges.right;
        v = e.right_vertex();
        v.QI = 0;
        SilhouetteFind.propagate(e, v, v.QI);
        SilhouetteFind.propagate(v, e);
        e = boundedges.top;
        v = e.top_vertex();
        v.QI = 0;
        SilhouetteFind.propagate(e, v, v.QI);
        SilhouetteFind.propagate(v, e);
        e = boundedges.bottom;
        v = e.bottom_vertex();
        v.QI = 0;
        SilhouetteFind.propagate(e, v, v.QI);
        SilhouetteFind.propagate(v, e);
    }

    public static LinkedList find_visible_edges(Polyhedron h, Vertex _camera) {
        ProjectedEdge projected_edge;
        if (!h.view_changed && visible_edges != null) {
            return visible_edges;
        }
        h.view_changed = false;
        camera = _camera;
        int i = 0;
        while (i < h.n_polygons) {
            h.polygons[i].check_facing(camera);
            ++i;
        }
        silhouette_edges = new ProjectedEdge[h.n_edges];
        n_silhouette_edges = 0;
        possible_edges = new ProjectedEdge[h.n_edges];
        n_possible_edges = 0;
        BoundEdges boundedges = new BoundEdges(new ProjectedEdge(h.edges[i]));
        i = 0;
        while (i < h.n_edges) {
            Edge edge = h.edges[i];
            int type = edge.visibility_type();
            if (type != 0) {
                projected_edge = new ProjectedEdge(edge);
                if (type == 2 || type == 1) {
                    SilhouetteFind.silhouette_edges[SilhouetteFind.n_silhouette_edges++] = projected_edge;
                }
                if (type == 2 || type == 3) {
                    SilhouetteFind.possible_edges[SilhouetteFind.n_possible_edges++] = projected_edge;
                    boundedges.check(projected_edge);
                }
            }
            ++i;
        }
        SilhouetteFind.renew_network();
        SilhouetteFind.propagate_from_boundedges(boundedges);
        i = 0;
        while (i < n_possible_edges) {
            projected_edge = possible_edges[i];
            if (projected_edge.QI == -1) {
                SilhouetteFind.propagate_from_silhouette(projected_edge, 0, h);
            }
            ++i;
        }
        visible_edges = new LinkedList();
        i = 0;
        while (i < n_possible_edges) {
            projected_edge = possible_edges[i];
            if (projected_edge.QI == 0 || projected_edge.QI == -1) {
                visible_edges.append(projected_edge);
            }
            ++i;
        }
        return visible_edges;
    }
}

