/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import teddy.Def;
import teddy.Vector2;
import teddy.Vertex2D;

public class Segment
implements Serializable {
    public double x1;
    public double y1;
    public double x2;
    public double y2;

    public boolean same(Segment s) {
        return this.start_node().same(s.start_node()) && this.end_node().same(s.end_node()) || this.start_node().same(s.end_node()) && this.end_node().same(s.start_node());
    }

    public static double get_distance(Vertex2D p, Vertex2D q) {
        return Math.sqrt((p.x - q.x) * (p.x - q.x) + (p.y - q.y) * (p.y - q.y));
    }

    public boolean online(Vertex2D node) {
        return this.distance_line(node) < 1.0E-5;
    }

    public boolean between(Vertex2D node) {
        if (Def.equal(this.y1, this.y2)) {
            return node.x >= Math.min(this.x1, this.x2) - 1.0E-5 && node.x <= Math.max(this.x1, this.x2) + 1.0E-5;
        }
        return node.y >= Math.min(this.y1, this.y2) - 1.0E-5 && node.y <= Math.max(this.y1, this.y2) + 1.0E-5;
    }

    public boolean parallel(Segment segment) {
        Vector2 vector2;
        Vector2 vector1 = this.vector();
        double sin = vector1.get_sin(vector2 = segment.vector());
        return Math.abs(sin) < 1.0E-5;
    }

    public double parallel_interval(Segment segment) {
        Vector2 normal_vector_x = this.vector().normalize();
        Segment segment1 = this.coord_system(normal_vector_x);
        Segment segment2 = segment.coord_system(normal_vector_x);
        if ((segment1.x1 - segment2.x2) * (segment1.x2 - segment2.x1) < 0.0 || (segment1.x1 - segment2.x2) * (segment1.x2 - segment2.x2) < 0.0 || (segment2.x1 - segment1.x1) * (segment2.x2 - segment1.x1) < 0.0) {
            double interval = segment2.y1 - segment1.y1;
            return Math.abs(interval);
        }
        return -1.0;
    }

    Segment(double _x1, double _y1, double _x2, double _y2) {
        this.x1 = _x1;
        this.y1 = _y1;
        this.x2 = _x2;
        this.y2 = _y2;
    }

    Segment(Vertex2D start, Vertex2D end) {
        this.x1 = start.x;
        this.y1 = start.y;
        this.x2 = end.x;
        this.y2 = end.y;
    }

    public Vector2 vector() {
        return new Vector2(this.x2 - this.x1, this.y2 - this.y1);
    }

    public Vertex2D start_node() {
        return new Vertex2D(this.x1, this.y1);
    }

    public Vertex2D cross_node(Segment s) {
        double a0 = this.y1 - this.y2;
        double b0 = this.x2 - this.x1;
        double c0 = this.y2 * this.x1 - this.x2 * this.y1;
        double a1 = s.y1 - s.y2;
        double b1 = s.x2 - s.x1;
        double c1 = s.y2 * s.x1 - s.x2 * s.y1;
        if (Math.abs(a0 * b1 - a1 * b0) < 1.0E-5) {
            System.out.println("Error in Segment.cross_node().");
            return null;
        }
        double x = (b0 * c1 - b1 * c0) / (a0 * b1 - a1 * b0);
        double y = (a0 * c1 - a1 * c0) / (a1 * b0 - a0 * b1);
        return new Vertex2D(x, y);
    }

    public double coords(int i) {
        switch (i) {
            case 0: {
                return this.x1;
            }
            case 1: {
                return this.y1;
            }
            case 2: {
                return this.x2;
            }
            case 3: {
                return this.y2;
            }
        }
        return 0.0;
    }

    public double distance_line(Vertex2D node) {
        double a = this.x2 - this.x1;
        double b = this.y2 - this.y1;
        double bunbo = Math.sqrt(a * a + b * b);
        double bunshi = a * (node.y - this.y1) - b * (node.x - this.x1);
        if (bunbo == 0.0) {
            System.out.println("Error in Segment.distance_line");
            return 0.0;
        }
        return Math.abs(bunshi / bunbo);
    }

    public boolean same_line(Segment segment) {
        return this.online(segment.start_node()) && this.online(segment.end_node());
    }

    public Segment coord_system(Vector2 normal) {
        double _x1 = this.x1 * normal.x + this.y1 * normal.y;
        double _y1 = -this.x1 * normal.y + this.y1 * normal.x;
        double _x2 = this.x2 * normal.x + this.y2 * normal.y;
        double _y2 = -this.x2 * normal.y + this.y2 * normal.x;
        return new Segment(_x1, _y1, _x2, _y2);
    }

    public double length() {
        return Vector2.distance(this.x1, this.y1, this.x2, this.y2);
    }

    public Vertex2D end_node() {
        return new Vertex2D(this.x2, this.y2);
    }

    public boolean cross(Segment s) {
        double a0 = this.y1 - this.y2;
        double b0 = this.x2 - this.x1;
        double c0 = this.y2 * this.x1 - this.x2 * this.y1;
        double a1 = s.y1 - s.y2;
        double b1 = s.x2 - s.x1;
        double c1 = s.y2 * s.x1 - s.x2 * s.y1;
        return (a0 * s.x1 + b0 * s.y1 + c0) * (a0 * s.x2 + b0 * s.y2 + c0) <= 1.0E-5 && (a1 * this.x1 + b1 * this.y1 + c1) * (a1 * this.x2 + b1 * this.y2 + c1) <= 1.0E-5;
    }

    public void configure(Vertex2D start, Vertex2D end) {
        this.x1 = start.x;
        this.y1 = start.y;
        this.x2 = end.x;
        this.y2 = end.y;
    }

    public double distance(Vertex2D node) {
        Vector2 vec1;
        Vertex2D end;
        Vertex2D start = this.start_node();
        Vector2 vec0 = new Vector2(start, (Vector2)(end = this.end_node()));
        if (vec0.inner_product(vec1 = new Vector2(start, (Vector2)node)) < 0.0) {
            return Segment.get_distance(node, start);
        }
        vec1 = new Vector2(end, (Vector2)node);
        if (vec0.inner_product(vec1) > 0.0) {
            return Segment.get_distance(node, end);
        }
        return this.distance_line(node);
    }
}

