/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.Edge;
import teddy.LinkedList;
import teddy.SurfacePath;
import teddy.Vector3;
import teddy.Vertex;

class Ring
extends LinkedList {
    Ring(SurfacePath path) {
        this();
        int i = 0;
        while (i < path.size()) {
            this.append(path.getVertex(i));
            ++i;
        }
        this.append(path.getVertex(0));
    }

    Ring(Vector edges) {
        this();
        int i = 0;
        while (i < edges.size()) {
            this.append(((Edge)edges.elementAt((int)i)).start);
            ++i;
        }
        this.append(((Edge)edges.elementAt((int)0)).start);
    }

    Ring() {
    }

    public static Ring linked_list_to_ring(LinkedList l) {
        Ring ring = new Ring();
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            ring.append(e.nextElement());
        }
        return ring;
    }

    public static Ring sweep(Ring base_ring, Vertex base_start, Vertex base_end, Vertex v0, Vertex v1, Vector3 normal) {
        Ring ring = new Ring();
        Vector3 base_axis0 = new Vector3(base_start, base_end);
        Vector3 base_axis1 = base_axis0.cross_product(normal);
        Vector3 base_axis2 = base_axis0.cross_product(base_axis1);
        Vector3 target_axis0 = new Vector3(v0, v1);
        Vector3 target_axis1 = base_axis1;
        Vector3 target_axis2 = target_axis0.cross_product(target_axis1);
        double scale = target_axis0.length() / base_axis0.length();
        base_axis0.normalize();
        base_axis1.normalize();
        base_axis2.normalize();
        target_axis0.normalize();
        target_axis1.normalize();
        target_axis2.normalize();
        Enumeration e = base_ring.elements();
        while (e.hasMoreElements()) {
            Vertex base_vertex = ((Vertex)e.nextElement()).copy();
            Vector3 base_vector = new Vector3(base_start, base_vertex);
            double projected0 = base_axis0.dot_product(base_vector);
            double projected1 = base_axis1.dot_product(base_vector);
            double projected2 = base_axis2.dot_product(base_vector);
            Vector3 target_vector = new Vector3(0.0, 0.0, 0.0);
            target_vector.add_self(target_axis0.multiple(projected0 * scale));
            target_vector.add_self(target_axis1.multiple(projected1 * scale));
            target_vector.add_self(target_axis2.multiple(projected2 * scale));
            Vertex target_vertex = v0.shift(target_vector);
            ring.append(target_vertex);
        }
        ring.replace_tail(ring.head());
        return ring;
    }
}

