/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Objects;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Skin;
import teddy.Vector3;
import teddy.Vertex;

class Remesh {
    public static Polyhedron h;

    public static boolean split_valence_test(Edge edge) {
        if (edge.left_polygon == null || edge.right_polygon == null) {
            System.out.println("! " + edge + " " + edge.seam);
            return false;
        }
        if (edge.right_polygon == null) {
            System.out.println("right edge");
        } else if (edge.right_polygon.patch == null) {
            System.out.println("right edge patch");
        }
        if (edge.left_polygon == null) {
            System.out.println("left edge");
        } else if (edge.left_polygon.patch == null) {
            System.out.println("left edge patch");
        }
        double target_length = edge.get_target_edge_length();
        if (edge.length() < target_length * 1.25) {
            return false;
        }
        if (edge.length() > target_length * 1.5) {
            return true;
        }
        if (edge.left_polygon == null || edge.right_polygon == null) {
            System.out.println("! " + edge);
            return false;
        }
        Vertex v0 = edge.left_polygon.get_opposite_vertex(edge);
        Vertex v1 = edge.right_polygon.get_opposite_vertex(edge);
        return v0.edges.size() < 6 && v1.edges.size() < 6;
    }

    public static int refine_mesh_connectivity(Polyhedron _h) {
        h = _h;
        Vector<Edge> edges = new Vector<Edge>();
        int i = 0;
        while (i < Remesh.h.n_edges) {
            if (Remesh.h.edges[i] != null) {
                edges.addElement(Remesh.h.edges[i]);
            }
            ++i;
        }
        return Remesh.refine_mesh_connectivity(edges, false);
    }

    public static int refine_mesh_connectivity(Polyhedron _h, Vector edges) {
        h = _h;
        return Remesh.refine_mesh_connectivity(edges, false);
    }

    public static int refine_mesh_connectivity(Vector edges, boolean split_only) {
        Enumeration e = edges.elements();
        int count = 0;
        Vector _edges = new Vector();
        int max_count = edges.size();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.disposed) {
                if (!split_only && Remesh.swap_valence_test(edge)) {
                    Remesh.swap_edge(edge, edges);
                    ++count;
                } else if (Remesh.split_valence_test(edge)) {
                    Remesh.split_edge(edge, edges);
                    ++count;
                } else if (!split_only && Remesh.collapse_valence_test(edge)) {
                    Remesh.collapse_edge(edge, edges);
                    ++count;
                }
            }
            if (count >= max_count) break;
        }
        return count;
    }

    private static void split_edge(Edge edge, Vector dirty_edges) {
        Vertex mid_vertex = edge.mid_vertex();
        Edge edge0 = new Edge(edge.start, mid_vertex);
        Edge edge1 = new Edge(mid_vertex, edge.end);
        edge0.seam = edge1.seam = edge.seam;
        edge0.sharp = edge1.sharp = edge.sharp;
        edge0.target_edge_length = edge1.target_edge_length = edge.target_edge_length;
        if (!edge.start.on_sharp() && edge.end.on_sharp()) {
            Skin.update_bodyPolygon_and_bodyVertex(mid_vertex, edge.start, edge.seam);
        } else {
            Skin.update_bodyPolygon_and_bodyVertex(mid_vertex, edge.end, edge.seam);
        }
        h.append(mid_vertex);
        h.append(edge0);
        h.append(edge1);
        dirty_edges.addElement(edge0);
        dirty_edges.addElement(edge1);
        Remesh.split_edge_sub(edge.left_polygon(), edge, edge0, edge1, mid_vertex, dirty_edges);
        Remesh.split_edge_sub(edge.right_polygon(), edge, edge1, edge0, mid_vertex, dirty_edges);
    }

    private static boolean no_big_distortion(Vertex vertex, Vertex middle, Edge base_edge) {
        Enumeration e = vertex.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge == base_edge) continue;
            Vertex base = edge.get_the_other_vertex(vertex);
            Vector3 vec0 = new Vector3(base, vertex);
            Vector3 vec1 = new Vector3(base, middle);
            double sin = Math.abs(vec0.sin(vec1));
            double cos = vec0.cos(vec1);
            if (!(sin > 0.3) && !(cos < 0.0)) continue;
            return false;
        }
        if (Remesh.flip_over_test(vertex, middle, base_edge)) {
            return false;
        }
        return Remesh.polygons_are_parallel_to_edge(base_edge, vertex.polygons());
    }

    private static Polygon2 replaced_polygon(Polygon2 polygon, LinkedList edge_replace_list) {
        LinkedList edges = new LinkedList();
        int i = 0;
        while (i < polygon.n_edges) {
            Edge edge = polygon.edges[i];
            edges.append(Remesh.get_corresponding_edge(edge, edge_replace_list));
            ++i;
        }
        Edge edge0 = (Edge)edges.elementAt(0);
        Edge edge1 = (Edge)edges.elementAt(1);
        Edge edge2 = (Edge)edges.elementAt(2);
        if (edge0.get_common_vertex(edge1) == null || edge2.get_common_vertex(edge1) == null || edge0.get_common_vertex(edge2) == null) {
            System.out.println("error in Remesh.repalced_polygon()");
            System.out.println("" + edge0.start.index + " " + edge0.end.index + " : " + edge1.start.index + " " + edge1.end.index + " : " + edge2.start.index + " " + edge2.end.index);
            System.out.println("" + polygon.edges[0].start.index + " " + polygon.edges[0].end.index + " : " + polygon.edges[1].start.index + " " + polygon.edges[1].end.index + " : " + polygon.edges[2].start.index + " " + polygon.edges[2].end.index);
        }
        return new Polygon2(edges, polygon);
    }

    Remesh() {
    }

    private static boolean flip_over_test(Vertex original, Vertex target, Edge base_edge) {
        Enumeration e = original.polygons().elements();
        while (e.hasMoreElements()) {
            Vector3 target_normal;
            Vector3 vec1;
            Polygon2 polygon = (Polygon2)e.nextElement();
            if (polygon == base_edge.left_polygon() || polygon == base_edge.right_polygon()) continue;
            Objects objects = polygon.get_the_other_edge(original);
            Vector3 vec0 = new Vector3(target, (Vertex)objects.get(0));
            if (vec0.parallel(vec1 = new Vector3(target, (Vertex)objects.get(1)))) {
                System.out.println("Tessellation.flip");
                return true;
            }
            Vector3 original_normal = new Vector3(original, (Vertex)objects.get(0)).cross_product(new Vector3(original, (Vertex)objects.get(1)));
            if (!(original_normal.cos(target_normal = vec0.cross_product(vec1)) < -0.8)) continue;
            return true;
        }
        return false;
    }

    public static boolean collapse_valence_test(Edge edge) {
        Vertex p;
        if (edge.left_polygon == null || edge.right_polygon == null) {
            System.out.println("! " + edge + " " + edge.seam);
            return false;
        }
        if ((edge.start.on_seam_cross() || edge.start.fixed) && (edge.end.on_seam_cross() || edge.end.fixed)) {
            return false;
        }
        if (!edge.on_seam() && edge.start.on_seam() && edge.end.on_seam()) {
            return false;
        }
        double target_length = edge.get_target_edge_length();
        if (edge.length() > target_length * 0.75) {
            return false;
        }
        Vertex v0 = edge.left_polygon.get_opposite_vertex(edge);
        Vertex v1 = edge.right_polygon.get_opposite_vertex(edge);
        Vector<Vertex> around_start = new Vector<Vertex>();
        Enumeration e = edge.start.get_surrounding_vertices().elements();
        while (e.hasMoreElements()) {
            Vertex p2 = (Vertex)e.nextElement();
            if (p2 == v0 || p2 == v1 || p2 == edge.end) continue;
            around_start.addElement(p2);
        }
        Vector<Vertex> around_end = new Vector<Vertex>();
        Enumeration e2 = edge.end.get_surrounding_vertices().elements();
        while (e2.hasMoreElements()) {
            p = (Vertex)e2.nextElement();
            if (p == v0 || p == v1 || p == edge.start) continue;
            around_end.addElement(p);
        }
        int i = 0;
        while (i < around_start.size()) {
            p = (Vertex)around_start.elementAt(i);
            int j = 0;
            while (j < around_end.size()) {
                Vertex q = (Vertex)around_end.elementAt(j);
                if (p == q || p.get_shared_edge(q) != null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        if (!edge.on_seam() && edge.start.on_seam() && Remesh.collapse_causes_flip(edge.start, edge.end)) {
            return false;
        }
        if (!edge.on_seam() && edge.end.on_seam() && Remesh.collapse_causes_flip(edge.end, edge.start)) {
            return false;
        }
        if (edge.length() < target_length * 0.5) {
            return true;
        }
        int before = Math.abs(v0.edges.size() - 6) + Math.abs(v1.edges.size() - 6) + Math.abs(edge.start.edges.size() - 6) + Math.abs(edge.end.edges.size() - 6);
        int after = Math.abs(v0.edges.size() - 7) + Math.abs(v1.edges.size() - 7) + Math.abs(edge.start.edges.size() + edge.end.edges.size() - 4 - 6);
        return after < before;
    }

    private static boolean swap_valence_test(Edge edge) {
        Vector3 target_normal1;
        Vertex v1;
        if (edge.left_polygon == null || edge.right_polygon == null) {
            System.out.println("! " + edge + " " + edge.seam);
            return false;
        }
        if (edge.left_polygon.patch != edge.right_polygon.patch) {
            return false;
        }
        if (edge.start.fixed && edge.end.fixed) {
            return false;
        }
        if (edge.on_seam()) {
            return false;
        }
        Vertex v0 = edge.left_polygon.get_opposite_vertex(edge);
        if (v0.get_shared_edge(v1 = edge.right_polygon.get_opposite_vertex(edge)) != null) {
            return false;
        }
        if (Remesh.get_angle(v0, edge.start, edge.end) >= 1.5707963267948966 || Remesh.get_angle(v0, edge.end, edge.start) >= 1.5707963267948966 || Remesh.get_angle(v1, edge.start, edge.end) >= 1.5707963267948966 || Remesh.get_angle(v1, edge.end, edge.start) >= 1.5707963267948966) {
            return false;
        }
        Vector3 target_normal0 = Remesh.get_normal(edge.start, v0, v1);
        if (target_normal0.cos(target_normal1 = Remesh.get_normal(edge.end, v1, v0)) < 0.7) {
            return false;
        }
        double current_min_angle = Remesh.min(Remesh.get_angle(v0, edge.start, edge.end), Remesh.get_angle(v0, edge.end, edge.start), Remesh.get_angle(v1, edge.start, edge.end), Remesh.get_angle(v1, edge.end, edge.start));
        double target_min_angle = Remesh.min(Remesh.get_angle(v0, v1, edge.end), Remesh.get_angle(v0, v1, edge.start), Remesh.get_angle(v1, v0, edge.end), Remesh.get_angle(v1, v0, edge.start));
        if (target_min_angle > current_min_angle * 1.25) {
            return true;
        }
        if (target_min_angle < current_min_angle * 0.8) {
            return false;
        }
        int before = Math.abs(v0.edges.size() - 6) + Math.abs(v1.edges.size() - 6) + Math.abs(edge.start.edges.size() - 6) + Math.abs(edge.end.edges.size() - 6);
        int after = Math.abs(v0.edges.size() - 5) + Math.abs(v1.edges.size() - 5) + Math.abs(edge.start.edges.size() - 7) + Math.abs(edge.end.edges.size() - 7);
        return after < before;
    }

    private static void split_edge_sub(Polygon2 old_polygon, Edge edge, Edge edge0, Edge edge1, Vertex mid_vertex, Vector dirty_edges) {
        int n = old_polygon.get_edge_index(edge);
        Edge mid_edge = new Edge(old_polygon.get_vertex(n + 2), mid_vertex);
        mid_edge.target_edge_length = edge.target_edge_length;
        Polygon2 new_polygon0 = new Polygon2(old_polygon.edges(n + 1), mid_edge, edge1, old_polygon);
        Polygon2 new_polygon1 = new Polygon2(old_polygon.edges(n + 2), edge0, mid_edge, old_polygon);
        h.append(mid_edge);
        h.append(new_polygon0);
        h.append(new_polygon1);
        h.remove(old_polygon);
        dirty_edges.addElement(mid_edge);
    }

    private static void collapse_edge(Edge short_edge, Vector dirty_edges) {
        boolean on_seam_start = short_edge.start.on_seam();
        boolean on_seam_end = short_edge.end.on_seam();
        if (short_edge.start.fixed && short_edge.end.fixed || short_edge.start.fixed && on_seam_end || on_seam_start && short_edge.end.fixed) {
            return;
        }
        if (short_edge.start.on_seam_cross() || short_edge.start.fixed) {
            Remesh.remove_a_short_edge(short_edge, short_edge.end, short_edge.start, dirty_edges);
        } else if (short_edge.end.on_seam_cross() || short_edge.end.fixed) {
            Remesh.remove_a_short_edge(short_edge, short_edge.start, short_edge.end, dirty_edges);
        } else if (on_seam_start && on_seam_end) {
            Remesh.collapse_edge_center(short_edge, dirty_edges);
        } else if (on_seam_start) {
            Remesh.remove_a_short_edge(short_edge, short_edge.end, short_edge.start, dirty_edges);
        } else if (on_seam_end) {
            Remesh.remove_a_short_edge(short_edge, short_edge.start, short_edge.end, dirty_edges);
        } else {
            Remesh.collapse_edge_center(short_edge, dirty_edges);
        }
    }

    private static void swap_edge(Edge edge, Vector dirty_edges) {
        Vertex v0 = edge.left_polygon.get_opposite_vertex(edge);
        Vertex v1 = edge.right_polygon.get_opposite_vertex(edge);
        Edge start_v0 = edge.left_polygon.get_opposite_edge(edge.end);
        Edge end_v0 = edge.left_polygon.get_opposite_edge(edge.start);
        Edge start_v1 = edge.right_polygon.get_opposite_edge(edge.end);
        Edge end_v1 = edge.right_polygon.get_opposite_edge(edge.start);
        Polygon2 left_polygon = edge.left_polygon();
        Polygon2 right_polygon = edge.right_polygon();
        Edge new_edge = new Edge(v0, v1);
        Polygon2 new_polygon0 = new Polygon2(start_v1, new_edge, start_v0, left_polygon);
        Polygon2 new_polygon1 = new Polygon2(end_v0, new_edge, end_v1, left_polygon);
        new_edge.target_edge_length = edge.target_edge_length;
        h.append(new_edge);
        h.append(new_polygon0);
        h.append(new_polygon1);
        h.remove(left_polygon);
        h.remove(right_polygon);
        dirty_edges.addElement(new_edge);
    }

    private static boolean polygons_are_parallel_to_edge(Edge base_edge, LinkedList polygons) {
        Enumeration e = polygons.elements();
        Vector3 vec = base_edge.vector3();
        while (e.hasMoreElements()) {
            Vector3 norm = ((Polygon2)e.nextElement()).get_normal_simple();
            double cos = Math.abs(norm.cos(vec));
            if (!(cos > 0.7)) continue;
            return false;
        }
        return true;
    }

    public static void remove_a_short_edge(Edge short_edge, Vertex deleted_vertex, Vertex base_vertex, Vector dirty_edges) {
        Polygon2 left_polygon = short_edge.left_polygon();
        Polygon2 right_polygon = short_edge.right_polygon();
        LinkedList deleted_polygons = deleted_vertex.polygons().copy();
        Vertex new_vertex = base_vertex;
        LinkedList edge_replace_list = new LinkedList();
        Remesh.init_replacement(edge_replace_list, base_vertex);
        Enumeration e = deleted_vertex.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge == short_edge) continue;
            Vertex the_other_vertex = edge.get_the_other_vertex(deleted_vertex);
            Remesh.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
        }
        h.remove(left_polygon);
        h.remove(right_polygon);
        e = deleted_polygons.elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            if (polygon == left_polygon || polygon == right_polygon) continue;
            h.remove(polygon);
            h.append(Remesh.replaced_polygon(polygon, edge_replace_list));
        }
        if (left_polygon.n_edges > 3) {
            h.append(Remesh.replaced_polygon_special(left_polygon, edge_replace_list, short_edge));
        }
        if (right_polygon.n_edges > 3) {
            h.append(Remesh.replaced_polygon_special(right_polygon, edge_replace_list, short_edge));
        }
    }

    public static int refine_mesh_connectivity_split_only(Polyhedron _h, Vector edges) {
        h = _h;
        return Remesh.refine_mesh_connectivity(edges, true);
    }

    private static double get_angle(Vertex v0, Vertex v1, Vertex v2) {
        Vector3 vec0 = new Vector3(v1, v0);
        Vector3 vec1 = new Vector3(v1, v2);
        return vec0.get_relative_angle(vec1);
    }

    public static int swap_all(Polyhedron _h) {
        h = _h;
        Vector<Edge> edges = new Vector<Edge>();
        int i = 0;
        while (i < Remesh.h.n_edges) {
            if (Remesh.h.edges[i] != null) {
                edges.addElement(Remesh.h.edges[i]);
            }
            ++i;
        }
        Enumeration e = edges.elements();
        int count = 0;
        Vector _edges = new Vector();
        int max_count = edges.size() * 4;
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.disposed && Remesh.swap_valence_test(edge)) {
                Remesh.swap_edge(edge, edges);
                ++count;
            }
            if (count >= max_count) break;
        }
        return count;
    }

    public static Vector remove_thin_polygons(Polyhedron _h) {
        Vector<Objects> vertex_replacement = new Vector<Objects>();
        h = _h;
        Edge edge = null;
        int i = 0;
        while (i < Remesh.h.n_edges) {
            Remesh.h.edges[i].checked = false;
            ++i;
        }
        Vector dirty_edges = new Vector();
        int i2 = 0;
        while (i2 < Remesh.h.n_edges) {
            if (!Remesh.h.edges[i2].checked) {
                edge = Remesh.h.edges[i2];
                Vertex middle = edge.mid_vertex();
                edge.checked = true;
                if (Remesh.no_big_distortion(edge.start, edge.end, edge)) {
                    Remesh.remove_a_short_edge(edge, edge.start, edge.end, dirty_edges);
                    vertex_replacement.addElement(new Objects(edge.start, edge.end));
                    i2 = 0;
                } else if (Remesh.no_big_distortion(edge.end, edge.start, edge)) {
                    Remesh.remove_a_short_edge(edge, edge.end, edge.start, dirty_edges);
                    vertex_replacement.addElement(new Objects(edge.end, edge.start));
                    i2 = 0;
                }
            }
            ++i2;
        }
        return vertex_replacement;
    }

    private static Edge get_corresponding_edge(Edge edge, LinkedList edge_replace_list) {
        Enumeration e = edge_replace_list.elements();
        while (e.hasMoreElements()) {
            Objects objects = (Objects)e.nextElement();
            Edge registered_edge = (Edge)objects.get(0);
            if (edge != registered_edge) continue;
            return (Edge)objects.get(1);
        }
        return edge;
    }

    private static void collapse_edge_center(Edge short_edge, Vector dirty_edges) {
        Polygon2 polygon;
        Vertex the_other_vertex;
        Edge edge;
        Polygon2 left_polygon = short_edge.left_polygon();
        Polygon2 right_polygon = short_edge.right_polygon();
        LinkedList start_polygons = short_edge.start.polygons().copy();
        LinkedList end_polygons = short_edge.end.polygons().copy();
        Vertex new_vertex = short_edge.mid_vertex();
        Skin.update_bodyPolygon_and_bodyVertex(new_vertex, short_edge.start, short_edge.seam);
        new_vertex.fixed = short_edge.start.fixed;
        h.append(new_vertex);
        LinkedList edge_replace_list = new LinkedList();
        Enumeration e = short_edge.start.edges.elements();
        while (e.hasMoreElements()) {
            edge = (Edge)e.nextElement();
            if (edge == short_edge) continue;
            the_other_vertex = edge.get_the_other_vertex(short_edge.start);
            Remesh.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
        }
        e = short_edge.end.edges.elements();
        while (e.hasMoreElements()) {
            edge = (Edge)e.nextElement();
            if (edge == short_edge) continue;
            the_other_vertex = edge.get_the_other_vertex(short_edge.end);
            Remesh.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
        }
        h.remove(left_polygon);
        h.remove(right_polygon);
        e = start_polygons.elements();
        while (e.hasMoreElements()) {
            polygon = (Polygon2)e.nextElement();
            if (polygon == left_polygon || polygon == right_polygon) continue;
            h.remove(polygon);
            h.append(Remesh.replaced_polygon(polygon, edge_replace_list));
        }
        e = end_polygons.elements();
        while (e.hasMoreElements()) {
            polygon = (Polygon2)e.nextElement();
            if (polygon == left_polygon || polygon == right_polygon) continue;
            h.remove(polygon);
            h.append(Remesh.replaced_polygon(polygon, edge_replace_list));
        }
    }

    private static boolean collapse_causes_flip(Vertex base, Vertex v) {
        LinkedList edges = v.get_surrounding_edges();
        Enumeration e = edges.elements();
        while (e.hasMoreElements()) {
            Vector3 target_normal;
            Vector3 current_normal;
            Edge edge = (Edge)e.nextElement();
            if (edge.contain(base) || !((current_normal = new Vector3(v, edge.start).cross_product(new Vector3(v, edge.end))).cos(target_normal = new Vector3(base, edge.start).cross_product(new Vector3(base, edge.end))) <= 0.0)) continue;
            return true;
        }
        return false;
    }

    private static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    private static void init_replacement(LinkedList edge_replace_list, Vertex base_vertex) {
        Enumeration e = base_vertex.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Objects new_objects = new Objects(edge, edge);
            edge_replace_list.append(new_objects);
        }
    }

    private static void register_replacement(LinkedList edge_replace_list, Edge edge, Vertex new_vertex, Vertex old_vertex, Vector dirty_edges) {
        Enumeration e = edge_replace_list.elements();
        while (e.hasMoreElements()) {
            Objects objects = (Objects)e.nextElement();
            Edge new_edge = (Edge)objects.get(1);
            if (!new_edge.same_edge(new_vertex, old_vertex)) continue;
            Objects new_objects = new Objects(edge, new_edge);
            edge_replace_list.append(new_objects);
            if (edge.sharp) {
                new_edge.sharp = true;
            }
            if (edge.on_seam()) {
                new_edge.seam = edge.seam;
            }
            if (edge.on_seam() && (new_edge.start == edge.end || new_edge.end == edge.start)) {
                Vertex v = new_edge.start;
                new_edge.start = new_edge.end;
                new_edge.end = v;
                Polygon2 polygon = new_edge.left_polygon;
                new_edge.left_polygon = new_edge.right_polygon;
                new_edge.right_polygon = polygon;
            }
            return;
        }
        Vertex start = new_vertex;
        Vertex end = old_vertex;
        if (edge.start == old_vertex) {
            start = old_vertex;
            end = new_vertex;
        }
        Edge new_edge = new Edge(start, end);
        h.append(new_edge);
        new_edge.sharp = edge.sharp;
        new_edge.seam = edge.seam;
        new_edge.target_edge_length = edge.target_edge_length;
        edge_replace_list.append(new Objects(edge, new_edge));
        dirty_edges.addElement(new_edge);
    }

    private static Vector3 get_normal(Vertex v0, Vertex v1, Vertex v2) {
        Vector3 vec0 = new Vector3(v1, v0);
        Vector3 vec1 = new Vector3(v1, v2);
        return vec0.cross_product(vec1);
    }

    private static Polygon2 replaced_polygon_special(Polygon2 polygon, LinkedList edge_replace_list, Edge short_edge) {
        LinkedList edges = new LinkedList();
        int i = 0;
        while (i < polygon.n_edges) {
            Edge edge = polygon.edges[i];
            if (edge != short_edge) {
                edges.append(Remesh.get_corresponding_edge(edge, edge_replace_list));
            }
            ++i;
        }
        return new Polygon2(edges);
    }
}

