/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import teddy.QueueElement;

public class Queue
implements Serializable {
    private QueueElement head = null;
    private QueueElement tail = null;
    private int len = 0;

    public void enqueue(Object object, double key) {
        if (this.head == null || key <= this.head.key) {
            this.head = new QueueElement(object, key, this.head);
            ++this.len;
            if (this.head.next == null) {
                this.tail = this.head;
            }
            return;
        }
        QueueElement element = this.head;
        while (element.next != null && key > element.next.key) {
            element = element.next;
        }
        QueueElement newElement = new QueueElement(object, key, element.next);
        if (element.next == null) {
            this.tail = newElement;
        }
        element.next = newElement;
        ++this.len;
    }

    Queue() {
    }

    public boolean contains(Object object) {
        QueueElement element = this.head;
        while (element != null) {
            if (element.data == object) {
                return true;
            }
            element = element.next;
        }
        return false;
    }

    public int size() {
        return this.len;
    }

    public Object dequeue() {
        if (this.head == null) {
            return null;
        }
        Object result = this.head.data;
        this.head = this.head.next;
        this.len += -1;
        if (this.len == 0) {
            this.tail = null;
        }
        return result;
    }

    public void print() {
        QueueElement element = this.head;
        while (element != null) {
            System.out.print(" " + element.data);
            element = element.next;
        }
        System.out.println("");
    }

    public void append(Object object) {
        QueueElement p = new QueueElement(object, 0.0, null);
        if (this.head == null) {
            this.head = this.tail = p;
        } else {
            this.tail.next = p;
            this.tail = p;
        }
        ++this.len;
    }
}

