/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import teddy.Edge;
import teddy.Edge2D;
import teddy.Polygon2;
import teddy.ProjectedVertex;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

class ProjectedEdge
extends Edge2D {
    public ProjectedVertex start;
    public ProjectedVertex end;
    Edge original;
    int QI;
    int type;

    public double bottom() {
        return Math.max(this.start.y, this.end.y);
    }

    public Vertex2D cross_point(ProjectedEdge e) {
        return Edge2D.cross_point(this.start.x, this.start.y, this.end.x, this.end.y, e.start.x, e.start.y, e.end.x, e.end.y);
    }

    public boolean connected(ProjectedEdge e) {
        return this.start == e.start || this.start == e.end || this.end == e.start || this.end == e.end;
    }

    ProjectedEdge(Edge edge) {
        this.start = new ProjectedVertex(edge.start());
        this.end = new ProjectedVertex(edge.end());
        this.QI = -1;
        this.original = edge;
        this.type = edge.type;
    }

    ProjectedEdge(Vertex2D _start, Vertex2D _end) {
        this.start = new ProjectedVertex(_start);
        this.end = new ProjectedVertex(_end);
        this.original = null;
    }

    public boolean cross_behind(ProjectedEdge e, Vertex camera) {
        double dab;
        if (this.connected(e)) {
            return false;
        }
        if (!this.cross(e)) {
            return false;
        }
        Vertex2D cross2D = this.cross_point(e);
        if (cross2D == null) {
            return false;
        }
        Vertex cross = new Vertex(cross2D.x, 0.0, cross2D.y);
        Vector3 qvi = new Vector3(camera, this.original.start());
        Vector3 vij = this.original.vector3();
        Vector3 qi = new Vector3(camera, cross);
        double dij = qvi.cross_product(vij).length() / qi.cross_product(vij).length();
        return dij > (dab = (qvi = new Vector3(camera, e.original.start())).cross_product(vij = e.original.vector3()).length() / qi.cross_product(vij).length());
    }

    public boolean in(Vertex2D v) {
        Polygon2 left_polygon = this.original.left_polygon();
        boolean right = this.right_side_of_edge(this.start.x, this.start.y, this.end.x, this.end.y, v.x, v.y);
        if (left_polygon.front_facing) {
            return !right;
        }
        return right;
    }

    public boolean in(Polygon2 polygon, Vertex2D v) {
        Polygon2 left_polygon = this.original.left_polygon();
        boolean right = this.right_side_of_edge(this.start.x, this.start.y, this.end.x, this.end.y, v.x, v.y);
        if (!polygon.front_facing) {
            boolean bl = right = !right;
        }
        if (polygon == left_polygon) {
            return !right;
        }
        return right;
    }

    public double top() {
        return Math.min(this.start.y, this.end.y);
    }

    public ProjectedVertex bottom_vertex() {
        if (this.start.y > this.end.y) {
            return this.start;
        }
        return this.end;
    }

    private boolean covered_sub(Vertex v, Polygon2 polygon) {
        if (!polygon.front_facing) {
            return false;
        }
        if (this.original.connected(polygon)) {
            return false;
        }
        Vector3 back_vector = this.original.vector3();
        if (this.original.end == v) {
            back_vector = back_vector.reverse();
        }
        if (polygon.absolute_normal().dot_product(back_vector) >= 0.0) {
            return false;
        }
        int index = polygon.get_vertex_index(v);
        Vertex in_vertex = polygon.get_vertex(index - 1);
        Vertex out_vertex = polygon.get_vertex(index + 1);
        Vertex back_vertex = this.original.get_the_other_vertex(v);
        ProjectedVertex in = new ProjectedVertex(in_vertex);
        ProjectedVertex out = new ProjectedVertex(out_vertex);
        ProjectedVertex c = new ProjectedVertex(v);
        ProjectedVertex back = new ProjectedVertex(back_vertex);
        Vector2 in_vec = new Vector2(c, (Vector2)in);
        Vector2 out_vec = new Vector2(c, (Vector2)out);
        Vector2 back_vec = new Vector2(c, (Vector2)back);
        double angle1 = 360.0 - in_vec.get_angle(out_vec);
        double angle2 = 360.0 - in_vec.get_angle(back_vec);
        return angle2 < angle1;
    }

    public double left() {
        return Math.min(this.start.x, this.end.x);
    }

    public ProjectedVertex left_vertex() {
        if (this.start.x < this.end.x) {
            return this.start;
        }
        return this.end;
    }

    public double right() {
        return Math.max(this.start.x, this.end.x);
    }

    public boolean covered(ProjectedVertex pv) {
        Vertex v = pv.original;
        Enumeration e = v.polygons().elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            if (!this.covered_sub(v, polygon)) continue;
            return true;
        }
        return false;
    }

    public ProjectedVertex another_vertex(ProjectedVertex v) {
        if (v == this.start) {
            return this.end;
        }
        return this.start;
    }

    public boolean cross(ProjectedEdge e) {
        return Edge2D.cross(this.start.x, this.start.y, this.end.x, this.end.y, e.start.x, e.start.y, e.end.x, e.end.y);
    }

    public ProjectedVertex right_vertex() {
        if (this.start.x > this.end.x) {
            return this.start;
        }
        return this.end;
    }

    public ProjectedVertex top_vertex() {
        if (this.start.y < this.end.y) {
            return this.start;
        }
        return this.end;
    }
}

