/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Delaunay;
import teddy.Edge;
import teddy.ImplicitFunction;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Seam;
import teddy.Skin;
import teddy.Sort;
import teddy.SubdivMesh;
import teddy.SurfacePath;
import teddy.TaubinFairing;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Pop {
    static Polyhedron h;
    private static int type;
    private static final int POP = 0;
    private static final int SMOOTH = 1;
    private static Patch adjusted_patch;
    private static Vector vertices;
    private static Vertex center;
    private static Vector3 normal;
    private static double radius;
    private static double unit_length;

    public static void pop(Polyhedron _h, SurfacePath surfacePath) {
        h = _h;
        type = 0;
        Pop.pop_main(surfacePath);
    }

    static Vector find_loop(Edge base_edge, Vertex vertex, Vector3 normal, Vector visited, Vector dead_edges, Vector possibleEdges, Vector outside_edges) {
        Vector<Edge> loop = new Vector<Edge>();
        Edge edge = base_edge;
        while (true) {
            loop.addElement(edge);
            visited.addElement(edge);
            possibleEdges.removeElement(edge);
            edge = Pop.find_next_edge(edge, vertex, normal, dead_edges, possibleEdges, outside_edges);
            if (edge == base_edge || edge == null) {
                return loop;
            }
            vertex = edge.get_the_other_vertex(vertex);
        }
    }

    public static Vector find_boundary_edges(Seam seam) {
        Edge edge;
        Edge start_edge = null;
        int i = Pop.h.n_edges - 1;
        while (i >= 0) {
            edge = Pop.h.edges[i];
            if (edge.seam == seam) {
                start_edge = edge;
                break;
            }
            --i;
        }
        if (start_edge == null) {
            return null;
        }
        Vertex v = start_edge.start;
        edge = start_edge;
        Vector<Edge> result = new Vector<Edge>();
        do {
            result.addElement(edge);
        } while ((edge = Pop.get_next_boundary_edge(v = edge.get_the_other_vertex(v), edge, seam)) != null && edge != start_edge);
        if (edge == start_edge) {
            return result;
        }
        v = start_edge.end;
        edge = start_edge;
        while ((edge = Pop.get_next_boundary_edge(v = edge.get_the_other_vertex(v), edge, seam)) != null) {
            result.insertElementAt(edge, 0);
        }
        return result;
    }

    private static void prepare_for_iFunction(Vector boundary_edges, SurfacePath surfacePath, Patch patch) {
        Seam seam = new Seam();
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i);
            edge.seam = seam;
            if (type == 0) {
                edge.sharp = true;
            }
            ++i;
        }
        vertices = new Vector();
        i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onPolygon(i)) {
                vertices.addElement(surfacePath.getVertex(i));
            }
            ++i;
        }
        center = new Vertex();
        i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i);
            center.add_self(v);
            ++i;
        }
        center.multiple_self(1.0 / (double)vertices.size());
        normal = new Vector3();
        double total_length = 0.0;
        Vertex prev = (Vertex)vertices.elementAt(vertices.size() - 1);
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vertex next = (Vertex)vertices.elementAt(i2);
            Vector3 vec0 = new Vector3(center, prev);
            Vector3 vec1 = new Vector3(center, next);
            normal.add_self(vec1.cross_product(vec0).get_normalized());
            total_length += Vector3.distance(prev, next);
            prev = next;
            ++i2;
        }
        normal.normalize_self();
        patch.unit_length = total_length / (double)vertices.size();
        radius = 0.0;
        i2 = 0;
        while (i2 < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i2);
            radius += Vector3.distance(v, center);
            ++i2;
        }
        radius /= (double)vertices.size();
        radius *= 0.8;
    }

    public static Object[] remesh(Polyhedron _h, SurfacePath surfacePath) {
        h = _h;
        return Pop.remesh(surfacePath, true, false);
    }

    public static Object[] remesh(Polyhedron _h, SurfacePath surfacePath, boolean smooth, boolean stop_at_seams) {
        h = _h;
        return Pop.remesh(surfacePath, smooth, stop_at_seams);
    }

    public static Object[] remesh(SurfacePath surfacePath, boolean smooth, boolean stop_at_seams) {
        if (surfacePath.getVertex(0).same_position(surfacePath.getVertex(surfacePath.size() - 1))) {
            surfacePath.path.removeElementAt(surfacePath.size() - 1);
        }
        Vector<Edge> dead_edges = new Vector<Edge>();
        Hashtable vertices_on_edge = new Hashtable();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onEdge(i)) {
                Edge edge = surfacePath.getEdge(i);
                Vertex vertex = surfacePath.getVertex(i);
                Vector vs = new Vector();
                if (vertices_on_edge.containsKey(edge)) {
                    vs = (Vector)vertices_on_edge.get(edge);
                } else {
                    vertices_on_edge.put(edge, vs);
                    dead_edges.addElement(edge);
                }
                vs.addElement(vertex);
            }
            ++i;
        }
        Vector<Vertex> fixed_vertices = new Vector<Vertex>();
        Vector<Polygon2> polygons = new Vector<Polygon2>();
        Polygon2 polygon = surfacePath.getPolygon(0);
        Vector<Edge> boundary_edges = new Vector<Edge>();
        Vertex prev_vertex = surfacePath.getVertex(surfacePath.size() - 1);
        Hashtable<Polygon2, Vector> edges_on_polygon = new Hashtable<Polygon2, Vector>();
        int i2 = 0;
        while (i2 < surfacePath.size()) {
            Vertex vertex = surfacePath.getVertex(i2);
            h.append(vertex);
            Edge edge = new Edge(prev_vertex, vertex);
            h.append(edge);
            Vector vs = new Vector();
            if (edges_on_polygon.containsKey(polygon)) {
                vs = (Vector)edges_on_polygon.get(polygon);
            } else {
                edges_on_polygon.put(polygon, vs);
            }
            vs.addElement(edge);
            if (surfacePath.onEdge(i2)) {
                polygon = surfacePath.getEdge(i2).get_the_other_polygon(polygon);
                if (!polygons.contains(polygon)) {
                    polygons.addElement(polygon);
                }
                if (surfacePath.getEdge((int)i2).sharp) {
                    fixed_vertices.addElement(vertex);
                }
            }
            boundary_edges.addElement(edge);
            prev_vertex = vertex;
            ++i2;
        }
        Enumeration e = vertices_on_edge.keys();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vector vs = (Vector)vertices_on_edge.get(edge);
            vs = Pop.sort_vertices_on_edge(vs, edge.start);
            vs.addElement(edge.end);
            prev_vertex = edge.start;
            Vector<Edge> newEdges = new Vector<Edge>();
            int i3 = 0;
            while (i3 < vs.size()) {
                Vertex next_vertex = (Vertex)vs.elementAt(i3);
                Edge newEdge = new Edge(prev_vertex, next_vertex);
                newEdges.addElement(newEdge);
                newEdge.seam = edge.seam;
                newEdge.sharp = edge.sharp;
                h.append(newEdge);
                prev_vertex = next_vertex;
                ++i3;
            }
            vertices_on_edge.put(edge, newEdges);
        }
        i = 0;
        while (i < polygons.size()) {
            polygon = (Polygon2)polygons.elementAt(i);
            Vector newEdges = new Vector();
            int j = 0;
            while (j < 3) {
                Edge edge = polygon.edges[j];
                if (vertices_on_edge.containsKey(edge)) {
                    Vector vs = (Vector)vertices_on_edge.get(edge);
                    if (edge.left_polygon != polygon) {
                        vs = Util.reverseVector(vs);
                    }
                    newEdges = Util.connectVector(newEdges, vs);
                } else {
                    newEdges.addElement(edge);
                }
                ++j;
            }
            Vector possibleEdges = (Vector)edges_on_polygon.get(polygon);
            possibleEdges = Util.connectVector(possibleEdges, possibleEdges);
            possibleEdges = Util.connectVector(possibleEdges, newEdges);
            Vector<Vector> loops = new Vector<Vector>();
            Vector visited = new Vector();
            int j2 = 0;
            while (j2 < newEdges.size()) {
                Edge edge = (Edge)newEdges.elementAt(j2);
                Edge nextEdge = (Edge)newEdges.elementAt(Util.mod(j2 + 1, newEdges.size()));
                if (!visited.contains(edge)) {
                    loops.addElement(Pop.find_loop(edge, edge.get_common_vertex(nextEdge), polygon.normal, visited, dead_edges, possibleEdges, newEdges));
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < loops.size()) {
                Vector loop = (Vector)loops.elementAt(j2);
                if (loop.size() == 3) {
                    Polygon2 p = new Polygon2((Edge)loop.elementAt(0), (Edge)loop.elementAt(1), (Edge)loop.elementAt(2), polygon.patch);
                    h.append(p);
                } else {
                    Pop.triangulate(loop, polygon);
                }
                ++j2;
            }
            h.remove(polygon);
            ++i;
        }
        h.set_parameters();
        Vector patch_polygons = new Vector();
        Edge start_edge = (Edge)boundary_edges.elementAt(0);
        Polygon2 start_polygon = start_edge.right_polygon();
        Pop.propagate_patch(start_polygon, start_edge, boundary_edges, patch_polygons, smooth, stop_at_seams);
        int i4 = 0;
        while (i4 < fixed_vertices.size()) {
            ((Vertex)fixed_vertices.elementAt((int)i4)).fixed = true;
            ++i4;
        }
        Object[] result = new Object[]{boundary_edges, patch_polygons};
        return result;
    }

    static void triangulate(Vector loop, Polygon2 polygon) {
        Vector3 normal = polygon.normal;
        Vector3 y_axis = new Vector3(normal.y, normal.z, normal.x);
        Vector3 x_axis = y_axis.cross_product(normal);
        y_axis = normal.cross_product(x_axis);
        x_axis.normalize_self();
        y_axis.normalize_self();
        Edge prev_edge = (Edge)loop.elementAt(loop.size() - 1);
        Vertex prev_vertex = prev_edge.get_common_vertex((Edge)loop.elementAt(loop.size() - 2));
        Vector<Vertex> vertices3D = new Vector<Vertex>();
        Vector<Vertex2D> vertices2D = new Vector<Vertex2D>();
        int i = 0;
        while (i < loop.size()) {
            Edge next_edge = (Edge)loop.elementAt(i);
            Vertex vertex = prev_edge.get_the_other_vertex(prev_vertex);
            vertices3D.addElement(vertex);
            Vertex2D v = new Vertex2D(x_axis.dot_product(vertex), y_axis.dot_product(vertex));
            v.index = i++;
            vertices2D.addElement(v);
            prev_edge = next_edge;
            prev_vertex = vertex;
        }
        Vector[] delaunay_result = Delaunay.triangulate(vertices2D);
        Vector delaunay_edges = delaunay_result[0];
        Vector delaunay_triangles = delaunay_result[1];
        Vector<Edge> edges = new Vector<Edge>();
        int i2 = 0;
        while (i2 < delaunay_edges.size()) {
            Vertex end;
            int[] delaunay_edge = (int[])delaunay_edges.elementAt(i2);
            Vertex start = (Vertex)vertices3D.elementAt(delaunay_edge[0]);
            Edge edge = start.get_shared_edge(end = (Vertex)vertices3D.elementAt(delaunay_edge[1]));
            if (edge == null) {
                edge = new Edge(start, end);
                edge.delaunay_edge = true;
                h.append(edge);
            }
            edges.addElement(edge);
            ++i2;
        }
        i2 = 0;
        while (i2 < delaunay_triangles.size()) {
            int[] delaunay_triangle = (int[])delaunay_triangles.elementAt(i2);
            Edge edge0 = (Edge)edges.elementAt(delaunay_triangle[0]);
            Edge edge1 = (Edge)edges.elementAt(delaunay_triangle[1]);
            Edge edge2 = (Edge)edges.elementAt(delaunay_triangle[2]);
            Polygon2 p = new Polygon2(edge0, edge1, edge2, polygon.patch);
            h.append(p);
            ++i2;
        }
    }

    public static void remove_seam(Seam seam) {
        int i = 0;
        while (i < Pop.h.n_edges) {
            Edge edge = Pop.h.edges[i];
            if (edge.seam == seam) {
                edge.seam = null;
                edge.sharp = false;
            }
            ++i;
        }
    }

    public static Vector find_boundary_vertices(Vector boundary_edges) {
        Vector<Vertex> boundary_vertices = new Vector<Vertex>();
        int i = 0;
        while (i < boundary_edges.size()) {
            boundary_vertices.addElement(((Edge)boundary_edges.elementAt((int)i)).start);
            ++i;
        }
        return boundary_vertices;
    }

    private static ImplicitFunction pop_iFunction(double height) {
        if (type == 1) {
            return Pop.smooth_iFunction(height);
        }
        double sign = 1.0;
        if (height >= 0.5) {
            height = 1.0 + (height - 0.5) * 2.0;
        } else {
            height = -1.0 + (height - 0.5) * 2.0;
            sign = -1.0;
        }
        Vector<Vertex> zeroKnots = new Vector<Vertex>();
        Vector<Vertex> plusKnots = new Vector<Vertex>();
        Vertex vm = center.translate(normal.multiple(radius * height));
        zeroKnots.addElement(vm);
        vm = vm.translate(normal.multiple(1.0E-4));
        plusKnots.addElement(vm);
        vm = center.translate(normal.multiple(-radius * height * 2.0));
        zeroKnots.addElement(vm);
        vm = vm.translate(normal.multiple(-1.0E-4));
        plusKnots.addElement(vm);
        Vertex prev_v = (Vertex)vertices.elementAt(vertices.size() - 1);
        int i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i);
            zeroKnots.addElement(v);
            Vector3 vec = new Vector3(prev_v, v);
            vec = v.normal.cross_product(vec);
            vec.normalize_self();
            vec.multiple_self(1.0E-4 * sign);
            Vertex pv = v.translate(vec);
            plusKnots.addElement(pv);
            prev_v = v;
            ++i;
        }
        return new ImplicitFunction(zeroKnots, plusKnots);
    }

    public static Vector find_boundary_vertices(Seam seam) {
        Vector<Vertex> result = new Vector<Vertex>();
        int i = 0;
        while (i < Pop.h.n_edges) {
            Edge edge = Pop.h.edges[i];
            if (edge.seam == seam) {
                if (!result.contains(edge.start)) {
                    result.addElement(edge.start);
                }
                if (!result.contains(edge.end)) {
                    result.addElement(edge.end);
                }
            }
            ++i;
        }
        return result;
    }

    public static Edge get_next_boundary_edge(Vertex v, Edge base_edge, Seam seam) {
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge == base_edge || edge.seam != seam) continue;
            return edge;
        }
        return null;
    }

    public static void soap_step(Vector vertices, Vertex[] target_positions) {
        Vertex v;
        int i = 0;
        while (i < vertices.size()) {
            v = (Vertex)vertices.elementAt(i);
            Vertex sum = new Vertex();
            Enumeration e = v.get_surrounding_vertices().elements();
            while (e.hasMoreElements()) {
                Vertex u = (Vertex)e.nextElement();
                sum.add_self(u);
            }
            sum.multiple_self(1.0 / (double)v.edges.size());
            target_positions[i] = sum;
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            v = (Vertex)vertices.elementAt(i);
            v.warp(target_positions[i]);
            ++i;
        }
        h.set_parameters();
    }

    static Vector sort_vertices_on_edge(Vector vs, Vertex base) {
        Vector<Double> values = new Vector<Double>();
        int i = 0;
        while (i < vs.size()) {
            Vertex v = (Vertex)vs.elementAt(i);
            values.addElement(new Double(base.distance(v)));
            ++i;
        }
        return Sort.sort(vs, values);
    }

    public static void soap(Vector boundary_edges, Vector patch_polygons) {
        Vector internal_vertices = Pop.find_internal_vertices(boundary_edges, patch_polygons);
        Pop.soap_main(internal_vertices);
    }

    public static void smooth(Polyhedron _h, SurfacePath surfacePath) {
        h = _h;
        type = 1;
        Pop.pop_main(surfacePath);
    }

    public static void taubin_smooth(Vector boundary_edges, Vector patch_polygons, int count) {
        Vector internal_vertices = Pop.find_internal_vertices(boundary_edges, patch_polygons);
        Vector boundary_vertices = Pop.find_boundary_vertices(boundary_edges);
        TaubinFairing.constrained_smooth(internal_vertices, boundary_vertices, count);
        h.set_parameters();
    }

    public static void remove_sharp(Seam seam) {
        int i = 0;
        while (i < Pop.h.n_edges) {
            Edge edge = Pop.h.edges[i];
            if (edge.seam == seam) {
                edge.sharp = false;
            }
            ++i;
        }
    }

    public static Vector find_dirty_edges(Patch patch, Seam seam) {
        Vector<Edge> results = new Vector<Edge>();
        int i = 0;
        while (i < Pop.h.n_edges) {
            Edge edge = Pop.h.edges[i];
            if (edge.left_polygon.patch == patch || edge.right_polygon.patch == patch) {
                results.addElement(edge);
            }
            ++i;
        }
        Vector boundary_edges = Pop.find_boundary_edges(seam);
        int i2 = 0;
        while (i2 < boundary_edges.size()) {
            Edge boundary_edge = (Edge)boundary_edges.elementAt(i2);
            Enumeration e = boundary_edge.start.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                if (edge.left_polygon.patch == patch || edge.right_polygon.patch == patch) continue;
                Vertex v = edge.get_the_other_vertex(boundary_edge.start);
                if (!results.contains(edge)) {
                    results.addElement(edge);
                }
                Enumeration ee = v.edges.elements();
                while (ee.hasMoreElements()) {
                    Edge u = (Edge)ee.nextElement();
                    if (results.contains(u)) continue;
                    results.addElement(u);
                }
            }
            ++i2;
        }
        return results;
    }

    private static ImplicitFunction smooth_iFunction(double height) {
        Vector<Vertex> zeroKnots = new Vector<Vertex>();
        Vector<Vertex> plusKnots = new Vector<Vertex>();
        if (Math.abs(height = (height - 0.5) * 2.0) > 0.2) {
            Vertex vm = center.translate(normal.multiple(radius * height));
            zeroKnots.addElement(vm);
            vm = vm.translate(normal.multiple(1.0E-4));
            plusKnots.addElement(vm);
        }
        Vertex prev_v = (Vertex)vertices.elementAt(vertices.size() - 1);
        int i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.elementAt(i);
            zeroKnots.addElement(v);
            Vector3 vec = new Vector3(v.normal);
            vec.normalize_self();
            vec.multiple_self(1.0E-4);
            Vertex pv = v.translate(vec);
            plusKnots.addElement(pv);
            prev_v = v;
            ++i;
        }
        return new ImplicitFunction(zeroKnots, plusKnots);
    }

    public static void adjust(double val) {
        Pop.adjusted_patch.iFunction = Pop.pop_iFunction(val);
    }

    static Edge find_next_edge(Edge prev_edge, Vertex vertex, Vector3 normal, Vector dead_edges, Vector possibleEdges, Vector outside_edges) {
        Vector<Edge> outlets = new Vector<Edge>();
        Enumeration e = vertex.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge == prev_edge || dead_edges.contains(edge) || !possibleEdges.contains(edge)) continue;
            outlets.addElement(edge);
        }
        if (outlets.size() == 0 && possibleEdges.contains(prev_edge)) {
            return prev_edge;
        }
        if (outlets.size() == 0) {
            return null;
        }
        if (outlets.size() == 1) {
            return (Edge)outlets.elementAt(0);
        }
        if (outlets.size() > 2) {
            System.out.println("too many outlets in Pop.find_next_edge");
        }
        Edge edge0 = (Edge)outlets.elementAt(0);
        Edge edge1 = (Edge)outlets.elementAt(1);
        if (outside_edges.contains(prev_edge)) {
            if (outside_edges.contains(edge0)) {
                return edge1;
            }
            return edge0;
        }
        if (outside_edges.indexOf(edge1) == Util.mod(outside_edges.indexOf(edge0) + 1, outside_edges.size())) {
            return edge1;
        }
        return edge0;
    }

    public static Vector find_internal_vertices(Vector boundary_edges, Vector patch_polygons) {
        Vector<Vertex> boundary_vertices = new Vector<Vertex>();
        int i = 0;
        while (i < boundary_edges.size()) {
            boundary_vertices.addElement(((Edge)boundary_edges.elementAt((int)i)).start);
            ++i;
        }
        Vector<Vertex> result = new Vector<Vertex>();
        int i2 = 0;
        while (i2 < patch_polygons.size()) {
            Polygon2 polygon = (Polygon2)patch_polygons.elementAt(i2);
            int j = 0;
            while (j < 3) {
                Vertex v = polygon.get_vertex(j);
                if (!result.contains(v) && !boundary_vertices.contains(v)) {
                    result.addElement(v);
                }
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static Vector find_dirty_vertices(Patch patch, Seam seam) {
        Vector edges = Pop.find_dirty_edges(patch, seam);
        Vector<Vertex> results = new Vector<Vertex>();
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.elementAt(i);
            if (!results.contains(edge.start)) {
                results.addElement(edge.start);
            }
            if (!results.contains(edge.end)) {
                results.addElement(edge.end);
            }
            ++i;
        }
        return results;
    }

    static void propagate_patch(Polygon2 polygon, Edge base_edge, Vector boundary_edges, Vector patch_polygons, boolean smooth, boolean stop_at_seams) {
        patch_polygons.addElement(polygon);
        int i = 0;
        while (i < 3) {
            Edge edge = polygon.edges[i];
            if (!(edge == base_edge || boundary_edges.contains(edge) || stop_at_seams && edge.seam != null)) {
                Polygon2 next_polygon;
                if (smooth) {
                    edge.seam = null;
                    edge.sharp = false;
                    edge.start.fixed = false;
                    edge.end.fixed = false;
                }
                if ((next_polygon = edge.get_the_other_polygon(polygon)) != null && !patch_polygons.contains(next_polygon)) {
                    Pop.propagate_patch(next_polygon, edge, boundary_edges, patch_polygons, smooth, stop_at_seams);
                }
            }
            ++i;
        }
    }

    public static void pop_main(SurfacePath surfacePath) {
        Object[] result = Pop.remesh(surfacePath, true, false);
        Vector boundary_edges = (Vector)result[0];
        Vector patch_polygons = (Vector)result[1];
        Patch patch = new Patch();
        int i = 0;
        while (i < patch_polygons.size()) {
            ((Polygon2)patch_polygons.elementAt((int)i)).patch = patch;
            ++i;
        }
        Seam seam = new Seam();
        int i2 = 0;
        while (i2 < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i2);
            edge.seam = seam;
            ++i2;
        }
        Pop.soap(boundary_edges, patch_polygons);
        Pop.set_original_mesh(h, true);
        Vector dirty_vertices = Pop.find_dirty_vertices(patch, seam);
        Skin.drift(dirty_vertices, 5);
        Vector internal_vertices = Pop.find_internal_vertices(patch);
        Vector boundary_vertices = Pop.find_boundary_vertices(seam);
        TaubinFairing.constrained_smooth(internal_vertices, boundary_vertices, 10);
        Pop.set_original_mesh(h, false);
        Skin.drift(internal_vertices, 5);
        TaubinFairing.constrained_smooth(internal_vertices, boundary_vertices, 10);
        Pop.set_original_mesh(h, false);
        Skin.drift(internal_vertices, 5);
        Pop.set_original_mesh(h, false);
        Vector dirty_edges = Pop.find_dirty_edges(patch, seam);
        Skin.refine_mesh_connectivity(h, dirty_edges);
        dirty_vertices = Pop.find_dirty_vertices(patch, seam);
        Skin.drift(dirty_vertices, 5);
        h.set_normals();
        adjusted_patch = patch;
    }

    public static void soap_main(Vector internal_vertices) {
        Vertex[] target_positions = new Vertex[internal_vertices.size()];
        int i = 0;
        while (i < 20) {
            Pop.soap_step(internal_vertices, target_positions);
            ++i;
        }
        h.set_parameters();
    }

    public static void set_original_mesh(Polyhedron mesh, boolean slow_and_robust) {
        SubdivMesh.create_skeleton_mesh(mesh, slow_and_robust);
    }

    public void update_original_mesh_positions(Polyhedron original_mesh, Polyhedron mesh) {
        Vector<Vertex> dirty_vertices = new Vector<Vertex>();
        int i = 0;
        while (i < mesh.n_vertices) {
            if (!Vertex.exactly_same_position(original_mesh.vertices[i], mesh.vertices[i])) {
                original_mesh.vertices[i].warp(mesh.vertices[i]);
                dirty_vertices.addElement(original_mesh.vertices[i]);
            }
            ++i;
        }
        original_mesh.set_normals(dirty_vertices);
        Skin.init_bodyPolygon_and_bodyVertex(mesh, original_mesh);
        Skin.calculate_curvature(dirty_vertices);
    }

    public static Vector find_internal_vertices(Patch patch) {
        Vector<Vertex> result = new Vector<Vertex>();
        int i = 0;
        while (i < Pop.h.n_polygons) {
            Polygon2 polygon = Pop.h.polygons[i];
            if (polygon.patch == patch) {
                int j = 0;
                while (j < 3) {
                    Vertex v = polygon.get_vertex(j);
                    if (!result.contains(v) && !v.on_seam()) {
                        result.addElement(v);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }
}

