/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import teddy.Edge;
import teddy.ImplicitFunction;
import teddy.LinkedList;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Seam;
import teddy.SurfaceLine;
import teddy.Vector3;
import teddy.Vertex;

public class Polyhedron
implements Serializable {
    public Vertex[] vertices;
    public Edge[] edges;
    public Polygon2[] polygons;
    public int n_vertices;
    public int n_edges;
    public int n_polygons;
    public int max_n_vertices;
    public int max_n_edges;
    public int max_n_polygons;
    public LinkedList surface_lines;
    public Vector3 base_x = new Vector3(1.0, 0.0, 0.0);
    public Vector3 base_y = new Vector3(0.0, 1.0, 0.0);
    public Vector3 base_z = new Vector3(0.0, 0.0, 1.0);
    public boolean view_changed = true;
    public transient boolean section_bumping = false;
    boolean locked = false;
    protected transient LinkedList tmp_polygons;
    protected transient LinkedList _vertices;
    protected transient LinkedList _edges;
    protected transient LinkedList _polygons;
    ImplicitFunction iFunction;

    public boolean edeg_check() {
        int i = 0;
        while (i < this.n_edges) {
            Edge edge = this.edges[i];
            if (!(edge == null || edge.disposed || edge.left_polygon != null && edge.right_polygon != null)) {
                System.out.println("broekn edge ");
                return true;
            }
            ++i;
        }
        return false;
    }

    public void set_parameters() {
        this.set_indices();
        this.set_normals();
    }

    public void restore(Polyhedron h) {
        this.n_vertices = h.n_vertices;
        this.n_edges = h.n_edges;
        this.n_polygons = h.n_polygons;
        this.max_n_vertices = h.max_n_vertices;
        this.max_n_edges = h.max_n_edges;
        this.max_n_polygons = h.max_n_polygons;
        this.vertices = h.vertices;
        this.edges = h.edges;
        this.polygons = h.polygons;
        int i = 0;
        while (i < this.n_polygons) {
            this.polygons[i].polyhedron = this;
            ++i;
        }
        this.surface_lines = h.surface_lines;
        this.base_x = h.base_x;
        this.base_y = h.base_y;
        this.base_z = h.base_z;
    }

    protected void postprocess() {
        this.postprocess_main();
        this.size_normalize();
        this.set_parameters();
    }

    void rotate_x(double angle) {
        this.rotate_sub(0, angle);
    }

    public Vector get_patches() {
        Vector<Patch> patches = new Vector<Patch>();
        int i = 0;
        while (i < this.n_polygons) {
            if (!patches.contains(this.polygons[i].patch)) {
                patches.addElement(this.polygons[i].patch);
            }
            ++i;
        }
        return patches;
    }

    public Vector find_broken_edges() {
        Vector<Edge> broken_edges = new Vector<Edge>();
        int i = 0;
        while (i < this.n_edges) {
            Edge edge = this.edges[i];
            if (edge.left_polygon == null || edge.right_polygon == null) {
                broken_edges.addElement(edge);
            }
            ++i;
        }
        broken_edges.addElement(this.edges[0]);
        return broken_edges;
    }

    public Vector getVertices() {
        Vector<double[]> vs = new Vector<double[]>();
        int i = 0;
        while (i < this.n_vertices) {
            Vertex v = this.vertices[i];
            double[] xyz = new double[]{v.x, v.y, v.z};
            vs.addElement(xyz);
            ++i;
        }
        return vs;
    }

    public void replace_edge(Edge original_edge, Edge edge0, Edge edge1) {
        if (original_edge.right_polygon() != null) {
            original_edge.right_polygon().edge_replace(original_edge, edge0, edge1);
        }
        if (original_edge.left_polygon() != null) {
            original_edge.left_polygon().edge_replace(original_edge, edge0, edge1);
        }
        this.remove(original_edge);
    }

    void rotate_y(double angle) {
        this.rotate_sub(1, angle);
    }

    public void replace_edge(Edge original_edge, Edge edge0, Edge edge1, Edge edge2) {
        if (original_edge.right_polygon() != null) {
            original_edge.right_polygon().edge_replace(original_edge, edge0, edge1, edge2);
        }
        if (original_edge.left_polygon() != null) {
            original_edge.left_polygon().edge_replace(original_edge, edge0, edge1, edge2);
        }
        this.remove(original_edge);
    }

    protected Edge get_edge(Vertex v0, Vertex v1) {
        Edge v;
        Enumeration e = v0.edges.elements();
        while (e.hasMoreElements()) {
            v = (Edge)e.nextElement();
            if (!v.same_edge(v0, v1)) continue;
            return v;
        }
        e = v1.edges.elements();
        while (e.hasMoreElements()) {
            v = (Edge)e.nextElement();
            if (!v.same_edge(v0, v1)) continue;
            return v;
        }
        v = new Edge(v0, v1);
        this._edges.append(v);
        return v;
    }

    public void set_normals() {
        int i = 0;
        while (i < this.n_polygons) {
            this.polygons[i].set_normal();
            this.polygons[i].polyhedron = this;
            ++i;
        }
        i = 0;
        while (i < this.n_vertices) {
            this.vertices[i].set_normal();
            ++i;
        }
    }

    public void set_normals(Vector vertices) {
        Vertex v;
        int i = 0;
        while (i < vertices.size()) {
            v = (Vertex)vertices.elementAt(i);
            v.normal = null;
            ++i;
        }
        i = 0;
        while (i < this.n_polygons) {
            Polygon2 polygon = this.polygons[i];
            if (polygon.get_vertex((int)0).normal == null || polygon.get_vertex((int)1).normal == null || polygon.get_vertex((int)2).normal == null) {
                polygon.set_normal();
            }
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            v = (Vertex)vertices.elementAt(i);
            v.set_normal();
            ++i;
        }
    }

    public Vertex get_vertex(Edge e1, Edge e2) {
        if (e1.start() == e2.start() || e1.start() == e2.end()) {
            return e1.start();
        }
        return e1.end();
    }

    protected Vertex get_vertex(double x, double y, double z) {
        Vertex v;
        Enumeration e = this._vertices.elements();
        while (e.hasMoreElements()) {
            v = (Vertex)e.nextElement();
            if (!v.same_vertex(x, y, z)) continue;
            return v;
        }
        v = new Vertex(x, y, z);
        this._vertices.append(v);
        return v;
    }

    public void append_edges(LinkedList new_edges) {
        Enumeration e = new_edges.elements();
        while (e.hasMoreElements()) {
            this.append((Edge)e.nextElement());
        }
    }

    public void append_a_new_polygon(Vertex v0, Vertex v1, Vertex v2) {
        Edge e0 = this.get_edge_array(v0, v1);
        Edge e1 = this.get_edge_array(v1, v2);
        Edge e2 = this.get_edge_array(v2, v0);
        this.append(new Polygon2(e0, e1, e2));
    }

    protected void postprocess_no_normalize() {
        this.postprocess_main();
        this.set_parameters();
    }

    protected Vertex get_vertex(Vertex v) {
        return this.get_vertex(v.x, v.y, v.z);
    }

    void rotate_z(double angle) {
        this.rotate_sub(2, angle);
    }

    public void unlock() {
        this.locked = false;
        int n = 0;
        int i = 0;
        while (i < this.n_polygons) {
            if (this.polygons[i] != null) {
                this.polygons[n] = this.polygons[i];
                this.polygons[n].index = n;
                ++n;
            }
            ++i;
        }
        this.n_polygons = n;
        n = 0;
        i = 0;
        while (i < this.n_edges) {
            if (this.edges[i] != null) {
                this.edges[n] = this.edges[i];
                this.edges[n].index = n;
                ++n;
            }
            ++i;
        }
        this.n_edges = n;
        n = 0;
        i = 0;
        while (i < this.n_vertices) {
            if (this.vertices[i] != null) {
                this.vertices[n] = this.vertices[i];
                this.vertices[n].index = n;
                ++n;
            }
            ++i;
        }
        this.n_vertices = n;
    }

    public void append_vertices(LinkedList new_vertices) {
        Enumeration e = new_vertices.elements();
        while (e.hasMoreElements()) {
            this.append((Vertex)e.nextElement());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void remove(Vertex vertex) {
        block3: {
            i = 0;
            while (i < this.n_vertices) {
                if (this.vertices[i] == vertex) break;
                ++i;
            }
            if (i == this.n_vertices) {
                return;
            }
            if (!this.locked) ** GOTO lbl14
            this.vertices[i] = null;
            break block3;
lbl-1000:
            // 1 sources

            {
                this.vertices[i] = this.vertices[i + 1];
                this.vertices[i].index = i;
                ++i;
lbl14:
                // 2 sources

                ** while (i < this.n_vertices - 1)
            }
lbl15:
            // 1 sources

            this.n_vertices += -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void remove(Polygon2 polygon) {
        block6: {
            i = 0;
            while (i < this.n_polygons) {
                if (this.polygons[i] == polygon) break;
                ++i;
            }
            if (i == this.n_polygons) {
                return;
            }
            if (!this.locked) ** GOTO lbl14
            this.polygons[i] = null;
            break block6;
lbl-1000:
            // 1 sources

            {
                this.polygons[i] = this.polygons[i + 1];
                this.polygons[i].index = i;
                ++i;
lbl14:
                // 2 sources

                ** while (i < this.n_polygons - 1)
            }
lbl15:
            // 1 sources

            this.n_polygons += -1;
        }
        i = 0;
        while (i < polygon.n_edges) {
            polygon.edges(i).remove_polygon(polygon);
            if (polygon.edges(i).polygon_is_empty()) {
                this.remove(polygon.edges(i));
            }
            ++i;
        }
        e = polygon.surface_lines.elements();
        while (e.hasMoreElements()) {
            this.surface_lines.remove((SurfaceLine)e.nextElement());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void remove(Edge edge) {
        block5: {
            i = 0;
            while (i < this.n_edges) {
                if (this.edges[i] == edge) break;
                ++i;
            }
            if (i == this.n_edges) {
                System.out.println("try to remove invalid (Polyhedron.remove(Edge)) " + edge + " " + edge.seam);
                v = null;
                v.x = 0.0;
                return;
            }
            if (!this.locked) ** GOTO lbl16
            this.edges[i] = null;
            break block5;
lbl-1000:
            // 1 sources

            {
                this.edges[i] = this.edges[i + 1];
                ++i;
lbl16:
                // 2 sources

                ** while (i < this.n_edges - 1)
            }
lbl17:
            // 1 sources

            this.n_edges += -1;
        }
        edge.disposed = true;
        edge.start.remove_edge(edge);
        if (edge.start.edge_is_empty()) {
            this.remove(edge.start);
        }
        edge.end.remove_edge(edge);
        if (edge.end.edge_is_empty()) {
            this.remove(edge.end);
        }
    }

    protected void postprocess_list_to_array() {
        this.n_vertices = this._vertices.size();
        this.n_edges = this._edges.size();
        this.n_polygons = this._polygons.size();
        this.max_n_vertices = this.n_vertices * 2;
        this.max_n_edges = this.n_edges * 2;
        this.max_n_polygons = this.n_polygons * 2;
        this.vertices = new Vertex[this.max_n_vertices];
        this.edges = new Edge[this.max_n_edges];
        this.polygons = new Polygon2[this.max_n_polygons];
        int i = 0;
        Enumeration e = this._vertices.elements();
        while (e.hasMoreElements()) {
            this.vertices[i] = (Vertex)e.nextElement();
            this.vertices[i].index = i;
            ++i;
        }
        i = 0;
        e = this._edges.elements();
        while (e.hasMoreElements()) {
            this.edges[i++] = (Edge)e.nextElement();
        }
        i = 0;
        e = this._polygons.elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            polygon.polyhedron = this;
            this.polygons[i++] = polygon;
        }
    }

    public void lock() {
        this.locked = true;
    }

    Polyhedron() {
        this.surface_lines = new LinkedList();
    }

    protected void postprocess_main() {
        Enumeration e = this.tmp_polygons.elements();
        while (e.hasMoreElements()) {
            TmpPolygon _polygon = (TmpPolygon)e.nextElement();
            this._polygons.append(_polygon.get_polygon());
        }
        this.postprocess_list_to_array();
    }

    Polyhedron(Vector _vertices, Vector _edges, Vector _polygons) {
        this();
        this.n_vertices = _vertices.size();
        this.max_n_vertices = this.n_vertices * 2;
        this.vertices = new Vertex[this.max_n_vertices];
        int i = 0;
        while (i < this.n_vertices) {
            this.vertices[i] = (Vertex)_vertices.elementAt(i);
            this.vertices[i].index = i;
            ++i;
        }
        this.n_edges = _edges.size();
        this.max_n_edges = this.n_edges * 2;
        this.edges = new Edge[this.max_n_edges];
        i = 0;
        while (i < this.n_edges) {
            this.edges[i] = (Edge)_edges.elementAt(i);
            this.edges[i].index = i;
            ++i;
        }
        this.n_polygons = _polygons.size();
        this.max_n_polygons = this.n_polygons * 2;
        this.polygons = new Polygon2[this.max_n_polygons];
        i = 0;
        while (i < this.n_polygons) {
            this.polygons[i] = (Polygon2)_polygons.elementAt(i);
            this.polygons[i].index = i;
            ++i;
        }
    }

    public Polyhedron(Vector vertices, Vector indices, Vector seams, Vector sharps) {
        this();
        Edge edge;
        this.tmp_polygons = new LinkedList();
        this._vertices = new LinkedList();
        this._edges = new LinkedList();
        this._polygons = new LinkedList();
        int i = 0;
        while (i < vertices.size()) {
            double[] xyz = (double[])vertices.elementAt(i);
            this._vertices.append(new Vertex(xyz[0], xyz[1], xyz[2]));
            ++i;
        }
        i = 0;
        while (i < indices.size()) {
            int[] index = (int[])indices.elementAt(i);
            LinkedList v_list = new LinkedList();
            int j = 0;
            while (j < 3) {
                v_list.append(this._vertices.elementAt(index[j]));
                ++j;
            }
            this.tmp_polygons.append(new TmpPolygon(v_list));
            ++i;
        }
        this.postprocess_no_normalize();
        Seam seam = new Seam();
        int i2 = 0;
        while (i2 < seams.size()) {
            int[] index = (int[])seams.elementAt(i2);
            Vertex start = this.vertices[index[0]];
            Vertex end = this.vertices[index[1]];
            edge = start.get_shared_edge(end);
            edge.seam = seam;
            ++i2;
        }
        Seam sharp_seam = new Seam();
        int i3 = 0;
        while (i3 < sharps.size()) {
            int[] index = (int[])sharps.elementAt(i3);
            Vertex start = this.vertices[index[0]];
            Vertex end = this.vertices[index[1]];
            Edge edge2 = start.get_shared_edge(end);
            edge2.seam = sharp_seam;
            edge2.sharp = true;
            ++i3;
        }
        double total = 0.0;
        int i4 = 0;
        while (i4 < this.n_edges) {
            edge = this.edges[i4];
            total += edge.length();
            ++i4;
        }
        Patch patch = new Patch();
        patch.unit_length = total /= (double)this.n_edges;
        int i5 = 0;
        while (i5 < this.n_polygons) {
            this.polygons[i5].patch = patch;
            ++i5;
        }
    }

    public Vector getSharps() {
        Vector<int[]> sharps = new Vector<int[]>();
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i].seam != null && this.edges[i].sharp) {
                int[] index = new int[]{this.edges[i].start.index, this.edges[i].end.index};
                sharps.addElement(index);
            }
            ++i;
        }
        return sharps;
    }

    public void _check_consistency() {
        int i = 0;
        while (i < this.n_vertices) {
            Vertex v = this.vertices[i];
            Enumeration e = v.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                if (this.edges[edge.index] == edge) continue;
                System.out.println("broken vertex " + v + " " + edge);
            }
            ++i;
        }
        i = 0;
        while (i < this.n_edges) {
            Edge edge = this.edges[i];
            if (this.vertices[edge.start.index] != edge.start) {
                System.out.println("broken edge " + edge + " " + edge.start);
            }
            if (this.vertices[edge.end.index] != edge.end) {
                System.out.println("broken edge " + edge + " " + edge.end);
            }
            if (edge.left_polygon == null || edge.right_polygon == null) {
                System.out.println("broken edge " + edge + " " + edge.seam);
            }
            if (this.polygons[edge.left_polygon.index] != edge.left_polygon) {
                System.out.println("broken edge " + edge + " " + edge.left_polygon);
            }
            if (this.polygons[edge.right_polygon.index] != edge.right_polygon) {
                System.out.println("broken edge " + edge + " " + edge.right_polygon);
            }
            if (!edge.right_polygon().contains(edge)) {
                System.out.println("broken edge_ " + edge + " " + edge.right_polygon);
            }
            if (!edge.left_polygon().contains(edge)) {
                System.out.println("broken edge_ " + edge + " " + edge.left_polygon);
            }
            ++i;
        }
        i = 0;
        while (i < this.n_polygons) {
            Polygon2 polygon = this.polygons[i];
            int j = 0;
            while (j < 3) {
                if (this.edges[polygon.edges[j].index] != polygon.edges[j]) {
                    System.out.println("broken polygon " + polygon + " " + polygon.edges[j]);
                }
                if (polygon.edges[j].left_polygon != polygon && polygon.edges[j].right_polygon != polygon) {
                    System.out.println("broken polygon_ " + polygon + " " + polygon.edges[j].left_polygon + " " + polygon.edges[j].right_polygon);
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean contains(Polygon2 polygon) {
        int i = 0;
        while (i < this.n_polygons) {
            if (this.polygons[i] == polygon) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void size_normalize() {
        double diameter = 0.0;
        int i = 0;
        while (i < this.n_vertices) {
            diameter = Math.max(diameter, Math.sqrt(this.vertices[i].x * this.vertices[i].x + this.vertices[i].y * this.vertices[i].y + this.vertices[i].z * this.vertices[i].z));
            ++i;
        }
        i = 0;
        while (i < this.n_vertices) {
            this.vertices[i].x /= diameter;
            this.vertices[i].y /= diameter;
            this.vertices[i].z /= diameter;
            ++i;
        }
    }

    public boolean contains(Edge edge) {
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i] == edge) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vertex absolute_coords(Vector3 v) {
        double x = this.base_x.x * v.x + this.base_y.x * v.y + this.base_z.x * v.z;
        double y = this.base_x.y * v.x + this.base_y.y * v.y + this.base_z.y * v.z;
        double z = this.base_x.z * v.x + this.base_y.z * v.y + this.base_z.z * v.z;
        return new Vertex(x, y, z);
    }

    public void after_loaded() {
    }

    public Polyhedron copy() {
        Polyhedron clone = new Polyhedron();
        clone.n_vertices = this.n_vertices;
        clone.n_edges = this.n_edges;
        clone.n_polygons = this.n_polygons;
        clone.max_n_vertices = this.max_n_vertices;
        clone.max_n_edges = this.max_n_edges;
        clone.max_n_polygons = this.max_n_polygons;
        clone.base_x = this.base_x.copyVector3();
        clone.base_y = this.base_y.copyVector3();
        clone.base_z = this.base_z.copyVector3();
        clone.view_changed = true;
        clone.vertices = new Vertex[this.max_n_vertices];
        int i = 0;
        while (i < this.n_vertices) {
            clone.vertices[i] = this.vertices[i].copy();
            ++i;
        }
        clone.edges = new Edge[this.max_n_edges];
        i = 0;
        while (i < this.n_edges) {
            clone.edges[i] = this.edges[i].copy();
            ++i;
        }
        clone.polygons = new Polygon2[this.max_n_polygons];
        i = 0;
        while (i < this.n_polygons) {
            clone.polygons[i] = this.polygons[i].copy();
            ++i;
        }
        i = 0;
        while (i < this.n_vertices) {
            clone.vertices[i].renew_network();
            ++i;
        }
        i = 0;
        while (i < this.n_edges) {
            clone.edges[i].renew_network();
            ++i;
        }
        i = 0;
        while (i < this.n_polygons) {
            clone.polygons[i].renew_network();
            ++i;
        }
        clone.surface_lines = new LinkedList();
        Enumeration e = this.surface_lines.elements();
        while (e.hasMoreElements()) {
            clone.surface_lines.append(((SurfaceLine)e.nextElement()).copy());
        }
        clone.set_normals();
        return clone;
    }

    public void set_indices() {
        int i = 0;
        while (i < this.n_polygons) {
            this.polygons[i].index = i;
            ++i;
        }
        i = 0;
        while (i < this.n_edges) {
            this.edges[i].index = i;
            ++i;
        }
        i = 0;
        while (i < this.n_vertices) {
            this.vertices[i].index = i;
            ++i;
        }
    }

    public Vector getIndices() {
        Vector<int[]> indices = new Vector<int[]>();
        int i = 0;
        while (i < this.n_polygons) {
            Polygon2 p = this.polygons[i];
            int[] index = new int[]{p.get_vertex((int)0).index, p.get_vertex((int)1).index, p.get_vertex((int)2).index};
            indices.addElement(index);
            ++i;
        }
        return indices;
    }

    public Edge get_edge_array(Vertex v0, Vertex v1) {
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i].same_edge(v0, v1)) {
                return this.edges[i];
            }
            ++i;
        }
        Edge edge = new Edge(v0, v1);
        this.append(edge);
        return edge;
    }

    public void set_sharp_edges() {
        int i = 0;
        while (i < this.n_edges) {
            this.edges[i].set_sharp_if_sharp();
            ++i;
        }
    }

    public Vertex relative_coords(Vector3 v) {
        double x = this.base_x.dot_product(v);
        double y = this.base_y.dot_product(v);
        double z = this.base_z.dot_product(v);
        return new Vertex(x, y, z);
    }

    public void append(Polygon2 polygon) {
        ++this.n_polygons;
        if (this.n_polygons > this.max_n_polygons) {
            this.max_n_polygons *= 2;
            Polygon2[] _polygons = this.polygons;
            this.polygons = new Polygon2[this.max_n_polygons];
            int i = 0;
            while (i < this.n_polygons - 1) {
                this.polygons[i] = _polygons[i];
                ++i;
            }
        }
        polygon.polyhedron = this;
        this.polygons[this.n_polygons - 1] = polygon;
        polygon.index = this.n_polygons - 1;
    }

    void rotate_sub(int axis, double angle) {
        this.base_x.rotate(axis, angle);
        this.base_y.rotate(axis, angle);
        this.base_z.rotate(axis, angle);
        int i = 0;
        while (i < this.n_vertices) {
            this.vertices[i].rotate(axis, angle);
            ++i;
        }
        Enumeration e = this.surface_lines.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            edge.start.rotate(axis, angle);
            edge.end.rotate(axis, angle);
        }
        this.view_changed = true;
    }

    public void append(Vertex vertex) {
        ++this.n_vertices;
        if (this.n_vertices > this.max_n_vertices) {
            this.max_n_vertices *= 2;
            Vertex[] _vertices = this.vertices;
            this.vertices = new Vertex[this.max_n_vertices];
            int i = 0;
            while (i < this.n_vertices - 1) {
                this.vertices[i] = _vertices[i];
                ++i;
            }
        }
        this.vertices[this.n_vertices - 1] = vertex;
        vertex.index = this.n_vertices - 1;
    }

    public void append(Edge edge) {
        ++this.n_edges;
        if (this.n_edges > this.max_n_edges) {
            this.max_n_edges *= 2;
            Edge[] _edges = this.edges;
            this.edges = new Edge[this.max_n_edges];
            int i = 0;
            while (i < this.n_edges - 1) {
                this.edges[i] = _edges[i];
                ++i;
            }
        }
        this.edges[this.n_edges - 1] = edge;
        edge.index = this.n_edges - 1;
    }

    public Vector getSeams() {
        Vector<int[]> seams = new Vector<int[]>();
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i].seam != null && !this.edges[i].sharp) {
                int[] index = new int[]{this.edges[i].start.index, this.edges[i].end.index};
                seams.addElement(index);
            }
            ++i;
        }
        return seams;
    }

    class TmpPolygon {
        public int n_vertices;
        public Vertex[] vertices;

        public Polygon2 get_polygon() {
            if (this.n_vertices == 3) {
                Edge e0 = Polyhedron.this.get_edge(this.vertices[0], this.vertices[1]);
                Edge e1 = Polyhedron.this.get_edge(this.vertices[1], this.vertices[2]);
                Edge e2 = Polyhedron.this.get_edge(this.vertices[2], this.vertices[0]);
                return new Polygon2(e0, e1, e2);
            }
            if (this.n_vertices == 4) {
                Edge e0 = Polyhedron.this.get_edge(this.vertices[0], this.vertices[1]);
                Edge e1 = Polyhedron.this.get_edge(this.vertices[1], this.vertices[2]);
                Edge e2 = Polyhedron.this.get_edge(this.vertices[2], this.vertices[3]);
                Edge e3 = Polyhedron.this.get_edge(this.vertices[3], this.vertices[0]);
                return new Polygon2(e0, e1, e2, e3);
            }
            LinkedList edges = new LinkedList();
            int i = 0;
            while (i < this.n_vertices - 1) {
                edges.append(Polyhedron.this.get_edge(this.vertices[i], this.vertices[i + 1]));
                ++i;
            }
            edges.append(Polyhedron.this.get_edge(this.vertices[i], this.vertices[0]));
            return new Polygon2(edges);
        }

        TmpPolygon(Vertex _v0, Vertex _v1, Vertex _v2, Vertex _v3) {
            Polyhedron.this.getClass();
            this.n_vertices = 4;
            this.vertices = new Vertex[this.n_vertices];
            this.vertices[0] = _v0;
            this.vertices[1] = _v1;
            this.vertices[2] = _v2;
            this.vertices[3] = _v3;
        }

        TmpPolygon(Vertex _v0, Vertex _v1, Vertex _v2) {
            Polyhedron.this.getClass();
            this.n_vertices = 3;
            this.vertices = new Vertex[this.n_vertices];
            this.vertices[0] = _v0;
            this.vertices[1] = _v1;
            this.vertices[2] = _v2;
        }

        TmpPolygon(LinkedList vertex_list) {
            Polyhedron.this.getClass();
            this.n_vertices = vertex_list.size();
            this.vertices = new Vertex[this.n_vertices];
            Enumeration e = vertex_list.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                this.vertices[i++] = (Vertex)e.nextElement();
            }
        }
    }
}

