/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import teddy.Edge;
import teddy.ImplicitFunction;
import teddy.Line;
import teddy.LinkedList;
import teddy.Objects;
import teddy.Patch;
import teddy.Plane;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;

public class Polygon2
implements Serializable {
    public Edge[] edges;
    public int n_edges;
    public LinkedList surface_lines;
    public Vector3 normal;
    boolean front_facing;
    public Polyhedron polyhedron;
    double distance;
    public transient Polygon2 child;
    public int part_index = 0;
    public double target_edge_length;
    public double[] quadratic_function;
    public int index;
    public Patch patch;
    public double area;
    public ImplicitFunction iFunction;

    public Vertex cross_point(Edge edge) {
        Vertex v = this.edges[0].start();
        Vector3 n = this.absolute_normal();
        Vector3 p = edge.vector3();
        Vertex q = edge.start();
        double t = (v.dot_product(n) - q.dot_product(n)) / p.dot_product(n);
        return new Vertex(q.x + p.x * t, q.y + p.y * t, q.z + p.z * t);
    }

    public Edge edges(int i) {
        if (i >= this.n_edges) {
            i -= i / this.n_edges * this.n_edges;
        }
        if (i < 0) {
            i += (-i / this.n_edges + 1) * this.n_edges;
        }
        return this.edges[i];
    }

    public Edge get_longest_edge() {
        Edge longest_edge = null;
        double max = -1.0;
        int i = 0;
        while (i < this.n_edges) {
            double len = this.edges[i].length();
            if (max < len) {
                longest_edge = this.edges[i];
                max = len;
            }
            ++i;
        }
        return longest_edge;
    }

    public Object[] find_closest_point(Vertex v) {
        boolean b2;
        Plane plane = new Plane(this.get_vertex(0), this.normal);
        Vertex p = plane.project(v);
        Vertex v0 = this.get_vertex(0);
        Vertex v1 = this.get_vertex(1);
        Vertex v2 = this.get_vertex(2);
        Vector3 vec = new Vector3(v0, v);
        boolean b0 = Vector3.dot_product(Vector3.cross_product(new Vector3(v0, v1), new Vector3(v0, v)), this.normal) >= 0.0;
        boolean b1 = Vector3.dot_product(Vector3.cross_product(new Vector3(v1, v2), new Vector3(v1, v)), this.normal) >= 0.0;
        boolean bl = b2 = Vector3.dot_product(Vector3.cross_product(new Vector3(v2, v0), new Vector3(v2, v)), this.normal) >= 0.0;
        if (b0 && b1 && b2) {
            Object[] result = new Object[]{plane.project(v), this};
            return result;
        }
        if (!b0 && b1 && b2) {
            Object[] result = new Object[]{this.edges(0).project_as_a_segment(v), this.edges(0)};
            return result;
        }
        if (b0 && !b1 && b2) {
            Object[] result = new Object[]{this.edges(1).project_as_a_segment(v), this.edges(1)};
            return result;
        }
        if (b0 && b1 && !b2) {
            Object[] result = new Object[]{this.edges(2).project_as_a_segment(v), this.edges(2)};
            return result;
        }
        if (!b0 && !b1 && b2) {
            Object[] result = new Object[]{new Vertex(v1), v1};
            return result;
        }
        if (!b0 && b1 && !b2) {
            Object[] result = new Object[]{new Vertex(v0), v0};
            return result;
        }
        if (b0 && !b1 && !b2) {
            Object[] result = new Object[]{new Vertex(v2), v2};
            return result;
        }
        System.out.println("error in Polygon2.project_as_a_segment (" + v.x + "," + v.y + "," + v.z + ")" + "(" + v0.x + "," + v0.y + "," + v0.z + ")" + "(" + v1.x + "," + v1.y + "," + v1.z + ")" + "(" + v2.x + "," + v2.y + "," + v2.z + ")");
        return null;
    }

    public Edge get_remaining_edge(Edge edge0, Edge edge1) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] != edge0 && this.edges[i] != edge1) {
                return this.edges[i];
            }
            ++i;
        }
        return null;
    }

    public Vertex get_vertex(int i) {
        return this.edges(i - 1).get_common_vertex(this.edges(i));
    }

    public LinkedList get_edges() {
        LinkedList edge_list = new LinkedList();
        int i = 0;
        while (i < this.n_edges) {
            edge_list.append(this.edges[i]);
            ++i;
        }
        return edge_list;
    }

    public void renew_network() {
        int i = 0;
        while (i < this.n_edges) {
            this.edges[i] = this.edges[i].child;
            if (this.edges[i] == null) {
                System.out.println("null in Polygon2.renew_network");
            }
            ++i;
        }
    }

    public Vector get_vertices() {
        Vector<Vertex> vertex_list = new Vector<Vertex>();
        int i = 0;
        while (i < this.n_edges) {
            vertex_list.addElement(this.get_vertex(i));
            ++i;
        }
        return vertex_list;
    }

    public void print_normal() {
        System.out.println("normal " + (int)(this.normal.x * 10.0) + "," + (int)(this.normal.y * 10.0) + "," + (int)(this.normal.z * 10.0));
    }

    public int get_vertex_index(Vertex v) {
        int i = 0;
        while (i < this.n_edges) {
            if (this.get_vertex(i) == v) {
                return i;
            }
            ++i;
        }
        System.out.println("Vertex not in Polygon (Polygon2.get_vertex_index)");
        return -1;
    }

    public int get_concave_vertex_index() {
        this.set_normal();
        int i = 0;
        while (i < this.n_edges) {
            if (this.is_concave(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean is_concave(int vertex_index) {
        Vertex base = this.get_vertex(vertex_index);
        double total_angle = 0.0;
        Vector3 prev_vector = new Vector3(this.get_vertex(vertex_index - 1), base);
        Vector3 next_vector = new Vector3(base, this.get_vertex(vertex_index + 1));
        Vector3 assumed_normal = prev_vector.cross_product(next_vector);
        if (prev_vector.parallel(next_vector) && prev_vector.dot_product(next_vector) > 0.0) {
            return true;
        }
        return this.normal.dot_product(assumed_normal) <= 0.0;
    }

    public boolean on_polygon(Vertex v) {
        this.set_normal();
        double total_angle = 0.0;
        Vertex base = v;
        Vector3 prev_vector = new Vector3(base, this.get_vertex(0));
        int i = 1;
        while (i < this.n_edges + 1) {
            Vector3 next_vector = new Vector3(base, this.get_vertex(i));
            double angle = prev_vector.get_relative_angle(next_vector);
            if (this.normal.dot_product(prev_vector.cross_product(next_vector)) < 0.0) {
                angle *= -1.0;
            }
            total_angle += angle;
            prev_vector = next_vector;
            ++i;
        }
        return total_angle > Math.PI;
    }

    private void add_edges(Enumeration e) {
        Edge current_edge;
        Edge first_edge = current_edge = (Edge)e.nextElement();
        int i = 0;
        while (i < this.n_edges - 1) {
            Edge next_edge = (Edge)e.nextElement();
            this.add_edge(i, current_edge, next_edge);
            current_edge = next_edge;
            ++i;
        }
        this.add_edge(this.n_edges - 1, current_edge, first_edge);
        this.set_normal();
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    private void add_edge(int i, Edge e, Edge next_edge) {
        this.edges[i] = e;
        if (next_edge.contain(e.end)) {
            e.set_left_polygon(this);
        } else {
            e.set_right_polygon(this);
        }
    }

    private Edge find_shared_edge(Vertex v0, Vertex v1) {
        Enumeration e1;
        Enumeration e0 = v0.edges.elements();
        while (e0.hasMoreElements()) {
            Edge edge = (Edge)e0.nextElement();
            e1 = v1.edges.elements();
            while (e1.hasMoreElements()) {
                if (edge != (Edge)e1.nextElement()) continue;
                return edge;
            }
        }
        System.out.println("error while searching shared edge (Polygon2.java)");
        e0 = v0.edges.elements();
        while (e0.hasMoreElements()) {
            System.out.print(" " + e0.nextElement());
        }
        System.out.println("");
        e1 = v1.edges.elements();
        while (e1.hasMoreElements()) {
            System.out.print(" " + e1.nextElement());
        }
        System.out.println("");
        return null;
    }

    public Objects get_the_other_edge(Vertex v) {
        int i = 0;
        i = 0;
        while (i < this.n_edges) {
            if (this.get_vertex(i) == v) break;
            ++i;
        }
        return new Objects(this.get_vertex(i - 1), this.get_vertex(i + 1));
    }

    public void set_distance(Vertex camera) {
        this.distance = Vector3.distance(camera, this.get_center());
    }

    public Edge get_opposite_edge(Vertex v) {
        int i = 0;
        i = 0;
        while (i < this.n_edges) {
            if (!this.edges[i].contain(v)) {
                return this.edges[i];
            }
            ++i;
        }
        return null;
    }

    public Edge get_common_edge(Polygon2 polygon) {
        int i = 0;
        while (i < 3) {
            Edge edge = this.edges[i];
            if (polygon.contains(edge)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public Vector3 absolute_normal() {
        return this.polyhedron.absolute_coords(this.normal);
    }

    Polygon2() {
        this.n_edges = 3;
        this.edges = new Edge[3];
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    Polygon2(Edge e0, Edge e1, Edge e2) {
        this.n_edges = 3;
        this.edges = new Edge[3];
        this.add_edge(0, e0, e1);
        this.add_edge(1, e1, e2);
        this.add_edge(2, e2, e0);
        this.set_normal();
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    Polygon2(Edge e0, Edge e1, Edge e2, Edge e3) {
        this.n_edges = 4;
        this.edges = new Edge[4];
        this.add_edge(0, e0, e1);
        this.add_edge(1, e1, e2);
        this.add_edge(2, e2, e3);
        this.add_edge(3, e3, e0);
        this.set_normal();
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    Polygon2(Vertex v0, Vertex v1, Vertex v2) {
        this.n_edges = 3;
        this.edges = new Edge[3];
        Edge e0 = this.find_shared_edge(v0, v1);
        Edge e1 = this.find_shared_edge(v1, v2);
        Edge e2 = this.find_shared_edge(v2, v0);
        this.add_edge(0, e0, e1);
        this.add_edge(1, e1, e2);
        this.add_edge(2, e2, e0);
        this.set_normal();
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    Polygon2(Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
        this.n_edges = 4;
        this.edges = new Edge[4];
        Edge e0 = this.find_shared_edge(v0, v1);
        Edge e1 = this.find_shared_edge(v1, v2);
        Edge e2 = this.find_shared_edge(v2, v3);
        Edge e3 = this.find_shared_edge(v3, v0);
        this.add_edge(0, e0, e1);
        this.add_edge(1, e1, e2);
        this.add_edge(2, e2, e3);
        this.add_edge(3, e3, e0);
        this.set_normal();
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    Polygon2(int n, Edge[] v) {
        this.n_edges = n;
        this.edges = new Edge[this.n_edges];
        int i = 0;
        while (i < this.n_edges - 1) {
            this.add_edge(i, v[i], v[i + 1]);
            ++i;
        }
        this.add_edge(n - 1, v[n - 1], v[0]);
        this.set_normal();
        this.front_facing = false;
        this.surface_lines = new LinkedList();
    }

    Polygon2(LinkedList l) {
        this.n_edges = l.size();
        this.edges = new Edge[this.n_edges];
        this.add_edges(l.elements());
    }

    Polygon2(Vector l) {
        this.n_edges = l.size();
        this.edges = new Edge[this.n_edges];
        this.add_edges(l.elements());
    }

    public Vector3 get_normal_simple() {
        int i = 0;
        while (i < this.n_edges - 1) {
            Vector3 vec0 = new Vector3(this.get_vertex(i - 1), this.get_vertex(i));
            Vector3 vec1 = new Vector3(this.get_vertex(i), this.get_vertex(i + 1));
            Vector3 temp_normal = vec0.cross_product(vec1);
            if (!vec0.parallel(vec1)) {
                return temp_normal;
            }
            ++i;
        }
        return null;
    }

    public Vertex get_opposite_vertex(Edge edge) {
        Vector vs = this.get_vertices();
        int i = 0;
        while (i < vs.size()) {
            Vertex v = (Vertex)vs.elementAt(i);
            if (!edge.contain(v)) {
                return v;
            }
            ++i;
        }
        System.out.println("error in Polygon2.get_opposite_vertex ");
        i = 0;
        while (i < 3) {
            System.out.println("" + this.edges[i] + " : " + this.edges[i].start.index + " - " + this.edges[i].end.index);
            ++i;
        }
        return null;
    }

    public boolean contains(Edge edge) {
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i] == edge) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Vertex vertex) {
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i].contain(vertex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    Polygon2(Edge e0, Edge e1, Edge e2, Patch patch) {
        this(e0, e1, e2);
        this.patch = patch;
    }

    Polygon2(LinkedList edges, Patch patch) {
        this(edges);
        this.patch = patch;
    }

    Polygon2(Edge e0, Edge e1, Edge e2, Polygon2 parent) {
        this(e0, e1, e2);
        this.patch = parent.patch;
        this.target_edge_length = parent.target_edge_length;
    }

    Polygon2(LinkedList edges, Polygon2 parent) {
        this(edges);
        this.patch = parent.patch;
        this.target_edge_length = parent.target_edge_length;
    }

    public Vertex project_as_a_segment(Vertex v) {
        Object[] result = this.find_closest_point(v);
        return (Vertex)result[0];
    }

    public double area() {
        Vector3 vec0 = this.edges[0].vector3();
        Vector3 vec1 = this.edges[1].vector3();
        return Vector3.cross_product(vec0, vec1).length() / 2.0;
    }

    public void check_facing(Vertex camera) {
        Vector3 polygon_normal;
        Vector3 camera_to_polygon = new Vector3(camera, this.edges(0).start());
        this.front_facing = camera_to_polygon.dot_product(polygon_normal = this.absolute_normal()) < 0.0;
    }

    public Polygon2 copy() {
        Polygon2 polygon = new Polygon2();
        polygon.edges = (Edge[])this.edges.clone();
        polygon.n_edges = this.n_edges;
        polygon.surface_lines = new LinkedList();
        polygon.normal = this.normal;
        polygon.front_facing = this.front_facing;
        polygon.index = this.index;
        polygon.patch = this.patch;
        polygon.target_edge_length = this.target_edge_length;
        this.child = polygon;
        return polygon;
    }

    public int get_edge_index(Edge e) {
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges(i) == e) {
                return i;
            }
            ++i;
        }
        System.out.println("Edge not in Polygon (Polygon2.get_edge_index)");
        return -1;
    }

    public Vertex get_center() {
        Vertex center = new Vertex();
        int i = 0;
        while (i < 3) {
            Vertex v = this.get_vertex(i);
            center.add_self(v);
            ++i;
        }
        center.multiple_self(0.3333333333333333);
        return center;
    }

    public Vertex get_circum_center() {
        Vertex v0 = this.get_vertex(0);
        Vertex v1 = this.get_vertex(1);
        Vertex v2 = this.get_vertex(2);
        Plane plane0 = new Plane(Vertex.mid_point(v0, v1), new Vector3(v0, v1));
        Plane plane1 = new Plane(Vertex.mid_point(v1, v2), new Vector3(v1, v2));
        Line line = Plane.cross_line(plane0, plane1);
        return new Plane(v0, v1, v2).cross_point(line);
    }

    public void edge_replace(Edge original_edge, Edge edge0, Edge edge1) {
        Edge[] new_edges = new Edge[this.n_edges + 1];
        int n = 0;
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i] != original_edge) {
                new_edges[n++] = this.edges[i];
            } else if (this.edges[i - 1].connected(edge0)) {
                this.add_edge(n++, edge0, edge1);
                this.add_edge(n++, edge1, this.edges[i + 1]);
            } else {
                this.add_edge(n++, edge1, edge0);
                this.add_edge(n++, edge0, this.edges[i + 1]);
            }
            ++i;
        }
        this.edges = new_edges;
        ++this.n_edges;
    }

    public void edge_replace(Edge original_edge, Edge edge0, Edge edge1, Edge edge2) {
        Edge[] new_edges = new Edge[this.n_edges + 2];
        int n = 0;
        int i = 0;
        while (i < this.n_edges) {
            if (this.edges[i] != original_edge) {
                new_edges[n++] = this.edges[i];
            } else if (this.edges[i - 1].connected(edge0)) {
                this.add_edge(n++, edge0, edge1);
                this.add_edge(n++, edge1, edge2);
                this.add_edge(n++, edge2, this.edges[i + 1]);
            } else {
                this.add_edge(n++, edge2, edge1);
                this.add_edge(n++, edge1, edge0);
                this.add_edge(n++, edge0, this.edges[i + 1]);
            }
            ++i;
        }
        this.edges = new_edges;
        this.n_edges += 2;
    }

    public Edge get_shortest_edge() {
        Edge shortest_edge = null;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.n_edges) {
            double len = this.edges[i].length();
            if (min > len) {
                shortest_edge = this.edges[i];
                min = len;
            }
            ++i;
        }
        return shortest_edge;
    }

    public void set_area() {
        this.area = this.area();
    }

    public void reverse_edges() {
        Edge edge = this.edges[1];
        this.edges[1] = this.edges[0];
        this.edges[0] = edge;
    }

    public double distance_as_a_segment(Vertex v) {
        Vertex u = this.project_as_a_segment(v);
        return Vector3.distance(u, v);
    }

    public void set_normal() {
        this.normal = this.calc_normal();
    }

    public Vector3 calc_normal() {
        Vertex v0 = this.get_vertex(0);
        Vertex v1 = this.get_vertex(1);
        Vertex v2 = this.get_vertex(2);
        if (v0 == null || v1 == null || v2 == null) {
            System.out.println("null in Polygon2.calc_normal()");
            return new Vector3();
        }
        Vector3 vec0 = new Vector3(v0, v1);
        Vector3 vec1 = new Vector3(v1, v2);
        Vector3 normal = Vector3.cross_product(vec0, vec1);
        normal.normalize_self();
        return normal;
    }

    public Vector3 _calc_normal() {
        int vertex_index = 0;
        double max_sin = 0.0;
        int i = 0;
        while (i < this.n_edges) {
            Vector3 next_vector;
            Vector3 prev_vector = new Vector3(this.get_vertex(i), this.get_vertex(i + 1));
            double sin = prev_vector.sin(next_vector = new Vector3(this.get_vertex(i), this.get_vertex(i - 1)));
            if (sin > max_sin) {
                max_sin = sin;
                vertex_index = i;
            }
            ++i;
        }
        Vertex base = this.get_vertex(vertex_index);
        double total_angle = 0.0;
        Vector3 prev_vector = new Vector3(this.get_vertex(vertex_index - 1), base);
        Vector3 next_vector = new Vector3(base, this.get_vertex(vertex_index + 1));
        Vector3 assumed_normal = prev_vector.cross_product(next_vector);
        prev_vector = new Vector3(base, this.get_vertex(vertex_index + 1));
        int i2 = vertex_index + 2;
        while (i2 < this.n_edges + vertex_index) {
            next_vector = new Vector3(base, this.get_vertex(i2));
            double angle = prev_vector.get_relative_angle(next_vector);
            if (assumed_normal.dot_product(prev_vector.cross_product(next_vector)) < 0.0) {
                angle *= -1.0;
            }
            total_angle += angle;
            prev_vector = next_vector;
            ++i2;
        }
        if (total_angle < 0.0) {
            assumed_normal.multiple_self(-1.0);
        }
        return assumed_normal.get_normalized();
    }
}

