/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import teddy.Edge;
import teddy.Line;
import teddy.Vector3;
import teddy.Vertex;

class Plane {
    public Vertex base;
    public Vector3 normal;

    public Vertex cross_point(Edge edge) {
        double start_to_surface = this.signed_distance(edge.start);
        double end_to_surface = this.signed_distance(edge.end);
        double start_to_end = start_to_surface - end_to_surface;
        return new Vertex(edge.start.add(edge.vector3().multiple(start_to_surface / start_to_end)));
    }

    public Vertex cross_point(Line line) {
        double plane_to_linebase = this.signed_distance(line.base);
        double cos = -this.normal.cos(line.direction);
        return new Vertex(line.base.add(line.direction.multiple(plane_to_linebase / cos)));
    }

    Plane() {
        this.base = new Vertex();
        this.normal = new Vector3();
    }

    Plane(Vertex _base, Vector3 _normal) {
        this.base = _base;
        this.normal = _normal;
        this.normal.normalize();
    }

    Plane(Vertex v0, Vertex v1, Vertex v2) {
        Vector3 vec0 = new Vector3(v0, v1);
        Vector3 vec1 = new Vector3(v0, v2);
        this.normal = vec0.cross_product(vec1);
        this.base = v0;
        this.normal.normalize();
    }

    public static Line cross_line(Plane plane0, Plane plane1) {
        Vector3 normal = Vector3.cross_product(plane0.normal, plane1.normal);
        Vector3 vector = new Vector3(plane0.base, plane1.base);
        vector = Vector3.subtract(vector, Vector3.multiply(plane0.normal, Vector3.dot_product(plane0.normal, vector)));
        Line line0 = new Line(plane0.base, vector);
        Vertex base = plane1.cross_point(line0);
        return new Line(base, normal);
    }

    public double angle(Vector3 v) {
        double angle = this.normal.get_relative_angle(v);
        return Math.abs(angle - 1.5707963267948966);
    }

    public static Plane get_normal_surface(Vertex prev_vertex, Vertex center_vertex, Vertex next_vertex) {
        Vector3 vector0 = new Vector3(prev_vertex, center_vertex);
        Vector3 vector1 = new Vector3(center_vertex, next_vertex);
        vector0.normalize();
        vector1.normalize();
        return new Plane(center_vertex, vector0.add(vector1));
    }

    public Vertex project(Vertex v) {
        Vector3 vec = new Vector3(v, this.base);
        double l = Vector3.dot_product(vec, this.normal);
        vec = Vector3.multiply(this.normal, l);
        return Vertex.translate(v, vec);
    }

    public double signed_distance(Vertex v) {
        Vector3 vector = new Vector3(this.base, v);
        return this.normal.dot_product(vector);
    }

    public double distance(Vertex v) {
        Vector3 vector = new Vector3(this.base, v);
        return Math.abs(this.normal.dot_product(vector));
    }
}

