/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.DoubleSVD;
import java.util.Enumeration;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;

public class PNsubdivision {
    public static Vector3 get_new_position(Vertex v, Edge edge) {
        if (edge.sharp) {
            return PNsubdivision.get_new_position_crease(v, edge);
        }
        Vector3 sum = new Vector3();
        sum.add_self(edge.start);
        sum.add_self(edge.end);
        sum.multiple_self(3.0);
        Vertex v0 = edge.left_polygon.get_opposite_vertex(edge);
        Vertex v1 = edge.right_polygon.get_opposite_vertex(edge);
        sum.add_self(v0);
        sum.add_self(v1);
        sum.multiple_self(0.125);
        return sum;
    }

    public static Vertex calculate_position(Vertex body_vertex, Object body_element) {
        if (body_element instanceof Vertex) {
            return body_vertex;
        }
        if (body_element instanceof Polygon2) {
            Polygon2 polygon = (Polygon2)body_element;
            Vertex p1 = polygon.get_vertex(0);
            Vertex p2 = polygon.get_vertex(1);
            Vertex p3 = polygon.get_vertex(2);
            Vector3 v12 = new Vector3(p1, p2);
            Vector3 v13 = new Vector3(p1, p3);
            Vector3 v10 = new Vector3(p1, body_vertex);
            double[] b = new double[]{v10.x, v10.y, v10.z};
            double[][] A = new double[][]{{v12.x, v13.x}, {v12.y, v13.y}, {v12.z, v13.z}};
            double[] x = null;
            try {
                DoubleSVD doubleSVD;
                DoubleSVD svd = doubleSVD = new DoubleSVD((double[][])A);
                x = DoubleMatrix.multiply((double[][])svd.inverse(), (double[])b);
            }
            catch (Exception e) {
                System.out.println("" + e);
            }
            double u = x[0];
            double v = x[1];
            double w = 1.0 - v - u;
            Vector3 n1 = p1.normal;
            Vector3 n2 = p2.normal;
            Vector3 n3 = p3.normal;
            if (p1.on_sharp()) {
                n1 = p1.get_sharp_normal(polygon);
            }
            if (p2.on_sharp()) {
                n2 = p2.get_sharp_normal(polygon);
            }
            if (p3.on_sharp()) {
                n3 = p3.get_sharp_normal(polygon);
            }
            Vertex b300 = p1;
            Vertex b030 = p2;
            Vertex b003 = p3;
            double w12 = Vector3.subtract(p2, p1).dot_product(n1);
            double w21 = Vector3.subtract(p1, p2).dot_product(n2);
            double w23 = Vector3.subtract(p3, p2).dot_product(n2);
            double w32 = Vector3.subtract(p2, p3).dot_product(n3);
            double w31 = Vector3.subtract(p1, p3).dot_product(n3);
            double w13 = Vector3.subtract(p3, p1).dot_product(n1);
            Vector3 b210 = p1.multiple(2.0).add(p2).subtract(n1.multiple(w12));
            Vector3 b120 = p2.multiple(2.0).add(p1).subtract(n2.multiple(w21));
            Vector3 b021 = p2.multiple(2.0).add(p3).subtract(n2.multiple(w23));
            Vector3 b012 = p3.multiple(2.0).add(p2).subtract(n3.multiple(w32));
            Vector3 b102 = p3.multiple(2.0).add(p1).subtract(n3.multiple(w31));
            Vector3 b201 = p1.multiple(2.0).add(p3).subtract(n1.multiple(w13));
            Vector3 E = b210.add(b120).add(b021).add(b012).add(b102).add(b201);
            Vector3 V = p1.add(p2).add(p3);
            Vector3 b111 = E.multiple(0.5).subtract(V);
            Vector3 total = Vector3.multiply(b300, w * w * w);
            total.add_self(Vector3.multiply(b030, u * u * u));
            total.add_self(Vector3.multiply(b003, v * v * v));
            total.add_self(Vector3.multiply(b210, w * w * u));
            total.add_self(Vector3.multiply(b120, w * u * u));
            total.add_self(Vector3.multiply(b201, w * w * v));
            total.add_self(Vector3.multiply(b021, u * u * v));
            total.add_self(Vector3.multiply(b102, w * v * v));
            total.add_self(Vector3.multiply(b012, u * v * v));
            total.add_self(Vector3.multiply(b111, w * u * v));
            return new Vertex(total);
        }
        if (body_element instanceof Edge) {
            Edge edge = (Edge)body_element;
            double u = Vector3.distance(edge.start, body_vertex) / edge.length();
            double w = 1.0 - u;
            Vertex p1 = edge.start;
            Vertex p2 = edge.end;
            Vector3 n1 = edge.start.normal;
            Vector3 n2 = edge.end.normal;
            if (p1.on_sharp() && !edge.sharp) {
                n1 = p1.get_sharp_normal(edge.left_polygon);
            }
            if (p2.on_sharp() && !edge.sharp) {
                n2 = p2.get_sharp_normal(edge.left_polygon);
            }
            Vertex b300 = p1;
            Vertex b030 = p2;
            double w12 = Vector3.subtract(p2, p1).dot_product(n1);
            double w21 = Vector3.subtract(p1, p2).dot_product(n2);
            Vector3 b210 = p1.multiple(2.0).add(p2).subtract(n1.multiple(w12));
            Vector3 b120 = p2.multiple(2.0).add(p1).subtract(n2.multiple(w21));
            if (edge.sharp) {
                Vector3 T1 = Vector3.cross_product(p1.get_sharp_normal(edge.left_polygon), p1.get_sharp_normal(edge.right_polygon));
                T1.normalize_self();
                Vector3 T2 = Vector3.cross_product(p2.get_sharp_normal(edge.left_polygon), p2.get_sharp_normal(edge.right_polygon));
                T2.normalize_self();
                b210 = p1.add(T1.multiple(Vector3.dot_product(p2.subtract(p1), T1) / 3.0)).multiple(3.0);
                b120 = p2.add(T2.multiple(Vector3.dot_product(p1.subtract(p2), T2) / 3.0)).multiple(3.0);
            }
            Vector3 total = Vector3.multiply(b300, w * w * w);
            total.add_self(Vector3.multiply(b030, u * u * u));
            total.add_self(Vector3.multiply(b210, w * w * u));
            total.add_self(Vector3.multiply(b120, w * u * u));
            return new Vertex(total);
        }
        System.out.println("error in PNsubdiviiton.culculate_position()");
        return null;
    }

    public static Vector3 get_new_position_crease(Vertex v) {
        if (v.fixed) {
            return new Vector3(v);
        }
        Vector3 sum = new Vector3();
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            Vertex w = edge.get_the_other_vertex(v);
            sum.add_self(w);
        }
        Vector3 original = v.copyVector3();
        original.multiple_self(6.0);
        sum.add_self(original);
        sum.multiple_self(0.125);
        return sum;
    }

    public static Vector3 get_new_position_crease(Vertex v, Edge edge) {
        Vector3 sum = new Vector3();
        sum.add_self(edge.start);
        sum.add_self(edge.end);
        sum.multiple_self(0.5);
        return sum;
    }

    public static boolean is_crease_vertex(Vertex v) {
        int crease_count = 0;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            ++crease_count;
        }
        return crease_count >= 2;
    }

    public static void subdivide(Polyhedron h) {
        Edge edge;
        h._vertices = new LinkedList();
        h._edges = new LinkedList();
        h._polygons = new LinkedList();
        Vector3[] new_edge_positions = new Vector3[h.n_edges];
        int i = 0;
        while (i < h.n_edges) {
            Vector3 b;
            edge = h.edges[i];
            Vertex p1 = edge.start;
            Vertex p2 = edge.end;
            Vector3 n1 = edge.start.normal;
            Vector3 n2 = edge.end.normal;
            if (edge.start.on_sharp()) {
                n1 = p1.get_sharp_normal(edge.left_polygon);
            }
            if (edge.end.on_sharp()) {
                n2 = p2.get_sharp_normal(edge.right_polygon);
            }
            Vertex b300 = p1;
            Vertex b030 = p2;
            double w12 = Vector3.subtract(p2, p1).dot_product(n1);
            double w21 = Vector3.subtract(p1, p2).dot_product(n2);
            Vector3 b210 = p1.multiple(2.0).add(p2).subtract(n1.multiple(w12));
            Vector3 b120 = p2.multiple(2.0).add(p1).subtract(n2.multiple(w21));
            if (edge.sharp) {
                Vector3 T1 = Vector3.cross_product(p1.get_sharp_normal(edge.left_polygon), p1.get_sharp_normal(edge.right_polygon));
                T1.normalize_self();
                Vector3 T2 = Vector3.cross_product(p2.get_sharp_normal(edge.left_polygon), p2.get_sharp_normal(edge.right_polygon));
                T2.normalize_self();
                b210 = p1.add(T1.multiple(Vector3.dot_product(p2.subtract(p1), T1) / 3.0)).multiple(3.0);
                b120 = p2.add(T2.multiple(Vector3.dot_product(p1.subtract(p2), T2) / 3.0)).multiple(3.0);
            }
            new_edge_positions[i] = b = b300.add(b030).add(b210).add(b120).multiple(0.125);
            ++i;
        }
        i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            h._vertices.append(v);
            ++i;
        }
        i = 0;
        while (i < h.n_edges) {
            Vertex mid_vertex = h.edges[i].get_mid_vertex();
            mid_vertex.warp(new_edge_positions[i]);
            h._vertices.append(mid_vertex);
            h._edges.append(new Edge(h.edges[i].start, mid_vertex, h.edges[i].sharp));
            h._edges.append(new Edge(mid_vertex, h.edges[i].end, h.edges[i].sharp));
            ++i;
        }
        i = 0;
        while (i < h.n_polygons) {
            Polygon2 polygon = h.polygons[i];
            Vertex v0 = polygon.get_vertex(0);
            Vertex v1 = polygon.edges[0].mid_vertex;
            Vertex v2 = polygon.get_vertex(1);
            Vertex v3 = polygon.edges[1].mid_vertex;
            Vertex v4 = polygon.get_vertex(2);
            Vertex v5 = polygon.edges[2].mid_vertex;
            Edge edge13 = new Edge(v1, v3);
            Edge edge35 = new Edge(v3, v5);
            Edge edge51 = new Edge(v5, v1);
            Edge edge01 = v0.get_shared_edge(v1);
            Edge edge12 = v1.get_shared_edge(v2);
            Edge edge23 = v2.get_shared_edge(v3);
            Edge edge34 = v3.get_shared_edge(v4);
            Edge edge45 = v4.get_shared_edge(v5);
            Edge edge50 = v5.get_shared_edge(v0);
            edge01.seam = edge12.seam = polygon.edges((int)0).seam;
            edge23.seam = edge34.seam = polygon.edges((int)1).seam;
            edge45.seam = edge50.seam = polygon.edges((int)2).seam;
            edge01.sharp = edge12.sharp = polygon.edges((int)0).sharp;
            edge23.sharp = edge34.sharp = polygon.edges((int)1).sharp;
            edge45.sharp = edge50.sharp = polygon.edges((int)2).sharp;
            h._polygons.append(new Polygon2(edge13, edge35, edge51, polygon.patch));
            h._polygons.append(new Polygon2(edge01, edge51, edge50, polygon.patch));
            h._polygons.append(new Polygon2(edge12, edge23, edge13, polygon.patch));
            h._polygons.append(new Polygon2(edge34, edge45, edge35, polygon.patch));
            h._edges.append(edge13);
            h._edges.append(edge35);
            h._edges.append(edge51);
            ++i;
        }
        i = 0;
        while (i < h.n_edges) {
            edge = h.edges[i];
            edge.start.remove_edge(edge);
            edge.end.remove_edge(edge);
            ++i;
        }
        int c = 0;
        Enumeration e = h._edges.elements();
        while (e.hasMoreElements()) {
            Edge edge2 = (Edge)e.nextElement();
            if (edge2.left_polygon() != null && edge2.right_polygon() != null) continue;
            ++c;
        }
        h.postprocess_list_to_array();
        h.set_parameters();
    }

    public static Vector3 get_new_position(Vertex v) {
        if (PNsubdivision.is_crease_vertex(v)) {
            return PNsubdivision.get_new_position_crease(v);
        }
        Vector3 sum = new Vector3();
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex w = edge.get_the_other_vertex(v);
            sum.add_self(w);
        }
        sum.multiple_self(3.0 / (double)v.edges.size());
        Vector3 original = v.copyVector3();
        original.multiple_self(5.0);
        sum.add_self(original);
        sum.multiple_self(0.125);
        return sum;
    }
}

