/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import teddy.Edge;
import teddy.Objects;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.SurfaceLine;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

class ObjFileHandler {
    ObjFileHandler() {
    }

    public static void convert(String filename) {
        double x_step;
        double z_step;
        double size;
        Polyhedron polyhedron = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            polyhedron = ObjFileHandler.load(in);
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
        Vector<Vertex> vertices = new Vector<Vertex>();
        Vector faces = new Vector();
        int i = 0;
        while (i < polyhedron.n_vertices) {
            Vertex v = polyhedron.vertices[i];
            vertices.addElement(v);
            v.index = i++;
        }
        i = 0;
        while (i < polyhedron.n_polygons) {
            Polygon2 p = polyhedron.polygons[i];
            Vector<Integer> indices = new Vector<Integer>();
            int j = 0;
            while (j < p.n_edges) {
                indices.addElement(new Integer(p.get_vertex((int)j).index + 1));
                ++j;
            }
            faces.addElement(indices);
            ++i;
        }
        int original_vertices_size = vertices.size();
        boolean[] used = new boolean[vertices.size() + 1];
        int i2 = 0;
        while (i2 < vertices.size() + 1) {
            used[i2] = false;
            ++i2;
        }
        int new_index = vertices.size() + 1;
        Vector new_faces = new Vector();
        int i3 = 0;
        while (i3 < faces.size()) {
            Vector new_indices = (Vector)faces.elementAt(i3);
            Vector reversed = new Vector();
            reversed.addElement(new_indices.elementAt(2));
            reversed.addElement(new_indices.elementAt(1));
            reversed.addElement(new_indices.elementAt(0));
            new_faces.addElement(reversed);
            ++i3;
        }
        faces = new_faces;
        double z_min = 0.0;
        double z_max = 0.0;
        double x_min = 0.0;
        double x_max = 0.0;
        int i4 = 0;
        while (i4 < original_vertices_size) {
            Vertex v = (Vertex)vertices.elementAt(i4);
            if (v.z < z_min) {
                z_min = v.z;
            }
            if (v.z > z_max) {
                z_max = v.z;
            }
            if (v.x < x_min) {
                x_min = v.x;
            }
            if (v.x > x_max) {
                x_max = v.x;
            }
            ++i4;
        }
        double x_size = x_max - x_min;
        double z_size = z_max - z_min;
        if (x_size > z_size) {
            size = Math.max(x_size, z_size * 2.0);
            z_step = z_size / size;
            x_step = 0.0;
        } else {
            size = Math.max(x_size * 2.0, z_size);
            x_step = x_size / size;
            z_step = 0.0;
        }
        Vector<Vertex2D> texture_coords = new Vector<Vertex2D>();
        Vector faces_texture = new Vector();
        int[] texture_coords_front = new int[vertices.size() + 1];
        int[] texture_coords_back = new int[vertices.size() + 1];
        int i5 = 0;
        while (i5 < faces.size()) {
            Vector indices = (Vector)faces.elementAt(i5);
            Vector<Integer> texture_indices = new Vector<Integer>();
            int j = 0;
            while (j < indices.size()) {
                int index = (Integer)indices.elementAt(j);
                int texture_index = texture_coords_front[index];
                if (!polyhedron.polygons[i5].front_facing) {
                    texture_index = texture_coords_back[index];
                }
                if (texture_index == 0) {
                    Vertex v = (Vertex)vertices.elementAt(index - 1);
                    double x = (v.x - x_min) / size;
                    double z = (v.z - z_min) / size;
                    if (!polyhedron.polygons[i5].front_facing) {
                        x += x_step;
                        z += z_step;
                    }
                    z = 1.0 - z;
                    texture_coords.addElement(new Vertex2D(x, z));
                    texture_index = texture_coords.size();
                    if (polyhedron.polygons[i5].front_facing) {
                        texture_coords_front[index] = texture_index;
                    } else {
                        texture_coords_back[index] = texture_index;
                    }
                }
                texture_indices.addElement(new Integer(texture_index));
                ++j;
            }
            faces_texture.addElement(texture_indices);
            ++i5;
        }
        try {
            Object v;
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i6 = 0;
            while (i6 < vertices.size()) {
                v = (Vertex)vertices.elementAt(i6);
                String line = "v " + ((Vector3)v).x + " " + ((Vector3)v).y + " " + ((Vector3)v).z;
                out.write(line, 0, line.length());
                out.newLine();
                ++i6;
            }
            i6 = 0;
            while (i6 < texture_coords.size()) {
                v = (Vertex2D)texture_coords.elementAt(i6);
                String line = "vt " + ((Vector2)v).x + " " + ((Vector2)v).y;
                out.write(line, 0, line.length());
                out.newLine();
                ++i6;
            }
            i6 = 0;
            while (i6 < faces.size()) {
                Vector indices = (Vector)faces.elementAt(i6);
                Vector texture_indices = (Vector)faces_texture.elementAt(i6);
                String line = "f";
                int j = 0;
                while (j < indices.size()) {
                    int index = (Integer)indices.elementAt(j);
                    int texture_index = (Integer)texture_indices.elementAt(j);
                    line = line + " " + index + "/" + texture_index + "";
                    ++j;
                }
                out.write(line, 0, line.length());
                out.newLine();
                ++i6;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }

    public static void main(String[] args) {
        ObjFileHandler.convert(args[0]);
    }

    /*
     * Unable to fully structure code
     */
    public static Polyhedron load(BufferedReader in) {
        vertices = new Vector<Vertex>();
        faces = new Vector<Vector<E>>();
        sharp_edges = new Vector<Objects>();
        surface_lines = new Vector<Objects>();
lbl5:
        // 3 sources

        try {
            while ((line = in.readLine()) != null && !line.equals("# end of part")) {
                block9: {
                    st = new StringTokenizer(line);
                    if (!st.hasMoreTokens()) continue;
                    head = st.nextToken();
                    if (head.equals("v")) {
                        x = new Double(st.nextToken());
                        y = new Double(st.nextToken());
                        z = new Double(st.nextToken());
                        vertices.addElement(new Vertex(x, -z, y));
                        continue;
                    }
                    if (head.equals("f")) {
                        v = new Vector<Integer>();
                        while (st.hasMoreTokens()) {
                            str = st.nextToken();
                            n = str.indexOf("/");
                            if (n != -1) {
                                str = str.substring(0, n);
                            }
                            index = new Integer(str) - 1;
                            v.addElement(new Integer(index));
                        }
                        faces.addElement(v);
                        continue;
                    }
                    if (!head.equals("#se")) break block9;
                    while (st.hasMoreTokens()) {
                        start = new Integer(st.nextToken());
                        end = new Integer(st.nextToken());
                        sharp_edges.addElement(new Objects(new Integer(start), new Integer(end)));
                    }
                    ** GOTO lbl5
                }
                if (!head.equals("#sl")) continue;
                while (st.hasMoreTokens()) {
                    x0 = new Double(st.nextToken());
                    y0 = new Double(st.nextToken());
                    z0 = new Double(st.nextToken());
                    x1 = new Double(st.nextToken());
                    y1 = new Double(st.nextToken());
                    z1 = new Double(st.nextToken());
                    start = new Vertex(x0, -z0, y0);
                    end = new Vertex(x1, -z1, y1);
                    polygon_index = new Integer(st.nextToken());
                    surface_lines.addElement(new Objects(start, end, polygon_index));
                }
                ** GOTO lbl5
            }
            in.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
        return new Polyhedron(vertices, faces, sharp_edges, surface_lines);
    }

    public static void save(Polyhedron polyhedron, String filename) {
        Vector<Vertex> vertices = new Vector<Vertex>();
        Vector faces = new Vector();
        int i = 0;
        while (i < polyhedron.n_vertices) {
            Vertex v = polyhedron.vertices[i];
            vertices.addElement(v);
            v.index = i++;
        }
        i = 0;
        while (i < polyhedron.n_polygons) {
            Polygon2 p = polyhedron.polygons[i];
            p.index = i;
            Vector<Integer> indices = new Vector<Integer>();
            int j = 0;
            while (j < p.n_edges) {
                indices.addElement(new Integer(p.get_vertex((int)j).index + 1));
                ++j;
            }
            faces.addElement(indices);
            ++i;
        }
        Vector<Objects> sharp_edges = new Vector<Objects>();
        int i2 = 0;
        while (i2 < polyhedron.n_edges) {
            Edge edge = polyhedron.edges[i2];
            if (edge.sharp) {
                sharp_edges.addElement(new Objects(new Integer(edge.start.index), new Integer(edge.end.index)));
            }
            ++i2;
        }
        Vector<SurfaceLine> surface_lines = new Vector<SurfaceLine>();
        Enumeration e = polyhedron.surface_lines.elements();
        while (e.hasMoreElements()) {
            SurfaceLine edge = (SurfaceLine)e.nextElement();
            surface_lines.addElement(edge);
        }
        try {
            String line;
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i3 = 0;
            while (i3 < vertices.size()) {
                Vertex v = (Vertex)vertices.elementAt(i3);
                line = "v " + v.x + " " + v.z + " " + -v.y;
                out.write(line, 0, line.length());
                out.newLine();
                ++i3;
            }
            i3 = 0;
            while (i3 < faces.size()) {
                Vector indices = (Vector)faces.elementAt(i3);
                line = "f";
                int j = 0;
                while (j < indices.size()) {
                    line = line + " " + ((Integer)indices.elementAt(j)).toString();
                    ++j;
                }
                out.write(line, 0, line.length());
                out.newLine();
                ++i3;
            }
            i3 = 0;
            while (i3 < surface_lines.size()) {
                String line2 = "#sl";
                SurfaceLine edge = (SurfaceLine)surface_lines.elementAt(i3);
                line2 = line2 + " " + edge.start.x + " " + edge.start.z + " " + -edge.start.y;
                line2 = line2 + " " + edge.end.x + " " + edge.end.z + " " + -edge.end.y;
                line2 = line2 + " " + edge.polygon.index;
                out.write(line2, 0, line2.length());
                out.newLine();
                ++i3;
            }
            String line3 = "#se";
            int i4 = 0;
            while (i4 < sharp_edges.size()) {
                Objects objects = (Objects)sharp_edges.elementAt(i4);
                line3 = line3 + " " + ((Integer)objects.get(0)).toString() + " " + ((Integer)objects.get(1)).toString();
                ++i4;
            }
            out.write(line3, 0, line3.length());
            out.newLine();
            out.flush();
            out.close();
        }
        catch (IOException e2) {
            System.out.print("IO Error " + e2);
        }
    }
}

