/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import teddy.LinkedList;
import teddy.Polyhedron;
import teddy.Vertex;
import teddy.Vertex2D;

class NewPolyhedron
extends Polyhedron {
    public void add_temp_polygon(double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2) {
        this.tmp_polygons.append(new Polyhedron.TmpPolygon(this, this.get_vertex(x0, y0, z0), this.get_vertex(x1, y1, z1), this.get_vertex(x2, y2, z2)));
    }

    public void add_temp_polygon(double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        this.tmp_polygons.append(new Polyhedron.TmpPolygon(this, this.get_vertex(x0, y0, z0), this.get_vertex(x1, y1, z1), this.get_vertex(x2, y2, z2), this.get_vertex(x3, y3, z3)));
    }

    NewPolyhedron() {
        this.tmp_polygons = new LinkedList();
        this._vertices = new LinkedList();
        this._edges = new LinkedList();
        this._polygons = new LinkedList();
    }

    NewPolyhedron(LinkedList stroke) {
        this.tmp_polygons = new LinkedList();
        this._vertices = new LinkedList();
        this._edges = new LinkedList();
        this._polygons = new LinkedList();
        Enumeration e = stroke.elements();
        Vertex2D center = new Vertex2D(0.0, 0.0);
        while (e.hasMoreElements()) {
            Vertex2D point = (Vertex2D)e.nextElement();
            center.x += point.x;
            center.y += point.y;
        }
        center.x /= (double)stroke.size();
        center.y /= (double)stroke.size();
        e = stroke.elements();
        Vertex2D prev = (Vertex2D)e.nextElement();
        int steps = 4;
        while (e.hasMoreElements()) {
            Vertex2D next = (Vertex2D)e.nextElement();
            double x0 = prev.x;
            double y0 = prev.y;
            double x1 = next.x;
            double y1 = next.y;
            int i = -steps;
            while (i < steps) {
                double r0 = Math.cos(Math.PI * (double)i / (double)steps / 2.0);
                double h0 = Math.sin(Math.PI * (double)i / (double)steps / 2.0) / 2.0;
                double r1 = Math.cos(Math.PI * (double)(i + 1) / (double)steps / 2.0);
                double h1 = Math.sin(Math.PI * (double)(i + 1) / (double)steps / 2.0) / 2.0;
                double xx0 = center.x + (x0 - center.x) * r0;
                double yy0 = center.y + (y0 - center.y) * r0;
                double xx1 = center.x + (x1 - center.x) * r0;
                double yy1 = center.y + (y1 - center.y) * r0;
                double xx2 = center.x + (x1 - center.x) * r1;
                double yy2 = center.y + (y1 - center.y) * r1;
                double xx3 = center.x + (x0 - center.x) * r1;
                double yy3 = center.y + (y0 - center.y) * r1;
                if (i == -steps) {
                    this.tmp_polygons.append(new Polyhedron.TmpPolygon(this, this.get_vertex(center.x, h0, center.y), this.get_vertex(xx3, h1, yy3), this.get_vertex(xx2, h1, yy2)));
                } else if (i == steps - 1) {
                    this.tmp_polygons.append(new Polyhedron.TmpPolygon(this, this.get_vertex(xx1, h0, yy1), this.get_vertex(xx0, h0, yy0), this.get_vertex(center.x, h1, center.y)));
                } else {
                    this.tmp_polygons.append(new Polyhedron.TmpPolygon(this, this.get_vertex(xx3, h1, yy3), this.get_vertex(xx2, h1, yy2), this.get_vertex(xx1, h0, yy1), this.get_vertex(xx0, h0, yy0)));
                }
                ++i;
            }
            prev = next;
        }
        this.postprocess_no_normalize();
    }

    public void generate_polygons() {
        this.postprocess_no_normalize();
    }

    public void add_tmp_polygon(Vertex v0, Vertex v1, Vertex v2) {
        this.tmp_polygons.append(new Polyhedron.TmpPolygon(this, v0, v1, v2));
    }
}

