/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Edge;
import teddy.Fillet;
import teddy.Path;
import teddy.PathElement;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Pop;
import teddy.Seam;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class Merge {
    public static Path path;
    public static Vector surfacePaths;

    public static SurfacePath merge(Polyhedron main, Polyhedron sub, boolean smooth) {
        Edge edge;
        Polygon2 polygon;
        Edge edge2;
        int j;
        Polygon2 polygon2;
        Path path = Merge.get_path(main, sub);
        if (path == null) {
            return null;
        }
        SurfacePath main_surfacePath = new SurfacePath(main);
        SurfacePath sub_surfacePath = new SurfacePath(sub);
        Hashtable<Vertex, Vertex> sub_vertex_to_main_vertex = new Hashtable<Vertex, Vertex>();
        int i = 0;
        while (i < path.size()) {
            PathElement pe = (PathElement)path.elementAt(i);
            Vertex main_vertex = pe.vertex;
            Vertex sub_vertex = new Vertex(main_vertex);
            sub_vertex_to_main_vertex.put(sub_vertex, main_vertex);
            if (pe.on_main_edge()) {
                main_surfacePath.add(main_vertex, pe.main_edge);
                sub_surfacePath.add(sub_vertex, pe.sub_polygon);
            } else {
                main_surfacePath.add(main_vertex, pe.main_polygon);
                sub_surfacePath.add(sub_vertex, pe.sub_edge);
            }
            ++i;
        }
        main_surfacePath.bring_PolygonVertex_first();
        Object[] result = Pop.remesh(main, main_surfacePath);
        Vector main_boundary_edges = (Vector)result[0];
        Vector main_patch_polygons = (Vector)result[1];
        int i2 = 0;
        while (i2 < main.n_polygons) {
            polygon2 = main.polygons[i2];
            j = 0;
            while (j < 3) {
                edge2 = polygon2.edges[j];
                if (!main.contains(edge2)) {
                    System.out.println("broken edge in polygon 0 " + polygon2 + " " + polygon2.edges[j] + " " + polygon2.edges[j].delaunay_edge);
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < main_patch_polygons.size()) {
            polygon2 = (Polygon2)main_patch_polygons.elementAt(i2);
            main.remove(polygon2);
            ++i2;
        }
        i2 = 0;
        while (i2 < main.n_polygons) {
            polygon2 = main.polygons[i2];
            j = 0;
            while (j < 3) {
                edge2 = polygon2.edges[j];
                if (!main.contains(edge2)) {
                    System.out.println("broken edge in polygon 1 " + polygon2 + " " + polygon2.edges[j] + " " + polygon2.edges[j].delaunay_edge);
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < main_boundary_edges.size()) {
            Edge edge0 = (Edge)main_boundary_edges.elementAt(i2);
            Edge edge1 = (Edge)main_boundary_edges.elementAt(Util.mod(i2 + 1, main_boundary_edges.size()));
            if (edge0.right_polygon != null && edge1.right_polygon != null) {
                System.out.println("" + edge0 + " " + edge1 + " : " + edge0.start + " " + edge0.end + " " + edge1.end);
                Polygon2 poly = edge0.get_common_polygon(edge1);
                System.out.println("" + poly + " " + poly.edges[0] + " " + poly.edges[1] + " " + poly.edges[2]);
                System.out.println("recovering in Merge " + edge0 + " " + edge1 + " " + poly);
                edge0.left_polygon = poly;
                edge1.left_polygon = poly;
                edge0.right_polygon = null;
                edge1.right_polygon = null;
                Edge edge22 = poly.get_remaining_edge(edge0, edge1);
                if (edge22.left_polygon == null) {
                    edge22.left_polygon = poly;
                } else if (edge22.right_polygon == null) {
                    edge22.right_polygon = poly;
                } else {
                    System.out.println("recovery failed in Merge " + edge22 + " " + poly);
                }
                Edge tmp_edge = poly.edges[0];
                poly.edges[0] = poly.edges[1];
                poly.edges[1] = tmp_edge;
            }
            ++i2;
        }
        result = Pop.remesh(sub, sub_surfacePath, false, false);
        Vector sub_boundary_edges = (Vector)result[0];
        Vector sub_patch_polygons = (Vector)result[1];
        if (sub_boundary_edges.size() != main_boundary_edges.size()) {
            System.out.println("boundary_edges doesnot match");
        }
        Seam seam = new Seam();
        Hashtable<Edge, Edge> sub_edge_to_main_edge = new Hashtable<Edge, Edge>();
        int i3 = 0;
        while (i3 < sub_boundary_edges.size()) {
            Edge sub_edge = (Edge)sub_boundary_edges.elementAt(i3);
            Vertex main_start = (Vertex)sub_vertex_to_main_vertex.get(sub_edge.start);
            Vertex main_end = (Vertex)sub_vertex_to_main_vertex.get(sub_edge.end);
            Edge main_edge = main_start.get_common_edge(main_end);
            sub_edge_to_main_edge.put(sub_edge, main_edge);
            main_edge.seam = seam;
            main_edge.sharp = true;
            ++i3;
        }
        sub.set_indices();
        i3 = 0;
        while (i3 < sub.n_edges) {
            sub.edges[i3].index = -1;
            ++i3;
        }
        Vector<Edge> new_sub_edges = new Vector<Edge>();
        int i4 = 0;
        while (i4 < sub_patch_polygons.size()) {
            polygon = (Polygon2)sub_patch_polygons.elementAt(i4);
            main.append(polygon);
            int j2 = 0;
            while (j2 < polygon.n_edges) {
                if (sub_edge_to_main_edge.get(polygon.edges[j2]) != null) {
                    polygon.edges[j2] = (Edge)sub_edge_to_main_edge.get(polygon.edges[j2]);
                    if (polygon.edges[j2].right_polygon != null) {
                        System.out.println("set left_polygon instead of right_polygon " + polygon.edges[j2] + " " + polygon + " " + polygon.edges[j2].right_polygon);
                        polygon.edges[j2].left_polygon = polygon;
                    } else {
                        polygon.edges[j2].right_polygon = polygon;
                    }
                } else {
                    edge = polygon.edges[j2];
                    if (edge.index == -1) {
                        new_sub_edges.addElement(edge);
                        main.append(edge);
                    }
                }
                ++j2;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < sub.n_vertices) {
            sub.vertices[i4].index = -9;
            ++i4;
        }
        i4 = 0;
        while (i4 < new_sub_edges.size()) {
            Edge edge3 = (Edge)new_sub_edges.elementAt(i4);
            if (sub_vertex_to_main_vertex.get(edge3.start) != null) {
                edge3.start = (Vertex)sub_vertex_to_main_vertex.get(edge3.start);
                edge3.start.edges.append(edge3);
            } else if (edge3.start.index == -9) {
                main.append(edge3.start);
            }
            if (sub_vertex_to_main_vertex.get(edge3.end) != null) {
                edge3.end = (Vertex)sub_vertex_to_main_vertex.get(edge3.end);
                edge3.end.edges.append(edge3);
            } else if (edge3.end.index == -9) {
                main.append(edge3.end);
            }
            ++i4;
        }
        main.set_parameters();
        i4 = 0;
        while (i4 < main.n_polygons) {
            polygon = main.polygons[i4];
            int j3 = 0;
            while (j3 < 3) {
                edge = polygon.edges[j3];
                if (!main.contains(edge)) {
                    System.out.println("recovering broken edge in polygon " + polygon + " " + polygon.edges[j3] + " " + polygon.edges[j3].delaunay_edge);
                    main.append(edge);
                    if (!edge.start.edges.contains(edge)) {
                        edge.start.edges.append(edge);
                    }
                    if (!edge.end.edges.contains(edge)) {
                        edge.end.edges.append(edge);
                    }
                }
                ++j3;
            }
            ++i4;
        }
        if (smooth) {
            Pop.h = main;
            Vector boundary_edges = Pop.find_boundary_edges(seam);
            System.out.println("fillet");
            Fillet.fillet(main, boundary_edges, 0.07);
            return null;
        }
        Pop.h = main;
        Vector boundary_edges = Pop.find_boundary_edges(seam);
        SurfacePath final_path = new SurfacePath(boundary_edges);
        final_path.seam = seam;
        return final_path;
    }

    public static int count_intersecting_edge_polygon(Polyhedron main, Polyhedron sub) {
        int count = 0;
        int i = 0;
        while (i < main.n_edges) {
            Edge edge = main.edges[i];
            int j = 0;
            while (j < sub.n_polygons) {
                Polygon2 polygon = sub.polygons[j];
                Vertex cross = Merge.intersects(edge, polygon);
                if (cross != null) {
                    System.out.print(" " + edge.index + " (");
                    int k = 0;
                    while (k < 3) {
                        System.out.print(" " + polygon.edges((int)k).index);
                        ++k;
                    }
                    System.out.print(" )");
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("");
        return count;
    }

    public static Vertex calculate_intersection(Edge edge, Polygon2 polygon) {
        Vertex base = polygon.get_vertex(0);
        Vector3 vec0 = new Vector3(base, edge.start);
        Vector3 vec1 = new Vector3(base, edge.end);
        double t0 = Vector3.dot_product(polygon.normal, vec0);
        double t1 = Vector3.dot_product(polygon.normal, vec1);
        return edge.start.translate(edge.vector3().multiple(t0 / (t0 - t1)));
    }

    public static Path get_path(Polyhedron main, Polyhedron sub) {
        Path path = null;
        while ((path = Merge.get_path_main(main, sub)) == null) {
            Merge.mutate(sub);
        }
        return path;
    }

    public static void mutate(Polyhedron h) {
        System.out.println("mutate");
        double d = 0.01 * (Math.random() - 0.5);
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            v.x += d;
            v.y += d;
            v.z += d;
            ++i;
        }
    }

    public static Object[] find_intersecting_edge_polygon(Polyhedron main, Polyhedron sub) {
        int i = 0;
        while (i < main.n_edges) {
            Edge edge = main.edges[i];
            int j = 0;
            while (j < sub.n_polygons) {
                Polygon2 polygon = sub.polygons[j];
                Vertex cross = Merge.intersects(edge, polygon);
                if (cross != null) {
                    Object[] result = new Object[]{edge, polygon, cross};
                    return result;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static Object[] recover_main_edge(Edge sub_edge, Polygon2 main_polygon, Polygon2 sub_polygon, Path path) {
        Edge next_sub_edge0 = sub_polygon.get_opposite_edge(sub_edge.start);
        Edge next_sub_edge1 = sub_polygon.get_opposite_edge(sub_edge.end);
        int i = 0;
        while (i < 3) {
            Edge main_edge = main_polygon.edges[i];
            Object[] result = Merge.recover_main_edge_test(next_sub_edge0, main_edge, main_polygon, sub_polygon, path);
            if (result != null) {
                return result;
            }
            result = Merge.recover_main_edge_test(next_sub_edge1, main_edge, main_polygon, sub_polygon, path);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Object[] recover_main_edge_test(Edge sub_edge, Edge main_edge, Polygon2 main_polygon, Polygon2 sub_polygon, Path path) {
        Polygon2 next_main_polygon = main_edge.get_another_polygon(main_polygon);
        if (Merge.intersects(sub_edge, next_main_polygon) != null) {
            path.add_main_edge(Merge.calculate_intersection(main_edge, sub_polygon), main_edge, sub_polygon);
            Object[] objectArray = new Object[4];
            objectArray[0] = main_edge;
            objectArray[2] = next_main_polygon;
            objectArray[3] = sub_polygon;
            Object[] result = objectArray;
            System.out.println(" ! recovered-c");
            return result;
        }
        Polygon2 next_sub_polygon = sub_edge.get_another_polygon(sub_polygon);
        if (Merge.intersects(main_edge, next_sub_polygon) != null) {
            path.add_sub_edge(Merge.calculate_intersection(sub_edge, main_polygon), sub_edge, main_polygon);
            Object[] objectArray = new Object[4];
            objectArray[1] = sub_edge;
            objectArray[2] = main_polygon;
            objectArray[3] = next_sub_polygon;
            Object[] result = objectArray;
            System.out.println(" ! recovered-d");
            return result;
        }
        return null;
    }

    public static Object[] find_next_main_edge(Edge main_edge, Polygon2 main_polygon, Polygon2 sub_polygon) {
        Object[] result = null;
        int i = 0;
        while (i < main_polygon.n_edges) {
            Vertex cross;
            Edge edge = main_polygon.edges(i);
            if (edge != main_edge && (cross = Merge.intersects(edge, sub_polygon)) != null) {
                if (result != null) {
                    System.out.print("!");
                    return null;
                }
                result = new Object[]{edge, cross};
            }
            ++i;
        }
        return result;
    }

    public static Vector gather_nearby_edges(Vector boundary_edges, Seam seam) {
        Vector results = Util.duplicateVector(boundary_edges);
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge boundary_edge = (Edge)boundary_edges.elementAt(i);
            Enumeration e = boundary_edge.start.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                if (edge.seam == seam) continue;
                Vertex v = edge.get_the_other_vertex(boundary_edge.start);
                if (!results.contains(edge)) {
                    results.addElement(edge);
                }
                Enumeration ee = v.edges.elements();
                while (ee.hasMoreElements()) {
                    Edge u = (Edge)ee.nextElement();
                    if (results.contains(u)) continue;
                    results.addElement(u);
                }
            }
            ++i;
        }
        return results;
    }

    public static Object[] recover_sub_edge(Edge main_edge, Polygon2 main_polygon, Polygon2 sub_polygon, Path path) {
        Edge next_main_edge0 = main_polygon.get_opposite_edge(main_edge.start);
        Edge next_main_edge1 = main_polygon.get_opposite_edge(main_edge.end);
        int i = 0;
        while (i < 3) {
            Edge sub_edge = sub_polygon.edges[i];
            Object[] result = Merge.recover_sub_edge_test(next_main_edge0, sub_edge, main_polygon, sub_polygon, path);
            if (result != null) {
                return result;
            }
            result = Merge.recover_sub_edge_test(next_main_edge1, sub_edge, main_polygon, sub_polygon, path);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Object[] recover_sub_edge_test(Edge main_edge, Edge sub_edge, Polygon2 main_polygon, Polygon2 sub_polygon, Path path) {
        Polygon2 next_sub_polygon = sub_edge.get_another_polygon(sub_polygon);
        if (Merge.intersects(main_edge, next_sub_polygon) != null) {
            path.add_sub_edge(Merge.calculate_intersection(sub_edge, main_polygon), sub_edge, main_polygon);
            Object[] objectArray = new Object[4];
            objectArray[1] = sub_edge;
            objectArray[2] = main_polygon;
            objectArray[3] = next_sub_polygon;
            Object[] result = objectArray;
            System.out.println(" ! recovered-a");
            return result;
        }
        Polygon2 next_main_polygon = main_edge.get_another_polygon(main_polygon);
        if (Merge.intersects(sub_edge, next_main_polygon) != null) {
            path.add_main_edge(Merge.calculate_intersection(main_edge, sub_polygon), main_edge, sub_polygon);
            Object[] objectArray = new Object[4];
            objectArray[0] = main_edge;
            objectArray[2] = next_main_polygon;
            objectArray[3] = sub_polygon;
            Object[] result = objectArray;
            System.out.println(" ! recovered-b");
            return result;
        }
        return null;
    }

    public static Object[] find_next_sub_edge(Edge sub_edge, Polygon2 main_polygon, Polygon2 sub_polygon) {
        Object[] result = null;
        int i = 0;
        while (i < sub_polygon.n_edges) {
            Vertex cross;
            Edge edge = sub_polygon.edges(i);
            if (edge != sub_edge && (cross = Merge.intersects(edge, main_polygon)) != null) {
                if (result != null) {
                    System.out.print("!");
                    return null;
                }
                result = new Object[]{edge, cross};
            }
            ++i;
        }
        return result;
    }

    public static Vector gather_nearby_vertices(Vector boundary_edges, Seam seam) {
        Vector<Vertex> results = new Vector<Vertex>();
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge boundary_edge = (Edge)boundary_edges.elementAt(i);
            Enumeration e = boundary_edge.start.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                if (edge.seam == seam) continue;
                Vertex v = edge.get_the_other_vertex(boundary_edge.start);
                if (!results.contains(v)) {
                    results.addElement(v);
                }
                Enumeration ee = v.get_surrounding_vertices().elements();
                while (ee.hasMoreElements()) {
                    Vertex u = (Vertex)ee.nextElement();
                    if (results.contains(u)) continue;
                    results.addElement(u);
                }
            }
            ++i;
        }
        return results;
    }

    public static Vertex intersects(Edge edge, Polygon2 polygon) {
        double t1;
        Vertex base = polygon.get_vertex(0);
        Vector3 vec0 = new Vector3(base, edge.start);
        Vector3 vec1 = new Vector3(base, edge.end);
        double t0 = Vector3.dot_product(polygon.normal, vec0);
        if (t0 * (t1 = Vector3.dot_product(polygon.normal, vec1)) > 0.0) {
            return null;
        }
        base = t0 > 0.0 ? edge.end : edge.start;
        Vector3 normal = new Vector3(base, edge.get_the_other_vertex(base));
        int i = 0;
        while (i < 3) {
            Vertex v1;
            Vertex v0 = polygon.get_vertex(i);
            vec0 = new Vector3(base, v0);
            Vector3 cross = Vector3.cross_product(vec0, vec1 = new Vector3(base, v1 = polygon.get_vertex(i + 1)));
            if (Vector3.dot_product(normal, cross) < 0.0) {
                return null;
            }
            ++i;
        }
        return edge.start.translate(edge.vector3().multiple(t0 / (t0 - t1)));
    }

    public static Path get_path_main(Polyhedron main, Polyhedron sub) {
        Object[] result = Merge.find_intersecting_edge_polygon(main, sub);
        Edge main_edge = (Edge)result[0];
        Polygon2 sub_polygon = (Polygon2)result[1];
        Vertex cross = (Vertex)result[2];
        Edge start_main_edge = main_edge;
        Polygon2 start_sub_polygon = sub_polygon;
        Polygon2 main_polygon = Vector3.dot_product(new Vector3(sub_polygon.get_vertex(0), main_edge.start), sub_polygon.normal) < 0.0 ? main_edge.right_polygon() : main_edge.left_polygon();
        path = new Path();
        Edge sub_edge = null;
        path.add_main_edge(cross, main_edge, sub_polygon);
        boolean finished = false;
        boolean success = true;
        while (true) {
            success = false;
            while ((result = Merge.find_next_main_edge(main_edge, main_polygon, sub_polygon)) != null) {
                success = true;
                main_edge = (Edge)result[0];
                cross = (Vertex)result[1];
                if (main_edge == start_main_edge && sub_polygon == start_sub_polygon) {
                    finished = true;
                    break;
                }
                path.add_main_edge(cross, main_edge, sub_polygon);
                main_polygon = main_edge.get_another_polygon(main_polygon);
            }
            if (!success && sub_edge != null) {
                return null;
            }
            sub_edge = null;
            if (finished) break;
            success = false;
            sub_edge = null;
            while ((result = Merge.find_next_sub_edge(sub_edge, main_polygon, sub_polygon)) != null) {
                success = true;
                sub_edge = (Edge)result[0];
                cross = (Vertex)result[1];
                path.add_sub_edge(cross, sub_edge, main_polygon);
                sub_polygon = sub_edge.get_another_polygon(sub_polygon);
            }
            if (!success) {
                return null;
            }
            main_edge = null;
        }
        return path;
    }
}

